<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta content="IE=edge,chrome=1" http-equiv="X-UA-Compatible">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <title>LaraClassifier API Documentation</title>

    <link href="https://fonts.googleapis.com/css?family=Open+Sans&display=swap" rel="stylesheet">

    <link rel="stylesheet" href="{{ asset("/vendor/scribe/css/theme-default.style.css") }}" media="screen">
    <link rel="stylesheet" href="{{ asset("/vendor/scribe/css/theme-default.print.css") }}" media="print">

    <script src="https://cdn.jsdelivr.net/npm/lodash@4.17.10/lodash.min.js"></script>

    <link rel="stylesheet"
          href="https://unpkg.com/@highlightjs/cdn-assets@11.6.0/styles/obsidian.min.css">
    <script src="https://unpkg.com/@highlightjs/cdn-assets@11.6.0/highlight.min.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jets/0.14.1/jets.min.js"></script>

    <style id="language-style">
        /* starts out as display none and is replaced with js later  */
                    body .content .bash-example code { display: none; }
                    body .content .javascript-example code { display: none; }
                    body .content .php-example code { display: none; }
                    body .content .python-example code { display: none; }
            </style>

    <script>
        var tryItOutBaseUrl = "https://demo.laraclassifier.local";
        var useCsrf = Boolean();
        var csrfUrl = "/sanctum/csrf-cookie";
    </script>
    <script src="{{ asset("/vendor/scribe/js/tryitout-5.3.0.js") }}"></script>

    <script src="{{ asset("/vendor/scribe/js/theme-default-5.3.0.js") }}"></script>

</head>

<body data-languages="[&quot;bash&quot;,&quot;javascript&quot;,&quot;php&quot;,&quot;python&quot;]">

<a href="#" id="nav-button">
    <span>
        MENU
        <img src="{{ asset("/vendor/scribe/images/navbar.png") }}" alt="navbar-image"/>
    </span>
</a>
<div class="tocify-wrapper">
            <img src="../storage/app/default/logo-api.png" alt="logo" class="logo" style="padding-top: 10px;" width="100%"/>
    
            <div class="lang-selector">
                                            <button type="button" class="lang-button" data-language-name="bash">bash</button>
                                            <button type="button" class="lang-button" data-language-name="javascript">javascript</button>
                                            <button type="button" class="lang-button" data-language-name="php">php</button>
                                            <button type="button" class="lang-button" data-language-name="python">python</button>
                    </div>
    
    <div class="search">
        <input type="text" class="search" id="input-search" placeholder="Search">
    </div>

    <div id="toc">
                    <ul id="tocify-header-introduction" class="tocify-header">
                <li class="tocify-item level-1" data-unique="introduction">
                    <a href="#introduction">Introduction</a>
                </li>
                            </ul>
                    <ul id="tocify-header-authenticating-requests" class="tocify-header">
                <li class="tocify-item level-1" data-unique="authenticating-requests">
                    <a href="#authenticating-requests">Authenticating requests</a>
                </li>
                            </ul>
                    <ul id="tocify-header-authentication" class="tocify-header">
                <li class="tocify-item level-1" data-unique="authentication">
                    <a href="#authentication">Authentication</a>
                </li>
                                    <ul id="tocify-subheader-authentication" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="authentication-POSTapi-auth-login">
                                <a href="#authentication-POSTapi-auth-login">Log in</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="authentication-GETapi-auth-logout--userId-">
                                <a href="#authentication-GETapi-auth-logout--userId-">Log out</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="authentication-POSTapi-auth-password-forgot">
                                <a href="#authentication-POSTapi-auth-password-forgot">Forgot password</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="authentication-POSTapi-auth-password-reset">
                                <a href="#authentication-POSTapi-auth-password-reset">Reset password</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-captcha" class="tocify-header">
                <li class="tocify-item level-1" data-unique="captcha">
                    <a href="#captcha">Captcha</a>
                </li>
                                    <ul id="tocify-subheader-captcha" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="captcha-GETapi-captcha">
                                <a href="#captcha-GETapi-captcha">Get CAPTCHA</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-categories" class="tocify-header">
                <li class="tocify-item level-1" data-unique="categories">
                    <a href="#categories">Categories</a>
                </li>
                                    <ul id="tocify-subheader-categories" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="categories-GETapi-categories">
                                <a href="#categories-GETapi-categories">List categories</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="categories-GETapi-categories--slugOrId-">
                                <a href="#categories-GETapi-categories--slugOrId-">Get category</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="categories-GETapi-categories--id--fields">
                                <a href="#categories-GETapi-categories--id--fields">List category's fields</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="categories-POSTapi-categories--id--fields">
                                <a href="#categories-POSTapi-categories--id--fields">List category's fields</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-contact" class="tocify-header">
                <li class="tocify-item level-1" data-unique="contact">
                    <a href="#contact">Contact</a>
                </li>
                                    <ul id="tocify-subheader-contact" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="contact-POSTapi-contact">
                                <a href="#contact-POSTapi-contact">Send Form</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="contact-POSTapi-posts--id--report">
                                <a href="#contact-POSTapi-posts--id--report">Report post</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-countries" class="tocify-header">
                <li class="tocify-item level-1" data-unique="countries">
                    <a href="#countries">Countries</a>
                </li>
                                    <ul id="tocify-subheader-countries" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="countries-GETapi-countries">
                                <a href="#countries-GETapi-countries">List countries</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="countries-GETapi-countries--code-">
                                <a href="#countries-GETapi-countries--code-">Get country</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="countries-GETapi-countries--countryCode--subAdmins1">
                                <a href="#countries-GETapi-countries--countryCode--subAdmins1">List admin. divisions (1)</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="countries-GETapi-countries--countryCode--subAdmins2">
                                <a href="#countries-GETapi-countries--countryCode--subAdmins2">List admin. divisions (2)</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="countries-GETapi-countries--countryCode--cities">
                                <a href="#countries-GETapi-countries--countryCode--cities">List cities</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="countries-GETapi-subAdmins1--code-">
                                <a href="#countries-GETapi-subAdmins1--code-">Get admin. division (1)</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="countries-GETapi-subAdmins2--code-">
                                <a href="#countries-GETapi-subAdmins2--code-">Get admin. division (2)</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="countries-GETapi-cities--id-">
                                <a href="#countries-GETapi-cities--id-">Get city</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-home" class="tocify-header">
                <li class="tocify-item level-1" data-unique="home">
                    <a href="#home">Home</a>
                </li>
                                    <ul id="tocify-subheader-home" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="home-GETapi-sections">
                                <a href="#home-GETapi-sections">List sections</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="home-GETapi-sections--method-">
                                <a href="#home-GETapi-sections--method-">Get section</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-languages" class="tocify-header">
                <li class="tocify-item level-1" data-unique="languages">
                    <a href="#languages">Languages</a>
                </li>
                                    <ul id="tocify-subheader-languages" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="languages-GETapi-languages">
                                <a href="#languages-GETapi-languages">List languages</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="languages-GETapi-languages--code-">
                                <a href="#languages-GETapi-languages--code-">Get language</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-listings" class="tocify-header">
                <li class="tocify-item level-1" data-unique="listings">
                    <a href="#listings">Listings</a>
                </li>
                                    <ul id="tocify-subheader-listings" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="listings-GETapi-postTypes">
                                <a href="#listings-GETapi-postTypes">List listing types</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="listings-GETapi-postTypes--id-">
                                <a href="#listings-GETapi-postTypes--id-">Get listing type</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="listings-GETapi-reportTypes">
                                <a href="#listings-GETapi-reportTypes">List report types</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="listings-GETapi-reportTypes--id-">
                                <a href="#listings-GETapi-reportTypes--id-">Get report type</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="listings-GETapi-posts">
                                <a href="#listings-GETapi-posts">List listings</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="listings-GETapi-posts--id-">
                                <a href="#listings-GETapi-posts--id-">Get listing</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="listings-POSTapi-posts">
                                <a href="#listings-POSTapi-posts">Store listing</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="listings-PUTapi-posts--id-">
                                <a href="#listings-PUTapi-posts--id-">Update listing</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="listings-DELETEapi-posts--ids-">
                                <a href="#listings-DELETEapi-posts--ids-">Delete listing(s)</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-packages" class="tocify-header">
                <li class="tocify-item level-1" data-unique="packages">
                    <a href="#packages">Packages</a>
                </li>
                                    <ul id="tocify-subheader-packages" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="packages-GETapi-packages-promotion">
                                <a href="#packages-GETapi-packages-promotion">List packages</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="packages-GETapi-packages-subscription">
                                <a href="#packages-GETapi-packages-subscription">List packages</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="packages-GETapi-packages--id-">
                                <a href="#packages-GETapi-packages--id-">Get package</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-pages" class="tocify-header">
                <li class="tocify-item level-1" data-unique="pages">
                    <a href="#pages">Pages</a>
                </li>
                                    <ul id="tocify-subheader-pages" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="pages-GETapi-pages">
                                <a href="#pages-GETapi-pages">List pages</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="pages-GETapi-pages--slugOrId-">
                                <a href="#pages-GETapi-pages--slugOrId-">Get page</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-payment-methods" class="tocify-header">
                <li class="tocify-item level-1" data-unique="payment-methods">
                    <a href="#payment-methods">Payment Methods</a>
                </li>
                                    <ul id="tocify-subheader-payment-methods" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="payment-methods-GETapi-paymentMethods">
                                <a href="#payment-methods-GETapi-paymentMethods">List payment methods</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="payment-methods-GETapi-paymentMethods--id-">
                                <a href="#payment-methods-GETapi-paymentMethods--id-">Get payment method</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-payments" class="tocify-header">
                <li class="tocify-item level-1" data-unique="payments">
                    <a href="#payments">Payments</a>
                </li>
                                    <ul id="tocify-subheader-payments" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="payments-GETapi-payments-promotion">
                                <a href="#payments-GETapi-payments-promotion">List payments</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="payments-GETapi-payments-subscription">
                                <a href="#payments-GETapi-payments-subscription">List payments</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="payments-GETapi-payments-subscription-users--userId--payments">
                                <a href="#payments-GETapi-payments-subscription-users--userId--payments">List payments</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="payments-GETapi-payments--id-">
                                <a href="#payments-GETapi-payments--id-">Get payment</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="payments-POSTapi-payments">
                                <a href="#payments-POSTapi-payments">Store payment</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-pictures" class="tocify-header">
                <li class="tocify-item level-1" data-unique="pictures">
                    <a href="#pictures">Pictures</a>
                </li>
                                    <ul id="tocify-subheader-pictures" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="pictures-GETapi-pictures--id-">
                                <a href="#pictures-GETapi-pictures--id-">Get picture</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="pictures-POSTapi-pictures">
                                <a href="#pictures-POSTapi-pictures">Store picture</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="pictures-DELETEapi-pictures--id-">
                                <a href="#pictures-DELETEapi-pictures--id-">Delete picture</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="pictures-POSTapi-pictures-reorder">
                                <a href="#pictures-POSTapi-pictures-reorder">Reorder pictures</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="pictures-GETapi-posts--postId--pictures">
                                <a href="#pictures-GETapi-posts--postId--pictures">List pictures</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-reviews" class="tocify-header">
                <li class="tocify-item level-1" data-unique="reviews">
                    <a href="#reviews">Reviews</a>
                </li>
                                    <ul id="tocify-subheader-reviews" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="reviews-GETapi-plugins-posts--postId--reviews">
                                <a href="#reviews-GETapi-plugins-posts--postId--reviews">List reviews</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="reviews-POSTapi-plugins-posts--postId--reviews">
                                <a href="#reviews-POSTapi-plugins-posts--postId--reviews">Store review</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="reviews-DELETEapi-plugins-posts--postId--reviews--ids-">
                                <a href="#reviews-DELETEapi-plugins-posts--postId--reviews--ids-">Delete review(s)</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-saved-posts" class="tocify-header">
                <li class="tocify-item level-1" data-unique="saved-posts">
                    <a href="#saved-posts">Saved Posts</a>
                </li>
                                    <ul id="tocify-subheader-saved-posts" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="saved-posts-POSTapi-savedPosts">
                                <a href="#saved-posts-POSTapi-savedPosts">Store/Delete saved listing</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="saved-posts-GETapi-savedPosts">
                                <a href="#saved-posts-GETapi-savedPosts">List saved listings</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="saved-posts-DELETEapi-savedPosts--ids-">
                                <a href="#saved-posts-DELETEapi-savedPosts--ids-">Delete saved listing(s)</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-saved-searches" class="tocify-header">
                <li class="tocify-item level-1" data-unique="saved-searches">
                    <a href="#saved-searches">Saved Searches</a>
                </li>
                                    <ul id="tocify-subheader-saved-searches" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="saved-searches-POSTapi-savedSearches">
                                <a href="#saved-searches-POSTapi-savedSearches">Store/Delete saved search</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="saved-searches-GETapi-savedSearches">
                                <a href="#saved-searches-GETapi-savedSearches">List saved searches</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="saved-searches-GETapi-savedSearches--id-">
                                <a href="#saved-searches-GETapi-savedSearches--id-">Get saved search</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="saved-searches-DELETEapi-savedSearches--ids-">
                                <a href="#saved-searches-DELETEapi-savedSearches--ids-">Delete saved search(es)</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-settings" class="tocify-header">
                <li class="tocify-item level-1" data-unique="settings">
                    <a href="#settings">Settings</a>
                </li>
                                    <ul id="tocify-subheader-settings" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="settings-GETapi-settings">
                                <a href="#settings-GETapi-settings">List settings</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="settings-GETapi-settings--key-">
                                <a href="#settings-GETapi-settings--key-">Get setting</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-social-auth" class="tocify-header">
                <li class="tocify-item level-1" data-unique="social-auth">
                    <a href="#social-auth">Social Auth</a>
                </li>
                                    <ul id="tocify-subheader-social-auth" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="social-auth-GETapi-auth-connect--provider-">
                                <a href="#social-auth-GETapi-auth-connect--provider-">Get target URL</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="social-auth-GETapi-auth-connect--provider--callback">
                                <a href="#social-auth-GETapi-auth-connect--provider--callback">Get user info</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-threads" class="tocify-header">
                <li class="tocify-item level-1" data-unique="threads">
                    <a href="#threads">Threads</a>
                </li>
                                    <ul id="tocify-subheader-threads" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="threads-POSTapi-threads">
                                <a href="#threads-POSTapi-threads">Store thread</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="threads-GETapi-threads">
                                <a href="#threads-GETapi-threads">List threads</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="threads-GETapi-threads--id-">
                                <a href="#threads-GETapi-threads--id-">Get thread</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="threads-PUTapi-threads--id-">
                                <a href="#threads-PUTapi-threads--id-">Update thread</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="threads-DELETEapi-threads--ids-">
                                <a href="#threads-DELETEapi-threads--ids-">Delete thread(s)</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="threads-POSTapi-threads-bulkUpdate--ids--">
                                <a href="#threads-POSTapi-threads-bulkUpdate--ids--">Bulk updates</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="threads-GETapi-threads--threadId--messages">
                                <a href="#threads-GETapi-threads--threadId--messages">List messages</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="threads-GETapi-threads--threadId--messages--id-">
                                <a href="#threads-GETapi-threads--threadId--messages--id-">Get message</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-users" class="tocify-header">
                <li class="tocify-item level-1" data-unique="users">
                    <a href="#users">Users</a>
                </li>
                                    <ul id="tocify-subheader-users" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="users-GETapi-genders">
                                <a href="#users-GETapi-genders">List genders</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="users-GETapi-genders--id-">
                                <a href="#users-GETapi-genders--id-">Get gender</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="users-GETapi-userTypes">
                                <a href="#users-GETapi-userTypes">List user types</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="users-GETapi-userTypes--id-">
                                <a href="#users-GETapi-userTypes--id-">Get user type</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="users-GETapi-users">
                                <a href="#users-GETapi-users">List users</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="users-GETapi-users--id-">
                                <a href="#users-GETapi-users--id-">Get user</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="users-POSTapi-users">
                                <a href="#users-POSTapi-users">Store user</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="users-GETapi-users--id--stats">
                                <a href="#users-GETapi-users--id--stats">User's mini stats</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="users-GETapi-users--id--photo-delete">
                                <a href="#users-GETapi-users--id--photo-delete">Delete user's photo</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="users-PUTapi-users--id--photo">
                                <a href="#users-PUTapi-users--id--photo">Update user's photo</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="users-PUTapi-users--id--preferences">
                                <a href="#users-PUTapi-users--id--preferences">Update user's preferences</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="users-PUTapi-users--id--save-theme-preference">
                                <a href="#users-PUTapi-users--id--save-theme-preference">Update the user's theme preference</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="users-PUTapi-users--id-">
                                <a href="#users-PUTapi-users--id-">Update user</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="users-DELETEapi-users--id-">
                                <a href="#users-DELETEapi-users--id-">Delete user</a>
                            </li>
                                                                        </ul>
                            </ul>
                    <ul id="tocify-header-verification" class="tocify-header">
                <li class="tocify-item level-1" data-unique="verification">
                    <a href="#verification">Verification</a>
                </li>
                                    <ul id="tocify-subheader-verification" class="tocify-subheader">
                                                    <li class="tocify-item level-2" data-unique="verification-GETapi-auth-verify--entityMetadataKey---entityId--resend-email">
                                <a href="#verification-GETapi-auth-verify--entityMetadataKey---entityId--resend-email">Email: Re-send link</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="verification-GETapi-auth-verify--entityMetadataKey---entityId--resend-sms">
                                <a href="#verification-GETapi-auth-verify--entityMetadataKey---entityId--resend-sms">SMS: Re-send code</a>
                            </li>
                                                                                <li class="tocify-item level-2" data-unique="verification-GETapi-auth-verify--entityMetadataKey---field---token--">
                                <a href="#verification-GETapi-auth-verify--entityMetadataKey---field---token--">Verification</a>
                            </li>
                                                                        </ul>
                            </ul>
            </div>

    <ul class="toc-footer" id="toc-footer">
                    <li style="padding-bottom: 5px;"><a href="{{ route("scribe.postman") }}">View Postman collection</a></li>
                        <li><a href="http://github.com/knuckleswtf/scribe">Documentation powered by Scribe ✍</a></li>
    </ul>

    <ul class="toc-footer" id="last-updated">
        <li>Last updated: September 8, 2025</li>
    </ul>
</div>

<div class="page-wrapper">
    <div class="dark-box"></div>
    <div class="content">
        <h1 id="introduction">Introduction</h1>
<p>LaraClassifier API specification and documentation.</p>
<aside>
    <strong>Base URL</strong>: <code>https://demo.laraclassifier.local</code>
</aside>
<p>This documentation aims to provide all the information you need to work with our API.</p>
<aside>As you scroll, you'll see code examples for working with the API in different programming languages in the dark area to the right (or as part of the content on mobile).
You can switch the language used with the tabs at the top right (or from the nav menu at the top left on mobile).</aside>
<p><strong>Important:</strong> By default the API uses an access token set in the <strong><code>/.env</code></strong> file with the variable <code>APP_API_TOKEN</code>, whose its value
need to be added in the header of all the API requests with <code>X-AppApiToken</code> as key. On the other hand, the key <code>X-AppType</code> must not be added to the header... This key is only useful for the included web client and for API documentation.</p>
<p>Also, by default the default app's country will be selected if the <strong><code>countryCode</code></strong> query parameter is not filled during API calls. If a default country is not set for the app, the most populated country will be selected. Same for the language, which the default app language will be selected if the <strong><code>languageCode</code></strong> query parameter is not filled.</p>

        <h1 id="authenticating-requests">Authenticating requests</h1>
<p>To authenticate requests, include an <strong><code>Authorization</code></strong> header with the value <strong><code>"Bearer {YOUR_AUTH_KEY}"</code></strong>.</p>
<p>All authenticated endpoints are marked with a <code>requires authentication</code> badge in the documentation below.</p>
<p>You can retrieve your token by visiting your dashboard and clicking <b>Generate API token</b>.</p>

        <h1 id="authentication">Authentication</h1>

    

                                <h2 id="authentication-POSTapi-auth-login">Log in</h2>

<p>
</p>



<span id="example-requests-POSTapi-auth-login">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request POST \
    "https://demo.laraclassifier.local/api/auth/login" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs" \
    --data "{
    \"email\": \"user@demosite.com\",
    \"password\": \"123456\",
    \"auth_field\": \"email\",
    \"phone\": null,
    \"phone_country\": null,
    \"captcha_key\": \"consequuntur\"
}"
</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/auth/login"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

let body = {
    "email": "user@demosite.com",
    "password": "123456",
    "auth_field": "email",
    "phone": null,
    "phone_country": null,
    "captcha_key": "consequuntur"
};

fetch(url, {
    method: "POST",
    headers,
    body: JSON.stringify(body),
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/auth/login';
$response = $client-&gt;post(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'json' =&gt; [
            'email' =&gt; 'user@demosite.com',
            'password' =&gt; '123456',
            'auth_field' =&gt; 'email',
            'phone' =&gt; null,
            'phone_country' =&gt; null,
            'captcha_key' =&gt; 'consequuntur',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/auth/login'
payload = {
    "email": "user@demosite.com",
    "password": "123456",
    "auth_field": "email",
    "phone": null,
    "phone_country": null,
    "captcha_key": "consequuntur"
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('POST', url, headers=headers, json=payload)
response.json()</code></pre></div>

</span>

<span id="example-responses-POSTapi-auth-login">
</span>
<span id="execution-results-POSTapi-auth-login" hidden>
    <blockquote>Received response<span
                id="execution-response-status-POSTapi-auth-login"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-POSTapi-auth-login"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-POSTapi-auth-login" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-POSTapi-auth-login">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-POSTapi-auth-login" data-method="POST"
      data-path="api/auth/login"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('POSTapi-auth-login', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-POSTapi-auth-login"
                    onclick="tryItOut('POSTapi-auth-login');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-POSTapi-auth-login"
                    onclick="cancelTryOut('POSTapi-auth-login');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-POSTapi-auth-login"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-black">POST</small>
            <b><code>api/auth/login</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="POSTapi-auth-login"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="POSTapi-auth-login"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="POSTapi-auth-login"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="POSTapi-auth-login"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="POSTapi-auth-login"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                                <h4 class="fancy-heading-panel"><b>Body Parameters</b></h4>
        <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>email</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="email"                data-endpoint="POSTapi-auth-login"
               value="user@demosite.com"
               data-component="body">
    <br>
<p>The user's email address or username (Required when 'auth_field' value is 'email'). Example: <code>user@demosite.com</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>password</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="password"                data-endpoint="POSTapi-auth-login"
               value="123456"
               data-component="body">
    <br>
<p>The user's password. Example: <code>123456</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>auth_field</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="auth_field"                data-endpoint="POSTapi-auth-login"
               value="email"
               data-component="body">
    <br>
<p>The user's auth field ('email' or 'phone'). Example: <code>email</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>phone</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="phone"                data-endpoint="POSTapi-auth-login"
               value=""
               data-component="body">
    <br>
<p>The user's mobile phone number (Required when 'auth_field' value is 'phone').</p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>phone_country</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="phone_country"                data-endpoint="POSTapi-auth-login"
               value=""
               data-component="body">
    <br>
<p>The user's phone number's country code (Required when the 'phone' field is filled).</p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>captcha_key</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="captcha_key"                data-endpoint="POSTapi-auth-login"
               value="consequuntur"
               data-component="body">
    <br>
<p>Key generated by the CAPTCHA endpoint calling (Required when the CAPTCHA verification is enabled from the Admin panel). Example: <code>consequuntur</code></p>
        </div>
        </form>

                    <h2 id="authentication-GETapi-auth-logout--userId-">Log out</h2>

<p>
<small class="badge badge-darkred">requires authentication</small>
</p>



<span id="example-requests-GETapi-auth-logout--userId-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/auth/logout/14" \
    --header "Authorization: Bearer {YOUR_AUTH_TOKEN}" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/auth/logout/14"
);

const headers = {
    "Authorization": "Bearer {YOUR_AUTH_TOKEN}",
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/auth/logout/14';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Authorization' =&gt; 'Bearer {YOUR_AUTH_TOKEN}',
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/auth/logout/14'
headers = {
  'Authorization': 'Bearer {YOUR_AUTH_TOKEN}',
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-auth-logout--userId-">
            <blockquote>
            <p>Example response (400):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: false,
    &quot;message&quot;: &quot;An error occurred and the logout failed.&quot;,
    &quot;result&quot;: null
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-auth-logout--userId-" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-auth-logout--userId-"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-auth-logout--userId-"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-auth-logout--userId-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-auth-logout--userId-">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-auth-logout--userId-" data-method="GET"
      data-path="api/auth/logout/{userId}"
      data-authed="1"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-auth-logout--userId-', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-auth-logout--userId-"
                    onclick="tryItOut('GETapi-auth-logout--userId-');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-auth-logout--userId-"
                    onclick="cancelTryOut('GETapi-auth-logout--userId-');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-auth-logout--userId-"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/auth/logout/{userId}</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Authorization</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Authorization" class="auth-value"               data-endpoint="GETapi-auth-logout--userId-"
               value="Bearer {YOUR_AUTH_TOKEN}"
               data-component="header">
    <br>
<p>Example: <code>Bearer {YOUR_AUTH_TOKEN}</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-auth-logout--userId-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-auth-logout--userId-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-auth-logout--userId-"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-auth-logout--userId-"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-auth-logout--userId-"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>userId</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="userId"                data-endpoint="GETapi-auth-logout--userId-"
               value="14"
               data-component="url">
    <br>
<p>The ID of the user to logout. Example: <code>14</code></p>
            </div>
                    </form>

                    <h2 id="authentication-POSTapi-auth-password-forgot">Forgot password</h2>

<p>
</p>



<span id="example-requests-POSTapi-auth-password-forgot">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request POST \
    "https://demo.laraclassifier.local/api/auth/password/forgot" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs" \
    --data "{
    \"email\": \"user@demosite.com\",
    \"auth_field\": \"email\",
    \"phone\": null,
    \"phone_country\": null,
    \"captcha_key\": \"omnis\"
}"
</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/auth/password/forgot"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

let body = {
    "email": "user@demosite.com",
    "auth_field": "email",
    "phone": null,
    "phone_country": null,
    "captcha_key": "omnis"
};

fetch(url, {
    method: "POST",
    headers,
    body: JSON.stringify(body),
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/auth/password/forgot';
$response = $client-&gt;post(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'json' =&gt; [
            'email' =&gt; 'user@demosite.com',
            'auth_field' =&gt; 'email',
            'phone' =&gt; null,
            'phone_country' =&gt; null,
            'captcha_key' =&gt; 'omnis',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/auth/password/forgot'
payload = {
    "email": "user@demosite.com",
    "auth_field": "email",
    "phone": null,
    "phone_country": null,
    "captcha_key": "omnis"
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('POST', url, headers=headers, json=payload)
response.json()</code></pre></div>

</span>

<span id="example-responses-POSTapi-auth-password-forgot">
</span>
<span id="execution-results-POSTapi-auth-password-forgot" hidden>
    <blockquote>Received response<span
                id="execution-response-status-POSTapi-auth-password-forgot"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-POSTapi-auth-password-forgot"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-POSTapi-auth-password-forgot" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-POSTapi-auth-password-forgot">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-POSTapi-auth-password-forgot" data-method="POST"
      data-path="api/auth/password/forgot"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('POSTapi-auth-password-forgot', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-POSTapi-auth-password-forgot"
                    onclick="tryItOut('POSTapi-auth-password-forgot');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-POSTapi-auth-password-forgot"
                    onclick="cancelTryOut('POSTapi-auth-password-forgot');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-POSTapi-auth-password-forgot"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-black">POST</small>
            <b><code>api/auth/password/forgot</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="POSTapi-auth-password-forgot"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="POSTapi-auth-password-forgot"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="POSTapi-auth-password-forgot"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="POSTapi-auth-password-forgot"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="POSTapi-auth-password-forgot"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                                <h4 class="fancy-heading-panel"><b>Body Parameters</b></h4>
        <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>email</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="email"                data-endpoint="POSTapi-auth-password-forgot"
               value="user@demosite.com"
               data-component="body">
    <br>
<p>The user's email address or username (Required when 'auth_field' value is 'email'). Example: <code>user@demosite.com</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>auth_field</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="auth_field"                data-endpoint="POSTapi-auth-password-forgot"
               value="email"
               data-component="body">
    <br>
<p>The user's auth field ('email' or 'phone'). Example: <code>email</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>phone</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="phone"                data-endpoint="POSTapi-auth-password-forgot"
               value=""
               data-component="body">
    <br>
<p>The user's mobile phone number (Required when 'auth_field' value is 'phone').</p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>phone_country</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="phone_country"                data-endpoint="POSTapi-auth-password-forgot"
               value=""
               data-component="body">
    <br>
<p>The user's phone number's country code (Required when the 'phone' field is filled).</p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>captcha_key</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="captcha_key"                data-endpoint="POSTapi-auth-password-forgot"
               value="omnis"
               data-component="body">
    <br>
<p>Key generated by the CAPTCHA endpoint calling (Required when the CAPTCHA verification is enabled from the Admin panel). Example: <code>omnis</code></p>
        </div>
        </form>

                    <h2 id="authentication-POSTapi-auth-password-reset">Reset password</h2>

<p>
</p>



<span id="example-requests-POSTapi-auth-password-reset">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request POST \
    "https://demo.laraclassifier.local/api/auth/password/reset" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs" \
    --data "{
    \"email\": \"john.doe@domain.tld\",
    \"token\": \"ipsum\",
    \"phone_country\": null,
    \"password\": \"js!X07$z61hLA\",
    \"auth_field\": \"email\",
    \"phone\": null,
    \"password_confirmation\": \"js!X07$z61hLA\",
    \"captcha_key\": \"ea\"
}"
</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/auth/password/reset"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

let body = {
    "email": "john.doe@domain.tld",
    "token": "ipsum",
    "phone_country": null,
    "password": "js!X07$z61hLA",
    "auth_field": "email",
    "phone": null,
    "password_confirmation": "js!X07$z61hLA",
    "captcha_key": "ea"
};

fetch(url, {
    method: "POST",
    headers,
    body: JSON.stringify(body),
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/auth/password/reset';
$response = $client-&gt;post(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'json' =&gt; [
            'email' =&gt; 'john.doe@domain.tld',
            'token' =&gt; 'ipsum',
            'phone_country' =&gt; null,
            'password' =&gt; 'js!X07$z61hLA',
            'auth_field' =&gt; 'email',
            'phone' =&gt; null,
            'password_confirmation' =&gt; 'js!X07$z61hLA',
            'captcha_key' =&gt; 'ea',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/auth/password/reset'
payload = {
    "email": "john.doe@domain.tld",
    "token": "ipsum",
    "phone_country": null,
    "password": "js!X07$z61hLA",
    "auth_field": "email",
    "phone": null,
    "password_confirmation": "js!X07$z61hLA",
    "captcha_key": "ea"
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('POST', url, headers=headers, json=payload)
response.json()</code></pre></div>

</span>

<span id="example-responses-POSTapi-auth-password-reset">
</span>
<span id="execution-results-POSTapi-auth-password-reset" hidden>
    <blockquote>Received response<span
                id="execution-response-status-POSTapi-auth-password-reset"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-POSTapi-auth-password-reset"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-POSTapi-auth-password-reset" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-POSTapi-auth-password-reset">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-POSTapi-auth-password-reset" data-method="POST"
      data-path="api/auth/password/reset"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('POSTapi-auth-password-reset', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-POSTapi-auth-password-reset"
                    onclick="tryItOut('POSTapi-auth-password-reset');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-POSTapi-auth-password-reset"
                    onclick="cancelTryOut('POSTapi-auth-password-reset');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-POSTapi-auth-password-reset"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-black">POST</small>
            <b><code>api/auth/password/reset</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="POSTapi-auth-password-reset"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="POSTapi-auth-password-reset"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="POSTapi-auth-password-reset"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="POSTapi-auth-password-reset"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="POSTapi-auth-password-reset"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                                <h4 class="fancy-heading-panel"><b>Body Parameters</b></h4>
        <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>email</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="email"                data-endpoint="POSTapi-auth-password-reset"
               value="john.doe@domain.tld"
               data-component="body">
    <br>
<p>The user's email address or username (Required when 'auth_field' value is 'email'). Example: <code>john.doe@domain.tld</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>token</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="token"                data-endpoint="POSTapi-auth-password-reset"
               value="ipsum"
               data-component="body">
    <br>
<p>Example: <code>ipsum</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>phone_country</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="phone_country"                data-endpoint="POSTapi-auth-password-reset"
               value=""
               data-component="body">
    <br>
<p>The user's phone number's country code (Required when the 'phone' field is filled).</p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>password</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="password"                data-endpoint="POSTapi-auth-password-reset"
               value="js!X07$z61hLA"
               data-component="body">
    <br>
<p>The user's password. Example: <code>js!X07$z61hLA</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>auth_field</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="auth_field"                data-endpoint="POSTapi-auth-password-reset"
               value="email"
               data-component="body">
    <br>
<p>The user's auth field ('email' or 'phone'). Example: <code>email</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>phone</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="phone"                data-endpoint="POSTapi-auth-password-reset"
               value=""
               data-component="body">
    <br>
<p>The user's mobile phone number (Required when 'auth_field' value is 'phone').</p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>password_confirmation</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="password_confirmation"                data-endpoint="POSTapi-auth-password-reset"
               value="js!X07$z61hLA"
               data-component="body">
    <br>
<p>The confirmation of the user's password. Example: <code>js!X07$z61hLA</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>captcha_key</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="captcha_key"                data-endpoint="POSTapi-auth-password-reset"
               value="ea"
               data-component="body">
    <br>
<p>Key generated by the CAPTCHA endpoint calling (Required when the CAPTCHA verification is enabled from the Admin panel). Example: <code>ea</code></p>
        </div>
        </form>

                <h1 id="captcha">Captcha</h1>

    

                                <h2 id="captcha-GETapi-captcha">Get CAPTCHA</h2>

<p>
</p>

<p>Calling this endpoint is mandatory if the captcha is enabled in the Admin panel.
Return JSON data with an 'img' item that contains the captcha image to show and a 'key' item that contains the generated key to send for validation.</p>

<span id="example-requests-GETapi-captcha">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/captcha" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/captcha"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/captcha';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/captcha'
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-captcha">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;sensitive&quot;: false,
        &quot;key&quot;: &quot;eyJpdiI6Ik1JOGQxRnZEL1F3VWk3RDlPT3MrVEE9PSIsInZhbHVlIjoiSG8rWE9FaXFxRzNuc1BpWkdtb0VsdytaVG4zL0hJbHlhQWVWa2NyeDdiU3huTHRkbnVEcXVjdFdYOEZWa2xwcjZBTHJXWlNnZ2FwL0dhR0t0RnpCZTZjbG5MSm5DMXhsZXlQUEdXVkZWTzg9IiwibWFjIjoiMDk5OGZjMjY2NTk4OTdlZTI3ODc2ZGI5ZjE2ZmEzNDY3MzFjMTZkNTQ3YmQ3OTdjN2VlZjllNDUxYTE1MmM0ZSIsInRhZyI6IiJ9&quot;,
        &quot;img&quot;: &quot;data:image/png;base64,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&quot;
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-captcha" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-captcha"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-captcha"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-captcha" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-captcha">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-captcha" data-method="GET"
      data-path="api/captcha"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-captcha', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-captcha"
                    onclick="tryItOut('GETapi-captcha');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-captcha"
                    onclick="cancelTryOut('GETapi-captcha');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-captcha"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/captcha</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-captcha"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-captcha"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-captcha"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-captcha"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-captcha"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        </form>

                <h1 id="categories">Categories</h1>

    

                                <h2 id="categories-GETapi-categories">List categories</h2>

<p>
</p>



<span id="example-requests-GETapi-categories">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/categories?parentId=0&amp;nestedIncluded=0&amp;embed=&amp;sort=-lft&amp;perPage=2&amp;page=1" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/categories"
);

const params = {
    "parentId": "0",
    "nestedIncluded": "0",
    "embed": "",
    "sort": "-lft",
    "perPage": "2",
    "page": "1",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/categories';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'parentId' =&gt; '0',
            'nestedIncluded' =&gt; '0',
            'embed' =&gt; '',
            'sort' =&gt; '-lft',
            'perPage' =&gt; '2',
            'page' =&gt; '1',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/categories'
params = {
  'parentId': '0',
  'nestedIncluded': '0',
  'embed': '',
  'sort': '-lft',
  'perPage': '2',
  'page': '1',
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-categories">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;data&quot;: [
            {
                &quot;id&quot;: 122,
                &quot;parent_id&quot;: null,
                &quot;name&quot;: &quot;Local Events&quot;,
                &quot;slug&quot;: &quot;local-events&quot;,
                &quot;description&quot;: &quot;&quot;,
                &quot;hide_description&quot;: null,
                &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                &quot;icon_class&quot;: &quot;fa-regular fa-calendar-days&quot;,
                &quot;seo_title&quot;: &quot;&quot;,
                &quot;seo_description&quot;: &quot;&quot;,
                &quot;seo_keywords&quot;: &quot;&quot;,
                &quot;lft&quot;: 243,
                &quot;rgt&quot;: 268,
                &quot;depth&quot;: 0,
                &quot;type&quot;: &quot;classified&quot;,
                &quot;is_for_permanent&quot;: 0,
                &quot;active&quot;: 1,
                &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/local-events?sort=-lft&quot;,
                &quot;parentClosure&quot;: null
            },
            {
                &quot;id&quot;: 114,
                &quot;parent_id&quot;: null,
                &quot;name&quot;: &quot;Learning&quot;,
                &quot;slug&quot;: &quot;learning&quot;,
                &quot;description&quot;: &quot;&quot;,
                &quot;hide_description&quot;: null,
                &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                &quot;icon_class&quot;: &quot;fa-solid fa-graduation-cap&quot;,
                &quot;seo_title&quot;: &quot;&quot;,
                &quot;seo_description&quot;: &quot;&quot;,
                &quot;seo_keywords&quot;: &quot;&quot;,
                &quot;lft&quot;: 227,
                &quot;rgt&quot;: 242,
                &quot;depth&quot;: 0,
                &quot;type&quot;: &quot;classified&quot;,
                &quot;is_for_permanent&quot;: 0,
                &quot;active&quot;: 1,
                &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/learning?sort=-lft&quot;,
                &quot;parentClosure&quot;: null
            }
        ],
        &quot;links&quot;: {
            &quot;first&quot;: &quot;https://demo.laraclassifier.local/api/categories?parentId=0&amp;nestedIncluded=0&amp;sort=-lft&amp;perPage=2&amp;page=1&quot;,
            &quot;last&quot;: &quot;https://demo.laraclassifier.local/api/categories?parentId=0&amp;nestedIncluded=0&amp;sort=-lft&amp;perPage=2&amp;page=6&quot;,
            &quot;prev&quot;: null,
            &quot;next&quot;: &quot;https://demo.laraclassifier.local/api/categories?parentId=0&amp;nestedIncluded=0&amp;sort=-lft&amp;perPage=2&amp;page=2&quot;
        },
        &quot;meta&quot;: {
            &quot;current_page&quot;: 1,
            &quot;from&quot;: 1,
            &quot;last_page&quot;: 6,
            &quot;links&quot;: [
                {
                    &quot;url&quot;: null,
                    &quot;label&quot;: &quot;&amp;laquo; Previous&quot;,
                    &quot;page&quot;: null,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/categories?parentId=0&amp;nestedIncluded=0&amp;sort=-lft&amp;perPage=2&amp;page=1&quot;,
                    &quot;label&quot;: &quot;1&quot;,
                    &quot;page&quot;: 1,
                    &quot;active&quot;: true
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/categories?parentId=0&amp;nestedIncluded=0&amp;sort=-lft&amp;perPage=2&amp;page=2&quot;,
                    &quot;label&quot;: &quot;2&quot;,
                    &quot;page&quot;: 2,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/categories?parentId=0&amp;nestedIncluded=0&amp;sort=-lft&amp;perPage=2&amp;page=3&quot;,
                    &quot;label&quot;: &quot;3&quot;,
                    &quot;page&quot;: 3,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/categories?parentId=0&amp;nestedIncluded=0&amp;sort=-lft&amp;perPage=2&amp;page=4&quot;,
                    &quot;label&quot;: &quot;4&quot;,
                    &quot;page&quot;: 4,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/categories?parentId=0&amp;nestedIncluded=0&amp;sort=-lft&amp;perPage=2&amp;page=5&quot;,
                    &quot;label&quot;: &quot;5&quot;,
                    &quot;page&quot;: 5,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/categories?parentId=0&amp;nestedIncluded=0&amp;sort=-lft&amp;perPage=2&amp;page=6&quot;,
                    &quot;label&quot;: &quot;6&quot;,
                    &quot;page&quot;: 6,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/categories?parentId=0&amp;nestedIncluded=0&amp;sort=-lft&amp;perPage=2&amp;page=2&quot;,
                    &quot;label&quot;: &quot;Next &amp;raquo;&quot;,
                    &quot;page&quot;: 2,
                    &quot;active&quot;: false
                }
            ],
            &quot;path&quot;: &quot;https://demo.laraclassifier.local/api/categories&quot;,
            &quot;per_page&quot;: 2,
            &quot;to&quot;: 2,
            &quot;total&quot;: 12
        }
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-categories" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-categories"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-categories"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-categories" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-categories">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-categories" data-method="GET"
      data-path="api/categories"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-categories', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-categories"
                    onclick="tryItOut('GETapi-categories');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-categories"
                    onclick="cancelTryOut('GETapi-categories');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-categories"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/categories</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-categories"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-categories"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-categories"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-categories"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-categories"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                            <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>parentId</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="parentId"                data-endpoint="GETapi-categories"
               value="0"
               data-component="query">
    <br>
<p>The ID of the parent category of the sub categories to retrieve. Example: <code>0</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>nestedIncluded</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="nestedIncluded"                data-endpoint="GETapi-categories"
               value="0"
               data-component="query">
    <br>
<p>If parent ID is not provided, are nested entries will be included? - Possible values: 0,1. Example: <code>0</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>embed</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="embed"                data-endpoint="GETapi-categories"
               value=""
               data-component="query">
    <br>
<p>The Comma-separated list of the category relationships for Eager Loading - Possible values: parent,children.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>sort</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="sort"                data-endpoint="GETapi-categories"
               value="-lft"
               data-component="query">
    <br>
<p>The sorting parameter (Order by DESC with the given column. Use &quot;-&quot; as prefix to order by ASC). Possible values: lft. Example: <code>-lft</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>perPage</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="perPage"                data-endpoint="GETapi-categories"
               value="2"
               data-component="query">
    <br>
<p>Items per page. Can be defined globally from the admin settings. Cannot be exceeded 100. Example: <code>2</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>page</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="page"                data-endpoint="GETapi-categories"
               value="1"
               data-component="query">
    <br>
<p>Items page number. From 1 to (&quot;total items&quot; divided by &quot;items per page value - perPage&quot;). Example: <code>1</code></p>
            </div>
                </form>

                    <h2 id="categories-GETapi-categories--slugOrId-">Get category</h2>

<p>
</p>

<p>Get category by its unique slug or ID.</p>

<span id="example-requests-GETapi-categories--slugOrId-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/categories/cars?parentCatSlug=automobiles" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/categories/cars"
);

const params = {
    "parentCatSlug": "automobiles",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/categories/cars';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'parentCatSlug' =&gt; 'automobiles',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/categories/cars'
params = {
  'parentCatSlug': 'automobiles',
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-categories--slugOrId-">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;id&quot;: 2,
        &quot;parent_id&quot;: 1,
        &quot;name&quot;: &quot;Cars&quot;,
        &quot;slug&quot;: &quot;cars&quot;,
        &quot;description&quot;: &quot;&quot;,
        &quot;hide_description&quot;: null,
        &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
        &quot;icon_class&quot;: &quot;bi bi-folder-fill&quot;,
        &quot;seo_title&quot;: &quot;&quot;,
        &quot;seo_description&quot;: &quot;&quot;,
        &quot;seo_keywords&quot;: &quot;&quot;,
        &quot;lft&quot;: 2,
        &quot;rgt&quot;: 3,
        &quot;depth&quot;: 1,
        &quot;type&quot;: &quot;classified&quot;,
        &quot;is_for_permanent&quot;: 0,
        &quot;active&quot;: 1,
        &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
        &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/automobiles/cars&quot;
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-categories--slugOrId-" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-categories--slugOrId-"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-categories--slugOrId-"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-categories--slugOrId-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-categories--slugOrId-">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-categories--slugOrId-" data-method="GET"
      data-path="api/categories/{slugOrId}"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-categories--slugOrId-', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-categories--slugOrId-"
                    onclick="tryItOut('GETapi-categories--slugOrId-');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-categories--slugOrId-"
                    onclick="cancelTryOut('GETapi-categories--slugOrId-');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-categories--slugOrId-"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/categories/{slugOrId}</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-categories--slugOrId-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-categories--slugOrId-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-categories--slugOrId-"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-categories--slugOrId-"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-categories--slugOrId-"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>slugOrId</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="slugOrId"                data-endpoint="GETapi-categories--slugOrId-"
               value="cars"
               data-component="url">
    <br>
<p>The slug or ID of the category. Example: <code>cars</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>parentCatSlug</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="parentCatSlug"                data-endpoint="GETapi-categories--slugOrId-"
               value="automobiles"
               data-component="query">
    <br>
<p>The slug of the parent category to retrieve used when category's slug provided instead of ID. Example: <code>automobiles</code></p>
            </div>
                </form>

                    <h2 id="categories-GETapi-categories--id--fields">List category&#039;s fields</h2>

<p>
</p>



<span id="example-requests-GETapi-categories--id--fields">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/categories/1/fields" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs" \
    --data "{
    \"language_code\": \"en\",
    \"post_id\": 1
}"
</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/categories/1/fields"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

let body = {
    "language_code": "en",
    "post_id": 1
};

fetch(url, {
    method: "GET",
    headers,
    body: JSON.stringify(body),
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/categories/1/fields';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'json' =&gt; [
            'language_code' =&gt; 'en',
            'post_id' =&gt; 1,
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/categories/1/fields'
payload = {
    "language_code": "en",
    "post_id": 1
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, json=payload)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-categories--id--fields">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: [
        {
            &quot;id&quot;: 1,
            &quot;belongs_to&quot;: &quot;post&quot;,
            &quot;name&quot;: &quot;Car Brand&quot;,
            &quot;type&quot;: &quot;select&quot;,
            &quot;max&quot;: null,
            &quot;default_value&quot;: &quot;&quot;,
            &quot;required&quot;: 1,
            &quot;use_as_filter&quot;: 1,
            &quot;help&quot;: &quot;&quot;,
            &quot;active&quot;: 1,
            &quot;options&quot;: [
                {
                    &quot;id&quot;: 1,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Toyota&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 1,
                    &quot;rgt&quot;: 2,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 2,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;BMW&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 3,
                    &quot;rgt&quot;: 4,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 3,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Mercedes-Benz&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 5,
                    &quot;rgt&quot;: 6,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 4,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Chevrolet&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 7,
                    &quot;rgt&quot;: 8,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 5,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Cadillac&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 9,
                    &quot;rgt&quot;: 10,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 6,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Buick&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 11,
                    &quot;rgt&quot;: 12,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 7,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;GMC&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 13,
                    &quot;rgt&quot;: 14,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 8,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Ford&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 15,
                    &quot;rgt&quot;: 16,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 9,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Chrysler&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 17,
                    &quot;rgt&quot;: 18,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 10,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Dodge&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 19,
                    &quot;rgt&quot;: 20,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 11,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Jeep&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 21,
                    &quot;rgt&quot;: 22,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 12,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Tesla&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 23,
                    &quot;rgt&quot;: 24,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 13,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Lexus&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 25,
                    &quot;rgt&quot;: 26,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 14,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Suzuki&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 27,
                    &quot;rgt&quot;: 28,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 15,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Mazda&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 29,
                    &quot;rgt&quot;: 30,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 16,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Honda&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 31,
                    &quot;rgt&quot;: 32,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 17,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Acura&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 33,
                    &quot;rgt&quot;: 34,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 18,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Mitsubishi&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 35,
                    &quot;rgt&quot;: 36,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 19,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Nissan&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 37,
                    &quot;rgt&quot;: 38,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 20,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Infiniti&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 39,
                    &quot;rgt&quot;: 40,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 21,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Audi&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 41,
                    &quot;rgt&quot;: 42,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 22,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Volkswagen&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 43,
                    &quot;rgt&quot;: 44,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 23,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Porsche&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 45,
                    &quot;rgt&quot;: 46,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 24,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Opel&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 47,
                    &quot;rgt&quot;: 48,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 25,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Jaguar&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 49,
                    &quot;rgt&quot;: 50,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 26,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Land Rover&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 51,
                    &quot;rgt&quot;: 52,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 27,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;MINI&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 53,
                    &quot;rgt&quot;: 54,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 28,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Aston Martin&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 55,
                    &quot;rgt&quot;: 56,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 29,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Bentley&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 57,
                    &quot;rgt&quot;: 58,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 30,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Rolls-Royce&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 59,
                    &quot;rgt&quot;: 60,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 31,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;McLaren&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 61,
                    &quot;rgt&quot;: 62,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 32,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Fiat&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 63,
                    &quot;rgt&quot;: 64,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 33,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Alfa Romeo&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 65,
                    &quot;rgt&quot;: 66,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 34,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Maserati&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 67,
                    &quot;rgt&quot;: 68,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 35,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Ferrari&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 69,
                    &quot;rgt&quot;: 70,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 36,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Lamborghini&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 71,
                    &quot;rgt&quot;: 72,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 37,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Pagani&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 73,
                    &quot;rgt&quot;: 74,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 38,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Lancia&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 75,
                    &quot;rgt&quot;: 76,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 39,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Renault&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 77,
                    &quot;rgt&quot;: 78,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 40,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Peugeot&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 79,
                    &quot;rgt&quot;: 80,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 41,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Citroen&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 81,
                    &quot;rgt&quot;: 82,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 42,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Bugatti&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 83,
                    &quot;rgt&quot;: 84,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 43,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Tata&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 85,
                    &quot;rgt&quot;: 86,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 44,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Hyundai&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 87,
                    &quot;rgt&quot;: 88,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 45,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Kia&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 89,
                    &quot;rgt&quot;: 90,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 46,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Daewoo&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 91,
                    &quot;rgt&quot;: 92,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 47,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Volvo&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 93,
                    &quot;rgt&quot;: 94,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 48,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Saab&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 95,
                    &quot;rgt&quot;: 96,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 49,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Lada&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 97,
                    &quot;rgt&quot;: 98,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 50,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Volga&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 99,
                    &quot;rgt&quot;: 100,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 51,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Zil&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 101,
                    &quot;rgt&quot;: 102,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 52,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;GAZ&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 103,
                    &quot;rgt&quot;: 104,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 53,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Geely&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 105,
                    &quot;rgt&quot;: 106,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 54,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Chery&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 107,
                    &quot;rgt&quot;: 108,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 55,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Hongqi&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 109,
                    &quot;rgt&quot;: 110,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 56,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Dacia&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 111,
                    &quot;rgt&quot;: 112,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 57,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Daihatsu&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 113,
                    &quot;rgt&quot;: 114,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 58,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;FIAT&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 115,
                    &quot;rgt&quot;: 116,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 59,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Genesis&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 117,
                    &quot;rgt&quot;: 118,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 60,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Isuzu&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 119,
                    &quot;rgt&quot;: 120,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 61,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Lincoln&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 121,
                    &quot;rgt&quot;: 122,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 62,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Lotus&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 123,
                    &quot;rgt&quot;: 124,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 63,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Ram&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 125,
                    &quot;rgt&quot;: 126,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 64,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Ram&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 127,
                    &quot;rgt&quot;: 128,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 65,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;SEAT&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 129,
                    &quot;rgt&quot;: 130,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 66,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Skoda&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 131,
                    &quot;rgt&quot;: 132,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 67,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Smart&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 133,
                    &quot;rgt&quot;: 134,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 68,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Subaru&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 135,
                    &quot;rgt&quot;: 136,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 69,
                    &quot;field_id&quot;: 1,
                    &quot;value&quot;: &quot;Other&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 137,
                    &quot;rgt&quot;: 138,
                    &quot;depth&quot;: null
                }
            ]
        },
        {
            &quot;id&quot;: 2,
            &quot;belongs_to&quot;: &quot;post&quot;,
            &quot;name&quot;: &quot;Car Model&quot;,
            &quot;type&quot;: &quot;text&quot;,
            &quot;max&quot;: null,
            &quot;default_value&quot;: &quot;&quot;,
            &quot;required&quot;: 0,
            &quot;use_as_filter&quot;: 0,
            &quot;help&quot;: &quot;&quot;,
            &quot;active&quot;: 1,
            &quot;options&quot;: []
        },
        {
            &quot;id&quot;: 3,
            &quot;belongs_to&quot;: &quot;post&quot;,
            &quot;name&quot;: &quot;Year of registration&quot;,
            &quot;type&quot;: &quot;number&quot;,
            &quot;max&quot;: null,
            &quot;default_value&quot;: &quot;&quot;,
            &quot;required&quot;: 0,
            &quot;use_as_filter&quot;: 0,
            &quot;help&quot;: &quot;&quot;,
            &quot;active&quot;: 1,
            &quot;options&quot;: []
        },
        {
            &quot;id&quot;: 4,
            &quot;belongs_to&quot;: &quot;post&quot;,
            &quot;name&quot;: &quot;Mileage&quot;,
            &quot;type&quot;: &quot;text&quot;,
            &quot;max&quot;: null,
            &quot;default_value&quot;: &quot;&quot;,
            &quot;required&quot;: 0,
            &quot;use_as_filter&quot;: 0,
            &quot;help&quot;: &quot;&quot;,
            &quot;active&quot;: 1,
            &quot;options&quot;: []
        },
        {
            &quot;id&quot;: 5,
            &quot;belongs_to&quot;: &quot;post&quot;,
            &quot;name&quot;: &quot;Fuel Type&quot;,
            &quot;type&quot;: &quot;select&quot;,
            &quot;max&quot;: null,
            &quot;default_value&quot;: &quot;&quot;,
            &quot;required&quot;: 0,
            &quot;use_as_filter&quot;: 1,
            &quot;help&quot;: &quot;&quot;,
            &quot;active&quot;: 1,
            &quot;options&quot;: [
                {
                    &quot;id&quot;: 70,
                    &quot;field_id&quot;: 5,
                    &quot;value&quot;: &quot;Essence&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 139,
                    &quot;rgt&quot;: 140,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 71,
                    &quot;field_id&quot;: 5,
                    &quot;value&quot;: &quot;Diesel&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 141,
                    &quot;rgt&quot;: 142,
                    &quot;depth&quot;: null
                }
            ]
        },
        {
            &quot;id&quot;: 6,
            &quot;belongs_to&quot;: &quot;post&quot;,
            &quot;name&quot;: &quot;Features&quot;,
            &quot;type&quot;: &quot;checkbox_multiple&quot;,
            &quot;max&quot;: null,
            &quot;default_value&quot;: &quot;&quot;,
            &quot;required&quot;: 0,
            &quot;use_as_filter&quot;: 1,
            &quot;help&quot;: &quot;&quot;,
            &quot;active&quot;: 1,
            &quot;options&quot;: [
                {
                    &quot;id&quot;: 72,
                    &quot;field_id&quot;: 6,
                    &quot;value&quot;: &quot;Air Conditioner&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 143,
                    &quot;rgt&quot;: 144,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 73,
                    &quot;field_id&quot;: 6,
                    &quot;value&quot;: &quot;GPS&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 145,
                    &quot;rgt&quot;: 146,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 74,
                    &quot;field_id&quot;: 6,
                    &quot;value&quot;: &quot;Security System&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 147,
                    &quot;rgt&quot;: 148,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 75,
                    &quot;field_id&quot;: 6,
                    &quot;value&quot;: &quot;Spare Tire&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 149,
                    &quot;rgt&quot;: 150,
                    &quot;depth&quot;: null
                }
            ]
        },
        {
            &quot;id&quot;: 7,
            &quot;belongs_to&quot;: &quot;post&quot;,
            &quot;name&quot;: &quot;Transmission&quot;,
            &quot;type&quot;: &quot;radio&quot;,
            &quot;max&quot;: null,
            &quot;default_value&quot;: &quot;&quot;,
            &quot;required&quot;: 0,
            &quot;use_as_filter&quot;: 1,
            &quot;help&quot;: &quot;&quot;,
            &quot;active&quot;: 1,
            &quot;options&quot;: [
                {
                    &quot;id&quot;: 76,
                    &quot;field_id&quot;: 7,
                    &quot;value&quot;: &quot;Automatic&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 151,
                    &quot;rgt&quot;: 152,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 77,
                    &quot;field_id&quot;: 7,
                    &quot;value&quot;: &quot;Manual&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 153,
                    &quot;rgt&quot;: 154,
                    &quot;depth&quot;: null
                }
            ]
        },
        {
            &quot;id&quot;: 8,
            &quot;belongs_to&quot;: &quot;post&quot;,
            &quot;name&quot;: &quot;Condition&quot;,
            &quot;type&quot;: &quot;select&quot;,
            &quot;max&quot;: null,
            &quot;default_value&quot;: &quot;&quot;,
            &quot;required&quot;: 0,
            &quot;use_as_filter&quot;: 1,
            &quot;help&quot;: &quot;&quot;,
            &quot;active&quot;: 1,
            &quot;options&quot;: [
                {
                    &quot;id&quot;: 78,
                    &quot;field_id&quot;: 8,
                    &quot;value&quot;: &quot;New&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 155,
                    &quot;rgt&quot;: 156,
                    &quot;depth&quot;: null
                },
                {
                    &quot;id&quot;: 79,
                    &quot;field_id&quot;: 8,
                    &quot;value&quot;: &quot;Used&quot;,
                    &quot;parent_id&quot;: null,
                    &quot;lft&quot;: 157,
                    &quot;rgt&quot;: 158,
                    &quot;depth&quot;: null
                }
            ]
        }
    ],
    &quot;extra&quot;: {
        &quot;errors&quot;: [],
        &quot;oldInput&quot;: null
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-categories--id--fields" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-categories--id--fields"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-categories--id--fields"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-categories--id--fields" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-categories--id--fields">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-categories--id--fields" data-method="GET"
      data-path="api/categories/{id}/fields"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-categories--id--fields', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-categories--id--fields"
                    onclick="tryItOut('GETapi-categories--id--fields');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-categories--id--fields"
                    onclick="cancelTryOut('GETapi-categories--id--fields');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-categories--id--fields"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/categories/{id}/fields</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-categories--id--fields"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-categories--id--fields"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-categories--id--fields"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-categories--id--fields"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-categories--id--fields"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="id"                data-endpoint="GETapi-categories--id--fields"
               value="1"
               data-component="url">
    <br>
<p>The ID of the category. Example: <code>1</code></p>
            </div>
                            <h4 class="fancy-heading-panel"><b>Body Parameters</b></h4>
        <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>language_code</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="language_code"                data-endpoint="GETapi-categories--id--fields"
               value="en"
               data-component="body">
    <br>
<p>The code of the user's spoken language. Example: <code>en</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>post_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="post_id"                data-endpoint="GETapi-categories--id--fields"
               value="1"
               data-component="body">
    <br>
<p>The unique ID of the post. Example: <code>1</code></p>
        </div>
        </form>

                    <h2 id="categories-POSTapi-categories--id--fields">List category&#039;s fields</h2>

<p>
</p>



<span id="example-requests-POSTapi-categories--id--fields">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request POST \
    "https://demo.laraclassifier.local/api/categories/1/fields" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs" \
    --data "{
    \"language_code\": \"en\",
    \"post_id\": 1
}"
</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/categories/1/fields"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

let body = {
    "language_code": "en",
    "post_id": 1
};

fetch(url, {
    method: "POST",
    headers,
    body: JSON.stringify(body),
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/categories/1/fields';
$response = $client-&gt;post(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'json' =&gt; [
            'language_code' =&gt; 'en',
            'post_id' =&gt; 1,
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/categories/1/fields'
payload = {
    "language_code": "en",
    "post_id": 1
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('POST', url, headers=headers, json=payload)
response.json()</code></pre></div>

</span>

<span id="example-responses-POSTapi-categories--id--fields">
</span>
<span id="execution-results-POSTapi-categories--id--fields" hidden>
    <blockquote>Received response<span
                id="execution-response-status-POSTapi-categories--id--fields"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-POSTapi-categories--id--fields"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-POSTapi-categories--id--fields" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-POSTapi-categories--id--fields">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-POSTapi-categories--id--fields" data-method="POST"
      data-path="api/categories/{id}/fields"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('POSTapi-categories--id--fields', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-POSTapi-categories--id--fields"
                    onclick="tryItOut('POSTapi-categories--id--fields');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-POSTapi-categories--id--fields"
                    onclick="cancelTryOut('POSTapi-categories--id--fields');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-POSTapi-categories--id--fields"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-black">POST</small>
            <b><code>api/categories/{id}/fields</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="POSTapi-categories--id--fields"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="POSTapi-categories--id--fields"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="POSTapi-categories--id--fields"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="POSTapi-categories--id--fields"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="POSTapi-categories--id--fields"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="id"                data-endpoint="POSTapi-categories--id--fields"
               value="1"
               data-component="url">
    <br>
<p>The ID of the category. Example: <code>1</code></p>
            </div>
                            <h4 class="fancy-heading-panel"><b>Body Parameters</b></h4>
        <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>language_code</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="language_code"                data-endpoint="POSTapi-categories--id--fields"
               value="en"
               data-component="body">
    <br>
<p>The code of the user's spoken language. Example: <code>en</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>post_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="post_id"                data-endpoint="POSTapi-categories--id--fields"
               value="1"
               data-component="body">
    <br>
<p>The unique ID of the post. Example: <code>1</code></p>
        </div>
        </form>

                <h1 id="contact">Contact</h1>

    

                                <h2 id="contact-POSTapi-contact">Send Form</h2>

<p>
</p>

<p>Send a message to the site owner.</p>

<span id="example-requests-POSTapi-contact">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request POST \
    "https://demo.laraclassifier.local/api/contact" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs" \
    --data "{
    \"name\": \"corrupti\",
    \"email\": \"john.doe@domain.tld\",
    \"phone\": \"officia\",
    \"message\": \"Nesciunt porro possimus maiores voluptatibus accusamus velit qui aspernatur.\",
    \"country_code\": \"US\",
    \"country_name\": \"United Sates\",
    \"first_name\": \"John\",
    \"last_name\": \"Doe\",
    \"captcha_key\": \"repellendus\"
}"
</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/contact"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

let body = {
    "name": "corrupti",
    "email": "john.doe@domain.tld",
    "phone": "officia",
    "message": "Nesciunt porro possimus maiores voluptatibus accusamus velit qui aspernatur.",
    "country_code": "US",
    "country_name": "United Sates",
    "first_name": "John",
    "last_name": "Doe",
    "captcha_key": "repellendus"
};

fetch(url, {
    method: "POST",
    headers,
    body: JSON.stringify(body),
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/contact';
$response = $client-&gt;post(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'json' =&gt; [
            'name' =&gt; 'corrupti',
            'email' =&gt; 'john.doe@domain.tld',
            'phone' =&gt; 'officia',
            'message' =&gt; 'Nesciunt porro possimus maiores voluptatibus accusamus velit qui aspernatur.',
            'country_code' =&gt; 'US',
            'country_name' =&gt; 'United Sates',
            'first_name' =&gt; 'John',
            'last_name' =&gt; 'Doe',
            'captcha_key' =&gt; 'repellendus',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/contact'
payload = {
    "name": "corrupti",
    "email": "john.doe@domain.tld",
    "phone": "officia",
    "message": "Nesciunt porro possimus maiores voluptatibus accusamus velit qui aspernatur.",
    "country_code": "US",
    "country_name": "United Sates",
    "first_name": "John",
    "last_name": "Doe",
    "captcha_key": "repellendus"
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('POST', url, headers=headers, json=payload)
response.json()</code></pre></div>

</span>

<span id="example-responses-POSTapi-contact">
</span>
<span id="execution-results-POSTapi-contact" hidden>
    <blockquote>Received response<span
                id="execution-response-status-POSTapi-contact"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-POSTapi-contact"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-POSTapi-contact" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-POSTapi-contact">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-POSTapi-contact" data-method="POST"
      data-path="api/contact"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('POSTapi-contact', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-POSTapi-contact"
                    onclick="tryItOut('POSTapi-contact');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-POSTapi-contact"
                    onclick="cancelTryOut('POSTapi-contact');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-POSTapi-contact"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-black">POST</small>
            <b><code>api/contact</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="POSTapi-contact"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="POSTapi-contact"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="POSTapi-contact"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="POSTapi-contact"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="POSTapi-contact"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                                <h4 class="fancy-heading-panel"><b>Body Parameters</b></h4>
        <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>name</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="name"                data-endpoint="POSTapi-contact"
               value="corrupti"
               data-component="body">
    <br>
<p>Example: <code>corrupti</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>email</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="email"                data-endpoint="POSTapi-contact"
               value="john.doe@domain.tld"
               data-component="body">
    <br>
<p>The user's email address. Example: <code>john.doe@domain.tld</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>phone</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="phone"                data-endpoint="POSTapi-contact"
               value="officia"
               data-component="body">
    <br>
<p>Example: <code>officia</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>message</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="message"                data-endpoint="POSTapi-contact"
               value="Nesciunt porro possimus maiores voluptatibus accusamus velit qui aspernatur."
               data-component="body">
    <br>
<p>The message to send. Example: <code>Nesciunt porro possimus maiores voluptatibus accusamus velit qui aspernatur.</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>country_code</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="country_code"                data-endpoint="POSTapi-contact"
               value="US"
               data-component="body">
    <br>
<p>The user's country code. Example: <code>US</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>country_name</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="country_name"                data-endpoint="POSTapi-contact"
               value="United Sates"
               data-component="body">
    <br>
<p>The user's country name. Example: <code>United Sates</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>first_name</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="first_name"                data-endpoint="POSTapi-contact"
               value="John"
               data-component="body">
    <br>
<p>The user's first name. Example: <code>John</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>last_name</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="last_name"                data-endpoint="POSTapi-contact"
               value="Doe"
               data-component="body">
    <br>
<p>The user's last name. Example: <code>Doe</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>captcha_key</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="captcha_key"                data-endpoint="POSTapi-contact"
               value="repellendus"
               data-component="body">
    <br>
<p>Key generated by the CAPTCHA endpoint calling (Required when the CAPTCHA verification is enabled from the Admin panel). Example: <code>repellendus</code></p>
        </div>
        </form>

                    <h2 id="contact-POSTapi-posts--id--report">Report post</h2>

<p>
</p>

<p>Report abuse or issues</p>

<span id="example-requests-POSTapi-posts--id--report">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request POST \
    "https://demo.laraclassifier.local/api/posts/8/report" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs" \
    --data "{
    \"report_type_id\": 2,
    \"email\": \"john.doe@domain.tld\",
    \"message\": \"Et sunt voluptatibus ducimus id assumenda sint.\",
    \"captcha_key\": \"fugit\"
}"
</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/posts/8/report"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

let body = {
    "report_type_id": 2,
    "email": "john.doe@domain.tld",
    "message": "Et sunt voluptatibus ducimus id assumenda sint.",
    "captcha_key": "fugit"
};

fetch(url, {
    method: "POST",
    headers,
    body: JSON.stringify(body),
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/posts/8/report';
$response = $client-&gt;post(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'json' =&gt; [
            'report_type_id' =&gt; 2,
            'email' =&gt; 'john.doe@domain.tld',
            'message' =&gt; 'Et sunt voluptatibus ducimus id assumenda sint.',
            'captcha_key' =&gt; 'fugit',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/posts/8/report'
payload = {
    "report_type_id": 2,
    "email": "john.doe@domain.tld",
    "message": "Et sunt voluptatibus ducimus id assumenda sint.",
    "captcha_key": "fugit"
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('POST', url, headers=headers, json=payload)
response.json()</code></pre></div>

</span>

<span id="example-responses-POSTapi-posts--id--report">
</span>
<span id="execution-results-POSTapi-posts--id--report" hidden>
    <blockquote>Received response<span
                id="execution-response-status-POSTapi-posts--id--report"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-POSTapi-posts--id--report"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-POSTapi-posts--id--report" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-POSTapi-posts--id--report">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-POSTapi-posts--id--report" data-method="POST"
      data-path="api/posts/{id}/report"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('POSTapi-posts--id--report', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-POSTapi-posts--id--report"
                    onclick="tryItOut('POSTapi-posts--id--report');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-POSTapi-posts--id--report"
                    onclick="cancelTryOut('POSTapi-posts--id--report');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-POSTapi-posts--id--report"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-black">POST</small>
            <b><code>api/posts/{id}/report</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="POSTapi-posts--id--report"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="POSTapi-posts--id--report"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="POSTapi-posts--id--report"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="POSTapi-posts--id--report"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="POSTapi-posts--id--report"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="id"                data-endpoint="POSTapi-posts--id--report"
               value="8"
               data-component="url">
    <br>
<p>The post ID. Example: <code>8</code></p>
            </div>
                            <h4 class="fancy-heading-panel"><b>Body Parameters</b></h4>
        <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>report_type_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="report_type_id"                data-endpoint="POSTapi-posts--id--report"
               value="2"
               data-component="body">
    <br>
<p>The report type ID. Example: <code>2</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>email</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="email"                data-endpoint="POSTapi-posts--id--report"
               value="john.doe@domain.tld"
               data-component="body">
    <br>
<p>The user's email address. Example: <code>john.doe@domain.tld</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>message</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="message"                data-endpoint="POSTapi-posts--id--report"
               value="Et sunt voluptatibus ducimus id assumenda sint."
               data-component="body">
    <br>
<p>The message to send. Example: <code>Et sunt voluptatibus ducimus id assumenda sint.</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>captcha_key</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="captcha_key"                data-endpoint="POSTapi-posts--id--report"
               value="fugit"
               data-component="body">
    <br>
<p>Key generated by the CAPTCHA endpoint calling (Required when the CAPTCHA verification is enabled from the Admin panel). Example: <code>fugit</code></p>
        </div>
        </form>

                <h1 id="countries">Countries</h1>

    

                                <h2 id="countries-GETapi-countries">List countries</h2>

<p>
</p>



<span id="example-requests-GETapi-countries">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/countries?embed=&amp;includeNonActive=&amp;iti=%27onlyCountries%27&amp;countryCode=&amp;sort=-name&amp;perPage=2" \
    --header "Content-Language: en" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/countries"
);

const params = {
    "embed": "",
    "includeNonActive": "0",
    "iti": "'onlyCountries'",
    "countryCode": "",
    "sort": "-name",
    "perPage": "2",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Language": "en",
    "Content-Type": "application/json",
    "Accept": "application/json",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/countries';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Language' =&gt; 'en',
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'embed' =&gt; '',
            'includeNonActive' =&gt; '0',
            'iti' =&gt; ''onlyCountries'',
            'countryCode' =&gt; '',
            'sort' =&gt; '-name',
            'perPage' =&gt; '2',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/countries'
params = {
  'embed': '',
  'includeNonActive': '0',
  'iti': ''onlyCountries'',
  'countryCode': '',
  'sort': '-name',
  'perPage': '2',
}
headers = {
  'Content-Language': 'en',
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-countries">
            <blockquote>
            <p>Example response (400):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: false,
    &quot;message&quot;: &quot;No data available. Only \&quot;i18n\&quot; and \&quot;onlyCountries\&quot; are accepted for the \&quot;iti\&quot; parameter.&quot;,
    &quot;result&quot;: null
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-countries" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-countries"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-countries"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-countries" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-countries">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-countries" data-method="GET"
      data-path="api/countries"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-countries', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-countries"
                    onclick="tryItOut('GETapi-countries');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-countries"
                    onclick="cancelTryOut('GETapi-countries');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-countries"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/countries</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-countries"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-countries"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-countries"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-countries"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-countries"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                            <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>embed</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="embed"                data-endpoint="GETapi-countries"
               value=""
               data-component="query">
    <br>
<p>Comma-separated list of the country relationships for Eager Loading - Possible values: currency,continent.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>includeNonActive</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="GETapi-countries" style="display: none">
            <input type="radio" name="includeNonActive"
                   value="1"
                   data-endpoint="GETapi-countries"
                   data-component="query"             >
            <code>true</code>
        </label>
        <label data-endpoint="GETapi-countries" style="display: none">
            <input type="radio" name="includeNonActive"
                   value="0"
                   data-endpoint="GETapi-countries"
                   data-component="query"             >
            <code>false</code>
        </label>
    <br>
<p>Allow including the non-activated countries in the list. Example: <code>false</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>iti</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="iti"                data-endpoint="GETapi-countries"
               value="'onlyCountries'"
               data-component="query">
    <br>
<p>Allow getting option data for the phone number input. Possible value: 'i18n' or 'onlyCountries'. Example: <code>'onlyCountries'</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>countryCode</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="countryCode"                data-endpoint="GETapi-countries"
               value=""
               data-component="query">
    <br>
<p>The code of the current country (Only when the 'iti' parameter is filled to true).</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>sort</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="sort"                data-endpoint="GETapi-countries"
               value="-name"
               data-component="query">
    <br>
<p>The sorting parameter (Order by DESC with the given column. Use &quot;-&quot; as prefix to order by ASC). Possible values: name. Example: <code>-name</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>perPage</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="perPage"                data-endpoint="GETapi-countries"
               value="2"
               data-component="query">
    <br>
<p>Items per page. Can be defined globally from the admin settings. Cannot be exceeded 100. Example: <code>2</code></p>
            </div>
                </form>

                    <h2 id="countries-GETapi-countries--code-">Get country</h2>

<p>
</p>



<span id="example-requests-GETapi-countries--code-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/countries/DE?embed=currency" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/countries/DE"
);

const params = {
    "embed": "currency",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/countries/DE';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'embed' =&gt; 'currency',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/countries/DE'
params = {
  'embed': 'currency',
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-countries--code-">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;code&quot;: &quot;DE&quot;,
        &quot;name&quot;: &quot;Germany&quot;,
        &quot;capital&quot;: &quot;Berlin&quot;,
        &quot;continent_code&quot;: &quot;EU&quot;,
        &quot;tld&quot;: &quot;.de&quot;,
        &quot;currency_code&quot;: &quot;EUR&quot;,
        &quot;phone&quot;: &quot;49&quot;,
        &quot;languages&quot;: &quot;de&quot;,
        &quot;time_zone&quot;: null,
        &quot;date_format&quot;: null,
        &quot;datetime_format&quot;: null,
        &quot;background_image_path&quot;: &quot;app/logo/header-68bea24d673de.jpg&quot;,
        &quot;admin_type&quot;: &quot;1&quot;,
        &quot;active&quot;: 1,
        &quot;currencies&quot;: null,
        &quot;icode&quot;: &quot;de&quot;,
        &quot;flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/de.png&quot;,
        &quot;flag16_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/de.png&quot;,
        &quot;flag24_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/24/de.png&quot;,
        &quot;flag32_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/32/de.png&quot;,
        &quot;flag48_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/48/de.png&quot;,
        &quot;flag64_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/64/de.png&quot;,
        &quot;background_image_url&quot;: null,
        &quot;currency&quot;: {
            &quot;code&quot;: &quot;EUR&quot;,
            &quot;name&quot;: &quot;Euro Member Countries&quot;,
            &quot;symbol&quot;: &quot;&euro;&quot;,
            &quot;html_entities&quot;: &quot;&euro;&quot;,
            &quot;in_left&quot;: 0,
            &quot;decimal_places&quot;: 2,
            &quot;decimal_separator&quot;: &quot;,&quot;,
            &quot;thousand_separator&quot;: &quot; &quot;,
            &quot;rate&quot;: null
        }
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-countries--code-" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-countries--code-"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-countries--code-"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-countries--code-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-countries--code-">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-countries--code-" data-method="GET"
      data-path="api/countries/{code}"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-countries--code-', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-countries--code-"
                    onclick="tryItOut('GETapi-countries--code-');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-countries--code-"
                    onclick="cancelTryOut('GETapi-countries--code-');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-countries--code-"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/countries/{code}</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-countries--code-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-countries--code-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-countries--code-"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-countries--code-"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-countries--code-"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>code</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="code"                data-endpoint="GETapi-countries--code-"
               value="DE"
               data-component="url">
    <br>
<p>The country's ISO 3166-1 code. Example: <code>DE</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>embed</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="embed"                data-endpoint="GETapi-countries--code-"
               value="currency"
               data-component="query">
    <br>
<p>Comma-separated list of the country relationships for Eager Loading - Possible values: currency. Example: <code>currency</code></p>
            </div>
                </form>

                    <h2 id="countries-GETapi-countries--countryCode--subAdmins1">List admin. divisions (1)</h2>

<p>
</p>



<span id="example-requests-GETapi-countries--countryCode--subAdmins1">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/countries/US/subAdmins1?embed=&amp;q=&amp;sort=-name&amp;perPage=2&amp;page=1" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/countries/US/subAdmins1"
);

const params = {
    "embed": "",
    "q": "",
    "sort": "-name",
    "perPage": "2",
    "page": "1",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/countries/US/subAdmins1';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'embed' =&gt; '',
            'q' =&gt; '',
            'sort' =&gt; '-name',
            'perPage' =&gt; '2',
            'page' =&gt; '1',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/countries/US/subAdmins1'
params = {
  'embed': '',
  'q': '',
  'sort': '-name',
  'perPage': '2',
  'page': '1',
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-countries--countryCode--subAdmins1">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;data&quot;: [
            {
                &quot;code&quot;: &quot;US.WY&quot;,
                &quot;country_code&quot;: &quot;US&quot;,
                &quot;name&quot;: &quot;Wyoming&quot;,
                &quot;active&quot;: 1
            },
            {
                &quot;code&quot;: &quot;US.WV&quot;,
                &quot;country_code&quot;: &quot;US&quot;,
                &quot;name&quot;: &quot;West Virginia&quot;,
                &quot;active&quot;: 1
            }
        ],
        &quot;links&quot;: {
            &quot;first&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins1?page=1&quot;,
            &quot;last&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins1?page=26&quot;,
            &quot;prev&quot;: null,
            &quot;next&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins1?page=2&quot;
        },
        &quot;meta&quot;: {
            &quot;current_page&quot;: 1,
            &quot;from&quot;: 1,
            &quot;last_page&quot;: 26,
            &quot;links&quot;: [
                {
                    &quot;url&quot;: null,
                    &quot;label&quot;: &quot;&amp;laquo; Previous&quot;,
                    &quot;page&quot;: null,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins1?page=1&quot;,
                    &quot;label&quot;: &quot;1&quot;,
                    &quot;page&quot;: 1,
                    &quot;active&quot;: true
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins1?page=2&quot;,
                    &quot;label&quot;: &quot;2&quot;,
                    &quot;page&quot;: 2,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins1?page=3&quot;,
                    &quot;label&quot;: &quot;3&quot;,
                    &quot;page&quot;: 3,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins1?page=4&quot;,
                    &quot;label&quot;: &quot;4&quot;,
                    &quot;page&quot;: 4,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins1?page=5&quot;,
                    &quot;label&quot;: &quot;5&quot;,
                    &quot;page&quot;: 5,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins1?page=6&quot;,
                    &quot;label&quot;: &quot;6&quot;,
                    &quot;page&quot;: 6,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: null,
                    &quot;label&quot;: &quot;...&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins1?page=25&quot;,
                    &quot;label&quot;: &quot;25&quot;,
                    &quot;page&quot;: 25,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins1?page=26&quot;,
                    &quot;label&quot;: &quot;26&quot;,
                    &quot;page&quot;: 26,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins1?page=2&quot;,
                    &quot;label&quot;: &quot;Next &amp;raquo;&quot;,
                    &quot;page&quot;: 2,
                    &quot;active&quot;: false
                }
            ],
            &quot;path&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins1&quot;,
            &quot;per_page&quot;: 2,
            &quot;to&quot;: 2,
            &quot;total&quot;: 51
        }
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-countries--countryCode--subAdmins1" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-countries--countryCode--subAdmins1"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-countries--countryCode--subAdmins1"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-countries--countryCode--subAdmins1" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-countries--countryCode--subAdmins1">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-countries--countryCode--subAdmins1" data-method="GET"
      data-path="api/countries/{countryCode}/subAdmins1"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-countries--countryCode--subAdmins1', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-countries--countryCode--subAdmins1"
                    onclick="tryItOut('GETapi-countries--countryCode--subAdmins1');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-countries--countryCode--subAdmins1"
                    onclick="cancelTryOut('GETapi-countries--countryCode--subAdmins1');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-countries--countryCode--subAdmins1"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/countries/{countryCode}/subAdmins1</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-countries--countryCode--subAdmins1"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-countries--countryCode--subAdmins1"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-countries--countryCode--subAdmins1"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-countries--countryCode--subAdmins1"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-countries--countryCode--subAdmins1"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>countryCode</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="countryCode"                data-endpoint="GETapi-countries--countryCode--subAdmins1"
               value="US"
               data-component="url">
    <br>
<p>The country code of the country of the cities to retrieve. Example: <code>US</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>embed</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="embed"                data-endpoint="GETapi-countries--countryCode--subAdmins1"
               value=""
               data-component="query">
    <br>
<p>Comma-separated list of the administrative division (1) relationships for Eager Loading - Possible values: country.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>q</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="q"                data-endpoint="GETapi-countries--countryCode--subAdmins1"
               value=""
               data-component="query">
    <br>
<p>Get the administrative division list related to the entered keyword.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>sort</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="sort"                data-endpoint="GETapi-countries--countryCode--subAdmins1"
               value="-name"
               data-component="query">
    <br>
<p>The sorting parameter (Order by DESC with the given column. Use &quot;-&quot; as prefix to order by ASC). Possible values: name. Example: <code>-name</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>perPage</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="perPage"                data-endpoint="GETapi-countries--countryCode--subAdmins1"
               value="2"
               data-component="query">
    <br>
<p>Items per page. Can be defined globally from the admin settings. Cannot be exceeded 100. Example: <code>2</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>page</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="page"                data-endpoint="GETapi-countries--countryCode--subAdmins1"
               value="1"
               data-component="query">
    <br>
<p>Items page number. From 1 to (&quot;total items&quot; divided by &quot;items per page value - perPage&quot;). Example: <code>1</code></p>
            </div>
                </form>

                    <h2 id="countries-GETapi-countries--countryCode--subAdmins2">List admin. divisions (2)</h2>

<p>
</p>



<span id="example-requests-GETapi-countries--countryCode--subAdmins2">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/countries/US/subAdmins2?embed=&amp;admin1Code=&amp;q=&amp;sort=-name&amp;perPage=2&amp;page=1" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/countries/US/subAdmins2"
);

const params = {
    "embed": "",
    "admin1Code": "",
    "q": "",
    "sort": "-name",
    "perPage": "2",
    "page": "1",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/countries/US/subAdmins2';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'embed' =&gt; '',
            'admin1Code' =&gt; '',
            'q' =&gt; '',
            'sort' =&gt; '-name',
            'perPage' =&gt; '2',
            'page' =&gt; '1',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/countries/US/subAdmins2'
params = {
  'embed': '',
  'admin1Code': '',
  'q': '',
  'sort': '-name',
  'perPage': '2',
  'page': '1',
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-countries--countryCode--subAdmins2">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;data&quot;: [
            {
                &quot;code&quot;: &quot;US.WY.045&quot;,
                &quot;country_code&quot;: &quot;US&quot;,
                &quot;subadmin1_code&quot;: &quot;US.WY&quot;,
                &quot;name&quot;: &quot;Weston County&quot;,
                &quot;active&quot;: 1
            },
            {
                &quot;code&quot;: &quot;US.WY.043&quot;,
                &quot;country_code&quot;: &quot;US&quot;,
                &quot;subadmin1_code&quot;: &quot;US.WY&quot;,
                &quot;name&quot;: &quot;Washakie County&quot;,
                &quot;active&quot;: 1
            }
        ],
        &quot;links&quot;: {
            &quot;first&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins2?page=1&quot;,
            &quot;last&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins2?page=1572&quot;,
            &quot;prev&quot;: null,
            &quot;next&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins2?page=2&quot;
        },
        &quot;meta&quot;: {
            &quot;current_page&quot;: 1,
            &quot;from&quot;: 1,
            &quot;last_page&quot;: 1572,
            &quot;links&quot;: [
                {
                    &quot;url&quot;: null,
                    &quot;label&quot;: &quot;&amp;laquo; Previous&quot;,
                    &quot;page&quot;: null,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins2?page=1&quot;,
                    &quot;label&quot;: &quot;1&quot;,
                    &quot;page&quot;: 1,
                    &quot;active&quot;: true
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins2?page=2&quot;,
                    &quot;label&quot;: &quot;2&quot;,
                    &quot;page&quot;: 2,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins2?page=3&quot;,
                    &quot;label&quot;: &quot;3&quot;,
                    &quot;page&quot;: 3,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins2?page=4&quot;,
                    &quot;label&quot;: &quot;4&quot;,
                    &quot;page&quot;: 4,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins2?page=5&quot;,
                    &quot;label&quot;: &quot;5&quot;,
                    &quot;page&quot;: 5,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins2?page=6&quot;,
                    &quot;label&quot;: &quot;6&quot;,
                    &quot;page&quot;: 6,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins2?page=7&quot;,
                    &quot;label&quot;: &quot;7&quot;,
                    &quot;page&quot;: 7,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins2?page=8&quot;,
                    &quot;label&quot;: &quot;8&quot;,
                    &quot;page&quot;: 8,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: null,
                    &quot;label&quot;: &quot;...&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins2?page=1571&quot;,
                    &quot;label&quot;: &quot;1571&quot;,
                    &quot;page&quot;: 1571,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins2?page=1572&quot;,
                    &quot;label&quot;: &quot;1572&quot;,
                    &quot;page&quot;: 1572,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins2?page=2&quot;,
                    &quot;label&quot;: &quot;Next &amp;raquo;&quot;,
                    &quot;page&quot;: 2,
                    &quot;active&quot;: false
                }
            ],
            &quot;path&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/subAdmins2&quot;,
            &quot;per_page&quot;: 2,
            &quot;to&quot;: 2,
            &quot;total&quot;: 3143
        }
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-countries--countryCode--subAdmins2" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-countries--countryCode--subAdmins2"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-countries--countryCode--subAdmins2"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-countries--countryCode--subAdmins2" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-countries--countryCode--subAdmins2">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-countries--countryCode--subAdmins2" data-method="GET"
      data-path="api/countries/{countryCode}/subAdmins2"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-countries--countryCode--subAdmins2', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-countries--countryCode--subAdmins2"
                    onclick="tryItOut('GETapi-countries--countryCode--subAdmins2');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-countries--countryCode--subAdmins2"
                    onclick="cancelTryOut('GETapi-countries--countryCode--subAdmins2');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-countries--countryCode--subAdmins2"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/countries/{countryCode}/subAdmins2</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-countries--countryCode--subAdmins2"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-countries--countryCode--subAdmins2"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-countries--countryCode--subAdmins2"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-countries--countryCode--subAdmins2"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-countries--countryCode--subAdmins2"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>countryCode</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="countryCode"                data-endpoint="GETapi-countries--countryCode--subAdmins2"
               value="US"
               data-component="url">
    <br>
<p>The country code of the country of the cities to retrieve. Example: <code>US</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>embed</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="embed"                data-endpoint="GETapi-countries--countryCode--subAdmins2"
               value=""
               data-component="query">
    <br>
<p>Comma-separated list of the administrative division (2) relationships for Eager Loading - Possible values: country,subAdmin1.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>admin1Code</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="admin1Code"                data-endpoint="GETapi-countries--countryCode--subAdmins2"
               value=""
               data-component="query">
    <br>
<p>Get the administrative division 2 list related to the administrative division 1 code.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>q</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="q"                data-endpoint="GETapi-countries--countryCode--subAdmins2"
               value=""
               data-component="query">
    <br>
<p>Get the administrative division 2 list related to the entered keyword.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>sort</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="sort"                data-endpoint="GETapi-countries--countryCode--subAdmins2"
               value="-name"
               data-component="query">
    <br>
<p>The sorting parameter (Order by DESC with the given column. Use &quot;-&quot; as prefix to order by ASC). Possible values: name. Example: <code>-name</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>perPage</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="perPage"                data-endpoint="GETapi-countries--countryCode--subAdmins2"
               value="2"
               data-component="query">
    <br>
<p>Items per page. Can be defined globally from the admin settings. Cannot be exceeded 100. Example: <code>2</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>page</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="page"                data-endpoint="GETapi-countries--countryCode--subAdmins2"
               value="1"
               data-component="query">
    <br>
<p>Items page number. From 1 to (&quot;total items&quot; divided by &quot;items per page value - perPage&quot;). Example: <code>1</code></p>
            </div>
                </form>

                    <h2 id="countries-GETapi-countries--countryCode--cities">List cities</h2>

<p>
</p>



<span id="example-requests-GETapi-countries--countryCode--cities">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/countries/US/cities?embed=&amp;admin1Code=&amp;admin2Code=&amp;q=&amp;autocomplete=&amp;sort=-name&amp;perPage=2&amp;page=1" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/countries/US/cities"
);

const params = {
    "embed": "",
    "admin1Code": "",
    "admin2Code": "",
    "q": "",
    "autocomplete": "0",
    "sort": "-name",
    "perPage": "2",
    "page": "1",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/countries/US/cities';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'embed' =&gt; '',
            'admin1Code' =&gt; '',
            'admin2Code' =&gt; '',
            'q' =&gt; '',
            'autocomplete' =&gt; '0',
            'sort' =&gt; '-name',
            'perPage' =&gt; '2',
            'page' =&gt; '1',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/countries/US/cities'
params = {
  'embed': '',
  'admin1Code': '',
  'admin2Code': '',
  'q': '',
  'autocomplete': '0',
  'sort': '-name',
  'perPage': '2',
  'page': '1',
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-countries--countryCode--cities">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;data&quot;: [
            {
                &quot;id&quot;: 50797,
                &quot;country_code&quot;: &quot;US&quot;,
                &quot;name&quot;: &quot;Communications Hill&quot;,
                &quot;latitude&quot;: 37.29,
                &quot;longitude&quot;: -121.86,
                &quot;subadmin1_code&quot;: &quot;US.CA&quot;,
                &quot;subadmin2_code&quot;: &quot;US.CA.085&quot;,
                &quot;population&quot;: 11267,
                &quot;time_zone&quot;: &quot;America/Los_Angeles&quot;,
                &quot;active&quot;: 1,
                &quot;slug&quot;: &quot;communications-hill&quot;,
                &quot;posts_count&quot;: 0
            },
            {
                &quot;id&quot;: 50796,
                &quot;country_code&quot;: &quot;US&quot;,
                &quot;name&quot;: &quot;James Island&quot;,
                &quot;latitude&quot;: 32.72,
                &quot;longitude&quot;: -79.96,
                &quot;subadmin1_code&quot;: &quot;US.SC&quot;,
                &quot;subadmin2_code&quot;: &quot;US.SC.019&quot;,
                &quot;population&quot;: 6000,
                &quot;time_zone&quot;: &quot;America/New_York&quot;,
                &quot;active&quot;: 1,
                &quot;slug&quot;: &quot;james-island&quot;,
                &quot;posts_count&quot;: 0
            }
        ],
        &quot;links&quot;: {
            &quot;first&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities?page=1&quot;,
            &quot;last&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities?page=3600&quot;,
            &quot;prev&quot;: null,
            &quot;next&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities?page=2&quot;
        },
        &quot;meta&quot;: {
            &quot;current_page&quot;: 1,
            &quot;from&quot;: 1,
            &quot;last_page&quot;: 3600,
            &quot;links&quot;: [
                {
                    &quot;url&quot;: null,
                    &quot;label&quot;: &quot;&amp;laquo; Previous&quot;,
                    &quot;page&quot;: null,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities?page=1&quot;,
                    &quot;label&quot;: &quot;1&quot;,
                    &quot;page&quot;: 1,
                    &quot;active&quot;: true
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities?page=2&quot;,
                    &quot;label&quot;: &quot;2&quot;,
                    &quot;page&quot;: 2,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities?page=3&quot;,
                    &quot;label&quot;: &quot;3&quot;,
                    &quot;page&quot;: 3,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities?page=4&quot;,
                    &quot;label&quot;: &quot;4&quot;,
                    &quot;page&quot;: 4,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities?page=5&quot;,
                    &quot;label&quot;: &quot;5&quot;,
                    &quot;page&quot;: 5,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities?page=6&quot;,
                    &quot;label&quot;: &quot;6&quot;,
                    &quot;page&quot;: 6,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities?page=7&quot;,
                    &quot;label&quot;: &quot;7&quot;,
                    &quot;page&quot;: 7,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities?page=8&quot;,
                    &quot;label&quot;: &quot;8&quot;,
                    &quot;page&quot;: 8,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities?page=9&quot;,
                    &quot;label&quot;: &quot;9&quot;,
                    &quot;page&quot;: 9,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities?page=10&quot;,
                    &quot;label&quot;: &quot;10&quot;,
                    &quot;page&quot;: 10,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: null,
                    &quot;label&quot;: &quot;...&quot;,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities?page=3599&quot;,
                    &quot;label&quot;: &quot;3599&quot;,
                    &quot;page&quot;: 3599,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities?page=3600&quot;,
                    &quot;label&quot;: &quot;3600&quot;,
                    &quot;page&quot;: 3600,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities?page=2&quot;,
                    &quot;label&quot;: &quot;Next &amp;raquo;&quot;,
                    &quot;page&quot;: 2,
                    &quot;active&quot;: false
                }
            ],
            &quot;path&quot;: &quot;https://demo.laraclassifier.local/api/countries/US/cities&quot;,
            &quot;per_page&quot;: 2,
            &quot;to&quot;: 2,
            &quot;total&quot;: 7200
        }
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-countries--countryCode--cities" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-countries--countryCode--cities"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-countries--countryCode--cities"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-countries--countryCode--cities" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-countries--countryCode--cities">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-countries--countryCode--cities" data-method="GET"
      data-path="api/countries/{countryCode}/cities"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-countries--countryCode--cities', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-countries--countryCode--cities"
                    onclick="tryItOut('GETapi-countries--countryCode--cities');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-countries--countryCode--cities"
                    onclick="cancelTryOut('GETapi-countries--countryCode--cities');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-countries--countryCode--cities"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/countries/{countryCode}/cities</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-countries--countryCode--cities"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-countries--countryCode--cities"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-countries--countryCode--cities"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-countries--countryCode--cities"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-countries--countryCode--cities"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>countryCode</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="countryCode"                data-endpoint="GETapi-countries--countryCode--cities"
               value="US"
               data-component="url">
    <br>
<p>The country code of the country of the cities to retrieve. Example: <code>US</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>embed</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="embed"                data-endpoint="GETapi-countries--countryCode--cities"
               value=""
               data-component="query">
    <br>
<p>Comma-separated list of the city relationships for Eager Loading - Possible values: country,subAdmin1,subAdmin2.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>admin1Code</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="admin1Code"                data-endpoint="GETapi-countries--countryCode--cities"
               value=""
               data-component="query">
    <br>
<p>Get the city list related to the administrative division 1 code.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>admin2Code</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="admin2Code"                data-endpoint="GETapi-countries--countryCode--cities"
               value=""
               data-component="query">
    <br>
<p>Get the city list related to the administrative division 2 code.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>q</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="q"                data-endpoint="GETapi-countries--countryCode--cities"
               value=""
               data-component="query">
    <br>
<p>Get the city list related to the entered keyword.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>autocomplete</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="GETapi-countries--countryCode--cities" style="display: none">
            <input type="radio" name="autocomplete"
                   value="1"
                   data-endpoint="GETapi-countries--countryCode--cities"
                   data-component="query"             >
            <code>true</code>
        </label>
        <label data-endpoint="GETapi-countries--countryCode--cities" style="display: none">
            <input type="radio" name="autocomplete"
                   value="0"
                   data-endpoint="GETapi-countries--countryCode--cities"
                   data-component="query"             >
            <code>false</code>
        </label>
    <br>
<p>Allow getting the city list in the autocomplete data format. Possible value: 0 or 1. Example: <code>false</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>sort</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="sort"                data-endpoint="GETapi-countries--countryCode--cities"
               value="-name"
               data-component="query">
    <br>
<p>string|array The sorting parameter (Order by DESC with the given column. Use &quot;-&quot; as prefix to order by ASC). Possible values: name,population. Example: <code>-name</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>perPage</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="perPage"                data-endpoint="GETapi-countries--countryCode--cities"
               value="2"
               data-component="query">
    <br>
<p>Items per page. Can be defined globally from the admin settings. Cannot be exceeded 100. Example: <code>2</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>page</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="page"                data-endpoint="GETapi-countries--countryCode--cities"
               value="1"
               data-component="query">
    <br>
<p>Items page number. From 1 to (&quot;total items&quot; divided by &quot;items per page value - perPage&quot;). Example: <code>1</code></p>
            </div>
                </form>

                    <h2 id="countries-GETapi-subAdmins1--code-">Get admin. division (1)</h2>

<p>
</p>



<span id="example-requests-GETapi-subAdmins1--code-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/subAdmins1/CH.VD?embed=" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/subAdmins1/CH.VD"
);

const params = {
    "embed": "",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/subAdmins1/CH.VD';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'embed' =&gt; '',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/subAdmins1/CH.VD'
params = {
  'embed': '',
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-subAdmins1--code-">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: &quot;No administrative divisions found&quot;,
    &quot;result&quot;: {
        &quot;data&quot;: [],
        &quot;links&quot;: {
            &quot;first&quot;: &quot;https://demo.laraclassifier.local/api/subAdmins1/CH.VD?page=1&quot;,
            &quot;last&quot;: &quot;https://demo.laraclassifier.local/api/subAdmins1/CH.VD?page=1&quot;,
            &quot;prev&quot;: null,
            &quot;next&quot;: null
        },
        &quot;meta&quot;: {
            &quot;current_page&quot;: 1,
            &quot;from&quot;: null,
            &quot;last_page&quot;: 1,
            &quot;links&quot;: [
                {
                    &quot;url&quot;: null,
                    &quot;label&quot;: &quot;&amp;laquo; Previous&quot;,
                    &quot;page&quot;: null,
                    &quot;active&quot;: false
                },
                {
                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/api/subAdmins1/CH.VD?page=1&quot;,
                    &quot;label&quot;: &quot;1&quot;,
                    &quot;page&quot;: 1,
                    &quot;active&quot;: true
                },
                {
                    &quot;url&quot;: null,
                    &quot;label&quot;: &quot;Next &amp;raquo;&quot;,
                    &quot;page&quot;: null,
                    &quot;active&quot;: false
                }
            ],
            &quot;path&quot;: &quot;https://demo.laraclassifier.local/api/subAdmins1/CH.VD&quot;,
            &quot;per_page&quot;: 39,
            &quot;to&quot;: null,
            &quot;total&quot;: 0
        }
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-subAdmins1--code-" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-subAdmins1--code-"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-subAdmins1--code-"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-subAdmins1--code-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-subAdmins1--code-">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-subAdmins1--code-" data-method="GET"
      data-path="api/subAdmins1/{code}"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-subAdmins1--code-', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-subAdmins1--code-"
                    onclick="tryItOut('GETapi-subAdmins1--code-');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-subAdmins1--code-"
                    onclick="cancelTryOut('GETapi-subAdmins1--code-');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-subAdmins1--code-"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/subAdmins1/{code}</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-subAdmins1--code-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-subAdmins1--code-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-subAdmins1--code-"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-subAdmins1--code-"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-subAdmins1--code-"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>code</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="code"                data-endpoint="GETapi-subAdmins1--code-"
               value="CH.VD"
               data-component="url">
    <br>
<p>The administrative division (1)'s code. Example: <code>CH.VD</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>embed</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="embed"                data-endpoint="GETapi-subAdmins1--code-"
               value=""
               data-component="query">
    <br>
<p>Comma-separated list of the administrative division (1) relationships for Eager Loading - Possible values: country.</p>
            </div>
                </form>

                    <h2 id="countries-GETapi-subAdmins2--code-">Get admin. division (2)</h2>

<p>
</p>



<span id="example-requests-GETapi-subAdmins2--code-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/subAdmins2/CH.VD.2225?embed=" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/subAdmins2/CH.VD.2225"
);

const params = {
    "embed": "",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/subAdmins2/CH.VD.2225';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'embed' =&gt; '',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/subAdmins2/CH.VD.2225'
params = {
  'embed': '',
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-subAdmins2--code-">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;code&quot;: &quot;CH.VD.2225&quot;,
        &quot;country_code&quot;: &quot;CH&quot;,
        &quot;subadmin1_code&quot;: &quot;CH.VD&quot;,
        &quot;name&quot;: &quot;Lausanne District&quot;,
        &quot;active&quot;: 1
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-subAdmins2--code-" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-subAdmins2--code-"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-subAdmins2--code-"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-subAdmins2--code-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-subAdmins2--code-">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-subAdmins2--code-" data-method="GET"
      data-path="api/subAdmins2/{code}"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-subAdmins2--code-', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-subAdmins2--code-"
                    onclick="tryItOut('GETapi-subAdmins2--code-');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-subAdmins2--code-"
                    onclick="cancelTryOut('GETapi-subAdmins2--code-');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-subAdmins2--code-"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/subAdmins2/{code}</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-subAdmins2--code-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-subAdmins2--code-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-subAdmins2--code-"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-subAdmins2--code-"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-subAdmins2--code-"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>code</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="code"                data-endpoint="GETapi-subAdmins2--code-"
               value="CH.VD.2225"
               data-component="url">
    <br>
<p>The administrative division (2)'s code. Example: <code>CH.VD.2225</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>embed</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="embed"                data-endpoint="GETapi-subAdmins2--code-"
               value=""
               data-component="query">
    <br>
<p>Comma-separated list of the administrative division (2) relationships for Eager Loading - Possible values: country,subAdmin1.</p>
            </div>
                </form>

                    <h2 id="countries-GETapi-cities--id-">Get city</h2>

<p>
</p>



<span id="example-requests-GETapi-cities--id-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/cities/12544?embed=country" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/cities/12544"
);

const params = {
    "embed": "country",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/cities/12544';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'embed' =&gt; 'country',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/cities/12544'
params = {
  'embed': 'country',
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-cities--id-">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;id&quot;: 12544,
        &quot;country_code&quot;: &quot;DE&quot;,
        &quot;name&quot;: &quot;Berlin&quot;,
        &quot;latitude&quot;: 52.52,
        &quot;longitude&quot;: 13.41,
        &quot;subadmin1_code&quot;: &quot;DE.16&quot;,
        &quot;subadmin2_code&quot;: &quot;DE.16.00&quot;,
        &quot;population&quot;: 3426354,
        &quot;time_zone&quot;: &quot;Europe/Berlin&quot;,
        &quot;active&quot;: 1,
        &quot;slug&quot;: &quot;berlin&quot;,
        &quot;posts_count&quot;: 0,
        &quot;country&quot;: {
            &quot;code&quot;: &quot;DE&quot;,
            &quot;name&quot;: &quot;Germany&quot;,
            &quot;capital&quot;: &quot;Berlin&quot;,
            &quot;continent_code&quot;: &quot;EU&quot;,
            &quot;tld&quot;: &quot;.de&quot;,
            &quot;currency_code&quot;: &quot;EUR&quot;,
            &quot;phone&quot;: &quot;49&quot;,
            &quot;languages&quot;: &quot;de&quot;,
            &quot;time_zone&quot;: null,
            &quot;date_format&quot;: null,
            &quot;datetime_format&quot;: null,
            &quot;background_image_path&quot;: &quot;app/logo/header-68bea24d673de.jpg&quot;,
            &quot;admin_type&quot;: &quot;1&quot;,
            &quot;active&quot;: 1,
            &quot;currencies&quot;: null,
            &quot;icode&quot;: &quot;de&quot;,
            &quot;flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/de.png&quot;,
            &quot;flag16_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/de.png&quot;,
            &quot;flag24_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/24/de.png&quot;,
            &quot;flag32_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/32/de.png&quot;,
            &quot;flag48_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/48/de.png&quot;,
            &quot;flag64_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/64/de.png&quot;,
            &quot;background_image_url&quot;: null
        }
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-cities--id-" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-cities--id-"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-cities--id-"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-cities--id-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-cities--id-">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-cities--id-" data-method="GET"
      data-path="api/cities/{id}"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-cities--id-', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-cities--id-"
                    onclick="tryItOut('GETapi-cities--id-');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-cities--id-"
                    onclick="cancelTryOut('GETapi-cities--id-');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-cities--id-"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/cities/{id}</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-cities--id-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-cities--id-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-cities--id-"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-cities--id-"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-cities--id-"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="id"                data-endpoint="GETapi-cities--id-"
               value="12544"
               data-component="url">
    <br>
<p>The city's ID. Example: <code>12544</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>embed</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="embed"                data-endpoint="GETapi-cities--id-"
               value="country"
               data-component="query">
    <br>
<p>Comma-separated list of the city relationships for Eager Loading - Possible values: country,subAdmin1,subAdmin2. Example: <code>country</code></p>
            </div>
                </form>

                <h1 id="home">Home</h1>

    

                                <h2 id="home-GETapi-sections">List sections</h2>

<p>
</p>



<span id="example-requests-GETapi-sections">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/sections" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/sections"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/sections';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/sections'
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-sections">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;data&quot;: {
            &quot;search_form&quot;: {
                &quot;belongs_to&quot;: &quot;home&quot;,
                &quot;name&quot;: &quot;search_form&quot;,
                &quot;data&quot;: [],
                &quot;options&quot;: {
                    &quot;enable_extended_form_area&quot;: &quot;1&quot;,
                    &quot;background_image_path&quot;: null,
                    &quot;background_image_darken&quot;: &quot;0.1&quot;,
                    &quot;enable_form_area_customization&quot;: &quot;1&quot;,
                    &quot;background_color&quot;: null,
                    &quot;background_image&quot;: null,
                    &quot;height&quot;: null,
                    &quot;parallax&quot;: &quot;0&quot;,
                    &quot;hide_searchbar&quot;: &quot;0&quot;,
                    &quot;form_border_color&quot;: null,
                    &quot;form_border_width&quot;: null,
                    &quot;form_btn_background_color&quot;: null,
                    &quot;form_btn_text_color&quot;: null,
                    &quot;hide_title&quot;: &quot;0&quot;,
                    &quot;title_en&quot;: &quot;Sell and Buy near you&quot;,
                    &quot;sub_title_en&quot;: &quot;Simple, fast and efficient&quot;,
                    &quot;title_fr&quot;: &quot;Vendre et acheter pr&egrave;s de chez vous&quot;,
                    &quot;sub_title_fr&quot;: &quot;Simple, rapide et efficace&quot;,
                    &quot;title_es&quot;: &quot;Vender y comprar cerca de usted&quot;,
                    &quot;sub_title_es&quot;: &quot;Simple, r&aacute;pido y eficiente&quot;,
                    &quot;title_ar&quot;: &quot;بيع وشراء بالقرب منك&quot;,
                    &quot;sub_title_ar&quot;: &quot;بسيطة وسريعة وفعالة&quot;,
                    &quot;title_pt&quot;: &quot;Vender e comprar perto de si&quot;,
                    &quot;sub_title_pt&quot;: &quot;Simples, R&aacute;pido e Eficiente&quot;,
                    &quot;title_ru&quot;: &quot;Продавайте и покупайте рядом с вами&quot;,
                    &quot;sub_title_ru&quot;: &quot;Просто, быстро и эффективно&quot;,
                    &quot;title_tr&quot;: &quot;Size yakın satıp satın alın&quot;,
                    &quot;sub_title_tr&quot;: &quot;Basit, hızlı ve verimli&quot;,
                    &quot;title_th&quot;: &quot;ขายและซื้อใกล้บ้านคุณ&quot;,
                    &quot;sub_title_th&quot;: &quot;ง่ายรวดเร็วและมีประสิทธิภาพ&quot;,
                    &quot;title_ka&quot;: &quot;გაყიდვა და შეძენა ახლოს თქვენ&quot;,
                    &quot;sub_title_ka&quot;: &quot;მარტივი, სწრაფი და ეფექტური&quot;,
                    &quot;title_zh&quot;: &quot;在您附近买卖&quot;,
                    &quot;sub_title_zh&quot;: &quot;简单，快速，高效&quot;,
                    &quot;title_ja&quot;: &quot;お近くの売買&quot;,
                    &quot;sub_title_ja&quot;: &quot;シンプル、迅速かつ効率的&quot;,
                    &quot;title_it&quot;: &quot;Vendi e compra vicino a te&quot;,
                    &quot;sub_title_it&quot;: &quot;Semplice, veloce ed efficiente&quot;,
                    &quot;big_title_color&quot;: null,
                    &quot;sub_title_color&quot;: null,
                    &quot;hide_on_mobile&quot;: &quot;0&quot;,
                    &quot;active&quot;: &quot;1&quot;,
                    &quot;title_de&quot;: &quot;Verkaufen und Kaufen in Ihrer N&auml;he&quot;,
                    &quot;sub_title_de&quot;: &quot;Einfach, schnell und effizient&quot;,
                    &quot;title_hi&quot;: &quot;अपने पास बेचें और खरीदें&quot;,
                    &quot;sub_title_hi&quot;: &quot;सरल, तेज और कुशल&quot;,
                    &quot;title_bn&quot;: &quot;আপনার কাছাকাছি বিক্রি করুন এবং কিনুন&quot;,
                    &quot;sub_title_bn&quot;: &quot;সহজ, দ্রুত এবং দক্ষ&quot;,
                    &quot;title_he&quot;: &quot;למכור ולקנות בקרבתך&quot;,
                    &quot;sub_title_he&quot;: &quot;פשוט, מהיר ויעיל&quot;,
                    &quot;title_ro&quot;: &quot;Vinde și Cumpără inteligent&quot;,
                    &quot;sub_title_ro&quot;: &quot;Simplu, rapid și eficient!&quot;,
                    &quot;background_image_url&quot;: null
                },
                &quot;lft&quot;: 1
            },
            &quot;categories&quot;: {
                &quot;belongs_to&quot;: &quot;home&quot;,
                &quot;name&quot;: &quot;categories&quot;,
                &quot;data&quot;: {
                    &quot;categories&quot;: {
                        &quot;1&quot;: {
                            &quot;id&quot;: 1,
                            &quot;parent_id&quot;: null,
                            &quot;name&quot;: &quot;Automobiles&quot;,
                            &quot;slug&quot;: &quot;automobiles&quot;,
                            &quot;description&quot;: &quot;&quot;,
                            &quot;hide_description&quot;: null,
                            &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                            &quot;icon_class&quot;: &quot;fa-solid fa-car&quot;,
                            &quot;seo_title&quot;: &quot;&quot;,
                            &quot;seo_description&quot;: &quot;&quot;,
                            &quot;seo_keywords&quot;: &quot;&quot;,
                            &quot;lft&quot;: 1,
                            &quot;rgt&quot;: 16,
                            &quot;depth&quot;: 0,
                            &quot;type&quot;: &quot;classified&quot;,
                            &quot;is_for_permanent&quot;: 0,
                            &quot;active&quot;: 1,
                            &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                            &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/automobiles&quot;,
                            &quot;parent&quot;: null
                        },
                        &quot;9&quot;: {
                            &quot;id&quot;: 9,
                            &quot;parent_id&quot;: null,
                            &quot;name&quot;: &quot;Phones &amp; Tablets&quot;,
                            &quot;slug&quot;: &quot;phones-and-tablets&quot;,
                            &quot;description&quot;: &quot;&quot;,
                            &quot;hide_description&quot;: null,
                            &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                            &quot;icon_class&quot;: &quot;fa-solid fa-mobile-screen-button&quot;,
                            &quot;seo_title&quot;: &quot;&quot;,
                            &quot;seo_description&quot;: &quot;&quot;,
                            &quot;seo_keywords&quot;: &quot;&quot;,
                            &quot;lft&quot;: 17,
                            &quot;rgt&quot;: 26,
                            &quot;depth&quot;: 0,
                            &quot;type&quot;: &quot;classified&quot;,
                            &quot;is_for_permanent&quot;: 0,
                            &quot;active&quot;: 1,
                            &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                            &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/phones-and-tablets&quot;,
                            &quot;parent&quot;: null
                        },
                        &quot;14&quot;: {
                            &quot;id&quot;: 14,
                            &quot;parent_id&quot;: null,
                            &quot;name&quot;: &quot;Electronics&quot;,
                            &quot;slug&quot;: &quot;electronics&quot;,
                            &quot;description&quot;: &quot;&quot;,
                            &quot;hide_description&quot;: null,
                            &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                            &quot;icon_class&quot;: &quot;fa-solid fa-laptop&quot;,
                            &quot;seo_title&quot;: &quot;&quot;,
                            &quot;seo_description&quot;: &quot;&quot;,
                            &quot;seo_keywords&quot;: &quot;&quot;,
                            &quot;lft&quot;: 27,
                            &quot;rgt&quot;: 58,
                            &quot;depth&quot;: 0,
                            &quot;type&quot;: &quot;classified&quot;,
                            &quot;is_for_permanent&quot;: 0,
                            &quot;active&quot;: 1,
                            &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                            &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/electronics&quot;,
                            &quot;parent&quot;: null
                        },
                        &quot;30&quot;: {
                            &quot;id&quot;: 30,
                            &quot;parent_id&quot;: null,
                            &quot;name&quot;: &quot;Furniture &amp; Appliances&quot;,
                            &quot;slug&quot;: &quot;furniture-appliances&quot;,
                            &quot;description&quot;: &quot;&quot;,
                            &quot;hide_description&quot;: null,
                            &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                            &quot;icon_class&quot;: &quot;fa-solid fa-couch&quot;,
                            &quot;seo_title&quot;: &quot;&quot;,
                            &quot;seo_description&quot;: &quot;&quot;,
                            &quot;seo_keywords&quot;: &quot;&quot;,
                            &quot;lft&quot;: 59,
                            &quot;rgt&quot;: 72,
                            &quot;depth&quot;: 0,
                            &quot;type&quot;: &quot;classified&quot;,
                            &quot;is_for_permanent&quot;: 0,
                            &quot;active&quot;: 1,
                            &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                            &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/furniture-appliances&quot;,
                            &quot;parent&quot;: null
                        },
                        &quot;37&quot;: {
                            &quot;id&quot;: 37,
                            &quot;parent_id&quot;: null,
                            &quot;name&quot;: &quot;Real estate&quot;,
                            &quot;slug&quot;: &quot;real-estate&quot;,
                            &quot;description&quot;: &quot;&quot;,
                            &quot;hide_description&quot;: null,
                            &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                            &quot;icon_class&quot;: &quot;fa-solid fa-house&quot;,
                            &quot;seo_title&quot;: &quot;&quot;,
                            &quot;seo_description&quot;: &quot;&quot;,
                            &quot;seo_keywords&quot;: &quot;&quot;,
                            &quot;lft&quot;: 73,
                            &quot;rgt&quot;: 90,
                            &quot;depth&quot;: 0,
                            &quot;type&quot;: &quot;classified&quot;,
                            &quot;is_for_permanent&quot;: 0,
                            &quot;active&quot;: 1,
                            &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                            &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/real-estate&quot;,
                            &quot;parent&quot;: null
                        },
                        &quot;46&quot;: {
                            &quot;id&quot;: 46,
                            &quot;parent_id&quot;: null,
                            &quot;name&quot;: &quot;Animals &amp; Pets&quot;,
                            &quot;slug&quot;: &quot;animals-and-pets&quot;,
                            &quot;description&quot;: &quot;&quot;,
                            &quot;hide_description&quot;: null,
                            &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                            &quot;icon_class&quot;: &quot;fa-solid fa-paw&quot;,
                            &quot;seo_title&quot;: &quot;&quot;,
                            &quot;seo_description&quot;: &quot;&quot;,
                            &quot;seo_keywords&quot;: &quot;&quot;,
                            &quot;lft&quot;: 91,
                            &quot;rgt&quot;: 106,
                            &quot;depth&quot;: 0,
                            &quot;type&quot;: &quot;classified&quot;,
                            &quot;is_for_permanent&quot;: 0,
                            &quot;active&quot;: 1,
                            &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                            &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/animals-and-pets&quot;,
                            &quot;parent&quot;: null
                        },
                        &quot;54&quot;: {
                            &quot;id&quot;: 54,
                            &quot;parent_id&quot;: null,
                            &quot;name&quot;: &quot;Fashion&quot;,
                            &quot;slug&quot;: &quot;fashion&quot;,
                            &quot;description&quot;: &quot;&quot;,
                            &quot;hide_description&quot;: null,
                            &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                            &quot;icon_class&quot;: &quot;fa-solid fa-shirt&quot;,
                            &quot;seo_title&quot;: &quot;&quot;,
                            &quot;seo_description&quot;: &quot;&quot;,
                            &quot;seo_keywords&quot;: &quot;&quot;,
                            &quot;lft&quot;: 107,
                            &quot;rgt&quot;: 122,
                            &quot;depth&quot;: 0,
                            &quot;type&quot;: &quot;classified&quot;,
                            &quot;is_for_permanent&quot;: 0,
                            &quot;active&quot;: 1,
                            &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                            &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/fashion&quot;,
                            &quot;parent&quot;: null
                        },
                        &quot;62&quot;: {
                            &quot;id&quot;: 62,
                            &quot;parent_id&quot;: null,
                            &quot;name&quot;: &quot;Beauty &amp; Well being&quot;,
                            &quot;slug&quot;: &quot;beauty-well-being&quot;,
                            &quot;description&quot;: &quot;&quot;,
                            &quot;hide_description&quot;: null,
                            &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                            &quot;icon_class&quot;: &quot;fa-solid fa-spa&quot;,
                            &quot;seo_title&quot;: &quot;&quot;,
                            &quot;seo_description&quot;: &quot;&quot;,
                            &quot;seo_keywords&quot;: &quot;&quot;,
                            &quot;lft&quot;: 123,
                            &quot;rgt&quot;: 144,
                            &quot;depth&quot;: 0,
                            &quot;type&quot;: &quot;classified&quot;,
                            &quot;is_for_permanent&quot;: 0,
                            &quot;active&quot;: 1,
                            &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                            &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/beauty-well-being&quot;,
                            &quot;parent&quot;: null
                        },
                        &quot;73&quot;: {
                            &quot;id&quot;: 73,
                            &quot;parent_id&quot;: null,
                            &quot;name&quot;: &quot;Jobs&quot;,
                            &quot;slug&quot;: &quot;jobs&quot;,
                            &quot;description&quot;: &quot;&quot;,
                            &quot;hide_description&quot;: null,
                            &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                            &quot;icon_class&quot;: &quot;fa-solid fa-briefcase&quot;,
                            &quot;seo_title&quot;: &quot;&quot;,
                            &quot;seo_description&quot;: &quot;&quot;,
                            &quot;seo_keywords&quot;: &quot;&quot;,
                            &quot;lft&quot;: 145,
                            &quot;rgt&quot;: 192,
                            &quot;depth&quot;: 0,
                            &quot;type&quot;: &quot;job-offer&quot;,
                            &quot;is_for_permanent&quot;: 0,
                            &quot;active&quot;: 1,
                            &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                            &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/jobs&quot;,
                            &quot;parent&quot;: null
                        },
                        &quot;97&quot;: {
                            &quot;id&quot;: 97,
                            &quot;parent_id&quot;: null,
                            &quot;name&quot;: &quot;Services&quot;,
                            &quot;slug&quot;: &quot;services&quot;,
                            &quot;description&quot;: &quot;&quot;,
                            &quot;hide_description&quot;: null,
                            &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                            &quot;icon_class&quot;: &quot;fa-solid fa-clipboard-list&quot;,
                            &quot;seo_title&quot;: &quot;&quot;,
                            &quot;seo_description&quot;: &quot;&quot;,
                            &quot;seo_keywords&quot;: &quot;&quot;,
                            &quot;lft&quot;: 193,
                            &quot;rgt&quot;: 226,
                            &quot;depth&quot;: 0,
                            &quot;type&quot;: &quot;classified&quot;,
                            &quot;is_for_permanent&quot;: 0,
                            &quot;active&quot;: 1,
                            &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                            &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/services&quot;,
                            &quot;parent&quot;: null
                        },
                        &quot;114&quot;: {
                            &quot;id&quot;: 114,
                            &quot;parent_id&quot;: null,
                            &quot;name&quot;: &quot;Learning&quot;,
                            &quot;slug&quot;: &quot;learning&quot;,
                            &quot;description&quot;: &quot;&quot;,
                            &quot;hide_description&quot;: null,
                            &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                            &quot;icon_class&quot;: &quot;fa-solid fa-graduation-cap&quot;,
                            &quot;seo_title&quot;: &quot;&quot;,
                            &quot;seo_description&quot;: &quot;&quot;,
                            &quot;seo_keywords&quot;: &quot;&quot;,
                            &quot;lft&quot;: 227,
                            &quot;rgt&quot;: 242,
                            &quot;depth&quot;: 0,
                            &quot;type&quot;: &quot;classified&quot;,
                            &quot;is_for_permanent&quot;: 0,
                            &quot;active&quot;: 1,
                            &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                            &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/learning&quot;,
                            &quot;parent&quot;: null
                        },
                        &quot;122&quot;: {
                            &quot;id&quot;: 122,
                            &quot;parent_id&quot;: null,
                            &quot;name&quot;: &quot;Local Events&quot;,
                            &quot;slug&quot;: &quot;local-events&quot;,
                            &quot;description&quot;: &quot;&quot;,
                            &quot;hide_description&quot;: null,
                            &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                            &quot;icon_class&quot;: &quot;fa-regular fa-calendar-days&quot;,
                            &quot;seo_title&quot;: &quot;&quot;,
                            &quot;seo_description&quot;: &quot;&quot;,
                            &quot;seo_keywords&quot;: &quot;&quot;,
                            &quot;lft&quot;: 243,
                            &quot;rgt&quot;: 268,
                            &quot;depth&quot;: 0,
                            &quot;type&quot;: &quot;classified&quot;,
                            &quot;is_for_permanent&quot;: 0,
                            &quot;active&quot;: 1,
                            &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                            &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/local-events&quot;,
                            &quot;parent&quot;: null
                        }
                    },
                    &quot;countPostsPerCat&quot;: []
                },
                &quot;options&quot;: {
                    &quot;max_items&quot;: null,
                    &quot;cat_display_type&quot;: &quot;c_bigIcon_list&quot;,
                    &quot;show_icon&quot;: &quot;0&quot;,
                    &quot;max_sub_cats&quot;: &quot;3&quot;,
                    &quot;type_of_display&quot;: &quot;c_picture_icon&quot;,
                    &quot;count_categories_posts&quot;: &quot;0&quot;,
                    &quot;cache_expiration&quot;: &quot;3600&quot;,
                    &quot;active&quot;: &quot;1&quot;
                },
                &quot;lft&quot;: 3
            },
            &quot;premium_listings&quot;: {
                &quot;belongs_to&quot;: &quot;home&quot;,
                &quot;name&quot;: &quot;premium_listings&quot;,
                &quot;data&quot;: {
                    &quot;premium&quot;: {
                        &quot;title&quot;: &quot;&lt;span style=\&quot;font-weight: bold;\&quot;&gt;Premium&lt;/span&gt; Listings&quot;,
                        &quot;link&quot;: &quot;https://demo.laraclassifier.local/search?filterBy=premium&quot;,
                        &quot;posts&quot;: [
                            {
                                &quot;id&quot;: 75,
                                &quot;country_code&quot;: &quot;US&quot;,
                                &quot;user_id&quot;: 1,
                                &quot;payment_id&quot;: null,
                                &quot;category_id&quot;: 11,
                                &quot;post_type_id&quot;: 2,
                                &quot;title&quot;: &quot;AirPods Pro&quot;,
                                &quot;description&quot;: &quot;Minus animi quis illo consequatur. Nulla ut facere earum ipsum autem veniam. Enim accusamus esse voluptatem sint. Atque autem autem eum ea.&quot;,
                                &quot;tags&quot;: [
                                    &quot;fuga&quot;,
                                    &quot;temporibus&quot;,
                                    &quot;sed&quot;
                                ],
                                &quot;price&quot;: &quot;1119.00&quot;,
                                &quot;currency_code&quot;: null,
                                &quot;negotiable&quot;: null,
                                &quot;contact_name&quot;: &quot;Administrator&quot;,
                                &quot;address&quot;: null,
                                &quot;city_id&quot;: 47391,
                                &quot;lat&quot;: null,
                                &quot;lon&quot;: null,
                                &quot;create_from_ip&quot;: null,
                                &quot;latest_update_ip&quot;: null,
                                &quot;visits&quot;: null,
                                &quot;auth_field&quot;: &quot;email&quot;,
                                &quot;email&quot;: &quot;mayeul@domain.tld&quot;,
                                &quot;phone&quot;: &quot;+18080288425&quot;,
                                &quot;phone_national&quot;: &quot;(808) 028-8425&quot;,
                                &quot;phone_country&quot;: &quot;US&quot;,
                                &quot;email_token&quot;: null,
                                &quot;phone_token&quot;: null,
                                &quot;email_verified_at&quot;: &quot;2025-09-07T21:27:35.000000Z&quot;,
                                &quot;phone_verified_at&quot;: &quot;2025-09-07T21:27:35.000000Z&quot;,
                                &quot;otp_expires_at&quot;: null,
                                &quot;last_otp_sent_at&quot;: null,
                                &quot;otp_resend_attempts&quot;: null,
                                &quot;otp_resend_attempts_expires_at&quot;: null,
                                &quot;total_otp_resend_attempts&quot;: null,
                                &quot;locked_at&quot;: null,
                                &quot;phone_hidden&quot;: null,
                                &quot;accept_terms&quot;: null,
                                &quot;accept_marketing_offers&quot;: null,
                                &quot;is_permanent&quot;: null,
                                &quot;featured&quot;: 1,
                                &quot;tmp_token&quot;: null,
                                &quot;reviewed_at&quot;: &quot;2025-09-07T21:27:35.000000Z&quot;,
                                &quot;archived_at&quot;: null,
                                &quot;archived_manually_at&quot;: null,
                                &quot;deletion_mail_sent_at&quot;: null,
                                &quot;created_at&quot;: &quot;2025-09-07T08:42:25.000000Z&quot;,
                                &quot;updated_at&quot;: &quot;2025-09-08T10:06:49.857572Z&quot;,
                                &quot;reference&quot;: &quot;kQBeXDWeyK8&quot;,
                                &quot;slug&quot;: &quot;airpods-pro&quot;,
                                &quot;url&quot;: &quot;https://demo.laraclassifier.local/airpods-pro/kQBeXDWeyK8&quot;,
                                &quot;excerpt&quot;: &quot;Minus animi quis illo consequatur. Nulla ut facere earum ipsum autem veniam. Enim accusamus esse vol...&quot;,
                                &quot;phone_intl&quot;: &quot;(808) 028-8425&quot;,
                                &quot;created_at_formatted&quot;: &quot;1 day ago&quot;,
                                &quot;updated_at_formatted&quot;: &quot;Sep 8th, 2025 at 06:06&quot;,
                                &quot;archived_at_formatted&quot;: &quot;&quot;,
                                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/1/thumbnails/800x800-f7d5a0d9df09422cd70ede1487d901a6.jpg&quot;,
                                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;,
                                &quot;count_pictures&quot;: 4,
                                &quot;price_label&quot;: &quot;Price:&quot;,
                                &quot;price_formatted&quot;: &quot;$1,119&quot;,
                                &quot;visits_formatted&quot;: &quot;0 view&quot;,
                                &quot;distance_info&quot;: null,
                                &quot;picture&quot;: {
                                    &quot;id&quot;: 211,
                                    &quot;post_id&quot;: 75,
                                    &quot;file_path&quot;: &quot;files/us/75/f48006f98e45e7f0ac582b46ab247f33.jpg&quot;,
                                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                    &quot;position&quot;: 2,
                                    &quot;active&quot;: 1,
                                    &quot;url&quot;: {
                                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/75/thumbnails/816x460-f48006f98e45e7f0ac582b46ab247f33.jpg&quot;,
                                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/75/thumbnails/120x90-f48006f98e45e7f0ac582b46ab247f33.jpg&quot;,
                                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/75/thumbnails/320x240-f48006f98e45e7f0ac582b46ab247f33.jpg&quot;,
                                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/75/thumbnails/816x460-f48006f98e45e7f0ac582b46ab247f33.jpg&quot;
                                    }
                                },
                                &quot;pictures&quot;: [
                                    {
                                        &quot;id&quot;: 211,
                                        &quot;post_id&quot;: 75,
                                        &quot;file_path&quot;: &quot;files/us/75/f48006f98e45e7f0ac582b46ab247f33.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 2,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/75/thumbnails/816x460-f48006f98e45e7f0ac582b46ab247f33.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/75/thumbnails/120x90-f48006f98e45e7f0ac582b46ab247f33.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/75/thumbnails/320x240-f48006f98e45e7f0ac582b46ab247f33.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/75/thumbnails/816x460-f48006f98e45e7f0ac582b46ab247f33.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 209,
                                        &quot;post_id&quot;: 75,
                                        &quot;file_path&quot;: &quot;files/us/75/e3c8fb6a97053e9ad8d54165f4989287.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 3,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 212,
                                        &quot;post_id&quot;: 75,
                                        &quot;file_path&quot;: &quot;files/us/75/7478832f0a5172e20571875f742e77ae.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 4,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 210,
                                        &quot;post_id&quot;: 75,
                                        &quot;file_path&quot;: &quot;files/us/75/399f357ba2bbca0dd6acb32e0ec298ae.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 4,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    }
                                ],
                                &quot;user&quot;: {
                                    &quot;id&quot;: 1,
                                    &quot;name&quot;: &quot;Administrator&quot;,
                                    &quot;username&quot;: &quot;adminak&quot;,
                                    &quot;two_factor_enabled&quot;: false,
                                    &quot;two_factor_method&quot;: &quot;email&quot;,
                                    &quot;updated_at&quot;: &quot;2025-09-08T09:29:18.000000Z&quot;,
                                    &quot;original_updated_at&quot;: &quot;2025-09-08 09:29:18&quot;,
                                    &quot;original_last_activity&quot;: &quot;2025-09-08 09:19:34&quot;,
                                    &quot;created_at_formatted&quot;: &quot;1 week ago&quot;,
                                    &quot;photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/1/thumbnails/800x800-f7d5a0d9df09422cd70ede1487d901a6.jpg&quot;,
                                    &quot;p_is_online&quot;: false,
                                    &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;
                                },
                                &quot;category&quot;: {
                                    &quot;id&quot;: 11,
                                    &quot;parent_id&quot;: 9,
                                    &quot;name&quot;: &quot;Accessories for Mobile Phones &amp; Tablets&quot;,
                                    &quot;slug&quot;: &quot;mobile-phones-tablets-accessories&quot;,
                                    &quot;description&quot;: &quot;&quot;,
                                    &quot;hide_description&quot;: null,
                                    &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                    &quot;icon_class&quot;: &quot;bi bi-folder-fill&quot;,
                                    &quot;seo_title&quot;: &quot;&quot;,
                                    &quot;seo_description&quot;: &quot;&quot;,
                                    &quot;seo_keywords&quot;: &quot;&quot;,
                                    &quot;lft&quot;: 20,
                                    &quot;rgt&quot;: 21,
                                    &quot;depth&quot;: 1,
                                    &quot;type&quot;: &quot;classified&quot;,
                                    &quot;is_for_permanent&quot;: 0,
                                    &quot;active&quot;: 1,
                                    &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/phones-and-tablets/mobile-phones-tablets-accessories&quot;,
                                    &quot;parent&quot;: {
                                        &quot;id&quot;: 9,
                                        &quot;parent_id&quot;: null,
                                        &quot;name&quot;: &quot;Phones &amp; Tablets&quot;,
                                        &quot;slug&quot;: &quot;phones-and-tablets&quot;,
                                        &quot;description&quot;: &quot;&quot;,
                                        &quot;hide_description&quot;: null,
                                        &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                        &quot;icon_class&quot;: &quot;fa-solid fa-mobile-screen-button&quot;,
                                        &quot;seo_title&quot;: &quot;&quot;,
                                        &quot;seo_description&quot;: &quot;&quot;,
                                        &quot;seo_keywords&quot;: &quot;&quot;,
                                        &quot;lft&quot;: 17,
                                        &quot;rgt&quot;: 26,
                                        &quot;depth&quot;: 0,
                                        &quot;type&quot;: &quot;classified&quot;,
                                        &quot;is_for_permanent&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                        &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/phones-and-tablets&quot;,
                                        &quot;parent&quot;: null
                                    }
                                },
                                &quot;postType&quot;: {
                                    &quot;id&quot;: 2,
                                    &quot;name&quot;: &quot;PROFESSIONAL&quot;,
                                    &quot;label&quot;: &quot;Professional&quot;
                                },
                                &quot;city&quot;: {
                                    &quot;id&quot;: 47391,
                                    &quot;country_code&quot;: &quot;US&quot;,
                                    &quot;name&quot;: &quot;River Rouge&quot;,
                                    &quot;latitude&quot;: 42.27,
                                    &quot;longitude&quot;: -83.13,
                                    &quot;subadmin1_code&quot;: &quot;US.MI&quot;,
                                    &quot;subadmin2_code&quot;: &quot;US.MI.163&quot;,
                                    &quot;population&quot;: 7546,
                                    &quot;time_zone&quot;: &quot;America/Detroit&quot;,
                                    &quot;active&quot;: 1,
                                    &quot;slug&quot;: &quot;river-rouge&quot;,
                                    &quot;posts_count&quot;: 0
                                },
                                &quot;payment&quot;: {
                                    &quot;id&quot;: 86,
                                    &quot;payable_id&quot;: 75,
                                    &quot;payable_type&quot;: &quot;App\\Models\\Post&quot;,
                                    &quot;package_id&quot;: 3,
                                    &quot;payment_method_id&quot;: 10,
                                    &quot;transaction_id&quot;: null,
                                    &quot;amount&quot;: &quot;9.00&quot;,
                                    &quot;currency_code&quot;: null,
                                    &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                                    &quot;period_end&quot;: &quot;2025-10-08T23:59:59.000000Z&quot;,
                                    &quot;canceled_at&quot;: null,
                                    &quot;refunded_at&quot;: null,
                                    &quot;active&quot;: 1,
                                    &quot;interval&quot;: 30.999988425925928,
                                    &quot;started&quot;: 1,
                                    &quot;expired&quot;: 0,
                                    &quot;status&quot;: &quot;valid&quot;,
                                    &quot;period_start_formatted&quot;: &quot;Sep 7th, 2025&quot;,
                                    &quot;period_end_formatted&quot;: &quot;Oct 8th, 2025&quot;,
                                    &quot;created_at_formatted&quot;: &quot;Sep 8th, 2025 at 04:46&quot;,
                                    &quot;status_info&quot;: &quot;Valid&quot;,
                                    &quot;starting_info&quot;: &quot;Started on Sep 7th, 2025&quot;,
                                    &quot;expiry_info&quot;: &quot;Will expire on Oct 8th, 2025&quot;,
                                    &quot;css_class_variant&quot;: &quot;success&quot;,
                                    &quot;package&quot;: {
                                        &quot;id&quot;: 3,
                                        &quot;type&quot;: &quot;promotion&quot;,
                                        &quot;name&quot;: &quot;Premium Listing (+)&quot;,
                                        &quot;short_name&quot;: &quot;Premium+&quot;,
                                        &quot;ribbon&quot;: &quot;success&quot;,
                                        &quot;has_badge&quot;: 1,
                                        &quot;price&quot;: &quot;9.00&quot;,
                                        &quot;currency_code&quot;: &quot;USD&quot;,
                                        &quot;promotion_time&quot;: 30,
                                        &quot;interval&quot;: null,
                                        &quot;listings_limit&quot;: null,
                                        &quot;pictures_limit&quot;: 15,
                                        &quot;expiration_time&quot;: 120,
                                        &quot;description&quot;: &quot;Featured on the homepage\nFeatured in the category&quot;,
                                        &quot;facebook_ads_duration&quot;: 0,
                                        &quot;google_ads_duration&quot;: 0,
                                        &quot;twitter_ads_duration&quot;: 0,
                                        &quot;linkedin_ads_duration&quot;: 0,
                                        &quot;recommended&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;parent_id&quot;: null,
                                        &quot;lft&quot;: 5,
                                        &quot;rgt&quot;: 6,
                                        &quot;depth&quot;: 0,
                                        &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                                        &quot;period_end&quot;: &quot;2025-10-08T23:59:59.999999Z&quot;,
                                        &quot;description_array&quot;: [
                                            &quot;30 days of promotion&quot;,
                                            &quot;Up to 15 images allowed&quot;,
                                            &quot;Featured on the homepage&quot;,
                                            &quot;Featured in the category&quot;,
                                            &quot;Keep online for 120 days&quot;
                                        ],
                                        &quot;description_string&quot;: &quot;30 days of promotion. \nUp to 15 images allowed. \nFeatured on the homepage. \nFeatured in the category. \nKeep online for 120 days&quot;,
                                        &quot;price_formatted&quot;: &quot;$9&quot;
                                    }
                                },
                                &quot;rating_cache&quot;: 0,
                                &quot;rating_count&quot;: 0
                            },
                            {
                                &quot;id&quot;: 66,
                                &quot;country_code&quot;: &quot;US&quot;,
                                &quot;user_id&quot;: 1,
                                &quot;payment_id&quot;: null,
                                &quot;category_id&quot;: 16,
                                &quot;post_type_id&quot;: 2,
                                &quot;title&quot;: &quot;New HP Envy x360 13&quot;,
                                &quot;description&quot;: &quot;Ea voluptatem iusto quidem qui et nemo. Optio cupiditate aspernatur et voluptatem quo id officia. Qui consequatur assumenda praesentium qui. Eos repellendus neque qui. Corporis officiis molestias quia voluptas ad veniam officiis eveniet. Vitae quis possimus velit facilis numquam maiores quo. Aperiam laborum et pariatur voluptatem. Cupiditate quas reprehenderit et sit.&quot;,
                                &quot;tags&quot;: [
                                    &quot;sed&quot;,
                                    &quot;nam&quot;,
                                    &quot;eius&quot;
                                ],
                                &quot;price&quot;: &quot;126.00&quot;,
                                &quot;currency_code&quot;: null,
                                &quot;negotiable&quot;: null,
                                &quot;contact_name&quot;: &quot;Administrator&quot;,
                                &quot;address&quot;: null,
                                &quot;city_id&quot;: 45777,
                                &quot;lat&quot;: null,
                                &quot;lon&quot;: null,
                                &quot;create_from_ip&quot;: null,
                                &quot;latest_update_ip&quot;: null,
                                &quot;visits&quot;: null,
                                &quot;auth_field&quot;: &quot;email&quot;,
                                &quot;email&quot;: &quot;mayeul@domain.tld&quot;,
                                &quot;phone&quot;: &quot;+16563611854&quot;,
                                &quot;phone_national&quot;: &quot;(656) 361-1854&quot;,
                                &quot;phone_country&quot;: &quot;US&quot;,
                                &quot;email_token&quot;: null,
                                &quot;phone_token&quot;: null,
                                &quot;email_verified_at&quot;: &quot;2025-09-07T01:07:43.000000Z&quot;,
                                &quot;phone_verified_at&quot;: &quot;2025-09-07T01:07:43.000000Z&quot;,
                                &quot;otp_expires_at&quot;: null,
                                &quot;last_otp_sent_at&quot;: null,
                                &quot;otp_resend_attempts&quot;: null,
                                &quot;otp_resend_attempts_expires_at&quot;: null,
                                &quot;total_otp_resend_attempts&quot;: null,
                                &quot;locked_at&quot;: null,
                                &quot;phone_hidden&quot;: null,
                                &quot;accept_terms&quot;: null,
                                &quot;accept_marketing_offers&quot;: null,
                                &quot;is_permanent&quot;: null,
                                &quot;featured&quot;: 1,
                                &quot;tmp_token&quot;: null,
                                &quot;reviewed_at&quot;: &quot;2025-09-07T01:07:43.000000Z&quot;,
                                &quot;archived_at&quot;: null,
                                &quot;archived_manually_at&quot;: null,
                                &quot;deletion_mail_sent_at&quot;: null,
                                &quot;created_at&quot;: &quot;2025-09-05T20:42:04.000000Z&quot;,
                                &quot;updated_at&quot;: &quot;2025-09-08T10:06:50.060929Z&quot;,
                                &quot;reference&quot;: &quot;q9wdL9wejPX&quot;,
                                &quot;slug&quot;: &quot;new-hp-envy-x360-13&quot;,
                                &quot;url&quot;: &quot;https://demo.laraclassifier.local/new-hp-envy-x360-13/q9wdL9wejPX&quot;,
                                &quot;excerpt&quot;: &quot;Ea voluptatem iusto quidem qui et nemo. Optio cupiditate aspernatur et voluptatem quo id officia. Qu...&quot;,
                                &quot;phone_intl&quot;: &quot;(656) 361-1854&quot;,
                                &quot;created_at_formatted&quot;: &quot;2 days ago&quot;,
                                &quot;updated_at_formatted&quot;: &quot;Sep 8th, 2025 at 06:06&quot;,
                                &quot;archived_at_formatted&quot;: &quot;&quot;,
                                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/1/thumbnails/800x800-f7d5a0d9df09422cd70ede1487d901a6.jpg&quot;,
                                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;,
                                &quot;count_pictures&quot;: 1,
                                &quot;price_label&quot;: &quot;Price:&quot;,
                                &quot;price_formatted&quot;: &quot;$126&quot;,
                                &quot;visits_formatted&quot;: &quot;0 view&quot;,
                                &quot;distance_info&quot;: null,
                                &quot;picture&quot;: {
                                    &quot;id&quot;: 192,
                                    &quot;post_id&quot;: 66,
                                    &quot;file_path&quot;: &quot;files/us/66/928bc7f85b5240d3705cee153063007c.jpg&quot;,
                                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                    &quot;position&quot;: 1,
                                    &quot;active&quot;: 1,
                                    &quot;url&quot;: {
                                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/66/thumbnails/816x460-928bc7f85b5240d3705cee153063007c.jpg&quot;,
                                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/66/thumbnails/120x90-928bc7f85b5240d3705cee153063007c.jpg&quot;,
                                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/66/thumbnails/320x240-928bc7f85b5240d3705cee153063007c.jpg&quot;,
                                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/66/thumbnails/816x460-928bc7f85b5240d3705cee153063007c.jpg&quot;
                                    }
                                },
                                &quot;pictures&quot;: [
                                    {
                                        &quot;id&quot;: 192,
                                        &quot;post_id&quot;: 66,
                                        &quot;file_path&quot;: &quot;files/us/66/928bc7f85b5240d3705cee153063007c.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 1,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/66/thumbnails/816x460-928bc7f85b5240d3705cee153063007c.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/66/thumbnails/120x90-928bc7f85b5240d3705cee153063007c.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/66/thumbnails/320x240-928bc7f85b5240d3705cee153063007c.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/66/thumbnails/816x460-928bc7f85b5240d3705cee153063007c.jpg&quot;
                                        }
                                    }
                                ],
                                &quot;user&quot;: {
                                    &quot;id&quot;: 1,
                                    &quot;name&quot;: &quot;Administrator&quot;,
                                    &quot;username&quot;: &quot;adminak&quot;,
                                    &quot;two_factor_enabled&quot;: false,
                                    &quot;two_factor_method&quot;: &quot;email&quot;,
                                    &quot;updated_at&quot;: &quot;2025-09-08T09:29:18.000000Z&quot;,
                                    &quot;original_updated_at&quot;: &quot;2025-09-08 09:29:18&quot;,
                                    &quot;original_last_activity&quot;: &quot;2025-09-08 09:19:34&quot;,
                                    &quot;created_at_formatted&quot;: &quot;1 week ago&quot;,
                                    &quot;photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/1/thumbnails/800x800-f7d5a0d9df09422cd70ede1487d901a6.jpg&quot;,
                                    &quot;p_is_online&quot;: false,
                                    &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;
                                },
                                &quot;category&quot;: {
                                    &quot;id&quot;: 16,
                                    &quot;parent_id&quot;: 14,
                                    &quot;name&quot;: &quot;Laptops &amp; Computers&quot;,
                                    &quot;slug&quot;: &quot;laptops-and-computers&quot;,
                                    &quot;description&quot;: &quot;&quot;,
                                    &quot;hide_description&quot;: null,
                                    &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                    &quot;icon_class&quot;: &quot;bi bi-folder-fill&quot;,
                                    &quot;seo_title&quot;: &quot;&quot;,
                                    &quot;seo_description&quot;: &quot;&quot;,
                                    &quot;seo_keywords&quot;: &quot;&quot;,
                                    &quot;lft&quot;: 30,
                                    &quot;rgt&quot;: 31,
                                    &quot;depth&quot;: 1,
                                    &quot;type&quot;: &quot;classified&quot;,
                                    &quot;is_for_permanent&quot;: 0,
                                    &quot;active&quot;: 1,
                                    &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/electronics/laptops-and-computers&quot;,
                                    &quot;parent&quot;: {
                                        &quot;id&quot;: 14,
                                        &quot;parent_id&quot;: null,
                                        &quot;name&quot;: &quot;Electronics&quot;,
                                        &quot;slug&quot;: &quot;electronics&quot;,
                                        &quot;description&quot;: &quot;&quot;,
                                        &quot;hide_description&quot;: null,
                                        &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                        &quot;icon_class&quot;: &quot;fa-solid fa-laptop&quot;,
                                        &quot;seo_title&quot;: &quot;&quot;,
                                        &quot;seo_description&quot;: &quot;&quot;,
                                        &quot;seo_keywords&quot;: &quot;&quot;,
                                        &quot;lft&quot;: 27,
                                        &quot;rgt&quot;: 58,
                                        &quot;depth&quot;: 0,
                                        &quot;type&quot;: &quot;classified&quot;,
                                        &quot;is_for_permanent&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                        &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/electronics&quot;,
                                        &quot;parent&quot;: null
                                    }
                                },
                                &quot;postType&quot;: {
                                    &quot;id&quot;: 2,
                                    &quot;name&quot;: &quot;PROFESSIONAL&quot;,
                                    &quot;label&quot;: &quot;Professional&quot;
                                },
                                &quot;city&quot;: {
                                    &quot;id&quot;: 45777,
                                    &quot;country_code&quot;: &quot;US&quot;,
                                    &quot;name&quot;: &quot;East Brainerd&quot;,
                                    &quot;latitude&quot;: 35,
                                    &quot;longitude&quot;: -85.15,
                                    &quot;subadmin1_code&quot;: &quot;US.TN&quot;,
                                    &quot;subadmin2_code&quot;: &quot;US.TN.065&quot;,
                                    &quot;population&quot;: 15114,
                                    &quot;time_zone&quot;: &quot;America/New_York&quot;,
                                    &quot;active&quot;: 1,
                                    &quot;slug&quot;: &quot;east-brainerd&quot;,
                                    &quot;posts_count&quot;: 0
                                },
                                &quot;payment&quot;: {
                                    &quot;id&quot;: 509,
                                    &quot;payable_id&quot;: 66,
                                    &quot;payable_type&quot;: &quot;App\\Models\\Post&quot;,
                                    &quot;package_id&quot;: 3,
                                    &quot;payment_method_id&quot;: 10,
                                    &quot;transaction_id&quot;: null,
                                    &quot;amount&quot;: &quot;9.00&quot;,
                                    &quot;currency_code&quot;: null,
                                    &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                                    &quot;period_end&quot;: &quot;2025-10-08T23:59:59.000000Z&quot;,
                                    &quot;canceled_at&quot;: null,
                                    &quot;refunded_at&quot;: null,
                                    &quot;active&quot;: 1,
                                    &quot;interval&quot;: 30.999988425925928,
                                    &quot;started&quot;: 1,
                                    &quot;expired&quot;: 0,
                                    &quot;status&quot;: &quot;valid&quot;,
                                    &quot;period_start_formatted&quot;: &quot;Sep 7th, 2025&quot;,
                                    &quot;period_end_formatted&quot;: &quot;Oct 8th, 2025&quot;,
                                    &quot;created_at_formatted&quot;: &quot;Sep 6th, 2025 at 08:37&quot;,
                                    &quot;status_info&quot;: &quot;Valid&quot;,
                                    &quot;starting_info&quot;: &quot;Started on Sep 7th, 2025&quot;,
                                    &quot;expiry_info&quot;: &quot;Will expire on Oct 8th, 2025&quot;,
                                    &quot;css_class_variant&quot;: &quot;success&quot;,
                                    &quot;package&quot;: {
                                        &quot;id&quot;: 3,
                                        &quot;type&quot;: &quot;promotion&quot;,
                                        &quot;name&quot;: &quot;Premium Listing (+)&quot;,
                                        &quot;short_name&quot;: &quot;Premium+&quot;,
                                        &quot;ribbon&quot;: &quot;success&quot;,
                                        &quot;has_badge&quot;: 1,
                                        &quot;price&quot;: &quot;9.00&quot;,
                                        &quot;currency_code&quot;: &quot;USD&quot;,
                                        &quot;promotion_time&quot;: 30,
                                        &quot;interval&quot;: null,
                                        &quot;listings_limit&quot;: null,
                                        &quot;pictures_limit&quot;: 15,
                                        &quot;expiration_time&quot;: 120,
                                        &quot;description&quot;: &quot;Featured on the homepage\nFeatured in the category&quot;,
                                        &quot;facebook_ads_duration&quot;: 0,
                                        &quot;google_ads_duration&quot;: 0,
                                        &quot;twitter_ads_duration&quot;: 0,
                                        &quot;linkedin_ads_duration&quot;: 0,
                                        &quot;recommended&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;parent_id&quot;: null,
                                        &quot;lft&quot;: 5,
                                        &quot;rgt&quot;: 6,
                                        &quot;depth&quot;: 0,
                                        &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                                        &quot;period_end&quot;: &quot;2025-10-08T23:59:59.999999Z&quot;,
                                        &quot;description_array&quot;: [
                                            &quot;30 days of promotion&quot;,
                                            &quot;Up to 15 images allowed&quot;,
                                            &quot;Featured on the homepage&quot;,
                                            &quot;Featured in the category&quot;,
                                            &quot;Keep online for 120 days&quot;
                                        ],
                                        &quot;description_string&quot;: &quot;30 days of promotion. \nUp to 15 images allowed. \nFeatured on the homepage. \nFeatured in the category. \nKeep online for 120 days&quot;,
                                        &quot;price_formatted&quot;: &quot;$9&quot;
                                    }
                                },
                                &quot;rating_cache&quot;: 0,
                                &quot;rating_count&quot;: 0
                            },
                            {
                                &quot;id&quot;: 83,
                                &quot;country_code&quot;: &quot;US&quot;,
                                &quot;user_id&quot;: 1,
                                &quot;payment_id&quot;: null,
                                &quot;category_id&quot;: 39,
                                &quot;post_type_id&quot;: 2,
                                &quot;title&quot;: &quot;Selling Palace&quot;,
                                &quot;description&quot;: &quot;Eos libero minima eum possimus consequatur temporibus dignissimos. Dicta molestias tenetur maiores debitis reprehenderit non quod. Optio animi facere dolor facere. Vero aut exercitationem quia doloremque non. Laborum repellendus laborum soluta fugit quasi repellat corrupti qui. Dolorem magnam quasi autem voluptas. Cupiditate aut enim dolorem labore.&quot;,
                                &quot;tags&quot;: [
                                    &quot;excepturi&quot;,
                                    &quot;sit&quot;
                                ],
                                &quot;price&quot;: &quot;28.00&quot;,
                                &quot;currency_code&quot;: null,
                                &quot;negotiable&quot;: null,
                                &quot;contact_name&quot;: &quot;Administrator&quot;,
                                &quot;address&quot;: null,
                                &quot;city_id&quot;: 47331,
                                &quot;lat&quot;: null,
                                &quot;lon&quot;: null,
                                &quot;create_from_ip&quot;: null,
                                &quot;latest_update_ip&quot;: null,
                                &quot;visits&quot;: null,
                                &quot;auth_field&quot;: &quot;email&quot;,
                                &quot;email&quot;: &quot;mayeul@domain.tld&quot;,
                                &quot;phone&quot;: &quot;+16511222129&quot;,
                                &quot;phone_national&quot;: &quot;(651) 122-2129&quot;,
                                &quot;phone_country&quot;: &quot;US&quot;,
                                &quot;email_token&quot;: null,
                                &quot;phone_token&quot;: null,
                                &quot;email_verified_at&quot;: &quot;2025-09-06T00:06:59.000000Z&quot;,
                                &quot;phone_verified_at&quot;: &quot;2025-09-06T00:06:59.000000Z&quot;,
                                &quot;otp_expires_at&quot;: null,
                                &quot;last_otp_sent_at&quot;: null,
                                &quot;otp_resend_attempts&quot;: null,
                                &quot;otp_resend_attempts_expires_at&quot;: null,
                                &quot;total_otp_resend_attempts&quot;: null,
                                &quot;locked_at&quot;: null,
                                &quot;phone_hidden&quot;: null,
                                &quot;accept_terms&quot;: null,
                                &quot;accept_marketing_offers&quot;: null,
                                &quot;is_permanent&quot;: null,
                                &quot;featured&quot;: 1,
                                &quot;tmp_token&quot;: null,
                                &quot;reviewed_at&quot;: &quot;2025-09-06T00:06:59.000000Z&quot;,
                                &quot;archived_at&quot;: null,
                                &quot;archived_manually_at&quot;: null,
                                &quot;deletion_mail_sent_at&quot;: null,
                                &quot;created_at&quot;: &quot;2025-09-04T22:26:55.000000Z&quot;,
                                &quot;updated_at&quot;: &quot;2025-09-08T10:06:50.263923Z&quot;,
                                &quot;reference&quot;: &quot;QK9b68neEvY&quot;,
                                &quot;slug&quot;: &quot;selling-palace&quot;,
                                &quot;url&quot;: &quot;https://demo.laraclassifier.local/selling-palace/QK9b68neEvY&quot;,
                                &quot;excerpt&quot;: &quot;Eos libero minima eum possimus consequatur temporibus dignissimos. Dicta molestias tenetur maiores d...&quot;,
                                &quot;phone_intl&quot;: &quot;(651) 122-2129&quot;,
                                &quot;created_at_formatted&quot;: &quot;3 days ago&quot;,
                                &quot;updated_at_formatted&quot;: &quot;Sep 8th, 2025 at 06:06&quot;,
                                &quot;archived_at_formatted&quot;: &quot;&quot;,
                                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/1/thumbnails/800x800-f7d5a0d9df09422cd70ede1487d901a6.jpg&quot;,
                                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;,
                                &quot;count_pictures&quot;: 4,
                                &quot;price_label&quot;: &quot;Price:&quot;,
                                &quot;price_formatted&quot;: &quot;$28&quot;,
                                &quot;visits_formatted&quot;: &quot;0 view&quot;,
                                &quot;distance_info&quot;: null,
                                &quot;picture&quot;: {
                                    &quot;id&quot;: 231,
                                    &quot;post_id&quot;: 83,
                                    &quot;file_path&quot;: &quot;files/us/83/f755bb6c2b1cbd35066b2609fdf05ac1.jpg&quot;,
                                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                    &quot;position&quot;: 1,
                                    &quot;active&quot;: 1,
                                    &quot;url&quot;: {
                                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/83/thumbnails/816x460-f755bb6c2b1cbd35066b2609fdf05ac1.jpg&quot;,
                                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/83/thumbnails/120x90-f755bb6c2b1cbd35066b2609fdf05ac1.jpg&quot;,
                                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/83/thumbnails/320x240-f755bb6c2b1cbd35066b2609fdf05ac1.jpg&quot;,
                                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/83/thumbnails/816x460-f755bb6c2b1cbd35066b2609fdf05ac1.jpg&quot;
                                    }
                                },
                                &quot;pictures&quot;: [
                                    {
                                        &quot;id&quot;: 231,
                                        &quot;post_id&quot;: 83,
                                        &quot;file_path&quot;: &quot;files/us/83/f755bb6c2b1cbd35066b2609fdf05ac1.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 1,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/83/thumbnails/816x460-f755bb6c2b1cbd35066b2609fdf05ac1.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/83/thumbnails/120x90-f755bb6c2b1cbd35066b2609fdf05ac1.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/83/thumbnails/320x240-f755bb6c2b1cbd35066b2609fdf05ac1.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/83/thumbnails/816x460-f755bb6c2b1cbd35066b2609fdf05ac1.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 234,
                                        &quot;post_id&quot;: 83,
                                        &quot;file_path&quot;: &quot;files/us/83/93491c6e5e789d3eb0ad080752fec4a2.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 3,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 233,
                                        &quot;post_id&quot;: 83,
                                        &quot;file_path&quot;: &quot;files/us/83/c759bec7bcf9ce13177419e5a3475de7.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 4,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 232,
                                        &quot;post_id&quot;: 83,
                                        &quot;file_path&quot;: &quot;files/us/83/60e62fe3ebb25807436ceb5fad3e5f27.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 4,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    }
                                ],
                                &quot;user&quot;: {
                                    &quot;id&quot;: 1,
                                    &quot;name&quot;: &quot;Administrator&quot;,
                                    &quot;username&quot;: &quot;adminak&quot;,
                                    &quot;two_factor_enabled&quot;: false,
                                    &quot;two_factor_method&quot;: &quot;email&quot;,
                                    &quot;updated_at&quot;: &quot;2025-09-08T09:29:18.000000Z&quot;,
                                    &quot;original_updated_at&quot;: &quot;2025-09-08 09:29:18&quot;,
                                    &quot;original_last_activity&quot;: &quot;2025-09-08 09:19:34&quot;,
                                    &quot;created_at_formatted&quot;: &quot;1 week ago&quot;,
                                    &quot;photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/1/thumbnails/800x800-f7d5a0d9df09422cd70ede1487d901a6.jpg&quot;,
                                    &quot;p_is_online&quot;: false,
                                    &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;
                                },
                                &quot;category&quot;: {
                                    &quot;id&quot;: 39,
                                    &quot;parent_id&quot;: 37,
                                    &quot;name&quot;: &quot;Houses &amp; Apartments For Sale&quot;,
                                    &quot;slug&quot;: &quot;houses-apartments-for-sale&quot;,
                                    &quot;description&quot;: &quot;&quot;,
                                    &quot;hide_description&quot;: null,
                                    &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                    &quot;icon_class&quot;: &quot;bi bi-folder-fill&quot;,
                                    &quot;seo_title&quot;: &quot;&quot;,
                                    &quot;seo_description&quot;: &quot;&quot;,
                                    &quot;seo_keywords&quot;: &quot;&quot;,
                                    &quot;lft&quot;: 76,
                                    &quot;rgt&quot;: 77,
                                    &quot;depth&quot;: 1,
                                    &quot;type&quot;: &quot;classified&quot;,
                                    &quot;is_for_permanent&quot;: 0,
                                    &quot;active&quot;: 1,
                                    &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/real-estate/houses-apartments-for-sale&quot;,
                                    &quot;parent&quot;: {
                                        &quot;id&quot;: 37,
                                        &quot;parent_id&quot;: null,
                                        &quot;name&quot;: &quot;Real estate&quot;,
                                        &quot;slug&quot;: &quot;real-estate&quot;,
                                        &quot;description&quot;: &quot;&quot;,
                                        &quot;hide_description&quot;: null,
                                        &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                        &quot;icon_class&quot;: &quot;fa-solid fa-house&quot;,
                                        &quot;seo_title&quot;: &quot;&quot;,
                                        &quot;seo_description&quot;: &quot;&quot;,
                                        &quot;seo_keywords&quot;: &quot;&quot;,
                                        &quot;lft&quot;: 73,
                                        &quot;rgt&quot;: 90,
                                        &quot;depth&quot;: 0,
                                        &quot;type&quot;: &quot;classified&quot;,
                                        &quot;is_for_permanent&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                        &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/real-estate&quot;,
                                        &quot;parent&quot;: null
                                    }
                                },
                                &quot;postType&quot;: {
                                    &quot;id&quot;: 2,
                                    &quot;name&quot;: &quot;PROFESSIONAL&quot;,
                                    &quot;label&quot;: &quot;Professional&quot;
                                },
                                &quot;city&quot;: {
                                    &quot;id&quot;: 47331,
                                    &quot;country_code&quot;: &quot;US&quot;,
                                    &quot;name&quot;: &quot;Hastings&quot;,
                                    &quot;latitude&quot;: 42.65,
                                    &quot;longitude&quot;: -85.29,
                                    &quot;subadmin1_code&quot;: &quot;US.MI&quot;,
                                    &quot;subadmin2_code&quot;: &quot;US.MI.015&quot;,
                                    &quot;population&quot;: 7284,
                                    &quot;time_zone&quot;: &quot;America/Detroit&quot;,
                                    &quot;active&quot;: 1,
                                    &quot;slug&quot;: &quot;hastings&quot;,
                                    &quot;posts_count&quot;: 0
                                },
                                &quot;payment&quot;: {
                                    &quot;id&quot;: 393,
                                    &quot;payable_id&quot;: 83,
                                    &quot;payable_type&quot;: &quot;App\\Models\\Post&quot;,
                                    &quot;package_id&quot;: 3,
                                    &quot;payment_method_id&quot;: 3,
                                    &quot;transaction_id&quot;: null,
                                    &quot;amount&quot;: &quot;9.00&quot;,
                                    &quot;currency_code&quot;: null,
                                    &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                                    &quot;period_end&quot;: &quot;2025-10-08T23:59:59.000000Z&quot;,
                                    &quot;canceled_at&quot;: null,
                                    &quot;refunded_at&quot;: null,
                                    &quot;active&quot;: 1,
                                    &quot;interval&quot;: 30.999988425925928,
                                    &quot;started&quot;: 1,
                                    &quot;expired&quot;: 0,
                                    &quot;status&quot;: &quot;valid&quot;,
                                    &quot;period_start_formatted&quot;: &quot;Sep 7th, 2025&quot;,
                                    &quot;period_end_formatted&quot;: &quot;Oct 8th, 2025&quot;,
                                    &quot;created_at_formatted&quot;: &quot;Sep 7th, 2025 at 07:14&quot;,
                                    &quot;status_info&quot;: &quot;Valid&quot;,
                                    &quot;starting_info&quot;: &quot;Started on Sep 7th, 2025&quot;,
                                    &quot;expiry_info&quot;: &quot;Will expire on Oct 8th, 2025&quot;,
                                    &quot;css_class_variant&quot;: &quot;success&quot;,
                                    &quot;package&quot;: {
                                        &quot;id&quot;: 3,
                                        &quot;type&quot;: &quot;promotion&quot;,
                                        &quot;name&quot;: &quot;Premium Listing (+)&quot;,
                                        &quot;short_name&quot;: &quot;Premium+&quot;,
                                        &quot;ribbon&quot;: &quot;success&quot;,
                                        &quot;has_badge&quot;: 1,
                                        &quot;price&quot;: &quot;9.00&quot;,
                                        &quot;currency_code&quot;: &quot;USD&quot;,
                                        &quot;promotion_time&quot;: 30,
                                        &quot;interval&quot;: null,
                                        &quot;listings_limit&quot;: null,
                                        &quot;pictures_limit&quot;: 15,
                                        &quot;expiration_time&quot;: 120,
                                        &quot;description&quot;: &quot;Featured on the homepage\nFeatured in the category&quot;,
                                        &quot;facebook_ads_duration&quot;: 0,
                                        &quot;google_ads_duration&quot;: 0,
                                        &quot;twitter_ads_duration&quot;: 0,
                                        &quot;linkedin_ads_duration&quot;: 0,
                                        &quot;recommended&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;parent_id&quot;: null,
                                        &quot;lft&quot;: 5,
                                        &quot;rgt&quot;: 6,
                                        &quot;depth&quot;: 0,
                                        &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                                        &quot;period_end&quot;: &quot;2025-10-08T23:59:59.999999Z&quot;,
                                        &quot;description_array&quot;: [
                                            &quot;30 days of promotion&quot;,
                                            &quot;Up to 15 images allowed&quot;,
                                            &quot;Featured on the homepage&quot;,
                                            &quot;Featured in the category&quot;,
                                            &quot;Keep online for 120 days&quot;
                                        ],
                                        &quot;description_string&quot;: &quot;30 days of promotion. \nUp to 15 images allowed. \nFeatured on the homepage. \nFeatured in the category. \nKeep online for 120 days&quot;,
                                        &quot;price_formatted&quot;: &quot;$9&quot;
                                    }
                                },
                                &quot;rating_cache&quot;: 0,
                                &quot;rating_count&quot;: 0
                            },
                            {
                                &quot;id&quot;: 8566,
                                &quot;country_code&quot;: &quot;US&quot;,
                                &quot;user_id&quot;: 659,
                                &quot;payment_id&quot;: null,
                                &quot;category_id&quot;: 19,
                                &quot;post_type_id&quot;: 2,
                                &quot;title&quot;: &quot;Walkie-talkie red&quot;,
                                &quot;description&quot;: &quot;Nihil ex odit sit dolorem qui voluptates voluptatem. Odio quae quod labore ea laborum repellendus. Iste nemo consequatur laboriosam temporibus. Laborum magnam facilis quis impedit officiis laudantium voluptatem eum. Soluta eos dolor ut qui autem nostrum voluptatem. Rem ipsam expedita eum dicta sit aut. Aut ex aperiam error. Eveniet rem velit omnis et. Consequatur voluptatem dolore esse qui expedita vitae voluptatem.&quot;,
                                &quot;tags&quot;: [
                                    &quot;in&quot;,
                                    &quot;dicta&quot;,
                                    &quot;accusantium&quot;
                                ],
                                &quot;price&quot;: &quot;326.00&quot;,
                                &quot;currency_code&quot;: null,
                                &quot;negotiable&quot;: null,
                                &quot;contact_name&quot;: &quot;Meredith Rohan&quot;,
                                &quot;address&quot;: null,
                                &quot;city_id&quot;: 45873,
                                &quot;lat&quot;: null,
                                &quot;lon&quot;: null,
                                &quot;create_from_ip&quot;: null,
                                &quot;latest_update_ip&quot;: null,
                                &quot;visits&quot;: null,
                                &quot;auth_field&quot;: &quot;email&quot;,
                                &quot;email&quot;: &quot;khaley@hotmail.com&quot;,
                                &quot;phone&quot;: &quot;+19357838525&quot;,
                                &quot;phone_national&quot;: &quot;(935) 783-8525&quot;,
                                &quot;phone_country&quot;: &quot;US&quot;,
                                &quot;email_token&quot;: null,
                                &quot;phone_token&quot;: null,
                                &quot;email_verified_at&quot;: &quot;2025-09-06T21:55:03.000000Z&quot;,
                                &quot;phone_verified_at&quot;: &quot;2025-09-06T21:55:03.000000Z&quot;,
                                &quot;otp_expires_at&quot;: null,
                                &quot;last_otp_sent_at&quot;: null,
                                &quot;otp_resend_attempts&quot;: null,
                                &quot;otp_resend_attempts_expires_at&quot;: null,
                                &quot;total_otp_resend_attempts&quot;: null,
                                &quot;locked_at&quot;: null,
                                &quot;phone_hidden&quot;: null,
                                &quot;accept_terms&quot;: null,
                                &quot;accept_marketing_offers&quot;: null,
                                &quot;is_permanent&quot;: null,
                                &quot;featured&quot;: 1,
                                &quot;tmp_token&quot;: null,
                                &quot;reviewed_at&quot;: &quot;2025-09-06T21:55:03.000000Z&quot;,
                                &quot;archived_at&quot;: null,
                                &quot;archived_manually_at&quot;: null,
                                &quot;deletion_mail_sent_at&quot;: null,
                                &quot;created_at&quot;: &quot;2025-08-31T03:10:03.000000Z&quot;,
                                &quot;updated_at&quot;: &quot;2025-09-08T10:06:50.475461Z&quot;,
                                &quot;reference&quot;: &quot;q9wdL7DrbjP&quot;,
                                &quot;slug&quot;: &quot;walkie-talkie-red&quot;,
                                &quot;url&quot;: &quot;https://demo.laraclassifier.local/walkie-talkie-red/q9wdL7DrbjP&quot;,
                                &quot;excerpt&quot;: &quot;Nihil ex odit sit dolorem qui voluptates voluptatem. Odio quae quod labore ea laborum repellendus. I...&quot;,
                                &quot;phone_intl&quot;: &quot;(935) 783-8525&quot;,
                                &quot;created_at_formatted&quot;: &quot;1 week ago&quot;,
                                &quot;updated_at_formatted&quot;: &quot;Sep 8th, 2025 at 06:06&quot;,
                                &quot;archived_at_formatted&quot;: &quot;&quot;,
                                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;,
                                &quot;count_pictures&quot;: 5,
                                &quot;price_label&quot;: &quot;Price:&quot;,
                                &quot;price_formatted&quot;: &quot;$326&quot;,
                                &quot;visits_formatted&quot;: &quot;0 view&quot;,
                                &quot;distance_info&quot;: null,
                                &quot;picture&quot;: {
                                    &quot;id&quot;: 13275,
                                    &quot;post_id&quot;: 8566,
                                    &quot;file_path&quot;: &quot;files/us/8566/cafebf3ac1369d5a09f3b81eb86b776b.jpg&quot;,
                                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                    &quot;position&quot;: 1,
                                    &quot;active&quot;: 1,
                                    &quot;url&quot;: {
                                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/8566/thumbnails/816x460-cafebf3ac1369d5a09f3b81eb86b776b.jpg&quot;,
                                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/8566/thumbnails/120x90-cafebf3ac1369d5a09f3b81eb86b776b.jpg&quot;,
                                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/8566/thumbnails/320x240-cafebf3ac1369d5a09f3b81eb86b776b.jpg&quot;,
                                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/8566/thumbnails/816x460-cafebf3ac1369d5a09f3b81eb86b776b.jpg&quot;
                                    }
                                },
                                &quot;pictures&quot;: [
                                    {
                                        &quot;id&quot;: 13275,
                                        &quot;post_id&quot;: 8566,
                                        &quot;file_path&quot;: &quot;files/us/8566/cafebf3ac1369d5a09f3b81eb86b776b.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 1,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/8566/thumbnails/816x460-cafebf3ac1369d5a09f3b81eb86b776b.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/8566/thumbnails/120x90-cafebf3ac1369d5a09f3b81eb86b776b.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/8566/thumbnails/320x240-cafebf3ac1369d5a09f3b81eb86b776b.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/8566/thumbnails/816x460-cafebf3ac1369d5a09f3b81eb86b776b.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 13277,
                                        &quot;post_id&quot;: 8566,
                                        &quot;file_path&quot;: &quot;files/us/8566/85bd143874cc5e4a4c6bd64ed295cb51.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 2,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 13276,
                                        &quot;post_id&quot;: 8566,
                                        &quot;file_path&quot;: &quot;files/us/8566/f647ae89c954359b5e1b3f075975708f.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 2,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 13279,
                                        &quot;post_id&quot;: 8566,
                                        &quot;file_path&quot;: &quot;files/us/8566/baed6ad9cb3c0fa6270daa4838f89a16.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 3,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 13278,
                                        &quot;post_id&quot;: 8566,
                                        &quot;file_path&quot;: &quot;files/us/8566/c1904db2b0a0972d7adf9eae5166c31b.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 4,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    }
                                ],
                                &quot;user&quot;: {
                                    &quot;id&quot;: 659,
                                    &quot;name&quot;: &quot;Meredith Rohan&quot;,
                                    &quot;username&quot;: &quot;lsporer&quot;,
                                    &quot;two_factor_enabled&quot;: false,
                                    &quot;two_factor_method&quot;: &quot;email&quot;,
                                    &quot;updated_at&quot;: &quot;2025-09-08T10:06:53.129654Z&quot;,
                                    &quot;original_updated_at&quot;: null,
                                    &quot;original_last_activity&quot;: null,
                                    &quot;created_at_formatted&quot;: &quot;5 months ago&quot;,
                                    &quot;photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                                    &quot;p_is_online&quot;: false,
                                    &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/ro.png&quot;
                                },
                                &quot;category&quot;: {
                                    &quot;id&quot;: 19,
                                    &quot;parent_id&quot;: 14,
                                    &quot;name&quot;: &quot;Computer Accessories&quot;,
                                    &quot;slug&quot;: &quot;computer-accessories&quot;,
                                    &quot;description&quot;: &quot;&quot;,
                                    &quot;hide_description&quot;: null,
                                    &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                    &quot;icon_class&quot;: &quot;bi bi-folder-fill&quot;,
                                    &quot;seo_title&quot;: &quot;&quot;,
                                    &quot;seo_description&quot;: &quot;&quot;,
                                    &quot;seo_keywords&quot;: &quot;&quot;,
                                    &quot;lft&quot;: 36,
                                    &quot;rgt&quot;: 37,
                                    &quot;depth&quot;: 1,
                                    &quot;type&quot;: &quot;classified&quot;,
                                    &quot;is_for_permanent&quot;: 0,
                                    &quot;active&quot;: 1,
                                    &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/electronics/computer-accessories&quot;,
                                    &quot;parent&quot;: {
                                        &quot;id&quot;: 14,
                                        &quot;parent_id&quot;: null,
                                        &quot;name&quot;: &quot;Electronics&quot;,
                                        &quot;slug&quot;: &quot;electronics&quot;,
                                        &quot;description&quot;: &quot;&quot;,
                                        &quot;hide_description&quot;: null,
                                        &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                        &quot;icon_class&quot;: &quot;fa-solid fa-laptop&quot;,
                                        &quot;seo_title&quot;: &quot;&quot;,
                                        &quot;seo_description&quot;: &quot;&quot;,
                                        &quot;seo_keywords&quot;: &quot;&quot;,
                                        &quot;lft&quot;: 27,
                                        &quot;rgt&quot;: 58,
                                        &quot;depth&quot;: 0,
                                        &quot;type&quot;: &quot;classified&quot;,
                                        &quot;is_for_permanent&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                        &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/electronics&quot;,
                                        &quot;parent&quot;: null
                                    }
                                },
                                &quot;postType&quot;: {
                                    &quot;id&quot;: 2,
                                    &quot;name&quot;: &quot;PROFESSIONAL&quot;,
                                    &quot;label&quot;: &quot;Professional&quot;
                                },
                                &quot;city&quot;: {
                                    &quot;id&quot;: 45873,
                                    &quot;country_code&quot;: &quot;US&quot;,
                                    &quot;name&quot;: &quot;Angleton&quot;,
                                    &quot;latitude&quot;: 29.17,
                                    &quot;longitude&quot;: -95.43,
                                    &quot;subadmin1_code&quot;: &quot;US.TX&quot;,
                                    &quot;subadmin2_code&quot;: &quot;US.TX.039&quot;,
                                    &quot;population&quot;: 19429,
                                    &quot;time_zone&quot;: &quot;America/Chicago&quot;,
                                    &quot;active&quot;: 1,
                                    &quot;slug&quot;: &quot;angleton&quot;,
                                    &quot;posts_count&quot;: 0
                                },
                                &quot;payment&quot;: {
                                    &quot;id&quot;: 453,
                                    &quot;payable_id&quot;: 8566,
                                    &quot;payable_type&quot;: &quot;App\\Models\\Post&quot;,
                                    &quot;package_id&quot;: 3,
                                    &quot;payment_method_id&quot;: 7,
                                    &quot;transaction_id&quot;: null,
                                    &quot;amount&quot;: &quot;9.00&quot;,
                                    &quot;currency_code&quot;: null,
                                    &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                                    &quot;period_end&quot;: &quot;2025-10-08T23:59:59.000000Z&quot;,
                                    &quot;canceled_at&quot;: null,
                                    &quot;refunded_at&quot;: null,
                                    &quot;active&quot;: 1,
                                    &quot;interval&quot;: 30.999988425925928,
                                    &quot;started&quot;: 1,
                                    &quot;expired&quot;: 0,
                                    &quot;status&quot;: &quot;valid&quot;,
                                    &quot;period_start_formatted&quot;: &quot;Sep 7th, 2025&quot;,
                                    &quot;period_end_formatted&quot;: &quot;Oct 8th, 2025&quot;,
                                    &quot;created_at_formatted&quot;: &quot;Sep 7th, 2025 at 07:21&quot;,
                                    &quot;status_info&quot;: &quot;Valid&quot;,
                                    &quot;starting_info&quot;: &quot;Started on Sep 7th, 2025&quot;,
                                    &quot;expiry_info&quot;: &quot;Will expire on Oct 8th, 2025&quot;,
                                    &quot;css_class_variant&quot;: &quot;success&quot;,
                                    &quot;package&quot;: {
                                        &quot;id&quot;: 3,
                                        &quot;type&quot;: &quot;promotion&quot;,
                                        &quot;name&quot;: &quot;Premium Listing (+)&quot;,
                                        &quot;short_name&quot;: &quot;Premium+&quot;,
                                        &quot;ribbon&quot;: &quot;success&quot;,
                                        &quot;has_badge&quot;: 1,
                                        &quot;price&quot;: &quot;9.00&quot;,
                                        &quot;currency_code&quot;: &quot;USD&quot;,
                                        &quot;promotion_time&quot;: 30,
                                        &quot;interval&quot;: null,
                                        &quot;listings_limit&quot;: null,
                                        &quot;pictures_limit&quot;: 15,
                                        &quot;expiration_time&quot;: 120,
                                        &quot;description&quot;: &quot;Featured on the homepage\nFeatured in the category&quot;,
                                        &quot;facebook_ads_duration&quot;: 0,
                                        &quot;google_ads_duration&quot;: 0,
                                        &quot;twitter_ads_duration&quot;: 0,
                                        &quot;linkedin_ads_duration&quot;: 0,
                                        &quot;recommended&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;parent_id&quot;: null,
                                        &quot;lft&quot;: 5,
                                        &quot;rgt&quot;: 6,
                                        &quot;depth&quot;: 0,
                                        &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                                        &quot;period_end&quot;: &quot;2025-10-08T23:59:59.999999Z&quot;,
                                        &quot;description_array&quot;: [
                                            &quot;30 days of promotion&quot;,
                                            &quot;Up to 15 images allowed&quot;,
                                            &quot;Featured on the homepage&quot;,
                                            &quot;Featured in the category&quot;,
                                            &quot;Keep online for 120 days&quot;
                                        ],
                                        &quot;description_string&quot;: &quot;30 days of promotion. \nUp to 15 images allowed. \nFeatured on the homepage. \nFeatured in the category. \nKeep online for 120 days&quot;,
                                        &quot;price_formatted&quot;: &quot;$9&quot;
                                    }
                                },
                                &quot;rating_cache&quot;: 0,
                                &quot;rating_count&quot;: 0
                            },
                            {
                                &quot;id&quot;: 102,
                                &quot;country_code&quot;: &quot;US&quot;,
                                &quot;user_id&quot;: 3,
                                &quot;payment_id&quot;: null,
                                &quot;category_id&quot;: 13,
                                &quot;post_type_id&quot;: 2,
                                &quot;title&quot;: &quot;ZTE Blade A7s 2020&quot;,
                                &quot;description&quot;: &quot;Sit repellendus debitis non sapiente. Adipisci expedita in minima voluptatem harum. Doloremque repudiandae non quaerat numquam veniam voluptatem tempore.&quot;,
                                &quot;tags&quot;: [
                                    &quot;nostrum&quot;,
                                    &quot;esse&quot;,
                                    &quot;dolores&quot;
                                ],
                                &quot;price&quot;: &quot;74774.00&quot;,
                                &quot;currency_code&quot;: null,
                                &quot;negotiable&quot;: null,
                                &quot;contact_name&quot;: &quot;User Demo&quot;,
                                &quot;address&quot;: null,
                                &quot;city_id&quot;: 48069,
                                &quot;lat&quot;: null,
                                &quot;lon&quot;: null,
                                &quot;create_from_ip&quot;: null,
                                &quot;latest_update_ip&quot;: null,
                                &quot;visits&quot;: null,
                                &quot;auth_field&quot;: &quot;email&quot;,
                                &quot;email&quot;: &quot;user@domain.tld&quot;,
                                &quot;phone&quot;: &quot;+16585858961&quot;,
                                &quot;phone_national&quot;: &quot;(658) 585-8961&quot;,
                                &quot;phone_country&quot;: &quot;US&quot;,
                                &quot;email_token&quot;: null,
                                &quot;phone_token&quot;: null,
                                &quot;email_verified_at&quot;: &quot;2025-09-08T02:45:15.000000Z&quot;,
                                &quot;phone_verified_at&quot;: &quot;2025-09-08T02:45:15.000000Z&quot;,
                                &quot;otp_expires_at&quot;: null,
                                &quot;last_otp_sent_at&quot;: null,
                                &quot;otp_resend_attempts&quot;: null,
                                &quot;otp_resend_attempts_expires_at&quot;: null,
                                &quot;total_otp_resend_attempts&quot;: null,
                                &quot;locked_at&quot;: null,
                                &quot;phone_hidden&quot;: null,
                                &quot;accept_terms&quot;: null,
                                &quot;accept_marketing_offers&quot;: null,
                                &quot;is_permanent&quot;: null,
                                &quot;featured&quot;: 1,
                                &quot;tmp_token&quot;: null,
                                &quot;reviewed_at&quot;: &quot;2025-09-08T02:45:15.000000Z&quot;,
                                &quot;archived_at&quot;: null,
                                &quot;archived_manually_at&quot;: null,
                                &quot;deletion_mail_sent_at&quot;: null,
                                &quot;created_at&quot;: &quot;2025-08-27T23:39:04.000000Z&quot;,
                                &quot;updated_at&quot;: &quot;2025-09-08T10:06:50.678202Z&quot;,
                                &quot;reference&quot;: &quot;Wpmbk5XezJn&quot;,
                                &quot;slug&quot;: &quot;zte-blade-a7s-2020&quot;,
                                &quot;url&quot;: &quot;https://demo.laraclassifier.local/zte-blade-a7s-2020/Wpmbk5XezJn&quot;,
                                &quot;excerpt&quot;: &quot;Sit repellendus debitis non sapiente. Adipisci expedita in minima voluptatem harum. Doloremque repud...&quot;,
                                &quot;phone_intl&quot;: &quot;(658) 585-8961&quot;,
                                &quot;created_at_formatted&quot;: &quot;1 week ago&quot;,
                                &quot;updated_at_formatted&quot;: &quot;Sep 8th, 2025 at 06:06&quot;,
                                &quot;archived_at_formatted&quot;: &quot;&quot;,
                                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/3/thumbnails/800x800-651c4b74b2627fd5476097c28e5cebf7.jpg&quot;,
                                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;,
                                &quot;count_pictures&quot;: 5,
                                &quot;price_label&quot;: &quot;Price:&quot;,
                                &quot;price_formatted&quot;: &quot;$74,774&quot;,
                                &quot;visits_formatted&quot;: &quot;0 view&quot;,
                                &quot;distance_info&quot;: null,
                                &quot;picture&quot;: {
                                    &quot;id&quot;: 296,
                                    &quot;post_id&quot;: 102,
                                    &quot;file_path&quot;: &quot;files/us/102/a2dd7ee2e8ec9b11077515ff3ce46e9d.jpg&quot;,
                                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                    &quot;position&quot;: 3,
                                    &quot;active&quot;: 1,
                                    &quot;url&quot;: {
                                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/102/thumbnails/816x460-a2dd7ee2e8ec9b11077515ff3ce46e9d.jpg&quot;,
                                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/102/thumbnails/120x90-a2dd7ee2e8ec9b11077515ff3ce46e9d.jpg&quot;,
                                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/102/thumbnails/320x240-a2dd7ee2e8ec9b11077515ff3ce46e9d.jpg&quot;,
                                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/102/thumbnails/816x460-a2dd7ee2e8ec9b11077515ff3ce46e9d.jpg&quot;
                                    }
                                },
                                &quot;pictures&quot;: [
                                    {
                                        &quot;id&quot;: 296,
                                        &quot;post_id&quot;: 102,
                                        &quot;file_path&quot;: &quot;files/us/102/a2dd7ee2e8ec9b11077515ff3ce46e9d.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 3,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/102/thumbnails/816x460-a2dd7ee2e8ec9b11077515ff3ce46e9d.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/102/thumbnails/120x90-a2dd7ee2e8ec9b11077515ff3ce46e9d.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/102/thumbnails/320x240-a2dd7ee2e8ec9b11077515ff3ce46e9d.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/102/thumbnails/816x460-a2dd7ee2e8ec9b11077515ff3ce46e9d.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 297,
                                        &quot;post_id&quot;: 102,
                                        &quot;file_path&quot;: &quot;files/us/102/ba4a0af66f2779b15789f590f93ab8a0.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 4,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 293,
                                        &quot;post_id&quot;: 102,
                                        &quot;file_path&quot;: &quot;files/us/102/92c669b5ee8b53e24d2a11a35da4e3da.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 4,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 295,
                                        &quot;post_id&quot;: 102,
                                        &quot;file_path&quot;: &quot;files/us/102/7d52d32450272d69dd9203d93f6bb33e.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 5,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 294,
                                        &quot;post_id&quot;: 102,
                                        &quot;file_path&quot;: &quot;files/us/102/665961ae232255d4a3c637f886bac00a.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 5,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    }
                                ],
                                &quot;user&quot;: {
                                    &quot;id&quot;: 3,
                                    &quot;name&quot;: &quot;User Demo&quot;,
                                    &quot;username&quot;: &quot;demouser&quot;,
                                    &quot;two_factor_enabled&quot;: false,
                                    &quot;two_factor_method&quot;: &quot;email&quot;,
                                    &quot;updated_at&quot;: &quot;2025-09-08T09:29:18.000000Z&quot;,
                                    &quot;original_updated_at&quot;: &quot;2025-09-08 09:29:18&quot;,
                                    &quot;original_last_activity&quot;: null,
                                    &quot;created_at_formatted&quot;: &quot;5 months ago&quot;,
                                    &quot;photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/3/thumbnails/800x800-651c4b74b2627fd5476097c28e5cebf7.jpg&quot;,
                                    &quot;p_is_online&quot;: false,
                                    &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;
                                },
                                &quot;category&quot;: {
                                    &quot;id&quot;: 13,
                                    &quot;parent_id&quot;: 9,
                                    &quot;name&quot;: &quot;Tablets&quot;,
                                    &quot;slug&quot;: &quot;tablets&quot;,
                                    &quot;description&quot;: &quot;&quot;,
                                    &quot;hide_description&quot;: null,
                                    &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                    &quot;icon_class&quot;: &quot;bi bi-folder-fill&quot;,
                                    &quot;seo_title&quot;: &quot;&quot;,
                                    &quot;seo_description&quot;: &quot;&quot;,
                                    &quot;seo_keywords&quot;: &quot;&quot;,
                                    &quot;lft&quot;: 24,
                                    &quot;rgt&quot;: 25,
                                    &quot;depth&quot;: 1,
                                    &quot;type&quot;: &quot;classified&quot;,
                                    &quot;is_for_permanent&quot;: 0,
                                    &quot;active&quot;: 1,
                                    &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/phones-and-tablets/tablets&quot;,
                                    &quot;parent&quot;: {
                                        &quot;id&quot;: 9,
                                        &quot;parent_id&quot;: null,
                                        &quot;name&quot;: &quot;Phones &amp; Tablets&quot;,
                                        &quot;slug&quot;: &quot;phones-and-tablets&quot;,
                                        &quot;description&quot;: &quot;&quot;,
                                        &quot;hide_description&quot;: null,
                                        &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                        &quot;icon_class&quot;: &quot;fa-solid fa-mobile-screen-button&quot;,
                                        &quot;seo_title&quot;: &quot;&quot;,
                                        &quot;seo_description&quot;: &quot;&quot;,
                                        &quot;seo_keywords&quot;: &quot;&quot;,
                                        &quot;lft&quot;: 17,
                                        &quot;rgt&quot;: 26,
                                        &quot;depth&quot;: 0,
                                        &quot;type&quot;: &quot;classified&quot;,
                                        &quot;is_for_permanent&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                        &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/phones-and-tablets&quot;,
                                        &quot;parent&quot;: null
                                    }
                                },
                                &quot;postType&quot;: {
                                    &quot;id&quot;: 2,
                                    &quot;name&quot;: &quot;PROFESSIONAL&quot;,
                                    &quot;label&quot;: &quot;Professional&quot;
                                },
                                &quot;city&quot;: {
                                    &quot;id&quot;: 48069,
                                    &quot;country_code&quot;: &quot;US&quot;,
                                    &quot;name&quot;: &quot;Fort Salonga&quot;,
                                    &quot;latitude&quot;: 40.91,
                                    &quot;longitude&quot;: -73.3,
                                    &quot;subadmin1_code&quot;: &quot;US.NY&quot;,
                                    &quot;subadmin2_code&quot;: &quot;US.NY.103&quot;,
                                    &quot;population&quot;: 10008,
                                    &quot;time_zone&quot;: &quot;America/New_York&quot;,
                                    &quot;active&quot;: 1,
                                    &quot;slug&quot;: &quot;fort-salonga&quot;,
                                    &quot;posts_count&quot;: 0
                                },
                                &quot;payment&quot;: {
                                    &quot;id&quot;: 115,
                                    &quot;payable_id&quot;: 102,
                                    &quot;payable_type&quot;: &quot;App\\Models\\Post&quot;,
                                    &quot;package_id&quot;: 2,
                                    &quot;payment_method_id&quot;: 8,
                                    &quot;transaction_id&quot;: null,
                                    &quot;amount&quot;: &quot;7.50&quot;,
                                    &quot;currency_code&quot;: null,
                                    &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                                    &quot;period_end&quot;: &quot;2025-09-15T23:59:59.000000Z&quot;,
                                    &quot;canceled_at&quot;: null,
                                    &quot;refunded_at&quot;: null,
                                    &quot;active&quot;: 1,
                                    &quot;interval&quot;: 7.999988425925926,
                                    &quot;started&quot;: 1,
                                    &quot;expired&quot;: 0,
                                    &quot;status&quot;: &quot;valid&quot;,
                                    &quot;period_start_formatted&quot;: &quot;Sep 7th, 2025&quot;,
                                    &quot;period_end_formatted&quot;: &quot;Sep 15th, 2025&quot;,
                                    &quot;created_at_formatted&quot;: &quot;Aug 31st, 2025 at 04:40&quot;,
                                    &quot;status_info&quot;: &quot;Valid&quot;,
                                    &quot;starting_info&quot;: &quot;Started on Sep 7th, 2025&quot;,
                                    &quot;expiry_info&quot;: &quot;Will expire on Sep 15th, 2025&quot;,
                                    &quot;css_class_variant&quot;: &quot;success&quot;,
                                    &quot;package&quot;: {
                                        &quot;id&quot;: 2,
                                        &quot;type&quot;: &quot;promotion&quot;,
                                        &quot;name&quot;: &quot;Premium Listing&quot;,
                                        &quot;short_name&quot;: &quot;Premium&quot;,
                                        &quot;ribbon&quot;: &quot;warning&quot;,
                                        &quot;has_badge&quot;: 1,
                                        &quot;price&quot;: &quot;7.50&quot;,
                                        &quot;currency_code&quot;: &quot;USD&quot;,
                                        &quot;promotion_time&quot;: 7,
                                        &quot;interval&quot;: null,
                                        &quot;listings_limit&quot;: null,
                                        &quot;pictures_limit&quot;: 10,
                                        &quot;expiration_time&quot;: 60,
                                        &quot;description&quot;: &quot;Featured on the homepage\nFeatured in the category&quot;,
                                        &quot;facebook_ads_duration&quot;: 0,
                                        &quot;google_ads_duration&quot;: 0,
                                        &quot;twitter_ads_duration&quot;: 0,
                                        &quot;linkedin_ads_duration&quot;: 0,
                                        &quot;recommended&quot;: 1,
                                        &quot;active&quot;: 1,
                                        &quot;parent_id&quot;: null,
                                        &quot;lft&quot;: 3,
                                        &quot;rgt&quot;: 4,
                                        &quot;depth&quot;: 0,
                                        &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                                        &quot;period_end&quot;: &quot;2025-09-15T23:59:59.999999Z&quot;,
                                        &quot;description_array&quot;: [
                                            &quot;7 days of promotion&quot;,
                                            &quot;Up to 10 images allowed&quot;,
                                            &quot;Featured on the homepage&quot;,
                                            &quot;Featured in the category&quot;,
                                            &quot;Keep online for 60 days&quot;
                                        ],
                                        &quot;description_string&quot;: &quot;7 days of promotion. \nUp to 10 images allowed. \nFeatured on the homepage. \nFeatured in the category. \nKeep online for 60 days&quot;,
                                        &quot;price_formatted&quot;: &quot;$7.50&quot;
                                    }
                                },
                                &quot;rating_cache&quot;: 0,
                                &quot;rating_count&quot;: 0
                            },
                            {
                                &quot;id&quot;: 393,
                                &quot;country_code&quot;: &quot;US&quot;,
                                &quot;user_id&quot;: 196,
                                &quot;payment_id&quot;: null,
                                &quot;category_id&quot;: 41,
                                &quot;post_type_id&quot;: 2,
                                &quot;title&quot;: &quot;Shop Space Detached&quot;,
                                &quot;description&quot;: &quot;Non esse et voluptate autem veritatis. Corrupti quisquam animi quisquam aut soluta. Ut mollitia et voluptatum voluptatum nesciunt. Et facilis commodi quam perspiciatis odit est. Quo sapiente omnis ut animi dicta nemo neque. Dolores repellat qui cupiditate explicabo praesentium. Praesentium illum voluptatum labore maxime sunt rerum praesentium. Qui quia autem repudiandae autem excepturi velit. Praesentium magni natus facere asperiores aut.&quot;,
                                &quot;tags&quot;: [
                                    &quot;sapiente&quot;,
                                    &quot;sunt&quot;,
                                    &quot;quia&quot;
                                ],
                                &quot;price&quot;: &quot;17.00&quot;,
                                &quot;currency_code&quot;: null,
                                &quot;negotiable&quot;: null,
                                &quot;contact_name&quot;: &quot;Chasity Rohan&quot;,
                                &quot;address&quot;: null,
                                &quot;city_id&quot;: 50326,
                                &quot;lat&quot;: null,
                                &quot;lon&quot;: null,
                                &quot;create_from_ip&quot;: null,
                                &quot;latest_update_ip&quot;: null,
                                &quot;visits&quot;: null,
                                &quot;auth_field&quot;: &quot;email&quot;,
                                &quot;email&quot;: &quot;roxane.bruen@gmail.com&quot;,
                                &quot;phone&quot;: &quot;+16739559566&quot;,
                                &quot;phone_national&quot;: &quot;(673) 955-9566&quot;,
                                &quot;phone_country&quot;: &quot;US&quot;,
                                &quot;email_token&quot;: null,
                                &quot;phone_token&quot;: null,
                                &quot;email_verified_at&quot;: &quot;2025-09-01T13:11:46.000000Z&quot;,
                                &quot;phone_verified_at&quot;: &quot;2025-09-01T13:11:46.000000Z&quot;,
                                &quot;otp_expires_at&quot;: null,
                                &quot;last_otp_sent_at&quot;: null,
                                &quot;otp_resend_attempts&quot;: null,
                                &quot;otp_resend_attempts_expires_at&quot;: null,
                                &quot;total_otp_resend_attempts&quot;: null,
                                &quot;locked_at&quot;: null,
                                &quot;phone_hidden&quot;: null,
                                &quot;accept_terms&quot;: null,
                                &quot;accept_marketing_offers&quot;: null,
                                &quot;is_permanent&quot;: null,
                                &quot;featured&quot;: 1,
                                &quot;tmp_token&quot;: null,
                                &quot;reviewed_at&quot;: &quot;2025-09-01T13:11:46.000000Z&quot;,
                                &quot;archived_at&quot;: null,
                                &quot;archived_manually_at&quot;: null,
                                &quot;deletion_mail_sent_at&quot;: null,
                                &quot;created_at&quot;: &quot;2025-08-27T21:04:47.000000Z&quot;,
                                &quot;updated_at&quot;: &quot;2025-09-08T10:06:50.878947Z&quot;,
                                &quot;reference&quot;: &quot;4openzDe7Az&quot;,
                                &quot;slug&quot;: &quot;shop-space-detached&quot;,
                                &quot;url&quot;: &quot;https://demo.laraclassifier.local/shop-space-detached/4openzDe7Az&quot;,
                                &quot;excerpt&quot;: &quot;Non esse et voluptate autem veritatis. Corrupti quisquam animi quisquam aut soluta. Ut mollitia et v...&quot;,
                                &quot;phone_intl&quot;: &quot;(673) 955-9566&quot;,
                                &quot;created_at_formatted&quot;: &quot;1 week ago&quot;,
                                &quot;updated_at_formatted&quot;: &quot;Sep 8th, 2025 at 06:06&quot;,
                                &quot;archived_at_formatted&quot;: &quot;&quot;,
                                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;,
                                &quot;count_pictures&quot;: 1,
                                &quot;price_label&quot;: &quot;Price:&quot;,
                                &quot;price_formatted&quot;: &quot;$17&quot;,
                                &quot;visits_formatted&quot;: &quot;0 view&quot;,
                                &quot;distance_info&quot;: null,
                                &quot;picture&quot;: {
                                    &quot;id&quot;: 745,
                                    &quot;post_id&quot;: 393,
                                    &quot;file_path&quot;: &quot;files/us/393/c2fb464a079e22497693b6d869176f59.jpg&quot;,
                                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                    &quot;position&quot;: 1,
                                    &quot;active&quot;: 1,
                                    &quot;url&quot;: {
                                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/393/thumbnails/816x460-c2fb464a079e22497693b6d869176f59.jpg&quot;,
                                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/393/thumbnails/120x90-c2fb464a079e22497693b6d869176f59.jpg&quot;,
                                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/393/thumbnails/320x240-c2fb464a079e22497693b6d869176f59.jpg&quot;,
                                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/393/thumbnails/816x460-c2fb464a079e22497693b6d869176f59.jpg&quot;
                                    }
                                },
                                &quot;pictures&quot;: [
                                    {
                                        &quot;id&quot;: 745,
                                        &quot;post_id&quot;: 393,
                                        &quot;file_path&quot;: &quot;files/us/393/c2fb464a079e22497693b6d869176f59.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 1,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/393/thumbnails/816x460-c2fb464a079e22497693b6d869176f59.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/393/thumbnails/120x90-c2fb464a079e22497693b6d869176f59.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/393/thumbnails/320x240-c2fb464a079e22497693b6d869176f59.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/393/thumbnails/816x460-c2fb464a079e22497693b6d869176f59.jpg&quot;
                                        }
                                    }
                                ],
                                &quot;user&quot;: {
                                    &quot;id&quot;: 196,
                                    &quot;name&quot;: &quot;Chasity Rohan&quot;,
                                    &quot;username&quot;: &quot;elnaadams&quot;,
                                    &quot;two_factor_enabled&quot;: false,
                                    &quot;two_factor_method&quot;: &quot;email&quot;,
                                    &quot;updated_at&quot;: &quot;2025-04-05T21:14:53.000000Z&quot;,
                                    &quot;original_updated_at&quot;: &quot;2025-04-05 21:14:53&quot;,
                                    &quot;original_last_activity&quot;: null,
                                    &quot;created_at_formatted&quot;: &quot;5 months ago&quot;,
                                    &quot;photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                                    &quot;p_is_online&quot;: false,
                                    &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/qa.png&quot;
                                },
                                &quot;category&quot;: {
                                    &quot;id&quot;: 41,
                                    &quot;parent_id&quot;: 37,
                                    &quot;name&quot;: &quot;Land &amp; Plots For Sale&quot;,
                                    &quot;slug&quot;: &quot;land-and-plots-for-sale&quot;,
                                    &quot;description&quot;: &quot;&quot;,
                                    &quot;hide_description&quot;: null,
                                    &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                    &quot;icon_class&quot;: &quot;bi bi-folder-fill&quot;,
                                    &quot;seo_title&quot;: &quot;&quot;,
                                    &quot;seo_description&quot;: &quot;&quot;,
                                    &quot;seo_keywords&quot;: &quot;&quot;,
                                    &quot;lft&quot;: 80,
                                    &quot;rgt&quot;: 81,
                                    &quot;depth&quot;: 1,
                                    &quot;type&quot;: &quot;classified&quot;,
                                    &quot;is_for_permanent&quot;: 0,
                                    &quot;active&quot;: 1,
                                    &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/real-estate/land-and-plots-for-sale&quot;,
                                    &quot;parent&quot;: {
                                        &quot;id&quot;: 37,
                                        &quot;parent_id&quot;: null,
                                        &quot;name&quot;: &quot;Real estate&quot;,
                                        &quot;slug&quot;: &quot;real-estate&quot;,
                                        &quot;description&quot;: &quot;&quot;,
                                        &quot;hide_description&quot;: null,
                                        &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                        &quot;icon_class&quot;: &quot;fa-solid fa-house&quot;,
                                        &quot;seo_title&quot;: &quot;&quot;,
                                        &quot;seo_description&quot;: &quot;&quot;,
                                        &quot;seo_keywords&quot;: &quot;&quot;,
                                        &quot;lft&quot;: 73,
                                        &quot;rgt&quot;: 90,
                                        &quot;depth&quot;: 0,
                                        &quot;type&quot;: &quot;classified&quot;,
                                        &quot;is_for_permanent&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                        &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/real-estate&quot;,
                                        &quot;parent&quot;: null
                                    }
                                },
                                &quot;postType&quot;: {
                                    &quot;id&quot;: 2,
                                    &quot;name&quot;: &quot;PROFESSIONAL&quot;,
                                    &quot;label&quot;: &quot;Professional&quot;
                                },
                                &quot;city&quot;: {
                                    &quot;id&quot;: 50326,
                                    &quot;country_code&quot;: &quot;US&quot;,
                                    &quot;name&quot;: &quot;Duvall&quot;,
                                    &quot;latitude&quot;: 47.74,
                                    &quot;longitude&quot;: -121.99,
                                    &quot;subadmin1_code&quot;: &quot;US.WA&quot;,
                                    &quot;subadmin2_code&quot;: &quot;US.WA.033&quot;,
                                    &quot;population&quot;: 7674,
                                    &quot;time_zone&quot;: &quot;America/Los_Angeles&quot;,
                                    &quot;active&quot;: 1,
                                    &quot;slug&quot;: &quot;duvall&quot;,
                                    &quot;posts_count&quot;: 0
                                },
                                &quot;payment&quot;: {
                                    &quot;id&quot;: 271,
                                    &quot;payable_id&quot;: 393,
                                    &quot;payable_type&quot;: &quot;App\\Models\\Post&quot;,
                                    &quot;package_id&quot;: 2,
                                    &quot;payment_method_id&quot;: 6,
                                    &quot;transaction_id&quot;: null,
                                    &quot;amount&quot;: &quot;7.50&quot;,
                                    &quot;currency_code&quot;: null,
                                    &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                                    &quot;period_end&quot;: &quot;2025-09-15T23:59:59.000000Z&quot;,
                                    &quot;canceled_at&quot;: null,
                                    &quot;refunded_at&quot;: null,
                                    &quot;active&quot;: 1,
                                    &quot;interval&quot;: 7.999988425925926,
                                    &quot;started&quot;: 1,
                                    &quot;expired&quot;: 0,
                                    &quot;status&quot;: &quot;valid&quot;,
                                    &quot;period_start_formatted&quot;: &quot;Sep 7th, 2025&quot;,
                                    &quot;period_end_formatted&quot;: &quot;Sep 15th, 2025&quot;,
                                    &quot;created_at_formatted&quot;: &quot;Sep 3rd, 2025 at 03:10&quot;,
                                    &quot;status_info&quot;: &quot;Valid&quot;,
                                    &quot;starting_info&quot;: &quot;Started on Sep 7th, 2025&quot;,
                                    &quot;expiry_info&quot;: &quot;Will expire on Sep 15th, 2025&quot;,
                                    &quot;css_class_variant&quot;: &quot;success&quot;,
                                    &quot;package&quot;: {
                                        &quot;id&quot;: 2,
                                        &quot;type&quot;: &quot;promotion&quot;,
                                        &quot;name&quot;: &quot;Premium Listing&quot;,
                                        &quot;short_name&quot;: &quot;Premium&quot;,
                                        &quot;ribbon&quot;: &quot;warning&quot;,
                                        &quot;has_badge&quot;: 1,
                                        &quot;price&quot;: &quot;7.50&quot;,
                                        &quot;currency_code&quot;: &quot;USD&quot;,
                                        &quot;promotion_time&quot;: 7,
                                        &quot;interval&quot;: null,
                                        &quot;listings_limit&quot;: null,
                                        &quot;pictures_limit&quot;: 10,
                                        &quot;expiration_time&quot;: 60,
                                        &quot;description&quot;: &quot;Featured on the homepage\nFeatured in the category&quot;,
                                        &quot;facebook_ads_duration&quot;: 0,
                                        &quot;google_ads_duration&quot;: 0,
                                        &quot;twitter_ads_duration&quot;: 0,
                                        &quot;linkedin_ads_duration&quot;: 0,
                                        &quot;recommended&quot;: 1,
                                        &quot;active&quot;: 1,
                                        &quot;parent_id&quot;: null,
                                        &quot;lft&quot;: 3,
                                        &quot;rgt&quot;: 4,
                                        &quot;depth&quot;: 0,
                                        &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                                        &quot;period_end&quot;: &quot;2025-09-15T23:59:59.999999Z&quot;,
                                        &quot;description_array&quot;: [
                                            &quot;7 days of promotion&quot;,
                                            &quot;Up to 10 images allowed&quot;,
                                            &quot;Featured on the homepage&quot;,
                                            &quot;Featured in the category&quot;,
                                            &quot;Keep online for 60 days&quot;
                                        ],
                                        &quot;description_string&quot;: &quot;7 days of promotion. \nUp to 10 images allowed. \nFeatured on the homepage. \nFeatured in the category. \nKeep online for 60 days&quot;,
                                        &quot;price_formatted&quot;: &quot;$7.50&quot;
                                    }
                                },
                                &quot;rating_cache&quot;: 0,
                                &quot;rating_count&quot;: 0
                            },
                            {
                                &quot;id&quot;: 4257,
                                &quot;country_code&quot;: &quot;US&quot;,
                                &quot;user_id&quot;: 4156,
                                &quot;payment_id&quot;: null,
                                &quot;category_id&quot;: 5,
                                &quot;post_type_id&quot;: 1,
                                &quot;title&quot;: &quot;For sale: Toyota Tundra&quot;,
                                &quot;description&quot;: &quot;Ut suscipit facere quo repellat sed odio. Quia libero iste ullam aspernatur at qui. Id nisi harum quibusdam reprehenderit ut modi repellendus porro.&quot;,
                                &quot;tags&quot;: [
                                    &quot;repellendus&quot;,
                                    &quot;non&quot;,
                                    &quot;et&quot;
                                ],
                                &quot;price&quot;: &quot;52704.00&quot;,
                                &quot;currency_code&quot;: null,
                                &quot;negotiable&quot;: null,
                                &quot;contact_name&quot;: &quot;Sven Mertz&quot;,
                                &quot;address&quot;: null,
                                &quot;city_id&quot;: 46110,
                                &quot;lat&quot;: null,
                                &quot;lon&quot;: null,
                                &quot;create_from_ip&quot;: null,
                                &quot;latest_update_ip&quot;: null,
                                &quot;visits&quot;: null,
                                &quot;auth_field&quot;: &quot;email&quot;,
                                &quot;email&quot;: &quot;dangelo.stehr@gmail.com&quot;,
                                &quot;phone&quot;: &quot;+14266196839&quot;,
                                &quot;phone_national&quot;: &quot;(426) 619-6839&quot;,
                                &quot;phone_country&quot;: &quot;US&quot;,
                                &quot;email_token&quot;: null,
                                &quot;phone_token&quot;: null,
                                &quot;email_verified_at&quot;: &quot;2025-08-25T16:36:24.000000Z&quot;,
                                &quot;phone_verified_at&quot;: &quot;2025-08-25T16:36:24.000000Z&quot;,
                                &quot;otp_expires_at&quot;: null,
                                &quot;last_otp_sent_at&quot;: null,
                                &quot;otp_resend_attempts&quot;: null,
                                &quot;otp_resend_attempts_expires_at&quot;: null,
                                &quot;total_otp_resend_attempts&quot;: null,
                                &quot;locked_at&quot;: null,
                                &quot;phone_hidden&quot;: null,
                                &quot;accept_terms&quot;: null,
                                &quot;accept_marketing_offers&quot;: null,
                                &quot;is_permanent&quot;: null,
                                &quot;featured&quot;: 1,
                                &quot;tmp_token&quot;: null,
                                &quot;reviewed_at&quot;: &quot;2025-08-25T16:36:24.000000Z&quot;,
                                &quot;archived_at&quot;: null,
                                &quot;archived_manually_at&quot;: null,
                                &quot;deletion_mail_sent_at&quot;: null,
                                &quot;created_at&quot;: &quot;2025-08-25T03:00:43.000000Z&quot;,
                                &quot;updated_at&quot;: &quot;2025-09-08T10:06:51.078344Z&quot;,
                                &quot;reference&quot;: &quot;kzPdy8mEbQr&quot;,
                                &quot;slug&quot;: &quot;for-sale-toyota-tundra&quot;,
                                &quot;url&quot;: &quot;https://demo.laraclassifier.local/for-sale-toyota-tundra/kzPdy8mEbQr&quot;,
                                &quot;excerpt&quot;: &quot;Ut suscipit facere quo repellat sed odio. Quia libero iste ullam aspernatur at qui. Id nisi harum qu...&quot;,
                                &quot;phone_intl&quot;: &quot;(426) 619-6839&quot;,
                                &quot;created_at_formatted&quot;: &quot;2 weeks ago&quot;,
                                &quot;updated_at_formatted&quot;: &quot;Sep 8th, 2025 at 06:06&quot;,
                                &quot;archived_at_formatted&quot;: &quot;&quot;,
                                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;,
                                &quot;count_pictures&quot;: 3,
                                &quot;price_label&quot;: &quot;Price:&quot;,
                                &quot;price_formatted&quot;: &quot;$52,704&quot;,
                                &quot;visits_formatted&quot;: &quot;0 view&quot;,
                                &quot;distance_info&quot;: null,
                                &quot;picture&quot;: {
                                    &quot;id&quot;: 6671,
                                    &quot;post_id&quot;: 4257,
                                    &quot;file_path&quot;: &quot;files/us/4257/d8864a30d65b2058dd14bff92bcc322d.jpg&quot;,
                                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                    &quot;position&quot;: 2,
                                    &quot;active&quot;: 1,
                                    &quot;url&quot;: {
                                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/4257/thumbnails/816x460-d8864a30d65b2058dd14bff92bcc322d.jpg&quot;,
                                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/4257/thumbnails/120x90-d8864a30d65b2058dd14bff92bcc322d.jpg&quot;,
                                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/4257/thumbnails/320x240-d8864a30d65b2058dd14bff92bcc322d.jpg&quot;,
                                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/4257/thumbnails/816x460-d8864a30d65b2058dd14bff92bcc322d.jpg&quot;
                                    }
                                },
                                &quot;pictures&quot;: [
                                    {
                                        &quot;id&quot;: 6671,
                                        &quot;post_id&quot;: 4257,
                                        &quot;file_path&quot;: &quot;files/us/4257/d8864a30d65b2058dd14bff92bcc322d.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 2,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/4257/thumbnails/816x460-d8864a30d65b2058dd14bff92bcc322d.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/4257/thumbnails/120x90-d8864a30d65b2058dd14bff92bcc322d.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/4257/thumbnails/320x240-d8864a30d65b2058dd14bff92bcc322d.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/4257/thumbnails/816x460-d8864a30d65b2058dd14bff92bcc322d.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 6670,
                                        &quot;post_id&quot;: 4257,
                                        &quot;file_path&quot;: &quot;files/us/4257/5bee63f66c1dc678df6d4490be23b729.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 3,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 6669,
                                        &quot;post_id&quot;: 4257,
                                        &quot;file_path&quot;: &quot;files/us/4257/3a9f81a1c1c7327027a5dbf8e0626705.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 3,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    }
                                ],
                                &quot;user&quot;: {
                                    &quot;id&quot;: 4156,
                                    &quot;name&quot;: &quot;Sven Mertz&quot;,
                                    &quot;username&quot;: &quot;purdynorval&quot;,
                                    &quot;two_factor_enabled&quot;: false,
                                    &quot;two_factor_method&quot;: &quot;email&quot;,
                                    &quot;updated_at&quot;: &quot;2025-09-08T10:06:53.764488Z&quot;,
                                    &quot;original_updated_at&quot;: null,
                                    &quot;original_last_activity&quot;: null,
                                    &quot;created_at_formatted&quot;: &quot;3 months ago&quot;,
                                    &quot;photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                                    &quot;p_is_online&quot;: false,
                                    &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/ru.png&quot;
                                },
                                &quot;category&quot;: {
                                    &quot;id&quot;: 5,
                                    &quot;parent_id&quot;: 1,
                                    &quot;name&quot;: &quot;Motorcycles &amp; Scooters&quot;,
                                    &quot;slug&quot;: &quot;motorcycles-and-scooters&quot;,
                                    &quot;description&quot;: &quot;&quot;,
                                    &quot;hide_description&quot;: null,
                                    &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                    &quot;icon_class&quot;: &quot;bi bi-folder-fill&quot;,
                                    &quot;seo_title&quot;: &quot;&quot;,
                                    &quot;seo_description&quot;: &quot;&quot;,
                                    &quot;seo_keywords&quot;: &quot;&quot;,
                                    &quot;lft&quot;: 8,
                                    &quot;rgt&quot;: 9,
                                    &quot;depth&quot;: 1,
                                    &quot;type&quot;: &quot;classified&quot;,
                                    &quot;is_for_permanent&quot;: 0,
                                    &quot;active&quot;: 1,
                                    &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/automobiles/motorcycles-and-scooters&quot;,
                                    &quot;parent&quot;: {
                                        &quot;id&quot;: 1,
                                        &quot;parent_id&quot;: null,
                                        &quot;name&quot;: &quot;Automobiles&quot;,
                                        &quot;slug&quot;: &quot;automobiles&quot;,
                                        &quot;description&quot;: &quot;&quot;,
                                        &quot;hide_description&quot;: null,
                                        &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                        &quot;icon_class&quot;: &quot;fa-solid fa-car&quot;,
                                        &quot;seo_title&quot;: &quot;&quot;,
                                        &quot;seo_description&quot;: &quot;&quot;,
                                        &quot;seo_keywords&quot;: &quot;&quot;,
                                        &quot;lft&quot;: 1,
                                        &quot;rgt&quot;: 16,
                                        &quot;depth&quot;: 0,
                                        &quot;type&quot;: &quot;classified&quot;,
                                        &quot;is_for_permanent&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                        &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/automobiles&quot;,
                                        &quot;parent&quot;: null
                                    }
                                },
                                &quot;postType&quot;: {
                                    &quot;id&quot;: 1,
                                    &quot;name&quot;: &quot;INDIVIDUAL&quot;,
                                    &quot;label&quot;: &quot;Individual&quot;
                                },
                                &quot;city&quot;: {
                                    &quot;id&quot;: 46110,
                                    &quot;country_code&quot;: &quot;US&quot;,
                                    &quot;name&quot;: &quot;Pearland&quot;,
                                    &quot;latitude&quot;: 29.56,
                                    &quot;longitude&quot;: -95.29,
                                    &quot;subadmin1_code&quot;: &quot;US.TX&quot;,
                                    &quot;subadmin2_code&quot;: &quot;US.TX.039&quot;,
                                    &quot;population&quot;: 108821,
                                    &quot;time_zone&quot;: &quot;America/Chicago&quot;,
                                    &quot;active&quot;: 1,
                                    &quot;slug&quot;: &quot;pearland&quot;,
                                    &quot;posts_count&quot;: 0
                                },
                                &quot;payment&quot;: {
                                    &quot;id&quot;: 246,
                                    &quot;payable_id&quot;: 4257,
                                    &quot;payable_type&quot;: &quot;App\\Models\\Post&quot;,
                                    &quot;package_id&quot;: 3,
                                    &quot;payment_method_id&quot;: 9,
                                    &quot;transaction_id&quot;: null,
                                    &quot;amount&quot;: &quot;9.00&quot;,
                                    &quot;currency_code&quot;: null,
                                    &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                                    &quot;period_end&quot;: &quot;2025-10-08T23:59:59.000000Z&quot;,
                                    &quot;canceled_at&quot;: null,
                                    &quot;refunded_at&quot;: null,
                                    &quot;active&quot;: 1,
                                    &quot;interval&quot;: 30.999988425925928,
                                    &quot;started&quot;: 1,
                                    &quot;expired&quot;: 0,
                                    &quot;status&quot;: &quot;valid&quot;,
                                    &quot;period_start_formatted&quot;: &quot;Sep 7th, 2025&quot;,
                                    &quot;period_end_formatted&quot;: &quot;Oct 8th, 2025&quot;,
                                    &quot;created_at_formatted&quot;: &quot;Aug 28th, 2025 at 22:58&quot;,
                                    &quot;status_info&quot;: &quot;Valid&quot;,
                                    &quot;starting_info&quot;: &quot;Started on Sep 7th, 2025&quot;,
                                    &quot;expiry_info&quot;: &quot;Will expire on Oct 8th, 2025&quot;,
                                    &quot;css_class_variant&quot;: &quot;success&quot;,
                                    &quot;package&quot;: {
                                        &quot;id&quot;: 3,
                                        &quot;type&quot;: &quot;promotion&quot;,
                                        &quot;name&quot;: &quot;Premium Listing (+)&quot;,
                                        &quot;short_name&quot;: &quot;Premium+&quot;,
                                        &quot;ribbon&quot;: &quot;success&quot;,
                                        &quot;has_badge&quot;: 1,
                                        &quot;price&quot;: &quot;9.00&quot;,
                                        &quot;currency_code&quot;: &quot;USD&quot;,
                                        &quot;promotion_time&quot;: 30,
                                        &quot;interval&quot;: null,
                                        &quot;listings_limit&quot;: null,
                                        &quot;pictures_limit&quot;: 15,
                                        &quot;expiration_time&quot;: 120,
                                        &quot;description&quot;: &quot;Featured on the homepage\nFeatured in the category&quot;,
                                        &quot;facebook_ads_duration&quot;: 0,
                                        &quot;google_ads_duration&quot;: 0,
                                        &quot;twitter_ads_duration&quot;: 0,
                                        &quot;linkedin_ads_duration&quot;: 0,
                                        &quot;recommended&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;parent_id&quot;: null,
                                        &quot;lft&quot;: 5,
                                        &quot;rgt&quot;: 6,
                                        &quot;depth&quot;: 0,
                                        &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                                        &quot;period_end&quot;: &quot;2025-10-08T23:59:59.999999Z&quot;,
                                        &quot;description_array&quot;: [
                                            &quot;30 days of promotion&quot;,
                                            &quot;Up to 15 images allowed&quot;,
                                            &quot;Featured on the homepage&quot;,
                                            &quot;Featured in the category&quot;,
                                            &quot;Keep online for 120 days&quot;
                                        ],
                                        &quot;description_string&quot;: &quot;30 days of promotion. \nUp to 15 images allowed. \nFeatured on the homepage. \nFeatured in the category. \nKeep online for 120 days&quot;,
                                        &quot;price_formatted&quot;: &quot;$9&quot;
                                    }
                                },
                                &quot;rating_cache&quot;: 0,
                                &quot;rating_count&quot;: 0
                            },
                            {
                                &quot;id&quot;: 5216,
                                &quot;country_code&quot;: &quot;US&quot;,
                                &quot;user_id&quot;: 3642,
                                &quot;payment_id&quot;: null,
                                &quot;category_id&quot;: 13,
                                &quot;post_type_id&quot;: 1,
                                &quot;title&quot;: &quot;(Urgent) Realme X50 Pro 5G for sale&quot;,
                                &quot;description&quot;: &quot;Qui ut quisquam quisquam ducimus architecto asperiores. Ducimus architecto velit architecto et velit tenetur. Ullam quo modi ea odio est. Natus numquam necessitatibus nam. Laborum aliquid laboriosam ad. Consectetur perspiciatis fugit non sit velit ut ut. Molestias est dolorem dolores eos et delectus.&quot;,
                                &quot;tags&quot;: [
                                    &quot;labore&quot;,
                                    &quot;amet&quot;,
                                    &quot;neque&quot;
                                ],
                                &quot;price&quot;: &quot;58764.00&quot;,
                                &quot;currency_code&quot;: null,
                                &quot;negotiable&quot;: null,
                                &quot;contact_name&quot;: &quot;Syble Rowe&quot;,
                                &quot;address&quot;: null,
                                &quot;city_id&quot;: 47894,
                                &quot;lat&quot;: null,
                                &quot;lon&quot;: null,
                                &quot;create_from_ip&quot;: null,
                                &quot;latest_update_ip&quot;: null,
                                &quot;visits&quot;: null,
                                &quot;auth_field&quot;: &quot;email&quot;,
                                &quot;email&quot;: &quot;watsica.linnie@gmail.com&quot;,
                                &quot;phone&quot;: &quot;+17009654317&quot;,
                                &quot;phone_national&quot;: &quot;(700) 965-4317&quot;,
                                &quot;phone_country&quot;: &quot;US&quot;,
                                &quot;email_token&quot;: null,
                                &quot;phone_token&quot;: null,
                                &quot;email_verified_at&quot;: &quot;2025-09-02T15:07:00.000000Z&quot;,
                                &quot;phone_verified_at&quot;: &quot;2025-09-02T15:07:00.000000Z&quot;,
                                &quot;otp_expires_at&quot;: null,
                                &quot;last_otp_sent_at&quot;: null,
                                &quot;otp_resend_attempts&quot;: null,
                                &quot;otp_resend_attempts_expires_at&quot;: null,
                                &quot;total_otp_resend_attempts&quot;: null,
                                &quot;locked_at&quot;: null,
                                &quot;phone_hidden&quot;: null,
                                &quot;accept_terms&quot;: null,
                                &quot;accept_marketing_offers&quot;: null,
                                &quot;is_permanent&quot;: null,
                                &quot;featured&quot;: 1,
                                &quot;tmp_token&quot;: null,
                                &quot;reviewed_at&quot;: &quot;2025-09-02T15:07:00.000000Z&quot;,
                                &quot;archived_at&quot;: null,
                                &quot;archived_manually_at&quot;: null,
                                &quot;deletion_mail_sent_at&quot;: null,
                                &quot;created_at&quot;: &quot;2025-08-07T09:21:43.000000Z&quot;,
                                &quot;updated_at&quot;: &quot;2025-09-08T10:06:51.275723Z&quot;,
                                &quot;reference&quot;: &quot;X46dBgZYe79&quot;,
                                &quot;slug&quot;: &quot;-urgent-realme-x50-pro-5g-for-sale&quot;,
                                &quot;url&quot;: &quot;https://demo.laraclassifier.local/-urgent-realme-x50-pro-5g-for-sale/X46dBgZYe79&quot;,
                                &quot;excerpt&quot;: &quot;Qui ut quisquam quisquam ducimus architecto asperiores. Ducimus architecto velit architecto et velit...&quot;,
                                &quot;phone_intl&quot;: &quot;(700) 965-4317&quot;,
                                &quot;created_at_formatted&quot;: &quot;1 month ago&quot;,
                                &quot;updated_at_formatted&quot;: &quot;Sep 8th, 2025 at 06:06&quot;,
                                &quot;archived_at_formatted&quot;: &quot;&quot;,
                                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;,
                                &quot;count_pictures&quot;: 3,
                                &quot;price_label&quot;: &quot;Price:&quot;,
                                &quot;price_formatted&quot;: &quot;$58,764&quot;,
                                &quot;visits_formatted&quot;: &quot;0 view&quot;,
                                &quot;distance_info&quot;: null,
                                &quot;picture&quot;: {
                                    &quot;id&quot;: 8121,
                                    &quot;post_id&quot;: 5216,
                                    &quot;file_path&quot;: &quot;files/us/5216/f136669092da1f6a6d0952d3a825033b.jpg&quot;,
                                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                    &quot;position&quot;: 1,
                                    &quot;active&quot;: 1,
                                    &quot;url&quot;: {
                                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/5216/thumbnails/816x460-f136669092da1f6a6d0952d3a825033b.jpg&quot;,
                                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/5216/thumbnails/120x90-f136669092da1f6a6d0952d3a825033b.jpg&quot;,
                                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/5216/thumbnails/320x240-f136669092da1f6a6d0952d3a825033b.jpg&quot;,
                                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/5216/thumbnails/816x460-f136669092da1f6a6d0952d3a825033b.jpg&quot;
                                    }
                                },
                                &quot;pictures&quot;: [
                                    {
                                        &quot;id&quot;: 8121,
                                        &quot;post_id&quot;: 5216,
                                        &quot;file_path&quot;: &quot;files/us/5216/f136669092da1f6a6d0952d3a825033b.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 1,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/5216/thumbnails/816x460-f136669092da1f6a6d0952d3a825033b.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/5216/thumbnails/120x90-f136669092da1f6a6d0952d3a825033b.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/5216/thumbnails/320x240-f136669092da1f6a6d0952d3a825033b.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/5216/thumbnails/816x460-f136669092da1f6a6d0952d3a825033b.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 8122,
                                        &quot;post_id&quot;: 5216,
                                        &quot;file_path&quot;: &quot;files/us/5216/e42e95601076412ad913ccb5dd670f05.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 2,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 8123,
                                        &quot;post_id&quot;: 5216,
                                        &quot;file_path&quot;: &quot;files/us/5216/be72632e788d23b9b1ee3eb816e78c8c.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 3,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    }
                                ],
                                &quot;user&quot;: {
                                    &quot;id&quot;: 3642,
                                    &quot;name&quot;: &quot;Syble Rowe&quot;,
                                    &quot;username&quot;: &quot;pbartell&quot;,
                                    &quot;two_factor_enabled&quot;: false,
                                    &quot;two_factor_method&quot;: &quot;email&quot;,
                                    &quot;updated_at&quot;: &quot;2025-04-29T01:09:41.000000Z&quot;,
                                    &quot;original_updated_at&quot;: &quot;2025-04-29 01:09:41&quot;,
                                    &quot;original_last_activity&quot;: null,
                                    &quot;created_at_formatted&quot;: &quot;4 months ago&quot;,
                                    &quot;photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                                    &quot;p_is_online&quot;: false,
                                    &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/kw.png&quot;
                                },
                                &quot;category&quot;: {
                                    &quot;id&quot;: 13,
                                    &quot;parent_id&quot;: 9,
                                    &quot;name&quot;: &quot;Tablets&quot;,
                                    &quot;slug&quot;: &quot;tablets&quot;,
                                    &quot;description&quot;: &quot;&quot;,
                                    &quot;hide_description&quot;: null,
                                    &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                    &quot;icon_class&quot;: &quot;bi bi-folder-fill&quot;,
                                    &quot;seo_title&quot;: &quot;&quot;,
                                    &quot;seo_description&quot;: &quot;&quot;,
                                    &quot;seo_keywords&quot;: &quot;&quot;,
                                    &quot;lft&quot;: 24,
                                    &quot;rgt&quot;: 25,
                                    &quot;depth&quot;: 1,
                                    &quot;type&quot;: &quot;classified&quot;,
                                    &quot;is_for_permanent&quot;: 0,
                                    &quot;active&quot;: 1,
                                    &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/phones-and-tablets/tablets&quot;,
                                    &quot;parent&quot;: {
                                        &quot;id&quot;: 9,
                                        &quot;parent_id&quot;: null,
                                        &quot;name&quot;: &quot;Phones &amp; Tablets&quot;,
                                        &quot;slug&quot;: &quot;phones-and-tablets&quot;,
                                        &quot;description&quot;: &quot;&quot;,
                                        &quot;hide_description&quot;: null,
                                        &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                        &quot;icon_class&quot;: &quot;fa-solid fa-mobile-screen-button&quot;,
                                        &quot;seo_title&quot;: &quot;&quot;,
                                        &quot;seo_description&quot;: &quot;&quot;,
                                        &quot;seo_keywords&quot;: &quot;&quot;,
                                        &quot;lft&quot;: 17,
                                        &quot;rgt&quot;: 26,
                                        &quot;depth&quot;: 0,
                                        &quot;type&quot;: &quot;classified&quot;,
                                        &quot;is_for_permanent&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                        &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/phones-and-tablets&quot;,
                                        &quot;parent&quot;: null
                                    }
                                },
                                &quot;postType&quot;: {
                                    &quot;id&quot;: 1,
                                    &quot;name&quot;: &quot;INDIVIDUAL&quot;,
                                    &quot;label&quot;: &quot;Individual&quot;
                                },
                                &quot;city&quot;: {
                                    &quot;id&quot;: 47894,
                                    &quot;country_code&quot;: &quot;US&quot;,
                                    &quot;name&quot;: &quot;Tenafly&quot;,
                                    &quot;latitude&quot;: 40.93,
                                    &quot;longitude&quot;: -73.96,
                                    &quot;subadmin1_code&quot;: &quot;US.NJ&quot;,
                                    &quot;subadmin2_code&quot;: &quot;US.NJ.003&quot;,
                                    &quot;population&quot;: 14880,
                                    &quot;time_zone&quot;: &quot;America/New_York&quot;,
                                    &quot;active&quot;: 1,
                                    &quot;slug&quot;: &quot;tenafly&quot;,
                                    &quot;posts_count&quot;: 0
                                },
                                &quot;payment&quot;: {
                                    &quot;id&quot;: 402,
                                    &quot;payable_id&quot;: 5216,
                                    &quot;payable_type&quot;: &quot;App\\Models\\Post&quot;,
                                    &quot;package_id&quot;: 3,
                                    &quot;payment_method_id&quot;: 4,
                                    &quot;transaction_id&quot;: null,
                                    &quot;amount&quot;: &quot;9.00&quot;,
                                    &quot;currency_code&quot;: null,
                                    &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                                    &quot;period_end&quot;: &quot;2025-10-08T23:59:59.000000Z&quot;,
                                    &quot;canceled_at&quot;: null,
                                    &quot;refunded_at&quot;: null,
                                    &quot;active&quot;: 1,
                                    &quot;interval&quot;: 30.999988425925928,
                                    &quot;started&quot;: 1,
                                    &quot;expired&quot;: 0,
                                    &quot;status&quot;: &quot;valid&quot;,
                                    &quot;period_start_formatted&quot;: &quot;Sep 7th, 2025&quot;,
                                    &quot;period_end_formatted&quot;: &quot;Oct 8th, 2025&quot;,
                                    &quot;created_at_formatted&quot;: &quot;Aug 23rd, 2025 at 23:39&quot;,
                                    &quot;status_info&quot;: &quot;Valid&quot;,
                                    &quot;starting_info&quot;: &quot;Started on Sep 7th, 2025&quot;,
                                    &quot;expiry_info&quot;: &quot;Will expire on Oct 8th, 2025&quot;,
                                    &quot;css_class_variant&quot;: &quot;success&quot;,
                                    &quot;package&quot;: {
                                        &quot;id&quot;: 3,
                                        &quot;type&quot;: &quot;promotion&quot;,
                                        &quot;name&quot;: &quot;Premium Listing (+)&quot;,
                                        &quot;short_name&quot;: &quot;Premium+&quot;,
                                        &quot;ribbon&quot;: &quot;success&quot;,
                                        &quot;has_badge&quot;: 1,
                                        &quot;price&quot;: &quot;9.00&quot;,
                                        &quot;currency_code&quot;: &quot;USD&quot;,
                                        &quot;promotion_time&quot;: 30,
                                        &quot;interval&quot;: null,
                                        &quot;listings_limit&quot;: null,
                                        &quot;pictures_limit&quot;: 15,
                                        &quot;expiration_time&quot;: 120,
                                        &quot;description&quot;: &quot;Featured on the homepage\nFeatured in the category&quot;,
                                        &quot;facebook_ads_duration&quot;: 0,
                                        &quot;google_ads_duration&quot;: 0,
                                        &quot;twitter_ads_duration&quot;: 0,
                                        &quot;linkedin_ads_duration&quot;: 0,
                                        &quot;recommended&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;parent_id&quot;: null,
                                        &quot;lft&quot;: 5,
                                        &quot;rgt&quot;: 6,
                                        &quot;depth&quot;: 0,
                                        &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                                        &quot;period_end&quot;: &quot;2025-10-08T23:59:59.999999Z&quot;,
                                        &quot;description_array&quot;: [
                                            &quot;30 days of promotion&quot;,
                                            &quot;Up to 15 images allowed&quot;,
                                            &quot;Featured on the homepage&quot;,
                                            &quot;Featured in the category&quot;,
                                            &quot;Keep online for 120 days&quot;
                                        ],
                                        &quot;description_string&quot;: &quot;30 days of promotion. \nUp to 15 images allowed. \nFeatured on the homepage. \nFeatured in the category. \nKeep online for 120 days&quot;,
                                        &quot;price_formatted&quot;: &quot;$9&quot;
                                    }
                                },
                                &quot;rating_cache&quot;: 0,
                                &quot;rating_count&quot;: 0
                            },
                            {
                                &quot;id&quot;: 8436,
                                &quot;country_code&quot;: &quot;US&quot;,
                                &quot;user_id&quot;: 1883,
                                &quot;payment_id&quot;: null,
                                &quot;category_id&quot;: 8,
                                &quot;post_type_id&quot;: 2,
                                &quot;title&quot;: &quot;Hire Tesla Model 3&quot;,
                                &quot;description&quot;: &quot;Non eos earum est. Quos atque fugiat exercitationem. Provident sed sint aspernatur porro libero distinctio quaerat. Expedita qui odit aspernatur atque non rem. Ut nam magnam consequatur ea aspernatur. Eum necessitatibus assumenda omnis iste. Rem amet repudiandae dignissimos soluta repellendus neque. Minima sapiente consectetur esse ex. At aut qui quasi illum molestias. Ut dicta ullam distinctio. Dicta veritatis ipsum rerum numquam. Eum quisquam blanditiis minus et repellat velit facilis enim.&quot;,
                                &quot;tags&quot;: [
                                    &quot;ratione&quot;,
                                    &quot;culpa&quot;,
                                    &quot;sed&quot;
                                ],
                                &quot;price&quot;: &quot;710.00&quot;,
                                &quot;currency_code&quot;: null,
                                &quot;negotiable&quot;: null,
                                &quot;contact_name&quot;: &quot;Kristopher Goyette&quot;,
                                &quot;address&quot;: null,
                                &quot;city_id&quot;: 49543,
                                &quot;lat&quot;: null,
                                &quot;lon&quot;: null,
                                &quot;create_from_ip&quot;: null,
                                &quot;latest_update_ip&quot;: null,
                                &quot;visits&quot;: null,
                                &quot;auth_field&quot;: &quot;email&quot;,
                                &quot;email&quot;: &quot;xbatz@yahoo.com&quot;,
                                &quot;phone&quot;: &quot;+19617857139&quot;,
                                &quot;phone_national&quot;: &quot;(961) 785-7139&quot;,
                                &quot;phone_country&quot;: &quot;US&quot;,
                                &quot;email_token&quot;: null,
                                &quot;phone_token&quot;: null,
                                &quot;email_verified_at&quot;: &quot;2025-08-04T10:33:26.000000Z&quot;,
                                &quot;phone_verified_at&quot;: &quot;2025-08-04T10:33:26.000000Z&quot;,
                                &quot;otp_expires_at&quot;: null,
                                &quot;last_otp_sent_at&quot;: null,
                                &quot;otp_resend_attempts&quot;: null,
                                &quot;otp_resend_attempts_expires_at&quot;: null,
                                &quot;total_otp_resend_attempts&quot;: null,
                                &quot;locked_at&quot;: null,
                                &quot;phone_hidden&quot;: null,
                                &quot;accept_terms&quot;: null,
                                &quot;accept_marketing_offers&quot;: null,
                                &quot;is_permanent&quot;: null,
                                &quot;featured&quot;: 1,
                                &quot;tmp_token&quot;: null,
                                &quot;reviewed_at&quot;: &quot;2025-08-04T10:33:26.000000Z&quot;,
                                &quot;archived_at&quot;: null,
                                &quot;archived_manually_at&quot;: null,
                                &quot;deletion_mail_sent_at&quot;: null,
                                &quot;created_at&quot;: &quot;2025-07-28T09:40:52.000000Z&quot;,
                                &quot;updated_at&quot;: &quot;2025-09-08T10:06:51.475522Z&quot;,
                                &quot;reference&quot;: &quot;GELe3QJAb69&quot;,
                                &quot;slug&quot;: &quot;hire-tesla-model-3&quot;,
                                &quot;url&quot;: &quot;https://demo.laraclassifier.local/hire-tesla-model-3/GELe3QJAb69&quot;,
                                &quot;excerpt&quot;: &quot;Non eos earum est. Quos atque fugiat exercitationem. Provident sed sint aspernatur porro libero dist...&quot;,
                                &quot;phone_intl&quot;: &quot;(961) 785-7139&quot;,
                                &quot;created_at_formatted&quot;: &quot;1 month ago&quot;,
                                &quot;updated_at_formatted&quot;: &quot;Sep 8th, 2025 at 06:06&quot;,
                                &quot;archived_at_formatted&quot;: &quot;&quot;,
                                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;,
                                &quot;count_pictures&quot;: 5,
                                &quot;price_label&quot;: &quot;Price:&quot;,
                                &quot;price_formatted&quot;: &quot;$710&quot;,
                                &quot;visits_formatted&quot;: &quot;0 view&quot;,
                                &quot;distance_info&quot;: null,
                                &quot;picture&quot;: {
                                    &quot;id&quot;: 13081,
                                    &quot;post_id&quot;: 8436,
                                    &quot;file_path&quot;: &quot;files/us/8436/459075dcee5af0609b57cd776301a402.jpg&quot;,
                                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                    &quot;position&quot;: 1,
                                    &quot;active&quot;: 1,
                                    &quot;url&quot;: {
                                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/8436/thumbnails/816x460-459075dcee5af0609b57cd776301a402.jpg&quot;,
                                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/8436/thumbnails/120x90-459075dcee5af0609b57cd776301a402.jpg&quot;,
                                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/8436/thumbnails/320x240-459075dcee5af0609b57cd776301a402.jpg&quot;,
                                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/8436/thumbnails/816x460-459075dcee5af0609b57cd776301a402.jpg&quot;
                                    }
                                },
                                &quot;pictures&quot;: [
                                    {
                                        &quot;id&quot;: 13081,
                                        &quot;post_id&quot;: 8436,
                                        &quot;file_path&quot;: &quot;files/us/8436/459075dcee5af0609b57cd776301a402.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 1,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/8436/thumbnails/816x460-459075dcee5af0609b57cd776301a402.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/8436/thumbnails/120x90-459075dcee5af0609b57cd776301a402.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/8436/thumbnails/320x240-459075dcee5af0609b57cd776301a402.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/8436/thumbnails/816x460-459075dcee5af0609b57cd776301a402.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 13085,
                                        &quot;post_id&quot;: 8436,
                                        &quot;file_path&quot;: &quot;files/us/8436/439fa034dfabf3eec8bffdbebdfc9fca.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 2,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 13083,
                                        &quot;post_id&quot;: 8436,
                                        &quot;file_path&quot;: &quot;files/us/8436/802d85750c3719d6a6d162f51327116b.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 3,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 13084,
                                        &quot;post_id&quot;: 8436,
                                        &quot;file_path&quot;: &quot;files/us/8436/986d710b63d5446f4d4e6d12105ac599.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 4,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 13082,
                                        &quot;post_id&quot;: 8436,
                                        &quot;file_path&quot;: &quot;files/us/8436/3867fe84e617adaec761999668ccff9c.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 5,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    }
                                ],
                                &quot;user&quot;: {
                                    &quot;id&quot;: 1883,
                                    &quot;name&quot;: &quot;Kristopher Goyette&quot;,
                                    &quot;username&quot;: &quot;khowe&quot;,
                                    &quot;two_factor_enabled&quot;: false,
                                    &quot;two_factor_method&quot;: &quot;email&quot;,
                                    &quot;updated_at&quot;: &quot;2025-07-08T03:51:59.000000Z&quot;,
                                    &quot;original_updated_at&quot;: &quot;2025-07-08 03:51:59&quot;,
                                    &quot;original_last_activity&quot;: null,
                                    &quot;created_at_formatted&quot;: &quot;5 months ago&quot;,
                                    &quot;photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                                    &quot;p_is_online&quot;: false,
                                    &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/pt.png&quot;
                                },
                                &quot;category&quot;: {
                                    &quot;id&quot;: 8,
                                    &quot;parent_id&quot;: 1,
                                    &quot;name&quot;: &quot;Watercraft &amp; Boats&quot;,
                                    &quot;slug&quot;: &quot;watercraft-and-boats&quot;,
                                    &quot;description&quot;: &quot;&quot;,
                                    &quot;hide_description&quot;: null,
                                    &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                    &quot;icon_class&quot;: &quot;bi bi-folder-fill&quot;,
                                    &quot;seo_title&quot;: &quot;&quot;,
                                    &quot;seo_description&quot;: &quot;&quot;,
                                    &quot;seo_keywords&quot;: &quot;&quot;,
                                    &quot;lft&quot;: 14,
                                    &quot;rgt&quot;: 15,
                                    &quot;depth&quot;: 1,
                                    &quot;type&quot;: &quot;classified&quot;,
                                    &quot;is_for_permanent&quot;: 0,
                                    &quot;active&quot;: 1,
                                    &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/automobiles/watercraft-and-boats&quot;,
                                    &quot;parent&quot;: {
                                        &quot;id&quot;: 1,
                                        &quot;parent_id&quot;: null,
                                        &quot;name&quot;: &quot;Automobiles&quot;,
                                        &quot;slug&quot;: &quot;automobiles&quot;,
                                        &quot;description&quot;: &quot;&quot;,
                                        &quot;hide_description&quot;: null,
                                        &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                        &quot;icon_class&quot;: &quot;fa-solid fa-car&quot;,
                                        &quot;seo_title&quot;: &quot;&quot;,
                                        &quot;seo_description&quot;: &quot;&quot;,
                                        &quot;seo_keywords&quot;: &quot;&quot;,
                                        &quot;lft&quot;: 1,
                                        &quot;rgt&quot;: 16,
                                        &quot;depth&quot;: 0,
                                        &quot;type&quot;: &quot;classified&quot;,
                                        &quot;is_for_permanent&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                        &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/automobiles&quot;,
                                        &quot;parent&quot;: null
                                    }
                                },
                                &quot;postType&quot;: {
                                    &quot;id&quot;: 2,
                                    &quot;name&quot;: &quot;PROFESSIONAL&quot;,
                                    &quot;label&quot;: &quot;Professional&quot;
                                },
                                &quot;city&quot;: {
                                    &quot;id&quot;: 49543,
                                    &quot;country_code&quot;: &quot;US&quot;,
                                    &quot;name&quot;: &quot;Parlier&quot;,
                                    &quot;latitude&quot;: 36.61,
                                    &quot;longitude&quot;: -119.53,
                                    &quot;subadmin1_code&quot;: &quot;US.CA&quot;,
                                    &quot;subadmin2_code&quot;: &quot;US.CA.019&quot;,
                                    &quot;population&quot;: 15138,
                                    &quot;time_zone&quot;: &quot;America/Los_Angeles&quot;,
                                    &quot;active&quot;: 1,
                                    &quot;slug&quot;: &quot;parlier&quot;,
                                    &quot;posts_count&quot;: 0
                                },
                                &quot;payment&quot;: {
                                    &quot;id&quot;: 328,
                                    &quot;payable_id&quot;: 8436,
                                    &quot;payable_type&quot;: &quot;App\\Models\\Post&quot;,
                                    &quot;package_id&quot;: 2,
                                    &quot;payment_method_id&quot;: 8,
                                    &quot;transaction_id&quot;: null,
                                    &quot;amount&quot;: &quot;7.50&quot;,
                                    &quot;currency_code&quot;: null,
                                    &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                                    &quot;period_end&quot;: &quot;2025-09-15T23:59:59.000000Z&quot;,
                                    &quot;canceled_at&quot;: null,
                                    &quot;refunded_at&quot;: null,
                                    &quot;active&quot;: 1,
                                    &quot;interval&quot;: 7.999988425925926,
                                    &quot;started&quot;: 1,
                                    &quot;expired&quot;: 0,
                                    &quot;status&quot;: &quot;valid&quot;,
                                    &quot;period_start_formatted&quot;: &quot;Sep 7th, 2025&quot;,
                                    &quot;period_end_formatted&quot;: &quot;Sep 15th, 2025&quot;,
                                    &quot;created_at_formatted&quot;: &quot;Aug 4th, 2025 at 08:39&quot;,
                                    &quot;status_info&quot;: &quot;Valid&quot;,
                                    &quot;starting_info&quot;: &quot;Started on Sep 7th, 2025&quot;,
                                    &quot;expiry_info&quot;: &quot;Will expire on Sep 15th, 2025&quot;,
                                    &quot;css_class_variant&quot;: &quot;success&quot;,
                                    &quot;package&quot;: {
                                        &quot;id&quot;: 2,
                                        &quot;type&quot;: &quot;promotion&quot;,
                                        &quot;name&quot;: &quot;Premium Listing&quot;,
                                        &quot;short_name&quot;: &quot;Premium&quot;,
                                        &quot;ribbon&quot;: &quot;warning&quot;,
                                        &quot;has_badge&quot;: 1,
                                        &quot;price&quot;: &quot;7.50&quot;,
                                        &quot;currency_code&quot;: &quot;USD&quot;,
                                        &quot;promotion_time&quot;: 7,
                                        &quot;interval&quot;: null,
                                        &quot;listings_limit&quot;: null,
                                        &quot;pictures_limit&quot;: 10,
                                        &quot;expiration_time&quot;: 60,
                                        &quot;description&quot;: &quot;Featured on the homepage\nFeatured in the category&quot;,
                                        &quot;facebook_ads_duration&quot;: 0,
                                        &quot;google_ads_duration&quot;: 0,
                                        &quot;twitter_ads_duration&quot;: 0,
                                        &quot;linkedin_ads_duration&quot;: 0,
                                        &quot;recommended&quot;: 1,
                                        &quot;active&quot;: 1,
                                        &quot;parent_id&quot;: null,
                                        &quot;lft&quot;: 3,
                                        &quot;rgt&quot;: 4,
                                        &quot;depth&quot;: 0,
                                        &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                                        &quot;period_end&quot;: &quot;2025-09-15T23:59:59.999999Z&quot;,
                                        &quot;description_array&quot;: [
                                            &quot;7 days of promotion&quot;,
                                            &quot;Up to 10 images allowed&quot;,
                                            &quot;Featured on the homepage&quot;,
                                            &quot;Featured in the category&quot;,
                                            &quot;Keep online for 60 days&quot;
                                        ],
                                        &quot;description_string&quot;: &quot;7 days of promotion. \nUp to 10 images allowed. \nFeatured on the homepage. \nFeatured in the category. \nKeep online for 60 days&quot;,
                                        &quot;price_formatted&quot;: &quot;$7.50&quot;
                                    }
                                },
                                &quot;rating_cache&quot;: 0,
                                &quot;rating_count&quot;: 0
                            },
                            {
                                &quot;id&quot;: 2360,
                                &quot;country_code&quot;: &quot;US&quot;,
                                &quot;user_id&quot;: 731,
                                &quot;payment_id&quot;: null,
                                &quot;category_id&quot;: 22,
                                &quot;post_type_id&quot;: 2,
                                &quot;title&quot;: &quot;(Urgent) Siri Remote for sale&quot;,
                                &quot;description&quot;: &quot;Laboriosam blanditiis deleniti debitis repellendus. Corrupti debitis et quo excepturi minus quo. Sunt enim sed soluta sit tempora et voluptas sunt. Ipsa blanditiis id exercitationem aut quae molestiae voluptas aut.&quot;,
                                &quot;tags&quot;: [
                                    &quot;itaque&quot;,
                                    &quot;sint&quot;,
                                    &quot;eius&quot;
                                ],
                                &quot;price&quot;: &quot;66578.00&quot;,
                                &quot;currency_code&quot;: null,
                                &quot;negotiable&quot;: null,
                                &quot;contact_name&quot;: &quot;Freeda Green&quot;,
                                &quot;address&quot;: null,
                                &quot;city_id&quot;: 47334,
                                &quot;lat&quot;: null,
                                &quot;lon&quot;: null,
                                &quot;create_from_ip&quot;: null,
                                &quot;latest_update_ip&quot;: null,
                                &quot;visits&quot;: null,
                                &quot;auth_field&quot;: &quot;email&quot;,
                                &quot;email&quot;: &quot;utromp@gmail.com&quot;,
                                &quot;phone&quot;: &quot;+15484148489&quot;,
                                &quot;phone_national&quot;: &quot;(548) 414-8489&quot;,
                                &quot;phone_country&quot;: &quot;US&quot;,
                                &quot;email_token&quot;: null,
                                &quot;phone_token&quot;: null,
                                &quot;email_verified_at&quot;: &quot;2025-07-31T18:04:17.000000Z&quot;,
                                &quot;phone_verified_at&quot;: &quot;2025-07-31T18:04:17.000000Z&quot;,
                                &quot;otp_expires_at&quot;: null,
                                &quot;last_otp_sent_at&quot;: null,
                                &quot;otp_resend_attempts&quot;: null,
                                &quot;otp_resend_attempts_expires_at&quot;: null,
                                &quot;total_otp_resend_attempts&quot;: null,
                                &quot;locked_at&quot;: null,
                                &quot;phone_hidden&quot;: null,
                                &quot;accept_terms&quot;: null,
                                &quot;accept_marketing_offers&quot;: null,
                                &quot;is_permanent&quot;: null,
                                &quot;featured&quot;: 1,
                                &quot;tmp_token&quot;: null,
                                &quot;reviewed_at&quot;: &quot;2025-07-31T18:04:17.000000Z&quot;,
                                &quot;archived_at&quot;: null,
                                &quot;archived_manually_at&quot;: null,
                                &quot;deletion_mail_sent_at&quot;: null,
                                &quot;created_at&quot;: &quot;2025-07-22T13:37:25.000000Z&quot;,
                                &quot;updated_at&quot;: &quot;2025-09-08T10:06:51.676145Z&quot;,
                                &quot;reference&quot;: &quot;X46dBB8Jd79&quot;,
                                &quot;slug&quot;: &quot;-urgent-siri-remote-for-sale&quot;,
                                &quot;url&quot;: &quot;https://demo.laraclassifier.local/-urgent-siri-remote-for-sale/X46dBB8Jd79&quot;,
                                &quot;excerpt&quot;: &quot;Laboriosam blanditiis deleniti debitis repellendus. Corrupti debitis et quo excepturi minus quo. Sun...&quot;,
                                &quot;phone_intl&quot;: &quot;(548) 414-8489&quot;,
                                &quot;created_at_formatted&quot;: &quot;1 month ago&quot;,
                                &quot;updated_at_formatted&quot;: &quot;Sep 8th, 2025 at 06:06&quot;,
                                &quot;archived_at_formatted&quot;: &quot;&quot;,
                                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;,
                                &quot;count_pictures&quot;: 4,
                                &quot;price_label&quot;: &quot;Price:&quot;,
                                &quot;price_formatted&quot;: &quot;$66,578&quot;,
                                &quot;visits_formatted&quot;: &quot;0 view&quot;,
                                &quot;distance_info&quot;: null,
                                &quot;picture&quot;: {
                                    &quot;id&quot;: 3760,
                                    &quot;post_id&quot;: 2360,
                                    &quot;file_path&quot;: &quot;files/us/2360/36361172c42b7fc080be205616f0c8fb.jpg&quot;,
                                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                    &quot;position&quot;: 1,
                                    &quot;active&quot;: 1,
                                    &quot;url&quot;: {
                                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/2360/thumbnails/816x460-36361172c42b7fc080be205616f0c8fb.jpg&quot;,
                                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/2360/thumbnails/120x90-36361172c42b7fc080be205616f0c8fb.jpg&quot;,
                                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/2360/thumbnails/320x240-36361172c42b7fc080be205616f0c8fb.jpg&quot;,
                                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/2360/thumbnails/816x460-36361172c42b7fc080be205616f0c8fb.jpg&quot;
                                    }
                                },
                                &quot;pictures&quot;: [
                                    {
                                        &quot;id&quot;: 3760,
                                        &quot;post_id&quot;: 2360,
                                        &quot;file_path&quot;: &quot;files/us/2360/36361172c42b7fc080be205616f0c8fb.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 1,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/2360/thumbnails/816x460-36361172c42b7fc080be205616f0c8fb.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/2360/thumbnails/120x90-36361172c42b7fc080be205616f0c8fb.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/2360/thumbnails/320x240-36361172c42b7fc080be205616f0c8fb.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/2360/thumbnails/816x460-36361172c42b7fc080be205616f0c8fb.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 3759,
                                        &quot;post_id&quot;: 2360,
                                        &quot;file_path&quot;: &quot;files/us/2360/9266395230fe7d07027ec40564728403.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 1,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 3758,
                                        &quot;post_id&quot;: 2360,
                                        &quot;file_path&quot;: &quot;files/us/2360/b5f582961bb7b1553d1d0f1bbec71629.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 3,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 3757,
                                        &quot;post_id&quot;: 2360,
                                        &quot;file_path&quot;: &quot;files/us/2360/e142b460fca81da137c653091dbbe9d2.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 4,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    }
                                ],
                                &quot;user&quot;: {
                                    &quot;id&quot;: 731,
                                    &quot;name&quot;: &quot;Freeda Green&quot;,
                                    &quot;username&quot;: &quot;alexandreadeckow&quot;,
                                    &quot;two_factor_enabled&quot;: false,
                                    &quot;two_factor_method&quot;: &quot;email&quot;,
                                    &quot;updated_at&quot;: &quot;2025-03-20T08:19:22.000000Z&quot;,
                                    &quot;original_updated_at&quot;: &quot;2025-03-20 08:19:22&quot;,
                                    &quot;original_last_activity&quot;: null,
                                    &quot;created_at_formatted&quot;: &quot;5 months ago&quot;,
                                    &quot;photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                                    &quot;p_is_online&quot;: false,
                                    &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/gh.png&quot;
                                },
                                &quot;category&quot;: {
                                    &quot;id&quot;: 22,
                                    &quot;parent_id&quot;: 14,
                                    &quot;name&quot;: &quot;Headphones&quot;,
                                    &quot;slug&quot;: &quot;headphones&quot;,
                                    &quot;description&quot;: &quot;&quot;,
                                    &quot;hide_description&quot;: null,
                                    &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                    &quot;icon_class&quot;: &quot;bi bi-folder-fill&quot;,
                                    &quot;seo_title&quot;: &quot;&quot;,
                                    &quot;seo_description&quot;: &quot;&quot;,
                                    &quot;seo_keywords&quot;: &quot;&quot;,
                                    &quot;lft&quot;: 42,
                                    &quot;rgt&quot;: 43,
                                    &quot;depth&quot;: 1,
                                    &quot;type&quot;: &quot;classified&quot;,
                                    &quot;is_for_permanent&quot;: 0,
                                    &quot;active&quot;: 1,
                                    &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/electronics/headphones&quot;,
                                    &quot;parent&quot;: {
                                        &quot;id&quot;: 14,
                                        &quot;parent_id&quot;: null,
                                        &quot;name&quot;: &quot;Electronics&quot;,
                                        &quot;slug&quot;: &quot;electronics&quot;,
                                        &quot;description&quot;: &quot;&quot;,
                                        &quot;hide_description&quot;: null,
                                        &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                        &quot;icon_class&quot;: &quot;fa-solid fa-laptop&quot;,
                                        &quot;seo_title&quot;: &quot;&quot;,
                                        &quot;seo_description&quot;: &quot;&quot;,
                                        &quot;seo_keywords&quot;: &quot;&quot;,
                                        &quot;lft&quot;: 27,
                                        &quot;rgt&quot;: 58,
                                        &quot;depth&quot;: 0,
                                        &quot;type&quot;: &quot;classified&quot;,
                                        &quot;is_for_permanent&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                        &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/electronics&quot;,
                                        &quot;parent&quot;: null
                                    }
                                },
                                &quot;postType&quot;: {
                                    &quot;id&quot;: 2,
                                    &quot;name&quot;: &quot;PROFESSIONAL&quot;,
                                    &quot;label&quot;: &quot;Professional&quot;
                                },
                                &quot;city&quot;: {
                                    &quot;id&quot;: 47334,
                                    &quot;country_code&quot;: &quot;US&quot;,
                                    &quot;name&quot;: &quot;Hillsdale&quot;,
                                    &quot;latitude&quot;: 41.92,
                                    &quot;longitude&quot;: -84.63,
                                    &quot;subadmin1_code&quot;: &quot;US.MI&quot;,
                                    &quot;subadmin2_code&quot;: &quot;US.MI.059&quot;,
                                    &quot;population&quot;: 8163,
                                    &quot;time_zone&quot;: &quot;America/Detroit&quot;,
                                    &quot;active&quot;: 1,
                                    &quot;slug&quot;: &quot;hillsdale&quot;,
                                    &quot;posts_count&quot;: 0
                                },
                                &quot;payment&quot;: {
                                    &quot;id&quot;: 236,
                                    &quot;payable_id&quot;: 2360,
                                    &quot;payable_type&quot;: &quot;App\\Models\\Post&quot;,
                                    &quot;package_id&quot;: 2,
                                    &quot;payment_method_id&quot;: 6,
                                    &quot;transaction_id&quot;: null,
                                    &quot;amount&quot;: &quot;7.50&quot;,
                                    &quot;currency_code&quot;: null,
                                    &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                                    &quot;period_end&quot;: &quot;2025-09-15T23:59:59.000000Z&quot;,
                                    &quot;canceled_at&quot;: null,
                                    &quot;refunded_at&quot;: null,
                                    &quot;active&quot;: 1,
                                    &quot;interval&quot;: 7.999988425925926,
                                    &quot;started&quot;: 1,
                                    &quot;expired&quot;: 0,
                                    &quot;status&quot;: &quot;valid&quot;,
                                    &quot;period_start_formatted&quot;: &quot;Sep 7th, 2025&quot;,
                                    &quot;period_end_formatted&quot;: &quot;Sep 15th, 2025&quot;,
                                    &quot;created_at_formatted&quot;: &quot;Aug 5th, 2025 at 00:00&quot;,
                                    &quot;status_info&quot;: &quot;Valid&quot;,
                                    &quot;starting_info&quot;: &quot;Started on Sep 7th, 2025&quot;,
                                    &quot;expiry_info&quot;: &quot;Will expire on Sep 15th, 2025&quot;,
                                    &quot;css_class_variant&quot;: &quot;success&quot;,
                                    &quot;package&quot;: {
                                        &quot;id&quot;: 2,
                                        &quot;type&quot;: &quot;promotion&quot;,
                                        &quot;name&quot;: &quot;Premium Listing&quot;,
                                        &quot;short_name&quot;: &quot;Premium&quot;,
                                        &quot;ribbon&quot;: &quot;warning&quot;,
                                        &quot;has_badge&quot;: 1,
                                        &quot;price&quot;: &quot;7.50&quot;,
                                        &quot;currency_code&quot;: &quot;USD&quot;,
                                        &quot;promotion_time&quot;: 7,
                                        &quot;interval&quot;: null,
                                        &quot;listings_limit&quot;: null,
                                        &quot;pictures_limit&quot;: 10,
                                        &quot;expiration_time&quot;: 60,
                                        &quot;description&quot;: &quot;Featured on the homepage\nFeatured in the category&quot;,
                                        &quot;facebook_ads_duration&quot;: 0,
                                        &quot;google_ads_duration&quot;: 0,
                                        &quot;twitter_ads_duration&quot;: 0,
                                        &quot;linkedin_ads_duration&quot;: 0,
                                        &quot;recommended&quot;: 1,
                                        &quot;active&quot;: 1,
                                        &quot;parent_id&quot;: null,
                                        &quot;lft&quot;: 3,
                                        &quot;rgt&quot;: 4,
                                        &quot;depth&quot;: 0,
                                        &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                                        &quot;period_end&quot;: &quot;2025-09-15T23:59:59.999999Z&quot;,
                                        &quot;description_array&quot;: [
                                            &quot;7 days of promotion&quot;,
                                            &quot;Up to 10 images allowed&quot;,
                                            &quot;Featured on the homepage&quot;,
                                            &quot;Featured in the category&quot;,
                                            &quot;Keep online for 60 days&quot;
                                        ],
                                        &quot;description_string&quot;: &quot;7 days of promotion. \nUp to 10 images allowed. \nFeatured on the homepage. \nFeatured in the category. \nKeep online for 60 days&quot;,
                                        &quot;price_formatted&quot;: &quot;$7.50&quot;
                                    }
                                },
                                &quot;rating_cache&quot;: 0,
                                &quot;rating_count&quot;: 0
                            },
                            {
                                &quot;id&quot;: 4056,
                                &quot;country_code&quot;: &quot;US&quot;,
                                &quot;user_id&quot;: 65,
                                &quot;payment_id&quot;: null,
                                &quot;category_id&quot;: 16,
                                &quot;post_type_id&quot;: 2,
                                &quot;title&quot;: &quot;Urgent sell Lenovo Chromebook Duet&quot;,
                                &quot;description&quot;: &quot;Qui dignissimos fugiat aut. Minima sit molestiae laudantium quibusdam repellendus consequatur ipsa. Ut alias dolor eius accusamus est ut harum. Enim aut id odio. Totam sint eveniet ullam eius ut. In necessitatibus qui laudantium. Nemo nobis sit voluptates molestiae perspiciatis sed. Atque laudantium consequatur iste dolor dolorem. Corrupti qui magni placeat voluptas sed tenetur.&quot;,
                                &quot;tags&quot;: [
                                    &quot;enim&quot;,
                                    &quot;vero&quot;,
                                    &quot;tempore&quot;
                                ],
                                &quot;price&quot;: &quot;66864.00&quot;,
                                &quot;currency_code&quot;: null,
                                &quot;negotiable&quot;: null,
                                &quot;contact_name&quot;: &quot;Amaya Rosenbaum&quot;,
                                &quot;address&quot;: null,
                                &quot;city_id&quot;: 44194,
                                &quot;lat&quot;: null,
                                &quot;lon&quot;: null,
                                &quot;create_from_ip&quot;: null,
                                &quot;latest_update_ip&quot;: null,
                                &quot;visits&quot;: null,
                                &quot;auth_field&quot;: &quot;email&quot;,
                                &quot;email&quot;: &quot;cortez.dubuque@gmail.com&quot;,
                                &quot;phone&quot;: &quot;+14989733190&quot;,
                                &quot;phone_national&quot;: &quot;(498) 973-3190&quot;,
                                &quot;phone_country&quot;: &quot;US&quot;,
                                &quot;email_token&quot;: null,
                                &quot;phone_token&quot;: null,
                                &quot;email_verified_at&quot;: &quot;2025-08-18T17:46:03.000000Z&quot;,
                                &quot;phone_verified_at&quot;: &quot;2025-08-18T17:46:03.000000Z&quot;,
                                &quot;otp_expires_at&quot;: null,
                                &quot;last_otp_sent_at&quot;: null,
                                &quot;otp_resend_attempts&quot;: null,
                                &quot;otp_resend_attempts_expires_at&quot;: null,
                                &quot;total_otp_resend_attempts&quot;: null,
                                &quot;locked_at&quot;: null,
                                &quot;phone_hidden&quot;: null,
                                &quot;accept_terms&quot;: null,
                                &quot;accept_marketing_offers&quot;: null,
                                &quot;is_permanent&quot;: null,
                                &quot;featured&quot;: 1,
                                &quot;tmp_token&quot;: null,
                                &quot;reviewed_at&quot;: &quot;2025-08-18T17:46:03.000000Z&quot;,
                                &quot;archived_at&quot;: null,
                                &quot;archived_manually_at&quot;: null,
                                &quot;deletion_mail_sent_at&quot;: null,
                                &quot;created_at&quot;: &quot;2025-07-22T08:33:52.000000Z&quot;,
                                &quot;updated_at&quot;: &quot;2025-09-08T10:06:51.873246Z&quot;,
                                &quot;reference&quot;: &quot;JX7axGnleyv&quot;,
                                &quot;slug&quot;: &quot;urgent-sell-lenovo-chromebook-duet&quot;,
                                &quot;url&quot;: &quot;https://demo.laraclassifier.local/urgent-sell-lenovo-chromebook-duet/JX7axGnleyv&quot;,
                                &quot;excerpt&quot;: &quot;Qui dignissimos fugiat aut. Minima sit molestiae laudantium quibusdam repellendus consequatur ipsa....&quot;,
                                &quot;phone_intl&quot;: &quot;(498) 973-3190&quot;,
                                &quot;created_at_formatted&quot;: &quot;1 month ago&quot;,
                                &quot;updated_at_formatted&quot;: &quot;Sep 8th, 2025 at 06:06&quot;,
                                &quot;archived_at_formatted&quot;: &quot;&quot;,
                                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;,
                                &quot;count_pictures&quot;: 1,
                                &quot;price_label&quot;: &quot;Price:&quot;,
                                &quot;price_formatted&quot;: &quot;$66,864&quot;,
                                &quot;visits_formatted&quot;: &quot;0 view&quot;,
                                &quot;distance_info&quot;: null,
                                &quot;picture&quot;: {
                                    &quot;id&quot;: 6359,
                                    &quot;post_id&quot;: 4056,
                                    &quot;file_path&quot;: &quot;files/us/4056/80e595945fd59a6c2ce4945db678900d.jpg&quot;,
                                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                    &quot;position&quot;: 1,
                                    &quot;active&quot;: 1,
                                    &quot;url&quot;: {
                                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/4056/thumbnails/816x460-80e595945fd59a6c2ce4945db678900d.jpg&quot;,
                                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/4056/thumbnails/120x90-80e595945fd59a6c2ce4945db678900d.jpg&quot;,
                                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/4056/thumbnails/320x240-80e595945fd59a6c2ce4945db678900d.jpg&quot;,
                                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/4056/thumbnails/816x460-80e595945fd59a6c2ce4945db678900d.jpg&quot;
                                    }
                                },
                                &quot;pictures&quot;: [
                                    {
                                        &quot;id&quot;: 6359,
                                        &quot;post_id&quot;: 4056,
                                        &quot;file_path&quot;: &quot;files/us/4056/80e595945fd59a6c2ce4945db678900d.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 1,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/4056/thumbnails/816x460-80e595945fd59a6c2ce4945db678900d.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/4056/thumbnails/120x90-80e595945fd59a6c2ce4945db678900d.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/4056/thumbnails/320x240-80e595945fd59a6c2ce4945db678900d.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/4056/thumbnails/816x460-80e595945fd59a6c2ce4945db678900d.jpg&quot;
                                        }
                                    }
                                ],
                                &quot;user&quot;: {
                                    &quot;id&quot;: 65,
                                    &quot;name&quot;: &quot;Amaya Rosenbaum&quot;,
                                    &quot;username&quot;: &quot;nayeli35&quot;,
                                    &quot;two_factor_enabled&quot;: false,
                                    &quot;two_factor_method&quot;: &quot;email&quot;,
                                    &quot;updated_at&quot;: &quot;2025-05-26T21:54:58.000000Z&quot;,
                                    &quot;original_updated_at&quot;: &quot;2025-05-26 21:54:58&quot;,
                                    &quot;original_last_activity&quot;: null,
                                    &quot;created_at_formatted&quot;: &quot;5 months ago&quot;,
                                    &quot;photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                                    &quot;p_is_online&quot;: false,
                                    &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/ua.png&quot;
                                },
                                &quot;category&quot;: {
                                    &quot;id&quot;: 16,
                                    &quot;parent_id&quot;: 14,
                                    &quot;name&quot;: &quot;Laptops &amp; Computers&quot;,
                                    &quot;slug&quot;: &quot;laptops-and-computers&quot;,
                                    &quot;description&quot;: &quot;&quot;,
                                    &quot;hide_description&quot;: null,
                                    &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                    &quot;icon_class&quot;: &quot;bi bi-folder-fill&quot;,
                                    &quot;seo_title&quot;: &quot;&quot;,
                                    &quot;seo_description&quot;: &quot;&quot;,
                                    &quot;seo_keywords&quot;: &quot;&quot;,
                                    &quot;lft&quot;: 30,
                                    &quot;rgt&quot;: 31,
                                    &quot;depth&quot;: 1,
                                    &quot;type&quot;: &quot;classified&quot;,
                                    &quot;is_for_permanent&quot;: 0,
                                    &quot;active&quot;: 1,
                                    &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/electronics/laptops-and-computers&quot;,
                                    &quot;parent&quot;: {
                                        &quot;id&quot;: 14,
                                        &quot;parent_id&quot;: null,
                                        &quot;name&quot;: &quot;Electronics&quot;,
                                        &quot;slug&quot;: &quot;electronics&quot;,
                                        &quot;description&quot;: &quot;&quot;,
                                        &quot;hide_description&quot;: null,
                                        &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                        &quot;icon_class&quot;: &quot;fa-solid fa-laptop&quot;,
                                        &quot;seo_title&quot;: &quot;&quot;,
                                        &quot;seo_description&quot;: &quot;&quot;,
                                        &quot;seo_keywords&quot;: &quot;&quot;,
                                        &quot;lft&quot;: 27,
                                        &quot;rgt&quot;: 58,
                                        &quot;depth&quot;: 0,
                                        &quot;type&quot;: &quot;classified&quot;,
                                        &quot;is_for_permanent&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                        &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/electronics&quot;,
                                        &quot;parent&quot;: null
                                    }
                                },
                                &quot;postType&quot;: {
                                    &quot;id&quot;: 2,
                                    &quot;name&quot;: &quot;PROFESSIONAL&quot;,
                                    &quot;label&quot;: &quot;Professional&quot;
                                },
                                &quot;city&quot;: {
                                    &quot;id&quot;: 44194,
                                    &quot;country_code&quot;: &quot;US&quot;,
                                    &quot;name&quot;: &quot;Sugarmill Woods&quot;,
                                    &quot;latitude&quot;: 28.73,
                                    &quot;longitude&quot;: -82.51,
                                    &quot;subadmin1_code&quot;: &quot;US.FL&quot;,
                                    &quot;subadmin2_code&quot;: &quot;US.FL.017&quot;,
                                    &quot;population&quot;: 8287,
                                    &quot;time_zone&quot;: &quot;America/New_York&quot;,
                                    &quot;active&quot;: 1,
                                    &quot;slug&quot;: &quot;sugarmill-woods&quot;,
                                    &quot;posts_count&quot;: 0
                                },
                                &quot;payment&quot;: {
                                    &quot;id&quot;: 82,
                                    &quot;payable_id&quot;: 4056,
                                    &quot;payable_type&quot;: &quot;App\\Models\\Post&quot;,
                                    &quot;package_id&quot;: 3,
                                    &quot;payment_method_id&quot;: 9,
                                    &quot;transaction_id&quot;: null,
                                    &quot;amount&quot;: &quot;9.00&quot;,
                                    &quot;currency_code&quot;: null,
                                    &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                                    &quot;period_end&quot;: &quot;2025-10-08T23:59:59.000000Z&quot;,
                                    &quot;canceled_at&quot;: null,
                                    &quot;refunded_at&quot;: null,
                                    &quot;active&quot;: 1,
                                    &quot;interval&quot;: 30.999988425925928,
                                    &quot;started&quot;: 1,
                                    &quot;expired&quot;: 0,
                                    &quot;status&quot;: &quot;valid&quot;,
                                    &quot;period_start_formatted&quot;: &quot;Sep 7th, 2025&quot;,
                                    &quot;period_end_formatted&quot;: &quot;Oct 8th, 2025&quot;,
                                    &quot;created_at_formatted&quot;: &quot;Aug 6th, 2025 at 08:21&quot;,
                                    &quot;status_info&quot;: &quot;Valid&quot;,
                                    &quot;starting_info&quot;: &quot;Started on Sep 7th, 2025&quot;,
                                    &quot;expiry_info&quot;: &quot;Will expire on Oct 8th, 2025&quot;,
                                    &quot;css_class_variant&quot;: &quot;success&quot;,
                                    &quot;package&quot;: {
                                        &quot;id&quot;: 3,
                                        &quot;type&quot;: &quot;promotion&quot;,
                                        &quot;name&quot;: &quot;Premium Listing (+)&quot;,
                                        &quot;short_name&quot;: &quot;Premium+&quot;,
                                        &quot;ribbon&quot;: &quot;success&quot;,
                                        &quot;has_badge&quot;: 1,
                                        &quot;price&quot;: &quot;9.00&quot;,
                                        &quot;currency_code&quot;: &quot;USD&quot;,
                                        &quot;promotion_time&quot;: 30,
                                        &quot;interval&quot;: null,
                                        &quot;listings_limit&quot;: null,
                                        &quot;pictures_limit&quot;: 15,
                                        &quot;expiration_time&quot;: 120,
                                        &quot;description&quot;: &quot;Featured on the homepage\nFeatured in the category&quot;,
                                        &quot;facebook_ads_duration&quot;: 0,
                                        &quot;google_ads_duration&quot;: 0,
                                        &quot;twitter_ads_duration&quot;: 0,
                                        &quot;linkedin_ads_duration&quot;: 0,
                                        &quot;recommended&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;parent_id&quot;: null,
                                        &quot;lft&quot;: 5,
                                        &quot;rgt&quot;: 6,
                                        &quot;depth&quot;: 0,
                                        &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                                        &quot;period_end&quot;: &quot;2025-10-08T23:59:59.999999Z&quot;,
                                        &quot;description_array&quot;: [
                                            &quot;30 days of promotion&quot;,
                                            &quot;Up to 15 images allowed&quot;,
                                            &quot;Featured on the homepage&quot;,
                                            &quot;Featured in the category&quot;,
                                            &quot;Keep online for 120 days&quot;
                                        ],
                                        &quot;description_string&quot;: &quot;30 days of promotion. \nUp to 15 images allowed. \nFeatured on the homepage. \nFeatured in the category. \nKeep online for 120 days&quot;,
                                        &quot;price_formatted&quot;: &quot;$9&quot;
                                    }
                                },
                                &quot;rating_cache&quot;: 0,
                                &quot;rating_count&quot;: 0
                            },
                            {
                                &quot;id&quot;: 1142,
                                &quot;country_code&quot;: &quot;US&quot;,
                                &quot;user_id&quot;: 1067,
                                &quot;payment_id&quot;: null,
                                &quot;category_id&quot;: 7,
                                &quot;post_type_id&quot;: 2,
                                &quot;title&quot;: &quot;Nissan Versa white color&quot;,
                                &quot;description&quot;: &quot;Alias est enim voluptates. Cumque cumque rerum commodi. Ex soluta accusantium tempora sed maxime eveniet delectus omnis. Eos beatae voluptatibus suscipit est. Numquam adipisci eaque eos quidem harum. Qui in autem consequatur non recusandae. Laudantium consequatur quis distinctio. Rerum aut eos recusandae. Laudantium debitis enim unde ut. Id quo quo deserunt. Voluptas consequatur quisquam sunt saepe provident. Tempora expedita qui quod natus asperiores qui.&quot;,
                                &quot;tags&quot;: [
                                    &quot;perspiciatis&quot;,
                                    &quot;dicta&quot;,
                                    &quot;error&quot;
                                ],
                                &quot;price&quot;: &quot;212.00&quot;,
                                &quot;currency_code&quot;: null,
                                &quot;negotiable&quot;: null,
                                &quot;contact_name&quot;: &quot;Erwin McCullough&quot;,
                                &quot;address&quot;: null,
                                &quot;city_id&quot;: 47825,
                                &quot;lat&quot;: null,
                                &quot;lon&quot;: null,
                                &quot;create_from_ip&quot;: null,
                                &quot;latest_update_ip&quot;: null,
                                &quot;visits&quot;: null,
                                &quot;auth_field&quot;: &quot;email&quot;,
                                &quot;email&quot;: &quot;peyton.kuhlman@hotmail.com&quot;,
                                &quot;phone&quot;: &quot;+11397577876&quot;,
                                &quot;phone_national&quot;: &quot;1397577876&quot;,
                                &quot;phone_country&quot;: &quot;US&quot;,
                                &quot;email_token&quot;: null,
                                &quot;phone_token&quot;: null,
                                &quot;email_verified_at&quot;: &quot;2025-07-23T23:28:46.000000Z&quot;,
                                &quot;phone_verified_at&quot;: &quot;2025-07-23T23:28:46.000000Z&quot;,
                                &quot;otp_expires_at&quot;: null,
                                &quot;last_otp_sent_at&quot;: null,
                                &quot;otp_resend_attempts&quot;: null,
                                &quot;otp_resend_attempts_expires_at&quot;: null,
                                &quot;total_otp_resend_attempts&quot;: null,
                                &quot;locked_at&quot;: null,
                                &quot;phone_hidden&quot;: null,
                                &quot;accept_terms&quot;: null,
                                &quot;accept_marketing_offers&quot;: null,
                                &quot;is_permanent&quot;: null,
                                &quot;featured&quot;: 1,
                                &quot;tmp_token&quot;: null,
                                &quot;reviewed_at&quot;: &quot;2025-07-23T23:28:46.000000Z&quot;,
                                &quot;archived_at&quot;: null,
                                &quot;archived_manually_at&quot;: null,
                                &quot;deletion_mail_sent_at&quot;: null,
                                &quot;created_at&quot;: &quot;2025-06-27T07:13:12.000000Z&quot;,
                                &quot;updated_at&quot;: &quot;2025-09-08T10:06:52.081023Z&quot;,
                                &quot;reference&quot;: &quot;VWPe9vxaLyw&quot;,
                                &quot;slug&quot;: &quot;nissan-versa-white-color&quot;,
                                &quot;url&quot;: &quot;https://demo.laraclassifier.local/nissan-versa-white-color/VWPe9vxaLyw&quot;,
                                &quot;excerpt&quot;: &quot;Alias est enim voluptates. Cumque cumque rerum commodi. Ex soluta accusantium tempora sed maxime eve...&quot;,
                                &quot;phone_intl&quot;: &quot;1397577876&quot;,
                                &quot;created_at_formatted&quot;: &quot;2 months ago&quot;,
                                &quot;updated_at_formatted&quot;: &quot;Sep 8th, 2025 at 06:06&quot;,
                                &quot;archived_at_formatted&quot;: &quot;&quot;,
                                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;,
                                &quot;count_pictures&quot;: 2,
                                &quot;price_label&quot;: &quot;Price:&quot;,
                                &quot;price_formatted&quot;: &quot;$212&quot;,
                                &quot;visits_formatted&quot;: &quot;0 view&quot;,
                                &quot;distance_info&quot;: null,
                                &quot;picture&quot;: {
                                    &quot;id&quot;: 1876,
                                    &quot;post_id&quot;: 1142,
                                    &quot;file_path&quot;: &quot;files/us/1142/b3f542ba15ccb795dce5ff09585f156d.jpg&quot;,
                                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                    &quot;position&quot;: 1,
                                    &quot;active&quot;: 1,
                                    &quot;url&quot;: {
                                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/1142/thumbnails/816x460-b3f542ba15ccb795dce5ff09585f156d.jpg&quot;,
                                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/1142/thumbnails/120x90-b3f542ba15ccb795dce5ff09585f156d.jpg&quot;,
                                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/1142/thumbnails/320x240-b3f542ba15ccb795dce5ff09585f156d.jpg&quot;,
                                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/1142/thumbnails/816x460-b3f542ba15ccb795dce5ff09585f156d.jpg&quot;
                                    }
                                },
                                &quot;pictures&quot;: [
                                    {
                                        &quot;id&quot;: 1876,
                                        &quot;post_id&quot;: 1142,
                                        &quot;file_path&quot;: &quot;files/us/1142/b3f542ba15ccb795dce5ff09585f156d.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 1,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/1142/thumbnails/816x460-b3f542ba15ccb795dce5ff09585f156d.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/1142/thumbnails/120x90-b3f542ba15ccb795dce5ff09585f156d.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/1142/thumbnails/320x240-b3f542ba15ccb795dce5ff09585f156d.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/1142/thumbnails/816x460-b3f542ba15ccb795dce5ff09585f156d.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 1875,
                                        &quot;post_id&quot;: 1142,
                                        &quot;file_path&quot;: &quot;files/us/1142/45ba7f940bbb579ec55f860ab1fe65d8.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 2,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    }
                                ],
                                &quot;user&quot;: {
                                    &quot;id&quot;: 1067,
                                    &quot;name&quot;: &quot;Erwin McCullough&quot;,
                                    &quot;username&quot;: &quot;sally05&quot;,
                                    &quot;two_factor_enabled&quot;: false,
                                    &quot;two_factor_method&quot;: &quot;email&quot;,
                                    &quot;updated_at&quot;: &quot;2025-09-08T10:06:54.801405Z&quot;,
                                    &quot;original_updated_at&quot;: null,
                                    &quot;original_last_activity&quot;: null,
                                    &quot;created_at_formatted&quot;: &quot;4 months ago&quot;,
                                    &quot;photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                                    &quot;p_is_online&quot;: false,
                                    &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/es.png&quot;
                                },
                                &quot;category&quot;: {
                                    &quot;id&quot;: 7,
                                    &quot;parent_id&quot;: 1,
                                    &quot;name&quot;: &quot;Vehicle Parts &amp; Accessories&quot;,
                                    &quot;slug&quot;: &quot;car-parts-and-accessories&quot;,
                                    &quot;description&quot;: &quot;&quot;,
                                    &quot;hide_description&quot;: null,
                                    &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                    &quot;icon_class&quot;: &quot;bi bi-folder-fill&quot;,
                                    &quot;seo_title&quot;: &quot;&quot;,
                                    &quot;seo_description&quot;: &quot;&quot;,
                                    &quot;seo_keywords&quot;: &quot;&quot;,
                                    &quot;lft&quot;: 12,
                                    &quot;rgt&quot;: 13,
                                    &quot;depth&quot;: 1,
                                    &quot;type&quot;: &quot;classified&quot;,
                                    &quot;is_for_permanent&quot;: 0,
                                    &quot;active&quot;: 1,
                                    &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/automobiles/car-parts-and-accessories&quot;,
                                    &quot;parent&quot;: {
                                        &quot;id&quot;: 1,
                                        &quot;parent_id&quot;: null,
                                        &quot;name&quot;: &quot;Automobiles&quot;,
                                        &quot;slug&quot;: &quot;automobiles&quot;,
                                        &quot;description&quot;: &quot;&quot;,
                                        &quot;hide_description&quot;: null,
                                        &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                        &quot;icon_class&quot;: &quot;fa-solid fa-car&quot;,
                                        &quot;seo_title&quot;: &quot;&quot;,
                                        &quot;seo_description&quot;: &quot;&quot;,
                                        &quot;seo_keywords&quot;: &quot;&quot;,
                                        &quot;lft&quot;: 1,
                                        &quot;rgt&quot;: 16,
                                        &quot;depth&quot;: 0,
                                        &quot;type&quot;: &quot;classified&quot;,
                                        &quot;is_for_permanent&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                        &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/automobiles&quot;,
                                        &quot;parent&quot;: null
                                    }
                                },
                                &quot;postType&quot;: {
                                    &quot;id&quot;: 2,
                                    &quot;name&quot;: &quot;PROFESSIONAL&quot;,
                                    &quot;label&quot;: &quot;Professional&quot;
                                },
                                &quot;city&quot;: {
                                    &quot;id&quot;: 47825,
                                    &quot;country_code&quot;: &quot;US&quot;,
                                    &quot;name&quot;: &quot;North Caldwell&quot;,
                                    &quot;latitude&quot;: 40.86,
                                    &quot;longitude&quot;: -74.26,
                                    &quot;subadmin1_code&quot;: &quot;US.NJ&quot;,
                                    &quot;subadmin2_code&quot;: &quot;US.NJ.013&quot;,
                                    &quot;population&quot;: 6661,
                                    &quot;time_zone&quot;: &quot;America/New_York&quot;,
                                    &quot;active&quot;: 1,
                                    &quot;slug&quot;: &quot;north-caldwell&quot;,
                                    &quot;posts_count&quot;: 0
                                },
                                &quot;payment&quot;: {
                                    &quot;id&quot;: 482,
                                    &quot;payable_id&quot;: 1142,
                                    &quot;payable_type&quot;: &quot;App\\Models\\Post&quot;,
                                    &quot;package_id&quot;: 2,
                                    &quot;payment_method_id&quot;: 1,
                                    &quot;transaction_id&quot;: null,
                                    &quot;amount&quot;: &quot;7.50&quot;,
                                    &quot;currency_code&quot;: null,
                                    &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                                    &quot;period_end&quot;: &quot;2025-09-15T23:59:59.000000Z&quot;,
                                    &quot;canceled_at&quot;: null,
                                    &quot;refunded_at&quot;: null,
                                    &quot;active&quot;: 1,
                                    &quot;interval&quot;: 7.999988425925926,
                                    &quot;started&quot;: 1,
                                    &quot;expired&quot;: 0,
                                    &quot;status&quot;: &quot;valid&quot;,
                                    &quot;period_start_formatted&quot;: &quot;Sep 7th, 2025&quot;,
                                    &quot;period_end_formatted&quot;: &quot;Sep 15th, 2025&quot;,
                                    &quot;created_at_formatted&quot;: &quot;Jul 26th, 2025 at 14:51&quot;,
                                    &quot;status_info&quot;: &quot;Valid&quot;,
                                    &quot;starting_info&quot;: &quot;Started on Sep 7th, 2025&quot;,
                                    &quot;expiry_info&quot;: &quot;Will expire on Sep 15th, 2025&quot;,
                                    &quot;css_class_variant&quot;: &quot;success&quot;,
                                    &quot;package&quot;: {
                                        &quot;id&quot;: 2,
                                        &quot;type&quot;: &quot;promotion&quot;,
                                        &quot;name&quot;: &quot;Premium Listing&quot;,
                                        &quot;short_name&quot;: &quot;Premium&quot;,
                                        &quot;ribbon&quot;: &quot;warning&quot;,
                                        &quot;has_badge&quot;: 1,
                                        &quot;price&quot;: &quot;7.50&quot;,
                                        &quot;currency_code&quot;: &quot;USD&quot;,
                                        &quot;promotion_time&quot;: 7,
                                        &quot;interval&quot;: null,
                                        &quot;listings_limit&quot;: null,
                                        &quot;pictures_limit&quot;: 10,
                                        &quot;expiration_time&quot;: 60,
                                        &quot;description&quot;: &quot;Featured on the homepage\nFeatured in the category&quot;,
                                        &quot;facebook_ads_duration&quot;: 0,
                                        &quot;google_ads_duration&quot;: 0,
                                        &quot;twitter_ads_duration&quot;: 0,
                                        &quot;linkedin_ads_duration&quot;: 0,
                                        &quot;recommended&quot;: 1,
                                        &quot;active&quot;: 1,
                                        &quot;parent_id&quot;: null,
                                        &quot;lft&quot;: 3,
                                        &quot;rgt&quot;: 4,
                                        &quot;depth&quot;: 0,
                                        &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                                        &quot;period_end&quot;: &quot;2025-09-15T23:59:59.999999Z&quot;,
                                        &quot;description_array&quot;: [
                                            &quot;7 days of promotion&quot;,
                                            &quot;Up to 10 images allowed&quot;,
                                            &quot;Featured on the homepage&quot;,
                                            &quot;Featured in the category&quot;,
                                            &quot;Keep online for 60 days&quot;
                                        ],
                                        &quot;description_string&quot;: &quot;7 days of promotion. \nUp to 10 images allowed. \nFeatured on the homepage. \nFeatured in the category. \nKeep online for 60 days&quot;,
                                        &quot;price_formatted&quot;: &quot;$7.50&quot;
                                    }
                                },
                                &quot;rating_cache&quot;: 0,
                                &quot;rating_count&quot;: 0
                            },
                            {
                                &quot;id&quot;: 22,
                                &quot;country_code&quot;: &quot;US&quot;,
                                &quot;user_id&quot;: 2,
                                &quot;payment_id&quot;: null,
                                &quot;category_id&quot;: 45,
                                &quot;post_type_id&quot;: 2,
                                &quot;title&quot;: &quot;Affordable 7 Bedroom&quot;,
                                &quot;description&quot;: &quot;Ut tempora sunt et dolorem. Praesentium nemo aut sed facere id accusamus. Assumenda voluptatem cupiditate id sunt blanditiis delectus. Occaecati voluptates minus deserunt id. Dolorem quibusdam aut eum molestias ut dolore quia autem. Facere doloribus earum dolores veniam fugiat eveniet et molestias. Fuga sed ea commodi reprehenderit earum. Et vitae ut quos praesentium. Animi autem deleniti deserunt.&quot;,
                                &quot;tags&quot;: [
                                    &quot;et&quot;,
                                    &quot;quia&quot;,
                                    &quot;nemo&quot;
                                ],
                                &quot;price&quot;: &quot;91631.00&quot;,
                                &quot;currency_code&quot;: null,
                                &quot;negotiable&quot;: null,
                                &quot;contact_name&quot;: &quot;Admin Demo&quot;,
                                &quot;address&quot;: null,
                                &quot;city_id&quot;: 44998,
                                &quot;lat&quot;: null,
                                &quot;lon&quot;: null,
                                &quot;create_from_ip&quot;: null,
                                &quot;latest_update_ip&quot;: null,
                                &quot;visits&quot;: null,
                                &quot;auth_field&quot;: &quot;email&quot;,
                                &quot;email&quot;: &quot;admin@domain.tld&quot;,
                                &quot;phone&quot;: &quot;+10988219755&quot;,
                                &quot;phone_national&quot;: &quot;0988219755&quot;,
                                &quot;phone_country&quot;: &quot;US&quot;,
                                &quot;email_token&quot;: null,
                                &quot;phone_token&quot;: null,
                                &quot;email_verified_at&quot;: &quot;2025-06-14T20:08:23.000000Z&quot;,
                                &quot;phone_verified_at&quot;: &quot;2025-06-14T20:08:23.000000Z&quot;,
                                &quot;otp_expires_at&quot;: null,
                                &quot;last_otp_sent_at&quot;: null,
                                &quot;otp_resend_attempts&quot;: null,
                                &quot;otp_resend_attempts_expires_at&quot;: null,
                                &quot;total_otp_resend_attempts&quot;: null,
                                &quot;locked_at&quot;: null,
                                &quot;phone_hidden&quot;: null,
                                &quot;accept_terms&quot;: null,
                                &quot;accept_marketing_offers&quot;: null,
                                &quot;is_permanent&quot;: null,
                                &quot;featured&quot;: 1,
                                &quot;tmp_token&quot;: null,
                                &quot;reviewed_at&quot;: &quot;2025-06-14T20:08:23.000000Z&quot;,
                                &quot;archived_at&quot;: null,
                                &quot;archived_manually_at&quot;: null,
                                &quot;deletion_mail_sent_at&quot;: null,
                                &quot;created_at&quot;: &quot;2025-06-13T17:02:16.000000Z&quot;,
                                &quot;updated_at&quot;: &quot;2025-09-08T10:06:52.287211Z&quot;,
                                &quot;reference&quot;: &quot;Yq9wdLwbjPX&quot;,
                                &quot;slug&quot;: &quot;affordable-7-bedroom&quot;,
                                &quot;url&quot;: &quot;https://demo.laraclassifier.local/affordable-7-bedroom/Yq9wdLwbjPX&quot;,
                                &quot;excerpt&quot;: &quot;Ut tempora sunt et dolorem. Praesentium nemo aut sed facere id accusamus. Assumenda voluptatem cupid...&quot;,
                                &quot;phone_intl&quot;: &quot;0988219755&quot;,
                                &quot;created_at_formatted&quot;: &quot;2 months ago&quot;,
                                &quot;updated_at_formatted&quot;: &quot;Sep 8th, 2025 at 06:06&quot;,
                                &quot;archived_at_formatted&quot;: &quot;&quot;,
                                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/2/thumbnails/800x800-a7591871e7d8d1de0f705c4a915a7edf.jpg&quot;,
                                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;,
                                &quot;count_pictures&quot;: 5,
                                &quot;price_label&quot;: &quot;Price:&quot;,
                                &quot;price_formatted&quot;: &quot;$91,631&quot;,
                                &quot;visits_formatted&quot;: &quot;0 view&quot;,
                                &quot;distance_info&quot;: null,
                                &quot;picture&quot;: {
                                    &quot;id&quot;: 67,
                                    &quot;post_id&quot;: 22,
                                    &quot;file_path&quot;: &quot;files/us/22/164bfe12a616c90c81d757e02b4c74c6.jpg&quot;,
                                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                    &quot;position&quot;: 1,
                                    &quot;active&quot;: 1,
                                    &quot;url&quot;: {
                                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/22/thumbnails/816x460-164bfe12a616c90c81d757e02b4c74c6.jpg&quot;,
                                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/22/thumbnails/120x90-164bfe12a616c90c81d757e02b4c74c6.jpg&quot;,
                                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/22/thumbnails/320x240-164bfe12a616c90c81d757e02b4c74c6.jpg&quot;,
                                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/22/thumbnails/816x460-164bfe12a616c90c81d757e02b4c74c6.jpg&quot;
                                    }
                                },
                                &quot;pictures&quot;: [
                                    {
                                        &quot;id&quot;: 67,
                                        &quot;post_id&quot;: 22,
                                        &quot;file_path&quot;: &quot;files/us/22/164bfe12a616c90c81d757e02b4c74c6.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 1,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/22/thumbnails/816x460-164bfe12a616c90c81d757e02b4c74c6.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/22/thumbnails/120x90-164bfe12a616c90c81d757e02b4c74c6.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/22/thumbnails/320x240-164bfe12a616c90c81d757e02b4c74c6.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/22/thumbnails/816x460-164bfe12a616c90c81d757e02b4c74c6.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 65,
                                        &quot;post_id&quot;: 22,
                                        &quot;file_path&quot;: &quot;files/us/22/a74588329e9b882a43f5816ba6c357d3.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 1,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 68,
                                        &quot;post_id&quot;: 22,
                                        &quot;file_path&quot;: &quot;files/us/22/3c850e1025375e83691d296126ca0e92.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 3,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 66,
                                        &quot;post_id&quot;: 22,
                                        &quot;file_path&quot;: &quot;files/us/22/e911bb0cc9ef71a595ef096b66b28eca.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 4,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 69,
                                        &quot;post_id&quot;: 22,
                                        &quot;file_path&quot;: &quot;files/us/22/715d0ad2e623e52ec2aeac678f91c8f5.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 5,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    }
                                ],
                                &quot;user&quot;: {
                                    &quot;id&quot;: 2,
                                    &quot;name&quot;: &quot;Admin Demo&quot;,
                                    &quot;username&quot;: &quot;admin&quot;,
                                    &quot;two_factor_enabled&quot;: false,
                                    &quot;two_factor_method&quot;: &quot;email&quot;,
                                    &quot;updated_at&quot;: &quot;2025-09-08T09:29:18.000000Z&quot;,
                                    &quot;original_updated_at&quot;: &quot;2025-09-08 09:29:18&quot;,
                                    &quot;original_last_activity&quot;: &quot;2025-09-08 08:00:59&quot;,
                                    &quot;created_at_formatted&quot;: &quot;5 months ago&quot;,
                                    &quot;photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/2/thumbnails/800x800-a7591871e7d8d1de0f705c4a915a7edf.jpg&quot;,
                                    &quot;p_is_online&quot;: false,
                                    &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;
                                },
                                &quot;category&quot;: {
                                    &quot;id&quot;: 45,
                                    &quot;parent_id&quot;: 37,
                                    &quot;name&quot;: &quot;Short Rental&quot;,
                                    &quot;slug&quot;: &quot;temporary-and-vacation-rentals&quot;,
                                    &quot;description&quot;: &quot;&quot;,
                                    &quot;hide_description&quot;: null,
                                    &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                    &quot;icon_class&quot;: &quot;bi bi-folder-fill&quot;,
                                    &quot;seo_title&quot;: &quot;&quot;,
                                    &quot;seo_description&quot;: &quot;&quot;,
                                    &quot;seo_keywords&quot;: &quot;&quot;,
                                    &quot;lft&quot;: 88,
                                    &quot;rgt&quot;: 89,
                                    &quot;depth&quot;: 1,
                                    &quot;type&quot;: &quot;classified&quot;,
                                    &quot;is_for_permanent&quot;: 0,
                                    &quot;active&quot;: 1,
                                    &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/real-estate/temporary-and-vacation-rentals&quot;,
                                    &quot;parent&quot;: {
                                        &quot;id&quot;: 37,
                                        &quot;parent_id&quot;: null,
                                        &quot;name&quot;: &quot;Real estate&quot;,
                                        &quot;slug&quot;: &quot;real-estate&quot;,
                                        &quot;description&quot;: &quot;&quot;,
                                        &quot;hide_description&quot;: null,
                                        &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                        &quot;icon_class&quot;: &quot;fa-solid fa-house&quot;,
                                        &quot;seo_title&quot;: &quot;&quot;,
                                        &quot;seo_description&quot;: &quot;&quot;,
                                        &quot;seo_keywords&quot;: &quot;&quot;,
                                        &quot;lft&quot;: 73,
                                        &quot;rgt&quot;: 90,
                                        &quot;depth&quot;: 0,
                                        &quot;type&quot;: &quot;classified&quot;,
                                        &quot;is_for_permanent&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                        &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/real-estate&quot;,
                                        &quot;parent&quot;: null
                                    }
                                },
                                &quot;postType&quot;: {
                                    &quot;id&quot;: 2,
                                    &quot;name&quot;: &quot;PROFESSIONAL&quot;,
                                    &quot;label&quot;: &quot;Professional&quot;
                                },
                                &quot;city&quot;: {
                                    &quot;id&quot;: 44998,
                                    &quot;country_code&quot;: &quot;US&quot;,
                                    &quot;name&quot;: &quot;Woodlawn&quot;,
                                    &quot;latitude&quot;: 39.32,
                                    &quot;longitude&quot;: -76.73,
                                    &quot;subadmin1_code&quot;: &quot;US.MD&quot;,
                                    &quot;subadmin2_code&quot;: &quot;US.MD.005&quot;,
                                    &quot;population&quot;: 37879,
                                    &quot;time_zone&quot;: &quot;America/New_York&quot;,
                                    &quot;active&quot;: 1,
                                    &quot;slug&quot;: &quot;woodlawn&quot;,
                                    &quot;posts_count&quot;: 0
                                },
                                &quot;payment&quot;: {
                                    &quot;id&quot;: 184,
                                    &quot;payable_id&quot;: 22,
                                    &quot;payable_type&quot;: &quot;App\\Models\\Post&quot;,
                                    &quot;package_id&quot;: 3,
                                    &quot;payment_method_id&quot;: 5,
                                    &quot;transaction_id&quot;: null,
                                    &quot;amount&quot;: &quot;9.00&quot;,
                                    &quot;currency_code&quot;: null,
                                    &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                                    &quot;period_end&quot;: &quot;2025-10-08T23:59:59.000000Z&quot;,
                                    &quot;canceled_at&quot;: null,
                                    &quot;refunded_at&quot;: null,
                                    &quot;active&quot;: 1,
                                    &quot;interval&quot;: 30.999988425925928,
                                    &quot;started&quot;: 1,
                                    &quot;expired&quot;: 0,
                                    &quot;status&quot;: &quot;valid&quot;,
                                    &quot;period_start_formatted&quot;: &quot;Sep 7th, 2025&quot;,
                                    &quot;period_end_formatted&quot;: &quot;Oct 8th, 2025&quot;,
                                    &quot;created_at_formatted&quot;: &quot;Jul 24th, 2025 at 12:32&quot;,
                                    &quot;status_info&quot;: &quot;Valid&quot;,
                                    &quot;starting_info&quot;: &quot;Started on Sep 7th, 2025&quot;,
                                    &quot;expiry_info&quot;: &quot;Will expire on Oct 8th, 2025&quot;,
                                    &quot;css_class_variant&quot;: &quot;success&quot;,
                                    &quot;package&quot;: {
                                        &quot;id&quot;: 3,
                                        &quot;type&quot;: &quot;promotion&quot;,
                                        &quot;name&quot;: &quot;Premium Listing (+)&quot;,
                                        &quot;short_name&quot;: &quot;Premium+&quot;,
                                        &quot;ribbon&quot;: &quot;success&quot;,
                                        &quot;has_badge&quot;: 1,
                                        &quot;price&quot;: &quot;9.00&quot;,
                                        &quot;currency_code&quot;: &quot;USD&quot;,
                                        &quot;promotion_time&quot;: 30,
                                        &quot;interval&quot;: null,
                                        &quot;listings_limit&quot;: null,
                                        &quot;pictures_limit&quot;: 15,
                                        &quot;expiration_time&quot;: 120,
                                        &quot;description&quot;: &quot;Featured on the homepage\nFeatured in the category&quot;,
                                        &quot;facebook_ads_duration&quot;: 0,
                                        &quot;google_ads_duration&quot;: 0,
                                        &quot;twitter_ads_duration&quot;: 0,
                                        &quot;linkedin_ads_duration&quot;: 0,
                                        &quot;recommended&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;parent_id&quot;: null,
                                        &quot;lft&quot;: 5,
                                        &quot;rgt&quot;: 6,
                                        &quot;depth&quot;: 0,
                                        &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                                        &quot;period_end&quot;: &quot;2025-10-08T23:59:59.999999Z&quot;,
                                        &quot;description_array&quot;: [
                                            &quot;30 days of promotion&quot;,
                                            &quot;Up to 15 images allowed&quot;,
                                            &quot;Featured on the homepage&quot;,
                                            &quot;Featured in the category&quot;,
                                            &quot;Keep online for 120 days&quot;
                                        ],
                                        &quot;description_string&quot;: &quot;30 days of promotion. \nUp to 15 images allowed. \nFeatured on the homepage. \nFeatured in the category. \nKeep online for 120 days&quot;,
                                        &quot;price_formatted&quot;: &quot;$9&quot;
                                    }
                                },
                                &quot;rating_cache&quot;: 0,
                                &quot;rating_count&quot;: 0
                            }
                        ],
                        &quot;totalPosts&quot;: 13
                    }
                },
                &quot;options&quot;: {
                    &quot;max_items&quot;: &quot;20&quot;,
                    &quot;items_in_carousel&quot;: &quot;1&quot;,
                    &quot;order_by&quot;: &quot;date&quot;,
                    &quot;cache_expiration&quot;: &quot;3600&quot;,
                    &quot;active&quot;: &quot;1&quot;
                },
                &quot;lft&quot;: 5
            },
            &quot;locations&quot;: {
                &quot;belongs_to&quot;: &quot;home&quot;,
                &quot;name&quot;: &quot;locations&quot;,
                &quot;data&quot;: {
                    &quot;cities&quot;: [
                        {
                            &quot;id&quot;: 48225,
                            &quot;country_code&quot;: &quot;US&quot;,
                            &quot;name&quot;: &quot;New York City&quot;,
                            &quot;longitude&quot;: -74.01,
                            &quot;latitude&quot;: 40.71,
                            &quot;feature_class&quot;: &quot;P&quot;,
                            &quot;feature_code&quot;: &quot;PPL&quot;,
                            &quot;subadmin1_code&quot;: &quot;US.NY&quot;,
                            &quot;subadmin2_code&quot;: null,
                            &quot;population&quot;: 8804190,
                            &quot;time_zone&quot;: &quot;America/New_York&quot;,
                            &quot;active&quot;: 1,
                            &quot;created_at&quot;: &quot;2022-01-28T00:00:00.000000Z&quot;,
                            &quot;updated_at&quot;: &quot;2022-01-28T00:00:00.000000Z&quot;,
                            &quot;slug&quot;: &quot;new-york-city&quot;
                        },
                        {
                            &quot;id&quot;: 49443,
                            &quot;country_code&quot;: &quot;US&quot;,
                            &quot;name&quot;: &quot;Los Angeles&quot;,
                            &quot;longitude&quot;: -118.24,
                            &quot;latitude&quot;: 34.05,
                            &quot;feature_class&quot;: &quot;P&quot;,
                            &quot;feature_code&quot;: &quot;PPLA2&quot;,
                            &quot;subadmin1_code&quot;: &quot;US.CA&quot;,
                            &quot;subadmin2_code&quot;: &quot;US.CA.037&quot;,
                            &quot;population&quot;: 3971883,
                            &quot;time_zone&quot;: &quot;America/Los_Angeles&quot;,
                            &quot;active&quot;: 1,
                            &quot;created_at&quot;: &quot;2019-12-12T00:00:00.000000Z&quot;,
                            &quot;updated_at&quot;: &quot;2019-12-12T00:00:00.000000Z&quot;,
                            &quot;slug&quot;: &quot;los-angeles&quot;
                        },
                        {
                            &quot;id&quot;: 46654,
                            &quot;country_code&quot;: &quot;US&quot;,
                            &quot;name&quot;: &quot;Chicago&quot;,
                            &quot;longitude&quot;: -87.65,
                            &quot;latitude&quot;: 41.85,
                            &quot;feature_class&quot;: &quot;P&quot;,
                            &quot;feature_code&quot;: &quot;PPLA2&quot;,
                            &quot;subadmin1_code&quot;: &quot;US.IL&quot;,
                            &quot;subadmin2_code&quot;: &quot;US.IL.031&quot;,
                            &quot;population&quot;: 2720546,
                            &quot;time_zone&quot;: &quot;America/Chicago&quot;,
                            &quot;active&quot;: 1,
                            &quot;created_at&quot;: &quot;2019-10-07T00:00:00.000000Z&quot;,
                            &quot;updated_at&quot;: &quot;2019-10-07T00:00:00.000000Z&quot;,
                            &quot;slug&quot;: &quot;chicago&quot;
                        },
                        {
                            &quot;id&quot;: 47977,
                            &quot;country_code&quot;: &quot;US&quot;,
                            &quot;name&quot;: &quot;Brooklyn&quot;,
                            &quot;longitude&quot;: -73.95,
                            &quot;latitude&quot;: 40.65,
                            &quot;feature_class&quot;: &quot;P&quot;,
                            &quot;feature_code&quot;: &quot;PPLA2&quot;,
                            &quot;subadmin1_code&quot;: &quot;US.NY&quot;,
                            &quot;subadmin2_code&quot;: &quot;US.NY.047&quot;,
                            &quot;population&quot;: 2300664,
                            &quot;time_zone&quot;: &quot;America/New_York&quot;,
                            &quot;active&quot;: 1,
                            &quot;created_at&quot;: &quot;2015-01-18T00:00:00.000000Z&quot;,
                            &quot;updated_at&quot;: &quot;2015-01-18T00:00:00.000000Z&quot;,
                            &quot;slug&quot;: &quot;brooklyn&quot;
                        },
                        {
                            &quot;id&quot;: 46017,
                            &quot;country_code&quot;: &quot;US&quot;,
                            &quot;name&quot;: &quot;Houston&quot;,
                            &quot;longitude&quot;: -95.36,
                            &quot;latitude&quot;: 29.76,
                            &quot;feature_class&quot;: &quot;P&quot;,
                            &quot;feature_code&quot;: &quot;PPLA2&quot;,
                            &quot;subadmin1_code&quot;: &quot;US.TX&quot;,
                            &quot;subadmin2_code&quot;: &quot;US.TX.201&quot;,
                            &quot;population&quot;: 2296224,
                            &quot;time_zone&quot;: &quot;America/Chicago&quot;,
                            &quot;active&quot;: 1,
                            &quot;created_at&quot;: &quot;2021-07-25T00:00:00.000000Z&quot;,
                            &quot;updated_at&quot;: &quot;2021-07-25T00:00:00.000000Z&quot;,
                            &quot;slug&quot;: &quot;houston&quot;
                        },
                        {
                            &quot;id&quot;: 48286,
                            &quot;country_code&quot;: &quot;US&quot;,
                            &quot;name&quot;: &quot;Queens&quot;,
                            &quot;longitude&quot;: -73.84,
                            &quot;latitude&quot;: 40.68,
                            &quot;feature_class&quot;: &quot;P&quot;,
                            &quot;feature_code&quot;: &quot;PPLA2&quot;,
                            &quot;subadmin1_code&quot;: &quot;US.NY&quot;,
                            &quot;subadmin2_code&quot;: &quot;US.NY.081&quot;,
                            &quot;population&quot;: 2272771,
                            &quot;time_zone&quot;: &quot;America/New_York&quot;,
                            &quot;active&quot;: 1,
                            &quot;created_at&quot;: &quot;2021-07-30T00:00:00.000000Z&quot;,
                            &quot;updated_at&quot;: &quot;2021-07-30T00:00:00.000000Z&quot;,
                            &quot;slug&quot;: &quot;queens&quot;
                        },
                        {
                            &quot;id&quot;: 49093,
                            &quot;country_code&quot;: &quot;US&quot;,
                            &quot;name&quot;: &quot;Phoenix&quot;,
                            &quot;longitude&quot;: -112.07,
                            &quot;latitude&quot;: 33.45,
                            &quot;feature_class&quot;: &quot;P&quot;,
                            &quot;feature_code&quot;: &quot;PPLA&quot;,
                            &quot;subadmin1_code&quot;: &quot;US.AZ&quot;,
                            &quot;subadmin2_code&quot;: &quot;US.AZ.013&quot;,
                            &quot;population&quot;: 1608139,
                            &quot;time_zone&quot;: &quot;America/Phoenix&quot;,
                            &quot;active&quot;: 1,
                            &quot;created_at&quot;: &quot;2022-01-28T00:00:00.000000Z&quot;,
                            &quot;updated_at&quot;: &quot;2022-01-28T00:00:00.000000Z&quot;,
                            &quot;slug&quot;: &quot;phoenix&quot;
                        },
                        {
                            &quot;id&quot;: 45632,
                            &quot;country_code&quot;: &quot;US&quot;,
                            &quot;name&quot;: &quot;Philadelphia&quot;,
                            &quot;longitude&quot;: -75.16,
                            &quot;latitude&quot;: 39.95,
                            &quot;feature_class&quot;: &quot;P&quot;,
                            &quot;feature_code&quot;: &quot;PPLA2&quot;,
                            &quot;subadmin1_code&quot;: &quot;US.PA&quot;,
                            &quot;subadmin2_code&quot;: &quot;US.PA.101&quot;,
                            &quot;population&quot;: 1603797,
                            &quot;time_zone&quot;: &quot;America/New_York&quot;,
                            &quot;active&quot;: 1,
                            &quot;created_at&quot;: &quot;2022-01-28T00:00:00.000000Z&quot;,
                            &quot;updated_at&quot;: &quot;2022-01-28T00:00:00.000000Z&quot;,
                            &quot;slug&quot;: &quot;philadelphia&quot;
                        },
                        {
                            &quot;id&quot;: 48176,
                            &quot;country_code&quot;: &quot;US&quot;,
                            &quot;name&quot;: &quot;Manhattan&quot;,
                            &quot;longitude&quot;: -73.97,
                            &quot;latitude&quot;: 40.78,
                            &quot;feature_class&quot;: &quot;P&quot;,
                            &quot;feature_code&quot;: &quot;PPLA2&quot;,
                            &quot;subadmin1_code&quot;: &quot;US.NY&quot;,
                            &quot;subadmin2_code&quot;: &quot;US.NY.061&quot;,
                            &quot;population&quot;: 1487536,
                            &quot;time_zone&quot;: &quot;America/New_York&quot;,
                            &quot;active&quot;: 1,
                            &quot;created_at&quot;: &quot;2021-08-20T00:00:00.000000Z&quot;,
                            &quot;updated_at&quot;: &quot;2021-08-20T00:00:00.000000Z&quot;,
                            &quot;slug&quot;: &quot;manhattan&quot;
                        },
                        {
                            &quot;id&quot;: 46150,
                            &quot;country_code&quot;: &quot;US&quot;,
                            &quot;name&quot;: &quot;San Antonio&quot;,
                            &quot;longitude&quot;: -98.49,
                            &quot;latitude&quot;: 29.42,
                            &quot;feature_class&quot;: &quot;P&quot;,
                            &quot;feature_code&quot;: &quot;PPLA2&quot;,
                            &quot;subadmin1_code&quot;: &quot;US.TX&quot;,
                            &quot;subadmin2_code&quot;: &quot;US.TX.029&quot;,
                            &quot;population&quot;: 1469845,
                            &quot;time_zone&quot;: &quot;America/Chicago&quot;,
                            &quot;active&quot;: 1,
                            &quot;created_at&quot;: &quot;2019-09-19T00:00:00.000000Z&quot;,
                            &quot;updated_at&quot;: &quot;2019-09-19T00:00:00.000000Z&quot;,
                            &quot;slug&quot;: &quot;san-antonio&quot;
                        },
                        {
                            &quot;id&quot;: 49614,
                            &quot;country_code&quot;: &quot;US&quot;,
                            &quot;name&quot;: &quot;San Diego&quot;,
                            &quot;longitude&quot;: -117.16,
                            &quot;latitude&quot;: 32.72,
                            &quot;feature_class&quot;: &quot;P&quot;,
                            &quot;feature_code&quot;: &quot;PPLA2&quot;,
                            &quot;subadmin1_code&quot;: &quot;US.CA&quot;,
                            &quot;subadmin2_code&quot;: &quot;US.CA.073&quot;,
                            &quot;population&quot;: 1394928,
                            &quot;time_zone&quot;: &quot;America/Los_Angeles&quot;,
                            &quot;active&quot;: 1,
                            &quot;created_at&quot;: &quot;2019-09-05T00:00:00.000000Z&quot;,
                            &quot;updated_at&quot;: &quot;2019-09-05T00:00:00.000000Z&quot;,
                            &quot;slug&quot;: &quot;san-diego&quot;
                        },
                        {
                            &quot;id&quot;: 47975,
                            &quot;country_code&quot;: &quot;US&quot;,
                            &quot;name&quot;: &quot;The Bronx&quot;,
                            &quot;longitude&quot;: -73.87,
                            &quot;latitude&quot;: 40.85,
                            &quot;feature_class&quot;: &quot;P&quot;,
                            &quot;feature_code&quot;: &quot;PPLA2&quot;,
                            &quot;subadmin1_code&quot;: &quot;US.NY&quot;,
                            &quot;subadmin2_code&quot;: &quot;US.NY.005&quot;,
                            &quot;population&quot;: 1385108,
                            &quot;time_zone&quot;: &quot;America/New_York&quot;,
                            &quot;active&quot;: 1,
                            &quot;created_at&quot;: &quot;2021-08-08T00:00:00.000000Z&quot;,
                            &quot;updated_at&quot;: &quot;2021-08-08T00:00:00.000000Z&quot;,
                            &quot;slug&quot;: &quot;the-bronx&quot;
                        },
                        {
                            &quot;id&quot;: 45946,
                            &quot;country_code&quot;: &quot;US&quot;,
                            &quot;name&quot;: &quot;Dallas&quot;,
                            &quot;longitude&quot;: -96.81,
                            &quot;latitude&quot;: 32.78,
                            &quot;feature_class&quot;: &quot;P&quot;,
                            &quot;feature_code&quot;: &quot;PPLA2&quot;,
                            &quot;subadmin1_code&quot;: &quot;US.TX&quot;,
                            &quot;subadmin2_code&quot;: &quot;US.TX.113&quot;,
                            &quot;population&quot;: 1300092,
                            &quot;time_zone&quot;: &quot;America/Chicago&quot;,
                            &quot;active&quot;: 1,
                            &quot;created_at&quot;: &quot;2021-07-25T00:00:00.000000Z&quot;,
                            &quot;updated_at&quot;: &quot;2021-07-25T00:00:00.000000Z&quot;,
                            &quot;slug&quot;: &quot;dallas&quot;
                        },
                        {
                            &quot;id&quot;: 49621,
                            &quot;country_code&quot;: &quot;US&quot;,
                            &quot;name&quot;: &quot;San Jose&quot;,
                            &quot;longitude&quot;: -121.89,
                            &quot;latitude&quot;: 37.34,
                            &quot;feature_class&quot;: &quot;P&quot;,
                            &quot;feature_code&quot;: &quot;PPLA2&quot;,
                            &quot;subadmin1_code&quot;: &quot;US.CA&quot;,
                            &quot;subadmin2_code&quot;: &quot;US.CA.085&quot;,
                            &quot;population&quot;: 1026908,
                            &quot;time_zone&quot;: &quot;America/Los_Angeles&quot;,
                            &quot;active&quot;: 1,
                            &quot;created_at&quot;: &quot;2019-09-05T00:00:00.000000Z&quot;,
                            &quot;updated_at&quot;: &quot;2019-09-05T00:00:00.000000Z&quot;,
                            &quot;slug&quot;: &quot;san-jose&quot;
                        },
                        {
                            &quot;id&quot;: 0,
                            &quot;name&quot;: &quot;More cities &amp;raquo;&quot;,
                            &quot;subadmin1_code&quot;: 0
                        }
                    ],
                    &quot;items_cols&quot;: 3
                },
                &quot;options&quot;: {
                    &quot;show_cities&quot;: &quot;1&quot;,
                    &quot;max_items&quot;: 14,
                    &quot;show_listing_btn&quot;: &quot;1&quot;,
                    &quot;enable_map&quot;: &quot;1&quot;,
                    &quot;map_width&quot;: &quot;300&quot;,
                    &quot;map_height&quot;: &quot;300&quot;,
                    &quot;show_post_btn&quot;: &quot;1&quot;,
                    &quot;background_color&quot;: null,
                    &quot;border_width&quot;: null,
                    &quot;border_color&quot;: null,
                    &quot;text_color&quot;: null,
                    &quot;link_color&quot;: null,
                    &quot;link_hover_color&quot;: null,
                    &quot;items_cols&quot;: &quot;3&quot;,
                    &quot;count_cities_posts&quot;: &quot;0&quot;,
                    &quot;cache_expiration&quot;: &quot;3600&quot;,
                    &quot;map_background_color&quot;: null,
                    &quot;map_border&quot;: null,
                    &quot;map_hover_border&quot;: null,
                    &quot;map_border_width&quot;: null,
                    &quot;map_color&quot;: null,
                    &quot;map_hover&quot;: null,
                    &quot;active&quot;: &quot;1&quot;
                },
                &quot;lft&quot;: 7
            },
            &quot;latest_listings&quot;: {
                &quot;belongs_to&quot;: &quot;home&quot;,
                &quot;name&quot;: &quot;latest_listings&quot;,
                &quot;data&quot;: {
                    &quot;latest&quot;: {
                        &quot;title&quot;: &quot;&lt;span style=\&quot;font-weight: bold;\&quot;&gt;Latest&lt;/span&gt; Listings&quot;,
                        &quot;link&quot;: &quot;https://demo.laraclassifier.local/search&quot;,
                        &quot;posts&quot;: [
                            {
                                &quot;id&quot;: 64,
                                &quot;country_code&quot;: &quot;US&quot;,
                                &quot;user_id&quot;: 1,
                                &quot;payment_id&quot;: null,
                                &quot;category_id&quot;: 89,
                                &quot;post_type_id&quot;: 1,
                                &quot;title&quot;: &quot;Looking for UPS Driver&quot;,
                                &quot;description&quot;: &quot;Eveniet consectetur asperiores nisi nihil hic aspernatur omnis. Architecto corrupti sit similique. Voluptas veritatis fuga quam eum numquam dignissimos. Et expedita quia asperiores fugit molestiae ea. Numquam esse quidem quo et rerum rerum. Vel eos officiis natus voluptatem magnam voluptas dolore. Repudiandae inventore laudantium placeat facere cupiditate. Officiis vel ut eius numquam quis qui non perferendis. At adipisci et non aut enim velit expedita. Dolor ea ut laboriosam quo vero et.&quot;,
                                &quot;tags&quot;: [
                                    &quot;velit&quot;,
                                    &quot;aut&quot;,
                                    &quot;itaque&quot;
                                ],
                                &quot;price&quot;: &quot;165.00&quot;,
                                &quot;currency_code&quot;: null,
                                &quot;negotiable&quot;: null,
                                &quot;contact_name&quot;: &quot;Administrator&quot;,
                                &quot;address&quot;: null,
                                &quot;city_id&quot;: 46886,
                                &quot;lat&quot;: null,
                                &quot;lon&quot;: null,
                                &quot;create_from_ip&quot;: null,
                                &quot;latest_update_ip&quot;: null,
                                &quot;visits&quot;: null,
                                &quot;auth_field&quot;: &quot;email&quot;,
                                &quot;email&quot;: &quot;mayeul@domain.tld&quot;,
                                &quot;phone&quot;: &quot;+12283918341&quot;,
                                &quot;phone_national&quot;: &quot;(228) 391-8341&quot;,
                                &quot;phone_country&quot;: &quot;US&quot;,
                                &quot;email_token&quot;: null,
                                &quot;phone_token&quot;: null,
                                &quot;email_verified_at&quot;: &quot;2025-09-08T05:39:28.000000Z&quot;,
                                &quot;phone_verified_at&quot;: &quot;2025-09-08T05:39:28.000000Z&quot;,
                                &quot;otp_expires_at&quot;: null,
                                &quot;last_otp_sent_at&quot;: null,
                                &quot;otp_resend_attempts&quot;: null,
                                &quot;otp_resend_attempts_expires_at&quot;: null,
                                &quot;total_otp_resend_attempts&quot;: null,
                                &quot;locked_at&quot;: null,
                                &quot;phone_hidden&quot;: null,
                                &quot;accept_terms&quot;: null,
                                &quot;accept_marketing_offers&quot;: null,
                                &quot;is_permanent&quot;: null,
                                &quot;featured&quot;: 0,
                                &quot;tmp_token&quot;: null,
                                &quot;reviewed_at&quot;: &quot;2025-09-08T05:39:28.000000Z&quot;,
                                &quot;archived_at&quot;: null,
                                &quot;archived_manually_at&quot;: null,
                                &quot;deletion_mail_sent_at&quot;: null,
                                &quot;created_at&quot;: &quot;2025-09-07T22:48:22.000000Z&quot;,
                                &quot;updated_at&quot;: &quot;2025-09-08T10:06:55.583948Z&quot;,
                                &quot;reference&quot;: &quot;1YQdJ62dOGp&quot;,
                                &quot;slug&quot;: &quot;looking-for-ups-driver&quot;,
                                &quot;url&quot;: &quot;https://demo.laraclassifier.local/looking-for-ups-driver/1YQdJ62dOGp&quot;,
                                &quot;excerpt&quot;: &quot;Eveniet consectetur asperiores nisi nihil hic aspernatur omnis. Architecto corrupti sit similique. V...&quot;,
                                &quot;phone_intl&quot;: &quot;(228) 391-8341&quot;,
                                &quot;created_at_formatted&quot;: &quot;11 hours ago&quot;,
                                &quot;updated_at_formatted&quot;: &quot;Sep 8th, 2025 at 06:06&quot;,
                                &quot;archived_at_formatted&quot;: &quot;&quot;,
                                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/1/thumbnails/800x800-f7d5a0d9df09422cd70ede1487d901a6.jpg&quot;,
                                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;,
                                &quot;count_pictures&quot;: 3,
                                &quot;price_label&quot;: &quot;Salary:&quot;,
                                &quot;price_formatted&quot;: &quot;$165&quot;,
                                &quot;visits_formatted&quot;: &quot;0 view&quot;,
                                &quot;distance_info&quot;: null,
                                &quot;picture&quot;: {
                                    &quot;id&quot;: 188,
                                    &quot;post_id&quot;: 64,
                                    &quot;file_path&quot;: &quot;files/us/64/77ac367515b016a9eb173a6459107572.jpg&quot;,
                                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                    &quot;position&quot;: 1,
                                    &quot;active&quot;: 1,
                                    &quot;url&quot;: {
                                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/64/thumbnails/816x460-77ac367515b016a9eb173a6459107572.jpg&quot;,
                                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/64/thumbnails/120x90-77ac367515b016a9eb173a6459107572.jpg&quot;,
                                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/64/thumbnails/320x240-77ac367515b016a9eb173a6459107572.jpg&quot;,
                                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/64/thumbnails/816x460-77ac367515b016a9eb173a6459107572.jpg&quot;
                                    }
                                },
                                &quot;pictures&quot;: [
                                    {
                                        &quot;id&quot;: 188,
                                        &quot;post_id&quot;: 64,
                                        &quot;file_path&quot;: &quot;files/us/64/77ac367515b016a9eb173a6459107572.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 1,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/64/thumbnails/816x460-77ac367515b016a9eb173a6459107572.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/64/thumbnails/120x90-77ac367515b016a9eb173a6459107572.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/64/thumbnails/320x240-77ac367515b016a9eb173a6459107572.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/64/thumbnails/816x460-77ac367515b016a9eb173a6459107572.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 187,
                                        &quot;post_id&quot;: 64,
                                        &quot;file_path&quot;: &quot;files/us/64/456254b1d78fefe3e5578b4dc492c2ff.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 1,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 186,
                                        &quot;post_id&quot;: 64,
                                        &quot;file_path&quot;: &quot;files/us/64/06a8ceb3fe65b3e2304297d96580c916.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 2,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    }
                                ],
                                &quot;user&quot;: {
                                    &quot;id&quot;: 1,
                                    &quot;name&quot;: &quot;Administrator&quot;,
                                    &quot;username&quot;: &quot;adminak&quot;,
                                    &quot;two_factor_enabled&quot;: false,
                                    &quot;two_factor_method&quot;: &quot;email&quot;,
                                    &quot;updated_at&quot;: &quot;2025-09-08T09:29:18.000000Z&quot;,
                                    &quot;original_updated_at&quot;: &quot;2025-09-08 09:29:18&quot;,
                                    &quot;original_last_activity&quot;: &quot;2025-09-08 09:19:34&quot;,
                                    &quot;created_at_formatted&quot;: &quot;1 week ago&quot;,
                                    &quot;photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/1/thumbnails/800x800-f7d5a0d9df09422cd70ede1487d901a6.jpg&quot;,
                                    &quot;p_is_online&quot;: false,
                                    &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;
                                },
                                &quot;category&quot;: {
                                    &quot;id&quot;: 89,
                                    &quot;parent_id&quot;: 73,
                                    &quot;name&quot;: &quot;Babysitting - Nanny Work&quot;,
                                    &quot;slug&quot;: &quot;babysitting-nanny-work&quot;,
                                    &quot;description&quot;: &quot;&quot;,
                                    &quot;hide_description&quot;: null,
                                    &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                    &quot;icon_class&quot;: &quot;bi bi-folder-fill&quot;,
                                    &quot;seo_title&quot;: &quot;&quot;,
                                    &quot;seo_description&quot;: &quot;&quot;,
                                    &quot;seo_keywords&quot;: &quot;&quot;,
                                    &quot;lft&quot;: 176,
                                    &quot;rgt&quot;: 177,
                                    &quot;depth&quot;: 1,
                                    &quot;type&quot;: &quot;job-offer&quot;,
                                    &quot;is_for_permanent&quot;: 0,
                                    &quot;active&quot;: 1,
                                    &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/jobs/babysitting-nanny-work&quot;,
                                    &quot;parent&quot;: {
                                        &quot;id&quot;: 73,
                                        &quot;parent_id&quot;: null,
                                        &quot;name&quot;: &quot;Jobs&quot;,
                                        &quot;slug&quot;: &quot;jobs&quot;,
                                        &quot;description&quot;: &quot;&quot;,
                                        &quot;hide_description&quot;: null,
                                        &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                        &quot;icon_class&quot;: &quot;fa-solid fa-briefcase&quot;,
                                        &quot;seo_title&quot;: &quot;&quot;,
                                        &quot;seo_description&quot;: &quot;&quot;,
                                        &quot;seo_keywords&quot;: &quot;&quot;,
                                        &quot;lft&quot;: 145,
                                        &quot;rgt&quot;: 192,
                                        &quot;depth&quot;: 0,
                                        &quot;type&quot;: &quot;job-offer&quot;,
                                        &quot;is_for_permanent&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                        &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/jobs&quot;,
                                        &quot;parent&quot;: null
                                    }
                                },
                                &quot;postType&quot;: {
                                    &quot;id&quot;: 1,
                                    &quot;name&quot;: &quot;INDIVIDUAL&quot;,
                                    &quot;label&quot;: &quot;Individual&quot;
                                },
                                &quot;city&quot;: {
                                    &quot;id&quot;: 46886,
                                    &quot;country_code&quot;: &quot;US&quot;,
                                    &quot;name&quot;: &quot;Streamwood&quot;,
                                    &quot;latitude&quot;: 42.03,
                                    &quot;longitude&quot;: -88.18,
                                    &quot;subadmin1_code&quot;: &quot;US.IL&quot;,
                                    &quot;subadmin2_code&quot;: &quot;US.IL.031&quot;,
                                    &quot;population&quot;: 40554,
                                    &quot;time_zone&quot;: &quot;America/Chicago&quot;,
                                    &quot;active&quot;: 1,
                                    &quot;slug&quot;: &quot;streamwood&quot;,
                                    &quot;posts_count&quot;: 0
                                },
                                &quot;payment&quot;: null,
                                &quot;rating_cache&quot;: 0,
                                &quot;rating_count&quot;: 0
                            },
                            {
                                &quot;id&quot;: 81,
                                &quot;country_code&quot;: &quot;US&quot;,
                                &quot;user_id&quot;: 1,
                                &quot;payment_id&quot;: null,
                                &quot;category_id&quot;: 80,
                                &quot;post_type_id&quot;: 2,
                                &quot;title&quot;: &quot;Phone Sales Specialist&quot;,
                                &quot;description&quot;: &quot;Numquam soluta corporis doloremque id perferendis et. Excepturi ullam eligendi tempore illo. Impedit dicta distinctio suscipit illo. Reiciendis inventore labore fugit. Exercitationem tenetur saepe id alias eos libero alias. Quasi iusto voluptates labore. Qui impedit aliquid ut iure quidem. Atque nulla ipsam commodi quasi quo debitis. Sint eius a et autem error. Consequatur minima necessitatibus at nobis vel. Aut possimus blanditiis quisquam voluptatem maxime qui nulla mollitia. Non eos quo nobis dolorem natus quae. Excepturi quisquam dolore vero cumque debitis velit voluptatem.&quot;,
                                &quot;tags&quot;: [
                                    &quot;nihil&quot;,
                                    &quot;ad&quot;,
                                    &quot;quia&quot;
                                ],
                                &quot;price&quot;: &quot;62.00&quot;,
                                &quot;currency_code&quot;: null,
                                &quot;negotiable&quot;: null,
                                &quot;contact_name&quot;: &quot;Administrator&quot;,
                                &quot;address&quot;: null,
                                &quot;city_id&quot;: 47343,
                                &quot;lat&quot;: null,
                                &quot;lon&quot;: null,
                                &quot;create_from_ip&quot;: null,
                                &quot;latest_update_ip&quot;: null,
                                &quot;visits&quot;: null,
                                &quot;auth_field&quot;: &quot;email&quot;,
                                &quot;email&quot;: &quot;mayeul@domain.tld&quot;,
                                &quot;phone&quot;: &quot;+10224634084&quot;,
                                &quot;phone_national&quot;: &quot;0224634084&quot;,
                                &quot;phone_country&quot;: &quot;US&quot;,
                                &quot;email_token&quot;: null,
                                &quot;phone_token&quot;: null,
                                &quot;email_verified_at&quot;: &quot;2025-09-08T06:16:14.000000Z&quot;,
                                &quot;phone_verified_at&quot;: &quot;2025-09-08T06:16:14.000000Z&quot;,
                                &quot;otp_expires_at&quot;: null,
                                &quot;last_otp_sent_at&quot;: null,
                                &quot;otp_resend_attempts&quot;: null,
                                &quot;otp_resend_attempts_expires_at&quot;: null,
                                &quot;total_otp_resend_attempts&quot;: null,
                                &quot;locked_at&quot;: null,
                                &quot;phone_hidden&quot;: null,
                                &quot;accept_terms&quot;: null,
                                &quot;accept_marketing_offers&quot;: null,
                                &quot;is_permanent&quot;: null,
                                &quot;featured&quot;: 0,
                                &quot;tmp_token&quot;: null,
                                &quot;reviewed_at&quot;: &quot;2025-09-08T06:16:14.000000Z&quot;,
                                &quot;archived_at&quot;: null,
                                &quot;archived_manually_at&quot;: null,
                                &quot;deletion_mail_sent_at&quot;: null,
                                &quot;created_at&quot;: &quot;2025-09-07T10:22:48.000000Z&quot;,
                                &quot;updated_at&quot;: &quot;2025-09-08T10:06:55.790571Z&quot;,
                                &quot;reference&quot;: &quot;KGRb4x1bBLZ&quot;,
                                &quot;slug&quot;: &quot;phone-sales-specialist&quot;,
                                &quot;url&quot;: &quot;https://demo.laraclassifier.local/phone-sales-specialist/KGRb4x1bBLZ&quot;,
                                &quot;excerpt&quot;: &quot;Numquam soluta corporis doloremque id perferendis et. Excepturi ullam eligendi tempore illo. Impedit...&quot;,
                                &quot;phone_intl&quot;: &quot;0224634084&quot;,
                                &quot;created_at_formatted&quot;: &quot;23 hours ago&quot;,
                                &quot;updated_at_formatted&quot;: &quot;Sep 8th, 2025 at 06:06&quot;,
                                &quot;archived_at_formatted&quot;: &quot;&quot;,
                                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/1/thumbnails/800x800-f7d5a0d9df09422cd70ede1487d901a6.jpg&quot;,
                                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;,
                                &quot;count_pictures&quot;: 1,
                                &quot;price_label&quot;: &quot;Salary:&quot;,
                                &quot;price_formatted&quot;: &quot;$62&quot;,
                                &quot;visits_formatted&quot;: &quot;0 view&quot;,
                                &quot;distance_info&quot;: null,
                                &quot;picture&quot;: {
                                    &quot;id&quot;: 226,
                                    &quot;post_id&quot;: 81,
                                    &quot;file_path&quot;: &quot;files/us/81/58c66a1c9fdca43236490cc88e73e2cf.jpg&quot;,
                                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                    &quot;position&quot;: 1,
                                    &quot;active&quot;: 1,
                                    &quot;url&quot;: {
                                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/81/thumbnails/816x460-58c66a1c9fdca43236490cc88e73e2cf.jpg&quot;,
                                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/81/thumbnails/120x90-58c66a1c9fdca43236490cc88e73e2cf.jpg&quot;,
                                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/81/thumbnails/320x240-58c66a1c9fdca43236490cc88e73e2cf.jpg&quot;,
                                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/81/thumbnails/816x460-58c66a1c9fdca43236490cc88e73e2cf.jpg&quot;
                                    }
                                },
                                &quot;pictures&quot;: [
                                    {
                                        &quot;id&quot;: 226,
                                        &quot;post_id&quot;: 81,
                                        &quot;file_path&quot;: &quot;files/us/81/58c66a1c9fdca43236490cc88e73e2cf.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 1,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/81/thumbnails/816x460-58c66a1c9fdca43236490cc88e73e2cf.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/81/thumbnails/120x90-58c66a1c9fdca43236490cc88e73e2cf.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/81/thumbnails/320x240-58c66a1c9fdca43236490cc88e73e2cf.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/81/thumbnails/816x460-58c66a1c9fdca43236490cc88e73e2cf.jpg&quot;
                                        }
                                    }
                                ],
                                &quot;user&quot;: {
                                    &quot;id&quot;: 1,
                                    &quot;name&quot;: &quot;Administrator&quot;,
                                    &quot;username&quot;: &quot;adminak&quot;,
                                    &quot;two_factor_enabled&quot;: false,
                                    &quot;two_factor_method&quot;: &quot;email&quot;,
                                    &quot;updated_at&quot;: &quot;2025-09-08T09:29:18.000000Z&quot;,
                                    &quot;original_updated_at&quot;: &quot;2025-09-08 09:29:18&quot;,
                                    &quot;original_last_activity&quot;: &quot;2025-09-08 09:19:34&quot;,
                                    &quot;created_at_formatted&quot;: &quot;1 week ago&quot;,
                                    &quot;photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/1/thumbnails/800x800-f7d5a0d9df09422cd70ede1487d901a6.jpg&quot;,
                                    &quot;p_is_online&quot;: false,
                                    &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;
                                },
                                &quot;category&quot;: {
                                    &quot;id&quot;: 80,
                                    &quot;parent_id&quot;: 73,
                                    &quot;name&quot;: &quot;Accounting - Management - Finance&quot;,
                                    &quot;slug&quot;: &quot;accounting-management-finance&quot;,
                                    &quot;description&quot;: &quot;&quot;,
                                    &quot;hide_description&quot;: null,
                                    &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                    &quot;icon_class&quot;: &quot;bi bi-folder-fill&quot;,
                                    &quot;seo_title&quot;: &quot;&quot;,
                                    &quot;seo_description&quot;: &quot;&quot;,
                                    &quot;seo_keywords&quot;: &quot;&quot;,
                                    &quot;lft&quot;: 158,
                                    &quot;rgt&quot;: 159,
                                    &quot;depth&quot;: 1,
                                    &quot;type&quot;: &quot;job-offer&quot;,
                                    &quot;is_for_permanent&quot;: 0,
                                    &quot;active&quot;: 1,
                                    &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/jobs/accounting-management-finance&quot;,
                                    &quot;parent&quot;: {
                                        &quot;id&quot;: 73,
                                        &quot;parent_id&quot;: null,
                                        &quot;name&quot;: &quot;Jobs&quot;,
                                        &quot;slug&quot;: &quot;jobs&quot;,
                                        &quot;description&quot;: &quot;&quot;,
                                        &quot;hide_description&quot;: null,
                                        &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                        &quot;icon_class&quot;: &quot;fa-solid fa-briefcase&quot;,
                                        &quot;seo_title&quot;: &quot;&quot;,
                                        &quot;seo_description&quot;: &quot;&quot;,
                                        &quot;seo_keywords&quot;: &quot;&quot;,
                                        &quot;lft&quot;: 145,
                                        &quot;rgt&quot;: 192,
                                        &quot;depth&quot;: 0,
                                        &quot;type&quot;: &quot;job-offer&quot;,
                                        &quot;is_for_permanent&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                        &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/jobs&quot;,
                                        &quot;parent&quot;: null
                                    }
                                },
                                &quot;postType&quot;: {
                                    &quot;id&quot;: 2,
                                    &quot;name&quot;: &quot;PROFESSIONAL&quot;,
                                    &quot;label&quot;: &quot;Professional&quot;
                                },
                                &quot;city&quot;: {
                                    &quot;id&quot;: 47343,
                                    &quot;country_code&quot;: &quot;US&quot;,
                                    &quot;name&quot;: &quot;Iron Mountain&quot;,
                                    &quot;latitude&quot;: 45.82,
                                    &quot;longitude&quot;: -88.07,
                                    &quot;subadmin1_code&quot;: &quot;US.MI&quot;,
                                    &quot;subadmin2_code&quot;: &quot;US.MI.043&quot;,
                                    &quot;population&quot;: 7504,
                                    &quot;time_zone&quot;: &quot;America/Menominee&quot;,
                                    &quot;active&quot;: 1,
                                    &quot;slug&quot;: &quot;iron-mountain&quot;,
                                    &quot;posts_count&quot;: 0
                                },
                                &quot;payment&quot;: null,
                                &quot;rating_cache&quot;: 0,
                                &quot;rating_count&quot;: 0
                            },
                            {
                                &quot;id&quot;: 75,
                                &quot;country_code&quot;: &quot;US&quot;,
                                &quot;user_id&quot;: 1,
                                &quot;payment_id&quot;: null,
                                &quot;category_id&quot;: 11,
                                &quot;post_type_id&quot;: 2,
                                &quot;title&quot;: &quot;AirPods Pro&quot;,
                                &quot;description&quot;: &quot;Minus animi quis illo consequatur. Nulla ut facere earum ipsum autem veniam. Enim accusamus esse voluptatem sint. Atque autem autem eum ea.&quot;,
                                &quot;tags&quot;: [
                                    &quot;fuga&quot;,
                                    &quot;temporibus&quot;,
                                    &quot;sed&quot;
                                ],
                                &quot;price&quot;: &quot;1119.00&quot;,
                                &quot;currency_code&quot;: null,
                                &quot;negotiable&quot;: null,
                                &quot;contact_name&quot;: &quot;Administrator&quot;,
                                &quot;address&quot;: null,
                                &quot;city_id&quot;: 47391,
                                &quot;lat&quot;: null,
                                &quot;lon&quot;: null,
                                &quot;create_from_ip&quot;: null,
                                &quot;latest_update_ip&quot;: null,
                                &quot;visits&quot;: null,
                                &quot;auth_field&quot;: &quot;email&quot;,
                                &quot;email&quot;: &quot;mayeul@domain.tld&quot;,
                                &quot;phone&quot;: &quot;+18080288425&quot;,
                                &quot;phone_national&quot;: &quot;(808) 028-8425&quot;,
                                &quot;phone_country&quot;: &quot;US&quot;,
                                &quot;email_token&quot;: null,
                                &quot;phone_token&quot;: null,
                                &quot;email_verified_at&quot;: &quot;2025-09-07T21:27:35.000000Z&quot;,
                                &quot;phone_verified_at&quot;: &quot;2025-09-07T21:27:35.000000Z&quot;,
                                &quot;otp_expires_at&quot;: null,
                                &quot;last_otp_sent_at&quot;: null,
                                &quot;otp_resend_attempts&quot;: null,
                                &quot;otp_resend_attempts_expires_at&quot;: null,
                                &quot;total_otp_resend_attempts&quot;: null,
                                &quot;locked_at&quot;: null,
                                &quot;phone_hidden&quot;: null,
                                &quot;accept_terms&quot;: null,
                                &quot;accept_marketing_offers&quot;: null,
                                &quot;is_permanent&quot;: null,
                                &quot;featured&quot;: 1,
                                &quot;tmp_token&quot;: null,
                                &quot;reviewed_at&quot;: &quot;2025-09-07T21:27:35.000000Z&quot;,
                                &quot;archived_at&quot;: null,
                                &quot;archived_manually_at&quot;: null,
                                &quot;deletion_mail_sent_at&quot;: null,
                                &quot;created_at&quot;: &quot;2025-09-07T08:42:25.000000Z&quot;,
                                &quot;updated_at&quot;: &quot;2025-09-08T10:06:55.995805Z&quot;,
                                &quot;reference&quot;: &quot;kQBeXDWeyK8&quot;,
                                &quot;slug&quot;: &quot;airpods-pro&quot;,
                                &quot;url&quot;: &quot;https://demo.laraclassifier.local/airpods-pro/kQBeXDWeyK8&quot;,
                                &quot;excerpt&quot;: &quot;Minus animi quis illo consequatur. Nulla ut facere earum ipsum autem veniam. Enim accusamus esse vol...&quot;,
                                &quot;phone_intl&quot;: &quot;(808) 028-8425&quot;,
                                &quot;created_at_formatted&quot;: &quot;1 day ago&quot;,
                                &quot;updated_at_formatted&quot;: &quot;Sep 8th, 2025 at 06:06&quot;,
                                &quot;archived_at_formatted&quot;: &quot;&quot;,
                                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/1/thumbnails/800x800-f7d5a0d9df09422cd70ede1487d901a6.jpg&quot;,
                                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;,
                                &quot;count_pictures&quot;: 4,
                                &quot;price_label&quot;: &quot;Price:&quot;,
                                &quot;price_formatted&quot;: &quot;$1,119&quot;,
                                &quot;visits_formatted&quot;: &quot;0 view&quot;,
                                &quot;distance_info&quot;: null,
                                &quot;picture&quot;: {
                                    &quot;id&quot;: 211,
                                    &quot;post_id&quot;: 75,
                                    &quot;file_path&quot;: &quot;files/us/75/f48006f98e45e7f0ac582b46ab247f33.jpg&quot;,
                                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                    &quot;position&quot;: 2,
                                    &quot;active&quot;: 1,
                                    &quot;url&quot;: {
                                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/75/thumbnails/816x460-f48006f98e45e7f0ac582b46ab247f33.jpg&quot;,
                                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/75/thumbnails/120x90-f48006f98e45e7f0ac582b46ab247f33.jpg&quot;,
                                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/75/thumbnails/320x240-f48006f98e45e7f0ac582b46ab247f33.jpg&quot;,
                                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/75/thumbnails/816x460-f48006f98e45e7f0ac582b46ab247f33.jpg&quot;
                                    }
                                },
                                &quot;pictures&quot;: [
                                    {
                                        &quot;id&quot;: 211,
                                        &quot;post_id&quot;: 75,
                                        &quot;file_path&quot;: &quot;files/us/75/f48006f98e45e7f0ac582b46ab247f33.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 2,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/75/thumbnails/816x460-f48006f98e45e7f0ac582b46ab247f33.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/75/thumbnails/120x90-f48006f98e45e7f0ac582b46ab247f33.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/75/thumbnails/320x240-f48006f98e45e7f0ac582b46ab247f33.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/75/thumbnails/816x460-f48006f98e45e7f0ac582b46ab247f33.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 209,
                                        &quot;post_id&quot;: 75,
                                        &quot;file_path&quot;: &quot;files/us/75/e3c8fb6a97053e9ad8d54165f4989287.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 3,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 212,
                                        &quot;post_id&quot;: 75,
                                        &quot;file_path&quot;: &quot;files/us/75/7478832f0a5172e20571875f742e77ae.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 4,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 210,
                                        &quot;post_id&quot;: 75,
                                        &quot;file_path&quot;: &quot;files/us/75/399f357ba2bbca0dd6acb32e0ec298ae.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 4,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    }
                                ],
                                &quot;user&quot;: {
                                    &quot;id&quot;: 1,
                                    &quot;name&quot;: &quot;Administrator&quot;,
                                    &quot;username&quot;: &quot;adminak&quot;,
                                    &quot;two_factor_enabled&quot;: false,
                                    &quot;two_factor_method&quot;: &quot;email&quot;,
                                    &quot;updated_at&quot;: &quot;2025-09-08T09:29:18.000000Z&quot;,
                                    &quot;original_updated_at&quot;: &quot;2025-09-08 09:29:18&quot;,
                                    &quot;original_last_activity&quot;: &quot;2025-09-08 09:19:34&quot;,
                                    &quot;created_at_formatted&quot;: &quot;1 week ago&quot;,
                                    &quot;photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/1/thumbnails/800x800-f7d5a0d9df09422cd70ede1487d901a6.jpg&quot;,
                                    &quot;p_is_online&quot;: false,
                                    &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;
                                },
                                &quot;category&quot;: {
                                    &quot;id&quot;: 11,
                                    &quot;parent_id&quot;: 9,
                                    &quot;name&quot;: &quot;Accessories for Mobile Phones &amp; Tablets&quot;,
                                    &quot;slug&quot;: &quot;mobile-phones-tablets-accessories&quot;,
                                    &quot;description&quot;: &quot;&quot;,
                                    &quot;hide_description&quot;: null,
                                    &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                    &quot;icon_class&quot;: &quot;bi bi-folder-fill&quot;,
                                    &quot;seo_title&quot;: &quot;&quot;,
                                    &quot;seo_description&quot;: &quot;&quot;,
                                    &quot;seo_keywords&quot;: &quot;&quot;,
                                    &quot;lft&quot;: 20,
                                    &quot;rgt&quot;: 21,
                                    &quot;depth&quot;: 1,
                                    &quot;type&quot;: &quot;classified&quot;,
                                    &quot;is_for_permanent&quot;: 0,
                                    &quot;active&quot;: 1,
                                    &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/phones-and-tablets/mobile-phones-tablets-accessories&quot;,
                                    &quot;parent&quot;: {
                                        &quot;id&quot;: 9,
                                        &quot;parent_id&quot;: null,
                                        &quot;name&quot;: &quot;Phones &amp; Tablets&quot;,
                                        &quot;slug&quot;: &quot;phones-and-tablets&quot;,
                                        &quot;description&quot;: &quot;&quot;,
                                        &quot;hide_description&quot;: null,
                                        &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                        &quot;icon_class&quot;: &quot;fa-solid fa-mobile-screen-button&quot;,
                                        &quot;seo_title&quot;: &quot;&quot;,
                                        &quot;seo_description&quot;: &quot;&quot;,
                                        &quot;seo_keywords&quot;: &quot;&quot;,
                                        &quot;lft&quot;: 17,
                                        &quot;rgt&quot;: 26,
                                        &quot;depth&quot;: 0,
                                        &quot;type&quot;: &quot;classified&quot;,
                                        &quot;is_for_permanent&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                        &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/phones-and-tablets&quot;,
                                        &quot;parent&quot;: null
                                    }
                                },
                                &quot;postType&quot;: {
                                    &quot;id&quot;: 2,
                                    &quot;name&quot;: &quot;PROFESSIONAL&quot;,
                                    &quot;label&quot;: &quot;Professional&quot;
                                },
                                &quot;city&quot;: {
                                    &quot;id&quot;: 47391,
                                    &quot;country_code&quot;: &quot;US&quot;,
                                    &quot;name&quot;: &quot;River Rouge&quot;,
                                    &quot;latitude&quot;: 42.27,
                                    &quot;longitude&quot;: -83.13,
                                    &quot;subadmin1_code&quot;: &quot;US.MI&quot;,
                                    &quot;subadmin2_code&quot;: &quot;US.MI.163&quot;,
                                    &quot;population&quot;: 7546,
                                    &quot;time_zone&quot;: &quot;America/Detroit&quot;,
                                    &quot;active&quot;: 1,
                                    &quot;slug&quot;: &quot;river-rouge&quot;,
                                    &quot;posts_count&quot;: 0
                                },
                                &quot;payment&quot;: {
                                    &quot;id&quot;: 86,
                                    &quot;payable_id&quot;: 75,
                                    &quot;payable_type&quot;: &quot;App\\Models\\Post&quot;,
                                    &quot;package_id&quot;: 3,
                                    &quot;payment_method_id&quot;: 10,
                                    &quot;transaction_id&quot;: null,
                                    &quot;amount&quot;: &quot;9.00&quot;,
                                    &quot;currency_code&quot;: null,
                                    &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                                    &quot;period_end&quot;: &quot;2025-10-08T23:59:59.000000Z&quot;,
                                    &quot;canceled_at&quot;: null,
                                    &quot;refunded_at&quot;: null,
                                    &quot;active&quot;: 1,
                                    &quot;interval&quot;: 30.999988425925928,
                                    &quot;started&quot;: 1,
                                    &quot;expired&quot;: 0,
                                    &quot;status&quot;: &quot;valid&quot;,
                                    &quot;period_start_formatted&quot;: &quot;Sep 7th, 2025&quot;,
                                    &quot;period_end_formatted&quot;: &quot;Oct 8th, 2025&quot;,
                                    &quot;created_at_formatted&quot;: &quot;Sep 8th, 2025 at 04:46&quot;,
                                    &quot;status_info&quot;: &quot;Valid&quot;,
                                    &quot;starting_info&quot;: &quot;Started on Sep 7th, 2025&quot;,
                                    &quot;expiry_info&quot;: &quot;Will expire on Oct 8th, 2025&quot;,
                                    &quot;css_class_variant&quot;: &quot;success&quot;,
                                    &quot;package&quot;: {
                                        &quot;id&quot;: 3,
                                        &quot;type&quot;: &quot;promotion&quot;,
                                        &quot;name&quot;: &quot;Premium Listing (+)&quot;,
                                        &quot;short_name&quot;: &quot;Premium+&quot;,
                                        &quot;ribbon&quot;: &quot;success&quot;,
                                        &quot;has_badge&quot;: 1,
                                        &quot;price&quot;: &quot;9.00&quot;,
                                        &quot;currency_code&quot;: &quot;USD&quot;,
                                        &quot;promotion_time&quot;: 30,
                                        &quot;interval&quot;: null,
                                        &quot;listings_limit&quot;: null,
                                        &quot;pictures_limit&quot;: 15,
                                        &quot;expiration_time&quot;: 120,
                                        &quot;description&quot;: &quot;Featured on the homepage\nFeatured in the category&quot;,
                                        &quot;facebook_ads_duration&quot;: 0,
                                        &quot;google_ads_duration&quot;: 0,
                                        &quot;twitter_ads_duration&quot;: 0,
                                        &quot;linkedin_ads_duration&quot;: 0,
                                        &quot;recommended&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;parent_id&quot;: null,
                                        &quot;lft&quot;: 5,
                                        &quot;rgt&quot;: 6,
                                        &quot;depth&quot;: 0,
                                        &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                                        &quot;period_end&quot;: &quot;2025-10-08T23:59:59.999999Z&quot;,
                                        &quot;description_array&quot;: [
                                            &quot;30 days of promotion&quot;,
                                            &quot;Up to 15 images allowed&quot;,
                                            &quot;Featured on the homepage&quot;,
                                            &quot;Featured in the category&quot;,
                                            &quot;Keep online for 120 days&quot;
                                        ],
                                        &quot;description_string&quot;: &quot;30 days of promotion. \nUp to 15 images allowed. \nFeatured on the homepage. \nFeatured in the category. \nKeep online for 120 days&quot;,
                                        &quot;price_formatted&quot;: &quot;$9&quot;
                                    }
                                },
                                &quot;rating_cache&quot;: 0,
                                &quot;rating_count&quot;: 0
                            },
                            {
                                &quot;id&quot;: 59,
                                &quot;country_code&quot;: &quot;US&quot;,
                                &quot;user_id&quot;: 1,
                                &quot;payment_id&quot;: null,
                                &quot;category_id&quot;: 86,
                                &quot;post_type_id&quot;: 1,
                                &quot;title&quot;: &quot;Digital Marketing Manager 4 years of experience&quot;,
                                &quot;description&quot;: &quot;Quis dolor earum quas non voluptatibus enim commodi. Ex pariatur ea reiciendis iste consequuntur sapiente qui enim. Ipsum libero ratione asperiores voluptas. Ex quisquam voluptatibus ullam quia.&quot;,
                                &quot;tags&quot;: [
                                    &quot;assumenda&quot;,
                                    &quot;quo&quot;,
                                    &quot;veniam&quot;
                                ],
                                &quot;price&quot;: &quot;90.00&quot;,
                                &quot;currency_code&quot;: null,
                                &quot;negotiable&quot;: null,
                                &quot;contact_name&quot;: &quot;Administrator&quot;,
                                &quot;address&quot;: null,
                                &quot;city_id&quot;: 45887,
                                &quot;lat&quot;: null,
                                &quot;lon&quot;: null,
                                &quot;create_from_ip&quot;: null,
                                &quot;latest_update_ip&quot;: null,
                                &quot;visits&quot;: null,
                                &quot;auth_field&quot;: &quot;email&quot;,
                                &quot;email&quot;: &quot;mayeul@domain.tld&quot;,
                                &quot;phone&quot;: &quot;+17896903070&quot;,
                                &quot;phone_national&quot;: &quot;(789) 690-3070&quot;,
                                &quot;phone_country&quot;: &quot;US&quot;,
                                &quot;email_token&quot;: null,
                                &quot;phone_token&quot;: null,
                                &quot;email_verified_at&quot;: &quot;2025-09-07T17:56:07.000000Z&quot;,
                                &quot;phone_verified_at&quot;: &quot;2025-09-07T17:56:07.000000Z&quot;,
                                &quot;otp_expires_at&quot;: null,
                                &quot;last_otp_sent_at&quot;: null,
                                &quot;otp_resend_attempts&quot;: null,
                                &quot;otp_resend_attempts_expires_at&quot;: null,
                                &quot;total_otp_resend_attempts&quot;: null,
                                &quot;locked_at&quot;: null,
                                &quot;phone_hidden&quot;: null,
                                &quot;accept_terms&quot;: null,
                                &quot;accept_marketing_offers&quot;: null,
                                &quot;is_permanent&quot;: null,
                                &quot;featured&quot;: 1,
                                &quot;tmp_token&quot;: null,
                                &quot;reviewed_at&quot;: &quot;2025-09-07T17:56:07.000000Z&quot;,
                                &quot;archived_at&quot;: null,
                                &quot;archived_manually_at&quot;: null,
                                &quot;deletion_mail_sent_at&quot;: null,
                                &quot;created_at&quot;: &quot;2025-09-07T06:36:35.000000Z&quot;,
                                &quot;updated_at&quot;: &quot;2025-09-08T10:06:56.196760Z&quot;,
                                &quot;reference&quot;: &quot;4w9aADOevMR&quot;,
                                &quot;slug&quot;: &quot;digital-marketing-manager-4-years-of-experience&quot;,
                                &quot;url&quot;: &quot;https://demo.laraclassifier.local/digital-marketing-manager-4-years-of-experience/4w9aADOevMR&quot;,
                                &quot;excerpt&quot;: &quot;Quis dolor earum quas non voluptatibus enim commodi. Ex pariatur ea reiciendis iste consequuntur sap...&quot;,
                                &quot;phone_intl&quot;: &quot;(789) 690-3070&quot;,
                                &quot;created_at_formatted&quot;: &quot;1 day ago&quot;,
                                &quot;updated_at_formatted&quot;: &quot;Sep 8th, 2025 at 06:06&quot;,
                                &quot;archived_at_formatted&quot;: &quot;&quot;,
                                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/1/thumbnails/800x800-f7d5a0d9df09422cd70ede1487d901a6.jpg&quot;,
                                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;,
                                &quot;count_pictures&quot;: 2,
                                &quot;price_label&quot;: &quot;Salary:&quot;,
                                &quot;price_formatted&quot;: &quot;$90&quot;,
                                &quot;visits_formatted&quot;: &quot;0 view&quot;,
                                &quot;distance_info&quot;: null,
                                &quot;picture&quot;: {
                                    &quot;id&quot;: 173,
                                    &quot;post_id&quot;: 59,
                                    &quot;file_path&quot;: &quot;files/us/59/3d1d14f9d50cbf9ab36755560599f19c.jpg&quot;,
                                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                    &quot;position&quot;: 1,
                                    &quot;active&quot;: 1,
                                    &quot;url&quot;: {
                                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/59/thumbnails/816x460-3d1d14f9d50cbf9ab36755560599f19c.jpg&quot;,
                                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/59/thumbnails/120x90-3d1d14f9d50cbf9ab36755560599f19c.jpg&quot;,
                                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/59/thumbnails/320x240-3d1d14f9d50cbf9ab36755560599f19c.jpg&quot;,
                                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/59/thumbnails/816x460-3d1d14f9d50cbf9ab36755560599f19c.jpg&quot;
                                    }
                                },
                                &quot;pictures&quot;: [
                                    {
                                        &quot;id&quot;: 173,
                                        &quot;post_id&quot;: 59,
                                        &quot;file_path&quot;: &quot;files/us/59/3d1d14f9d50cbf9ab36755560599f19c.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 1,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/59/thumbnails/816x460-3d1d14f9d50cbf9ab36755560599f19c.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/59/thumbnails/120x90-3d1d14f9d50cbf9ab36755560599f19c.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/59/thumbnails/320x240-3d1d14f9d50cbf9ab36755560599f19c.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/59/thumbnails/816x460-3d1d14f9d50cbf9ab36755560599f19c.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 172,
                                        &quot;post_id&quot;: 59,
                                        &quot;file_path&quot;: &quot;files/us/59/2392247f3358b47075793e6e127f70aa.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 1,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    }
                                ],
                                &quot;user&quot;: {
                                    &quot;id&quot;: 1,
                                    &quot;name&quot;: &quot;Administrator&quot;,
                                    &quot;username&quot;: &quot;adminak&quot;,
                                    &quot;two_factor_enabled&quot;: false,
                                    &quot;two_factor_method&quot;: &quot;email&quot;,
                                    &quot;updated_at&quot;: &quot;2025-09-08T09:29:18.000000Z&quot;,
                                    &quot;original_updated_at&quot;: &quot;2025-09-08 09:29:18&quot;,
                                    &quot;original_last_activity&quot;: &quot;2025-09-08 09:19:34&quot;,
                                    &quot;created_at_formatted&quot;: &quot;1 week ago&quot;,
                                    &quot;photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/1/thumbnails/800x800-f7d5a0d9df09422cd70ede1487d901a6.jpg&quot;,
                                    &quot;p_is_online&quot;: false,
                                    &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;
                                },
                                &quot;category&quot;: {
                                    &quot;id&quot;: 86,
                                    &quot;parent_id&quot;: 73,
                                    &quot;name&quot;: &quot;Computers - Internet - Telecommunications&quot;,
                                    &quot;slug&quot;: &quot;computers-internet-telecommunications&quot;,
                                    &quot;description&quot;: &quot;&quot;,
                                    &quot;hide_description&quot;: null,
                                    &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                    &quot;icon_class&quot;: &quot;bi bi-folder-fill&quot;,
                                    &quot;seo_title&quot;: &quot;&quot;,
                                    &quot;seo_description&quot;: &quot;&quot;,
                                    &quot;seo_keywords&quot;: &quot;&quot;,
                                    &quot;lft&quot;: 170,
                                    &quot;rgt&quot;: 171,
                                    &quot;depth&quot;: 1,
                                    &quot;type&quot;: &quot;job-offer&quot;,
                                    &quot;is_for_permanent&quot;: 0,
                                    &quot;active&quot;: 1,
                                    &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/jobs/computers-internet-telecommunications&quot;,
                                    &quot;parent&quot;: {
                                        &quot;id&quot;: 73,
                                        &quot;parent_id&quot;: null,
                                        &quot;name&quot;: &quot;Jobs&quot;,
                                        &quot;slug&quot;: &quot;jobs&quot;,
                                        &quot;description&quot;: &quot;&quot;,
                                        &quot;hide_description&quot;: null,
                                        &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                        &quot;icon_class&quot;: &quot;fa-solid fa-briefcase&quot;,
                                        &quot;seo_title&quot;: &quot;&quot;,
                                        &quot;seo_description&quot;: &quot;&quot;,
                                        &quot;seo_keywords&quot;: &quot;&quot;,
                                        &quot;lft&quot;: 145,
                                        &quot;rgt&quot;: 192,
                                        &quot;depth&quot;: 0,
                                        &quot;type&quot;: &quot;job-offer&quot;,
                                        &quot;is_for_permanent&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                        &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/jobs&quot;,
                                        &quot;parent&quot;: null
                                    }
                                },
                                &quot;postType&quot;: {
                                    &quot;id&quot;: 1,
                                    &quot;name&quot;: &quot;INDIVIDUAL&quot;,
                                    &quot;label&quot;: &quot;Individual&quot;
                                },
                                &quot;city&quot;: {
                                    &quot;id&quot;: 45887,
                                    &quot;country_code&quot;: &quot;US&quot;,
                                    &quot;name&quot;: &quot;Bedford&quot;,
                                    &quot;latitude&quot;: 32.84,
                                    &quot;longitude&quot;: -97.14,
                                    &quot;subadmin1_code&quot;: &quot;US.TX&quot;,
                                    &quot;subadmin2_code&quot;: &quot;US.TX.439&quot;,
                                    &quot;population&quot;: 49337,
                                    &quot;time_zone&quot;: &quot;America/Chicago&quot;,
                                    &quot;active&quot;: 1,
                                    &quot;slug&quot;: &quot;bedford&quot;,
                                    &quot;posts_count&quot;: 0
                                },
                                &quot;payment&quot;: null,
                                &quot;rating_cache&quot;: 0,
                                &quot;rating_count&quot;: 0
                            },
                            {
                                &quot;id&quot;: 45,
                                &quot;country_code&quot;: &quot;US&quot;,
                                &quot;user_id&quot;: 1,
                                &quot;payment_id&quot;: null,
                                &quot;category_id&quot;: 85,
                                &quot;post_type_id&quot;: 2,
                                &quot;title&quot;: &quot;New Interior Designer&quot;,
                                &quot;description&quot;: &quot;Quidem autem impedit reprehenderit aut possimus eos. Et laboriosam asperiores eaque. Quis omnis omnis velit dolorem dolor unde. Sit non molestiae odit aut ut. Corporis fuga laudantium perspiciatis nesciunt et aliquam. Ex magnam eaque ratione et dolorem veritatis. Culpa repudiandae veritatis facilis ex. Dicta nesciunt ratione qui voluptas. Amet alias et eum cum quam quos nihil. Non dolores suscipit autem voluptates sed nobis.&quot;,
                                &quot;tags&quot;: [
                                    &quot;eos&quot;,
                                    &quot;ut&quot;,
                                    &quot;voluptas&quot;
                                ],
                                &quot;price&quot;: &quot;956.00&quot;,
                                &quot;currency_code&quot;: null,
                                &quot;negotiable&quot;: null,
                                &quot;contact_name&quot;: &quot;Administrator&quot;,
                                &quot;address&quot;: null,
                                &quot;city_id&quot;: 48291,
                                &quot;lat&quot;: null,
                                &quot;lon&quot;: null,
                                &quot;create_from_ip&quot;: null,
                                &quot;latest_update_ip&quot;: null,
                                &quot;visits&quot;: null,
                                &quot;auth_field&quot;: &quot;email&quot;,
                                &quot;email&quot;: &quot;mayeul@domain.tld&quot;,
                                &quot;phone&quot;: &quot;+11339827214&quot;,
                                &quot;phone_national&quot;: &quot;1339827214&quot;,
                                &quot;phone_country&quot;: &quot;US&quot;,
                                &quot;email_token&quot;: null,
                                &quot;phone_token&quot;: null,
                                &quot;email_verified_at&quot;: &quot;2025-09-07T23:41:58.000000Z&quot;,
                                &quot;phone_verified_at&quot;: &quot;2025-09-07T23:41:58.000000Z&quot;,
                                &quot;otp_expires_at&quot;: null,
                                &quot;last_otp_sent_at&quot;: null,
                                &quot;otp_resend_attempts&quot;: null,
                                &quot;otp_resend_attempts_expires_at&quot;: null,
                                &quot;total_otp_resend_attempts&quot;: null,
                                &quot;locked_at&quot;: null,
                                &quot;phone_hidden&quot;: null,
                                &quot;accept_terms&quot;: null,
                                &quot;accept_marketing_offers&quot;: null,
                                &quot;is_permanent&quot;: null,
                                &quot;featured&quot;: 0,
                                &quot;tmp_token&quot;: null,
                                &quot;reviewed_at&quot;: &quot;2025-09-07T23:41:58.000000Z&quot;,
                                &quot;archived_at&quot;: null,
                                &quot;archived_manually_at&quot;: null,
                                &quot;deletion_mail_sent_at&quot;: null,
                                &quot;created_at&quot;: &quot;2025-09-07T00:21:56.000000Z&quot;,
                                &quot;updated_at&quot;: &quot;2025-09-08T10:06:56.398358Z&quot;,
                                &quot;reference&quot;: &quot;VolejRRejNm&quot;,
                                &quot;slug&quot;: &quot;new-interior-designer&quot;,
                                &quot;url&quot;: &quot;https://demo.laraclassifier.local/new-interior-designer/VolejRRejNm&quot;,
                                &quot;excerpt&quot;: &quot;Quidem autem impedit reprehenderit aut possimus eos. Et laboriosam asperiores eaque. Quis omnis omni...&quot;,
                                &quot;phone_intl&quot;: &quot;1339827214&quot;,
                                &quot;created_at_formatted&quot;: &quot;1 day ago&quot;,
                                &quot;updated_at_formatted&quot;: &quot;Sep 8th, 2025 at 06:06&quot;,
                                &quot;archived_at_formatted&quot;: &quot;&quot;,
                                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/1/thumbnails/800x800-f7d5a0d9df09422cd70ede1487d901a6.jpg&quot;,
                                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;,
                                &quot;count_pictures&quot;: 4,
                                &quot;price_label&quot;: &quot;Salary:&quot;,
                                &quot;price_formatted&quot;: &quot;$956&quot;,
                                &quot;visits_formatted&quot;: &quot;0 view&quot;,
                                &quot;distance_info&quot;: null,
                                &quot;picture&quot;: {
                                    &quot;id&quot;: 135,
                                    &quot;post_id&quot;: 45,
                                    &quot;file_path&quot;: &quot;files/us/45/99a90eb310249629b5d71b99a62db41c.jpg&quot;,
                                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                    &quot;position&quot;: 2,
                                    &quot;active&quot;: 1,
                                    &quot;url&quot;: {
                                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/45/thumbnails/816x460-99a90eb310249629b5d71b99a62db41c.jpg&quot;,
                                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/45/thumbnails/120x90-99a90eb310249629b5d71b99a62db41c.jpg&quot;,
                                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/45/thumbnails/320x240-99a90eb310249629b5d71b99a62db41c.jpg&quot;,
                                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/45/thumbnails/816x460-99a90eb310249629b5d71b99a62db41c.jpg&quot;
                                    }
                                },
                                &quot;pictures&quot;: [
                                    {
                                        &quot;id&quot;: 135,
                                        &quot;post_id&quot;: 45,
                                        &quot;file_path&quot;: &quot;files/us/45/99a90eb310249629b5d71b99a62db41c.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 2,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/45/thumbnails/816x460-99a90eb310249629b5d71b99a62db41c.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/45/thumbnails/120x90-99a90eb310249629b5d71b99a62db41c.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/45/thumbnails/320x240-99a90eb310249629b5d71b99a62db41c.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/45/thumbnails/816x460-99a90eb310249629b5d71b99a62db41c.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 134,
                                        &quot;post_id&quot;: 45,
                                        &quot;file_path&quot;: &quot;files/us/45/8281a6a4fb5903704e4cd7b6bb83d7a6.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 3,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 133,
                                        &quot;post_id&quot;: 45,
                                        &quot;file_path&quot;: &quot;files/us/45/495925f73829553e711da155d1f25b18.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 3,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 132,
                                        &quot;post_id&quot;: 45,
                                        &quot;file_path&quot;: &quot;files/us/45/7d5811a2935cc24b6fdbf954ff493369.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 3,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    }
                                ],
                                &quot;user&quot;: {
                                    &quot;id&quot;: 1,
                                    &quot;name&quot;: &quot;Administrator&quot;,
                                    &quot;username&quot;: &quot;adminak&quot;,
                                    &quot;two_factor_enabled&quot;: false,
                                    &quot;two_factor_method&quot;: &quot;email&quot;,
                                    &quot;updated_at&quot;: &quot;2025-09-08T09:29:18.000000Z&quot;,
                                    &quot;original_updated_at&quot;: &quot;2025-09-08 09:29:18&quot;,
                                    &quot;original_last_activity&quot;: &quot;2025-09-08 09:19:34&quot;,
                                    &quot;created_at_formatted&quot;: &quot;1 week ago&quot;,
                                    &quot;photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/1/thumbnails/800x800-f7d5a0d9df09422cd70ede1487d901a6.jpg&quot;,
                                    &quot;p_is_online&quot;: false,
                                    &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;
                                },
                                &quot;category&quot;: {
                                    &quot;id&quot;: 85,
                                    &quot;parent_id&quot;: 73,
                                    &quot;name&quot;: &quot;Independent - Freelance - Telecommuting&quot;,
                                    &quot;slug&quot;: &quot;independent-freelance-telecommuting&quot;,
                                    &quot;description&quot;: &quot;&quot;,
                                    &quot;hide_description&quot;: null,
                                    &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                    &quot;icon_class&quot;: &quot;bi bi-folder-fill&quot;,
                                    &quot;seo_title&quot;: &quot;&quot;,
                                    &quot;seo_description&quot;: &quot;&quot;,
                                    &quot;seo_keywords&quot;: &quot;&quot;,
                                    &quot;lft&quot;: 168,
                                    &quot;rgt&quot;: 169,
                                    &quot;depth&quot;: 1,
                                    &quot;type&quot;: &quot;job-offer&quot;,
                                    &quot;is_for_permanent&quot;: 0,
                                    &quot;active&quot;: 1,
                                    &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/jobs/independent-freelance-telecommuting&quot;,
                                    &quot;parent&quot;: {
                                        &quot;id&quot;: 73,
                                        &quot;parent_id&quot;: null,
                                        &quot;name&quot;: &quot;Jobs&quot;,
                                        &quot;slug&quot;: &quot;jobs&quot;,
                                        &quot;description&quot;: &quot;&quot;,
                                        &quot;hide_description&quot;: null,
                                        &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                        &quot;icon_class&quot;: &quot;fa-solid fa-briefcase&quot;,
                                        &quot;seo_title&quot;: &quot;&quot;,
                                        &quot;seo_description&quot;: &quot;&quot;,
                                        &quot;seo_keywords&quot;: &quot;&quot;,
                                        &quot;lft&quot;: 145,
                                        &quot;rgt&quot;: 192,
                                        &quot;depth&quot;: 0,
                                        &quot;type&quot;: &quot;job-offer&quot;,
                                        &quot;is_for_permanent&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                        &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/jobs&quot;,
                                        &quot;parent&quot;: null
                                    }
                                },
                                &quot;postType&quot;: {
                                    &quot;id&quot;: 2,
                                    &quot;name&quot;: &quot;PROFESSIONAL&quot;,
                                    &quot;label&quot;: &quot;Professional&quot;
                                },
                                &quot;city&quot;: {
                                    &quot;id&quot;: 48291,
                                    &quot;country_code&quot;: &quot;US&quot;,
                                    &quot;name&quot;: &quot;Richmond Hill&quot;,
                                    &quot;latitude&quot;: 40.7,
                                    &quot;longitude&quot;: -73.83,
                                    &quot;subadmin1_code&quot;: &quot;US.NY&quot;,
                                    &quot;subadmin2_code&quot;: &quot;US.NY.081&quot;,
                                    &quot;population&quot;: 98984,
                                    &quot;time_zone&quot;: &quot;America/New_York&quot;,
                                    &quot;active&quot;: 1,
                                    &quot;slug&quot;: &quot;richmond-hill&quot;,
                                    &quot;posts_count&quot;: 0
                                },
                                &quot;payment&quot;: null,
                                &quot;rating_cache&quot;: 0,
                                &quot;rating_count&quot;: 0
                            },
                            {
                                &quot;id&quot;: 57,
                                &quot;country_code&quot;: &quot;US&quot;,
                                &quot;user_id&quot;: 1,
                                &quot;payment_id&quot;: null,
                                &quot;category_id&quot;: 15,
                                &quot;post_type_id&quot;: 2,
                                &quot;title&quot;: &quot;Apple HDMI to DVI Adapter silver&quot;,
                                &quot;description&quot;: &quot;Earum eaque amet est nulla qui voluptatibus. Autem reprehenderit velit quibusdam aut. Perferendis adipisci in et et voluptatibus aut. Et cumque est sequi rerum autem. In rerum harum ut explicabo provident. Eum animi qui praesentium nostrum veniam ad. Dignissimos expedita id sit autem sint ut qui.&quot;,
                                &quot;tags&quot;: [
                                    &quot;maiores&quot;,
                                    &quot;molestiae&quot;,
                                    &quot;illo&quot;
                                ],
                                &quot;price&quot;: &quot;25.00&quot;,
                                &quot;currency_code&quot;: null,
                                &quot;negotiable&quot;: null,
                                &quot;contact_name&quot;: &quot;Administrator&quot;,
                                &quot;address&quot;: null,
                                &quot;city_id&quot;: 48911,
                                &quot;lat&quot;: null,
                                &quot;lon&quot;: null,
                                &quot;create_from_ip&quot;: null,
                                &quot;latest_update_ip&quot;: null,
                                &quot;visits&quot;: null,
                                &quot;auth_field&quot;: &quot;email&quot;,
                                &quot;email&quot;: &quot;mayeul@domain.tld&quot;,
                                &quot;phone&quot;: &quot;+19392357756&quot;,
                                &quot;phone_national&quot;: &quot;(939) 235-7756&quot;,
                                &quot;phone_country&quot;: &quot;US&quot;,
                                &quot;email_token&quot;: null,
                                &quot;phone_token&quot;: null,
                                &quot;email_verified_at&quot;: &quot;2025-09-07T04:07:04.000000Z&quot;,
                                &quot;phone_verified_at&quot;: &quot;2025-09-07T04:07:04.000000Z&quot;,
                                &quot;otp_expires_at&quot;: null,
                                &quot;last_otp_sent_at&quot;: null,
                                &quot;otp_resend_attempts&quot;: null,
                                &quot;otp_resend_attempts_expires_at&quot;: null,
                                &quot;total_otp_resend_attempts&quot;: null,
                                &quot;locked_at&quot;: null,
                                &quot;phone_hidden&quot;: null,
                                &quot;accept_terms&quot;: null,
                                &quot;accept_marketing_offers&quot;: null,
                                &quot;is_permanent&quot;: null,
                                &quot;featured&quot;: 0,
                                &quot;tmp_token&quot;: null,
                                &quot;reviewed_at&quot;: &quot;2025-09-07T04:07:04.000000Z&quot;,
                                &quot;archived_at&quot;: null,
                                &quot;archived_manually_at&quot;: null,
                                &quot;deletion_mail_sent_at&quot;: null,
                                &quot;created_at&quot;: &quot;2025-09-07T00:06:59.000000Z&quot;,
                                &quot;updated_at&quot;: &quot;2025-09-08T10:06:56.612300Z&quot;,
                                &quot;reference&quot;: &quot;kzPdyP7bQro&quot;,
                                &quot;slug&quot;: &quot;apple-hdmi-to-dvi-adapter-silver&quot;,
                                &quot;url&quot;: &quot;https://demo.laraclassifier.local/apple-hdmi-to-dvi-adapter-silver/kzPdyP7bQro&quot;,
                                &quot;excerpt&quot;: &quot;Earum eaque amet est nulla qui voluptatibus. Autem reprehenderit velit quibusdam aut. Perferendis ad...&quot;,
                                &quot;phone_intl&quot;: &quot;(939) 235-7756&quot;,
                                &quot;created_at_formatted&quot;: &quot;1 day ago&quot;,
                                &quot;updated_at_formatted&quot;: &quot;Sep 8th, 2025 at 06:06&quot;,
                                &quot;archived_at_formatted&quot;: &quot;&quot;,
                                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/1/thumbnails/800x800-f7d5a0d9df09422cd70ede1487d901a6.jpg&quot;,
                                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;,
                                &quot;count_pictures&quot;: 2,
                                &quot;price_label&quot;: &quot;Price:&quot;,
                                &quot;price_formatted&quot;: &quot;$25&quot;,
                                &quot;visits_formatted&quot;: &quot;0 view&quot;,
                                &quot;distance_info&quot;: null,
                                &quot;picture&quot;: {
                                    &quot;id&quot;: 169,
                                    &quot;post_id&quot;: 57,
                                    &quot;file_path&quot;: &quot;files/us/57/d971612ddc0bd24f176dbda591eedb21.jpg&quot;,
                                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                    &quot;position&quot;: 1,
                                    &quot;active&quot;: 1,
                                    &quot;url&quot;: {
                                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/57/thumbnails/816x460-d971612ddc0bd24f176dbda591eedb21.jpg&quot;,
                                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/57/thumbnails/120x90-d971612ddc0bd24f176dbda591eedb21.jpg&quot;,
                                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/57/thumbnails/320x240-d971612ddc0bd24f176dbda591eedb21.jpg&quot;,
                                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/57/thumbnails/816x460-d971612ddc0bd24f176dbda591eedb21.jpg&quot;
                                    }
                                },
                                &quot;pictures&quot;: [
                                    {
                                        &quot;id&quot;: 169,
                                        &quot;post_id&quot;: 57,
                                        &quot;file_path&quot;: &quot;files/us/57/d971612ddc0bd24f176dbda591eedb21.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 1,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/57/thumbnails/816x460-d971612ddc0bd24f176dbda591eedb21.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/57/thumbnails/120x90-d971612ddc0bd24f176dbda591eedb21.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/57/thumbnails/320x240-d971612ddc0bd24f176dbda591eedb21.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/57/thumbnails/816x460-d971612ddc0bd24f176dbda591eedb21.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 170,
                                        &quot;post_id&quot;: 57,
                                        &quot;file_path&quot;: &quot;files/us/57/7949922594556334a46b357ee0fd7b8d.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 2,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    }
                                ],
                                &quot;user&quot;: {
                                    &quot;id&quot;: 1,
                                    &quot;name&quot;: &quot;Administrator&quot;,
                                    &quot;username&quot;: &quot;adminak&quot;,
                                    &quot;two_factor_enabled&quot;: false,
                                    &quot;two_factor_method&quot;: &quot;email&quot;,
                                    &quot;updated_at&quot;: &quot;2025-09-08T09:29:18.000000Z&quot;,
                                    &quot;original_updated_at&quot;: &quot;2025-09-08 09:29:18&quot;,
                                    &quot;original_last_activity&quot;: &quot;2025-09-08 09:19:34&quot;,
                                    &quot;created_at_formatted&quot;: &quot;1 week ago&quot;,
                                    &quot;photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/1/thumbnails/800x800-f7d5a0d9df09422cd70ede1487d901a6.jpg&quot;,
                                    &quot;p_is_online&quot;: false,
                                    &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;
                                },
                                &quot;category&quot;: {
                                    &quot;id&quot;: 15,
                                    &quot;parent_id&quot;: 14,
                                    &quot;name&quot;: &quot;Accessories &amp; Supplies for Electronics&quot;,
                                    &quot;slug&quot;: &quot;accessories-supplies-for-electronics&quot;,
                                    &quot;description&quot;: &quot;&quot;,
                                    &quot;hide_description&quot;: null,
                                    &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                    &quot;icon_class&quot;: &quot;bi bi-folder-fill&quot;,
                                    &quot;seo_title&quot;: &quot;&quot;,
                                    &quot;seo_description&quot;: &quot;&quot;,
                                    &quot;seo_keywords&quot;: &quot;&quot;,
                                    &quot;lft&quot;: 28,
                                    &quot;rgt&quot;: 29,
                                    &quot;depth&quot;: 1,
                                    &quot;type&quot;: &quot;classified&quot;,
                                    &quot;is_for_permanent&quot;: 0,
                                    &quot;active&quot;: 1,
                                    &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/electronics/accessories-supplies-for-electronics&quot;,
                                    &quot;parent&quot;: {
                                        &quot;id&quot;: 14,
                                        &quot;parent_id&quot;: null,
                                        &quot;name&quot;: &quot;Electronics&quot;,
                                        &quot;slug&quot;: &quot;electronics&quot;,
                                        &quot;description&quot;: &quot;&quot;,
                                        &quot;hide_description&quot;: null,
                                        &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                        &quot;icon_class&quot;: &quot;fa-solid fa-laptop&quot;,
                                        &quot;seo_title&quot;: &quot;&quot;,
                                        &quot;seo_description&quot;: &quot;&quot;,
                                        &quot;seo_keywords&quot;: &quot;&quot;,
                                        &quot;lft&quot;: 27,
                                        &quot;rgt&quot;: 58,
                                        &quot;depth&quot;: 0,
                                        &quot;type&quot;: &quot;classified&quot;,
                                        &quot;is_for_permanent&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                        &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/electronics&quot;,
                                        &quot;parent&quot;: null
                                    }
                                },
                                &quot;postType&quot;: {
                                    &quot;id&quot;: 2,
                                    &quot;name&quot;: &quot;PROFESSIONAL&quot;,
                                    &quot;label&quot;: &quot;Professional&quot;
                                },
                                &quot;city&quot;: {
                                    &quot;id&quot;: 48911,
                                    &quot;country_code&quot;: &quot;US&quot;,
                                    &quot;name&quot;: &quot;Delafield&quot;,
                                    &quot;latitude&quot;: 43.06,
                                    &quot;longitude&quot;: -88.4,
                                    &quot;subadmin1_code&quot;: &quot;US.WI&quot;,
                                    &quot;subadmin2_code&quot;: &quot;US.WI.133&quot;,
                                    &quot;population&quot;: 7180,
                                    &quot;time_zone&quot;: &quot;America/Chicago&quot;,
                                    &quot;active&quot;: 1,
                                    &quot;slug&quot;: &quot;delafield&quot;,
                                    &quot;posts_count&quot;: 0
                                },
                                &quot;payment&quot;: null,
                                &quot;rating_cache&quot;: 0,
                                &quot;rating_count&quot;: 0
                            },
                            {
                                &quot;id&quot;: 9197,
                                &quot;country_code&quot;: &quot;US&quot;,
                                &quot;user_id&quot;: 2164,
                                &quot;payment_id&quot;: null,
                                &quot;category_id&quot;: 3,
                                &quot;post_type_id&quot;: 1,
                                &quot;title&quot;: &quot;Jeep Grand Cherokee 2022&quot;,
                                &quot;description&quot;: &quot;Accusamus occaecati voluptates sunt voluptatibus aut modi nulla illum. Sint nostrum omnis error fuga magni nisi. Fugiat maiores aut doloribus at in itaque. Tenetur accusamus rerum porro ab. Dolore omnis qui eum qui qui. Facilis perferendis voluptatem dolor rerum. Culpa quibusdam adipisci non voluptas dolores sunt numquam.&quot;,
                                &quot;tags&quot;: [
                                    &quot;distinctio&quot;,
                                    &quot;rerum&quot;,
                                    &quot;possimus&quot;
                                ],
                                &quot;price&quot;: &quot;355.00&quot;,
                                &quot;currency_code&quot;: null,
                                &quot;negotiable&quot;: null,
                                &quot;contact_name&quot;: &quot;Zora Ebert&quot;,
                                &quot;address&quot;: null,
                                &quot;city_id&quot;: 47891,
                                &quot;lat&quot;: null,
                                &quot;lon&quot;: null,
                                &quot;create_from_ip&quot;: null,
                                &quot;latest_update_ip&quot;: null,
                                &quot;visits&quot;: null,
                                &quot;auth_field&quot;: &quot;email&quot;,
                                &quot;email&quot;: &quot;pcasper@hotmail.com&quot;,
                                &quot;phone&quot;: &quot;+18117300208&quot;,
                                &quot;phone_national&quot;: &quot;(811) 730-0208&quot;,
                                &quot;phone_country&quot;: &quot;US&quot;,
                                &quot;email_token&quot;: null,
                                &quot;phone_token&quot;: null,
                                &quot;email_verified_at&quot;: &quot;2025-09-06T23:59:37.000000Z&quot;,
                                &quot;phone_verified_at&quot;: &quot;2025-09-06T23:59:37.000000Z&quot;,
                                &quot;otp_expires_at&quot;: null,
                                &quot;last_otp_sent_at&quot;: null,
                                &quot;otp_resend_attempts&quot;: null,
                                &quot;otp_resend_attempts_expires_at&quot;: null,
                                &quot;total_otp_resend_attempts&quot;: null,
                                &quot;locked_at&quot;: null,
                                &quot;phone_hidden&quot;: null,
                                &quot;accept_terms&quot;: null,
                                &quot;accept_marketing_offers&quot;: null,
                                &quot;is_permanent&quot;: null,
                                &quot;featured&quot;: 0,
                                &quot;tmp_token&quot;: null,
                                &quot;reviewed_at&quot;: &quot;2025-09-06T23:59:37.000000Z&quot;,
                                &quot;archived_at&quot;: null,
                                &quot;archived_manually_at&quot;: null,
                                &quot;deletion_mail_sent_at&quot;: null,
                                &quot;created_at&quot;: &quot;2025-09-06T20:31:29.000000Z&quot;,
                                &quot;updated_at&quot;: &quot;2025-09-08T10:06:56.817550Z&quot;,
                                &quot;reference&quot;: &quot;yMYer8wkbOB&quot;,
                                &quot;slug&quot;: &quot;jeep-grand-cherokee-2022&quot;,
                                &quot;url&quot;: &quot;https://demo.laraclassifier.local/jeep-grand-cherokee-2022/yMYer8wkbOB&quot;,
                                &quot;excerpt&quot;: &quot;Accusamus occaecati voluptates sunt voluptatibus aut modi nulla illum. Sint nostrum omnis error fuga...&quot;,
                                &quot;phone_intl&quot;: &quot;(811) 730-0208&quot;,
                                &quot;created_at_formatted&quot;: &quot;1 day ago&quot;,
                                &quot;updated_at_formatted&quot;: &quot;Sep 8th, 2025 at 06:06&quot;,
                                &quot;archived_at_formatted&quot;: &quot;&quot;,
                                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;,
                                &quot;count_pictures&quot;: 2,
                                &quot;price_label&quot;: &quot;Price:&quot;,
                                &quot;price_formatted&quot;: &quot;$355&quot;,
                                &quot;visits_formatted&quot;: &quot;0 view&quot;,
                                &quot;distance_info&quot;: null,
                                &quot;picture&quot;: {
                                    &quot;id&quot;: 14264,
                                    &quot;post_id&quot;: 9197,
                                    &quot;file_path&quot;: &quot;files/us/9197/4a9d0e4fa79e7997f8fe4a6ae219960b.jpg&quot;,
                                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                    &quot;position&quot;: 1,
                                    &quot;active&quot;: 1,
                                    &quot;url&quot;: {
                                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9197/thumbnails/816x460-4a9d0e4fa79e7997f8fe4a6ae219960b.jpg&quot;,
                                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9197/thumbnails/120x90-4a9d0e4fa79e7997f8fe4a6ae219960b.jpg&quot;,
                                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9197/thumbnails/320x240-4a9d0e4fa79e7997f8fe4a6ae219960b.jpg&quot;,
                                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9197/thumbnails/816x460-4a9d0e4fa79e7997f8fe4a6ae219960b.jpg&quot;
                                    }
                                },
                                &quot;pictures&quot;: [
                                    {
                                        &quot;id&quot;: 14264,
                                        &quot;post_id&quot;: 9197,
                                        &quot;file_path&quot;: &quot;files/us/9197/4a9d0e4fa79e7997f8fe4a6ae219960b.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 1,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9197/thumbnails/816x460-4a9d0e4fa79e7997f8fe4a6ae219960b.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9197/thumbnails/120x90-4a9d0e4fa79e7997f8fe4a6ae219960b.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9197/thumbnails/320x240-4a9d0e4fa79e7997f8fe4a6ae219960b.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/9197/thumbnails/816x460-4a9d0e4fa79e7997f8fe4a6ae219960b.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 14263,
                                        &quot;post_id&quot;: 9197,
                                        &quot;file_path&quot;: &quot;files/us/9197/028a29b170e8485399d49f4797b9c940.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 2,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    }
                                ],
                                &quot;user&quot;: {
                                    &quot;id&quot;: 2164,
                                    &quot;name&quot;: &quot;Zora Ebert&quot;,
                                    &quot;username&quot;: &quot;schmelerrupert&quot;,
                                    &quot;two_factor_enabled&quot;: false,
                                    &quot;two_factor_method&quot;: &quot;email&quot;,
                                    &quot;updated_at&quot;: &quot;2025-05-16T17:34:42.000000Z&quot;,
                                    &quot;original_updated_at&quot;: &quot;2025-05-16 17:34:42&quot;,
                                    &quot;original_last_activity&quot;: null,
                                    &quot;created_at_formatted&quot;: &quot;4 months ago&quot;,
                                    &quot;photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                                    &quot;p_is_online&quot;: false,
                                    &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/au.png&quot;
                                },
                                &quot;category&quot;: {
                                    &quot;id&quot;: 3,
                                    &quot;parent_id&quot;: 1,
                                    &quot;name&quot;: &quot;Buses &amp; Minibus&quot;,
                                    &quot;slug&quot;: &quot;buses-and-minibus&quot;,
                                    &quot;description&quot;: &quot;&quot;,
                                    &quot;hide_description&quot;: null,
                                    &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                    &quot;icon_class&quot;: &quot;bi bi-folder-fill&quot;,
                                    &quot;seo_title&quot;: &quot;&quot;,
                                    &quot;seo_description&quot;: &quot;&quot;,
                                    &quot;seo_keywords&quot;: &quot;&quot;,
                                    &quot;lft&quot;: 4,
                                    &quot;rgt&quot;: 5,
                                    &quot;depth&quot;: 1,
                                    &quot;type&quot;: &quot;classified&quot;,
                                    &quot;is_for_permanent&quot;: 0,
                                    &quot;active&quot;: 1,
                                    &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/automobiles/buses-and-minibus&quot;,
                                    &quot;parent&quot;: {
                                        &quot;id&quot;: 1,
                                        &quot;parent_id&quot;: null,
                                        &quot;name&quot;: &quot;Automobiles&quot;,
                                        &quot;slug&quot;: &quot;automobiles&quot;,
                                        &quot;description&quot;: &quot;&quot;,
                                        &quot;hide_description&quot;: null,
                                        &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                        &quot;icon_class&quot;: &quot;fa-solid fa-car&quot;,
                                        &quot;seo_title&quot;: &quot;&quot;,
                                        &quot;seo_description&quot;: &quot;&quot;,
                                        &quot;seo_keywords&quot;: &quot;&quot;,
                                        &quot;lft&quot;: 1,
                                        &quot;rgt&quot;: 16,
                                        &quot;depth&quot;: 0,
                                        &quot;type&quot;: &quot;classified&quot;,
                                        &quot;is_for_permanent&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                        &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/automobiles&quot;,
                                        &quot;parent&quot;: null
                                    }
                                },
                                &quot;postType&quot;: {
                                    &quot;id&quot;: 1,
                                    &quot;name&quot;: &quot;INDIVIDUAL&quot;,
                                    &quot;label&quot;: &quot;Individual&quot;
                                },
                                &quot;city&quot;: {
                                    &quot;id&quot;: 47891,
                                    &quot;country_code&quot;: &quot;US&quot;,
                                    &quot;name&quot;: &quot;Succasunna&quot;,
                                    &quot;latitude&quot;: 40.87,
                                    &quot;longitude&quot;: -74.64,
                                    &quot;subadmin1_code&quot;: &quot;US.NJ&quot;,
                                    &quot;subadmin2_code&quot;: &quot;US.NJ.027&quot;,
                                    &quot;population&quot;: 9152,
                                    &quot;time_zone&quot;: &quot;America/New_York&quot;,
                                    &quot;active&quot;: 1,
                                    &quot;slug&quot;: &quot;succasunna&quot;,
                                    &quot;posts_count&quot;: 0
                                },
                                &quot;payment&quot;: null,
                                &quot;rating_cache&quot;: 0,
                                &quot;rating_count&quot;: 0
                            },
                            {
                                &quot;id&quot;: 7108,
                                &quot;country_code&quot;: &quot;US&quot;,
                                &quot;user_id&quot;: 280,
                                &quot;payment_id&quot;: null,
                                &quot;category_id&quot;: 6,
                                &quot;post_type_id&quot;: 1,
                                &quot;title&quot;: &quot;Test sell Toyota 4Runner&quot;,
                                &quot;description&quot;: &quot;Sunt accusantium consequatur repellat placeat. Voluptatibus et neque aspernatur nihil odit. Omnis aut dolor sed quis eveniet molestias architecto.&quot;,
                                &quot;tags&quot;: [
                                    &quot;culpa&quot;,
                                    &quot;est&quot;,
                                    &quot;consequatur&quot;
                                ],
                                &quot;price&quot;: &quot;925.00&quot;,
                                &quot;currency_code&quot;: null,
                                &quot;negotiable&quot;: null,
                                &quot;contact_name&quot;: &quot;Brett West&quot;,
                                &quot;address&quot;: null,
                                &quot;city_id&quot;: 44298,
                                &quot;lat&quot;: null,
                                &quot;lon&quot;: null,
                                &quot;create_from_ip&quot;: null,
                                &quot;latest_update_ip&quot;: null,
                                &quot;visits&quot;: null,
                                &quot;auth_field&quot;: &quot;email&quot;,
                                &quot;email&quot;: &quot;stiedemann.enid@yahoo.com&quot;,
                                &quot;phone&quot;: &quot;+17314472905&quot;,
                                &quot;phone_national&quot;: &quot;(731) 447-2905&quot;,
                                &quot;phone_country&quot;: &quot;US&quot;,
                                &quot;email_token&quot;: null,
                                &quot;phone_token&quot;: null,
                                &quot;email_verified_at&quot;: &quot;2025-09-07T00:14:39.000000Z&quot;,
                                &quot;phone_verified_at&quot;: &quot;2025-09-07T00:14:39.000000Z&quot;,
                                &quot;otp_expires_at&quot;: null,
                                &quot;last_otp_sent_at&quot;: null,
                                &quot;otp_resend_attempts&quot;: null,
                                &quot;otp_resend_attempts_expires_at&quot;: null,
                                &quot;total_otp_resend_attempts&quot;: null,
                                &quot;locked_at&quot;: null,
                                &quot;phone_hidden&quot;: null,
                                &quot;accept_terms&quot;: null,
                                &quot;accept_marketing_offers&quot;: null,
                                &quot;is_permanent&quot;: null,
                                &quot;featured&quot;: 0,
                                &quot;tmp_token&quot;: null,
                                &quot;reviewed_at&quot;: &quot;2025-09-07T00:14:39.000000Z&quot;,
                                &quot;archived_at&quot;: null,
                                &quot;archived_manually_at&quot;: null,
                                &quot;deletion_mail_sent_at&quot;: null,
                                &quot;created_at&quot;: &quot;2025-09-06T19:08:01.000000Z&quot;,
                                &quot;updated_at&quot;: &quot;2025-09-08T10:06:57.017495Z&quot;,
                                &quot;reference&quot;: &quot;l4zbqY4kbpr&quot;,
                                &quot;slug&quot;: &quot;test-sell-toyota-4runner&quot;,
                                &quot;url&quot;: &quot;https://demo.laraclassifier.local/test-sell-toyota-4runner/l4zbqY4kbpr&quot;,
                                &quot;excerpt&quot;: &quot;Sunt accusantium consequatur repellat placeat. Voluptatibus et neque aspernatur nihil odit. Omnis au...&quot;,
                                &quot;phone_intl&quot;: &quot;(731) 447-2905&quot;,
                                &quot;created_at_formatted&quot;: &quot;1 day ago&quot;,
                                &quot;updated_at_formatted&quot;: &quot;Sep 8th, 2025 at 06:06&quot;,
                                &quot;archived_at_formatted&quot;: &quot;&quot;,
                                &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
                                &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                                &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;,
                                &quot;count_pictures&quot;: 5,
                                &quot;price_label&quot;: &quot;Price:&quot;,
                                &quot;price_formatted&quot;: &quot;$925&quot;,
                                &quot;visits_formatted&quot;: &quot;0 view&quot;,
                                &quot;distance_info&quot;: null,
                                &quot;picture&quot;: {
                                    &quot;id&quot;: 11065,
                                    &quot;post_id&quot;: 7108,
                                    &quot;file_path&quot;: &quot;files/us/7108/7ccfa2930a852fdf666d61146eff5648.jpg&quot;,
                                    &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                    &quot;position&quot;: 1,
                                    &quot;active&quot;: 1,
                                    &quot;url&quot;: {
                                        &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/7108/thumbnails/816x460-7ccfa2930a852fdf666d61146eff5648.jpg&quot;,
                                        &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/7108/thumbnails/120x90-7ccfa2930a852fdf666d61146eff5648.jpg&quot;,
                                        &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/7108/thumbnails/320x240-7ccfa2930a852fdf666d61146eff5648.jpg&quot;,
                                        &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/7108/thumbnails/816x460-7ccfa2930a852fdf666d61146eff5648.jpg&quot;
                                    }
                                },
                                &quot;pictures&quot;: [
                                    {
                                        &quot;id&quot;: 11065,
                                        &quot;post_id&quot;: 7108,
                                        &quot;file_path&quot;: &quot;files/us/7108/7ccfa2930a852fdf666d61146eff5648.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 1,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/7108/thumbnails/816x460-7ccfa2930a852fdf666d61146eff5648.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/7108/thumbnails/120x90-7ccfa2930a852fdf666d61146eff5648.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/7108/thumbnails/320x240-7ccfa2930a852fdf666d61146eff5648.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/7108/thumbnails/816x460-7ccfa2930a852fdf666d61146eff5648.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 11064,
                                        &quot;post_id&quot;: 7108,
                                        &quot;file_path&quot;: &quot;files/us/7108/aa6c9c9754a367489b61fa6b5d7cc3b4.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 2,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 11063,
                                        &quot;post_id&quot;: 7108,
                                        &quot;file_path&quot;: &quot;files/us/7108/e6a5835f267a4b279f380e56db127fcf.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 4,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 11062,
                                        &quot;post_id&quot;: 7108,
                                        &quot;file_path&quot;: &quot;files/us/7108/2cb567dc496f7b098c78ac32f57ac98f.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 4,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    },
                                    {
                                        &quot;id&quot;: 11061,
                                        &quot;post_id&quot;: 7108,
                                        &quot;file_path&quot;: &quot;files/us/7108/036c0acaa2144ff54f35c2d924cd45f4.jpg&quot;,
                                        &quot;mime_type&quot;: &quot;image/jpeg&quot;,
                                        &quot;position&quot;: 5,
                                        &quot;active&quot;: 1,
                                        &quot;url&quot;: {
                                            &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;,
                                            &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/picture.jpg&quot;
                                        }
                                    }
                                ],
                                &quot;user&quot;: {
                                    &quot;id&quot;: 280,
                                    &quot;name&quot;: &quot;Brett West&quot;,
                                    &quot;username&quot;: &quot;schummdanika&quot;,
                                    &quot;two_factor_enabled&quot;: false,
                                    &quot;two_factor_method&quot;: &quot;email&quot;,
                                    &quot;updated_at&quot;: &quot;2025-07-21T00:22:42.000000Z&quot;,
                                    &quot;original_updated_at&quot;: &quot;2025-07-21 00:22:42&quot;,
                                    &quot;original_last_activity&quot;: null,
                                    &quot;created_at_formatted&quot;: &quot;3 months ago&quot;,
                                    &quot;photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/user.png&quot;,
                                    &quot;p_is_online&quot;: false,
                                    &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/ma.png&quot;
                                },
                                &quot;category&quot;: {
                                    &quot;id&quot;: 6,
                                    &quot;parent_id&quot;: 1,
                                    &quot;name&quot;: &quot;Trucks &amp; Trailers&quot;,
                                    &quot;slug&quot;: &quot;trucks-and-trailers&quot;,
                                    &quot;description&quot;: &quot;&quot;,
                                    &quot;hide_description&quot;: null,
                                    &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                    &quot;icon_class&quot;: &quot;bi bi-folder-fill&quot;,
                                    &quot;seo_title&quot;: &quot;&quot;,
                                    &quot;seo_description&quot;: &quot;&quot;,
                                    &quot;seo_keywords&quot;: &quot;&quot;,
                                    &quot;lft&quot;: 10,
                                    &quot;rgt&quot;: 11,
                                    &quot;depth&quot;: 1,
                                    &quot;type&quot;: &quot;classified&quot;,
                                    &quot;is_for_permanent&quot;: 0,
                                    &quot;active&quot;: 1,
                                    &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                    &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/automobiles/trucks-and-trailers&quot;,
                                    &quot;parent&quot;: {
                                        &quot;id&quot;: 1,
                                        &quot;parent_id&quot;: null,
                                        &quot;name&quot;: &quot;Automobiles&quot;,
                                        &quot;slug&quot;: &quot;automobiles&quot;,
                                        &quot;description&quot;: &quot;&quot;,
                                        &quot;hide_description&quot;: null,
                                        &quot;image_path&quot;: &quot;app/default/categories/fa-folder-default.png&quot;,
                                        &quot;icon_class&quot;: &quot;fa-solid fa-car&quot;,
                                        &quot;seo_title&quot;: &quot;&quot;,
                                        &quot;seo_description&quot;: &quot;&quot;,
                                        &quot;seo_keywords&quot;: &quot;&quot;,
                                        &quot;lft&quot;: 1,
                                        &quot;rgt&quot;: 16,
                                        &quot;depth&quot;: 0,
                                        &quot;type&quot;: &quot;classified&quot;,
                                        &quot;is_for_permanent&quot;: 0,
                                        &quot;active&quot;: 1,
                                        &quot;image_url&quot;: &quot;https://demo.laraclassifier.local/storage/app/default/categories/thumbnails/70x70-fa-folder-default.png&quot;,
                                        &quot;url&quot;: &quot;https://demo.laraclassifier.local/category/automobiles&quot;,
                                        &quot;parent&quot;: null
                                    }
                                },
                                &quot;postType&quot;: {
                                    &quot;id&quot;: 1,
                                    &quot;name&quot;: &quot;INDIVIDUAL&quot;,
                                    &quot;label&quot;: &quot;Individual&quot;
                                },
                                &quot;city&quot;: {
                                    &quot;id&quot;: 44298,
                                    &quot;country_code&quot;: &quot;US&quot;,
                                    &quot;name&quot;: &quot;Country Club Estates&quot;,
                                    &quot;latitude&quot;: 33.99,
                                    &quot;longitude&quot;: -83.41,
                                    &quot;subadmin1_code&quot;: &quot;US.GA&quot;,
                                    &quot;subadmin2_code&quot;: &quot;US.GA.059&quot;,
                                    &quot;population&quot;: 7555,
                                    &quot;time_zone&quot;: &quot;America/New_York&quot;,
                                    &quot;active&quot;: 1,
                                    &quot;slug&quot;: &quot;country-club-estates&quot;,
                                    &quot;posts_count&quot;: 0
                                },
                                &quot;payment&quot;: null,
                                &quot;rating_cache&quot;: 0,
                                &quot;rating_count&quot;: 0
                            }
                        ],
                        &quot;totalPosts&quot;: 268
                    }
                },
                &quot;options&quot;: {
                    &quot;max_items&quot;: &quot;8&quot;,
                    &quot;show_view_more_btn&quot;: &quot;1&quot;
                },
                &quot;lft&quot;: 9
            },
            &quot;stats&quot;: {
                &quot;belongs_to&quot;: &quot;home&quot;,
                &quot;name&quot;: &quot;stats&quot;,
                &quot;data&quot;: {
                    &quot;count&quot;: {
                        &quot;posts&quot;: 268,
                        &quot;users&quot;: 4595,
                        &quot;locations&quot;: 7200
                    }
                },
                &quot;options&quot;: {
                    &quot;icon_count_listings&quot;: &quot;bi bi-megaphone&quot;,
                    &quot;icon_count_users&quot;: &quot;bi bi-people&quot;,
                    &quot;icon_count_locations&quot;: &quot;bi bi-geo-alt&quot;,
                    &quot;counter_up_delay&quot;: 10,
                    &quot;counter_up_time&quot;: 2000
                },
                &quot;lft&quot;: 11
            }
        }
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-sections" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-sections"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-sections"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-sections" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-sections">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-sections" data-method="GET"
      data-path="api/sections"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-sections', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-sections"
                    onclick="tryItOut('GETapi-sections');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-sections"
                    onclick="cancelTryOut('GETapi-sections');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-sections"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/sections</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-sections"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-sections"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-sections"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-sections"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-sections"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        </form>

                    <h2 id="home-GETapi-sections--method-">Get section</h2>

<p>
</p>

<p>Get section by its name.</p>

<span id="example-requests-GETapi-sections--method-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/sections/1" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/sections/1"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/sections/1';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/sections/1'
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-sections--method-">
            <blockquote>
            <p>Example response (404):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: false,
    &quot;message&quot;: &quot;Section not found&quot;,
    &quot;result&quot;: null,
    &quot;error&quot;: &quot;Section not found&quot;
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-sections--method-" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-sections--method-"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-sections--method-"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-sections--method-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-sections--method-">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-sections--method-" data-method="GET"
      data-path="api/sections/{method}"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-sections--method-', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-sections--method-"
                    onclick="tryItOut('GETapi-sections--method-');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-sections--method-"
                    onclick="cancelTryOut('GETapi-sections--method-');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-sections--method-"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/sections/{method}</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-sections--method-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-sections--method-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-sections--method-"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-sections--method-"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-sections--method-"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>method</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="method"                data-endpoint="GETapi-sections--method-"
               value="1"
               data-component="url">
    <br>
<p>Example: <code>1</code></p>
            </div>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>name</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="name"                data-endpoint="GETapi-sections--method-"
               value="getCategories"
               data-component="url">
    <br>
<p>The key/method of the section. Example: <code>getCategories</code></p>
            </div>
                    </form>

                <h1 id="languages">Languages</h1>

    

                                <h2 id="languages-GETapi-languages">List languages</h2>

<p>
</p>



<span id="example-requests-GETapi-languages">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/languages" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/languages"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/languages';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/languages'
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-languages">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;data&quot;: [
            {
                &quot;code&quot;: &quot;en&quot;,
                &quot;locale&quot;: &quot;en_US&quot;,
                &quot;name&quot;: &quot;English&quot;,
                &quot;native&quot;: &quot;English&quot;,
                &quot;flag&quot;: &quot;flag-icon-gb&quot;,
                &quot;script&quot;: &quot;Latn&quot;,
                &quot;direction&quot;: &quot;ltr&quot;,
                &quot;russian_pluralization&quot;: 0,
                &quot;date_format&quot;: &quot;MMM Do, YYYY&quot;,
                &quot;datetime_format&quot;: &quot;MMM Do, YYYY [at] HH:mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 1,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 1,
                &quot;rgt&quot;: 2,
                &quot;depth&quot;: 0,
                &quot;created_at&quot;: &quot;2025-09-08 09:28:49&quot;,
                &quot;updated_at&quot;: null,
                &quot;iso_locale&quot;: &quot;en_US&quot;,
                &quot;tag&quot;: &quot;en&quot;,
                &quot;primary&quot;: &quot;en&quot;
            },
            {
                &quot;code&quot;: &quot;fr&quot;,
                &quot;locale&quot;: &quot;fr_FR&quot;,
                &quot;name&quot;: &quot;French&quot;,
                &quot;native&quot;: &quot;Fran&ccedil;ais&quot;,
                &quot;flag&quot;: &quot;flag-icon-fr&quot;,
                &quot;script&quot;: &quot;Latn&quot;,
                &quot;direction&quot;: &quot;ltr&quot;,
                &quot;russian_pluralization&quot;: 0,
                &quot;date_format&quot;: &quot;Do MMM YYYY&quot;,
                &quot;datetime_format&quot;: &quot;Do MMM YYYY [&agrave;] H[h]mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 0,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 3,
                &quot;rgt&quot;: 4,
                &quot;depth&quot;: 0,
                &quot;created_at&quot;: &quot;2025-09-08 09:28:49&quot;,
                &quot;updated_at&quot;: null,
                &quot;iso_locale&quot;: &quot;fr_FR&quot;,
                &quot;tag&quot;: &quot;fr&quot;,
                &quot;primary&quot;: &quot;fr&quot;
            },
            {
                &quot;code&quot;: &quot;es&quot;,
                &quot;locale&quot;: &quot;es_ES&quot;,
                &quot;name&quot;: &quot;Spanish&quot;,
                &quot;native&quot;: &quot;Espa&ntilde;ol&quot;,
                &quot;flag&quot;: &quot;flag-icon-es&quot;,
                &quot;script&quot;: &quot;Latn&quot;,
                &quot;direction&quot;: &quot;ltr&quot;,
                &quot;russian_pluralization&quot;: 0,
                &quot;date_format&quot;: &quot;D [de] MMMM [de] YYYY&quot;,
                &quot;datetime_format&quot;: &quot;D [de] MMMM [de] YYYY HH:mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 0,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 5,
                &quot;rgt&quot;: 6,
                &quot;depth&quot;: 0,
                &quot;created_at&quot;: &quot;2025-09-08 09:28:49&quot;,
                &quot;updated_at&quot;: null,
                &quot;iso_locale&quot;: &quot;es_ES&quot;,
                &quot;tag&quot;: &quot;es&quot;,
                &quot;primary&quot;: &quot;es&quot;
            },
            {
                &quot;code&quot;: &quot;ar&quot;,
                &quot;locale&quot;: &quot;ar_SA&quot;,
                &quot;name&quot;: &quot;Arabic&quot;,
                &quot;native&quot;: &quot;العربية&quot;,
                &quot;flag&quot;: &quot;flag-icon-sa&quot;,
                &quot;script&quot;: &quot;Arab&quot;,
                &quot;direction&quot;: &quot;rtl&quot;,
                &quot;russian_pluralization&quot;: 0,
                &quot;date_format&quot;: &quot;DD/MMMM/YYYY&quot;,
                &quot;datetime_format&quot;: &quot;DD/MMMM/YYYY HH:mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 0,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 7,
                &quot;rgt&quot;: 8,
                &quot;depth&quot;: 0,
                &quot;created_at&quot;: &quot;2025-09-08 09:28:49&quot;,
                &quot;updated_at&quot;: null,
                &quot;iso_locale&quot;: &quot;ar_SA&quot;,
                &quot;tag&quot;: &quot;ar&quot;,
                &quot;primary&quot;: &quot;ar&quot;
            },
            {
                &quot;code&quot;: &quot;pt&quot;,
                &quot;locale&quot;: &quot;pt_PT&quot;,
                &quot;name&quot;: &quot;Portuguese&quot;,
                &quot;native&quot;: &quot;Portugu&ecirc;s&quot;,
                &quot;flag&quot;: &quot;flag-icon-pt&quot;,
                &quot;script&quot;: &quot;Latn&quot;,
                &quot;direction&quot;: &quot;ltr&quot;,
                &quot;russian_pluralization&quot;: 0,
                &quot;date_format&quot;: &quot;D [de] MMMM [de] YYYY&quot;,
                &quot;datetime_format&quot;: &quot;D [de] MMMM [de] YYYY HH:mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 0,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 9,
                &quot;rgt&quot;: 10,
                &quot;depth&quot;: 0,
                &quot;created_at&quot;: &quot;2025-09-08 09:28:49&quot;,
                &quot;updated_at&quot;: null,
                &quot;iso_locale&quot;: &quot;pt_PT&quot;,
                &quot;tag&quot;: &quot;pt&quot;,
                &quot;primary&quot;: &quot;pt&quot;
            },
            {
                &quot;code&quot;: &quot;de&quot;,
                &quot;locale&quot;: &quot;de_DE&quot;,
                &quot;name&quot;: &quot;German&quot;,
                &quot;native&quot;: &quot;Deutsch&quot;,
                &quot;flag&quot;: &quot;flag-icon-de&quot;,
                &quot;script&quot;: &quot;Latn&quot;,
                &quot;direction&quot;: &quot;ltr&quot;,
                &quot;russian_pluralization&quot;: 0,
                &quot;date_format&quot;: &quot;dddd, D. MMMM YYYY&quot;,
                &quot;datetime_format&quot;: &quot;dddd, D. MMMM YYYY HH:mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 0,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 11,
                &quot;rgt&quot;: 12,
                &quot;depth&quot;: 0,
                &quot;created_at&quot;: &quot;2025-09-08 09:28:49&quot;,
                &quot;updated_at&quot;: null,
                &quot;iso_locale&quot;: &quot;de_DE&quot;,
                &quot;tag&quot;: &quot;de&quot;,
                &quot;primary&quot;: &quot;de&quot;
            },
            {
                &quot;code&quot;: &quot;it&quot;,
                &quot;locale&quot;: &quot;it_IT&quot;,
                &quot;name&quot;: &quot;Italian&quot;,
                &quot;native&quot;: &quot;Italiano&quot;,
                &quot;flag&quot;: &quot;flag-icon-it&quot;,
                &quot;script&quot;: &quot;Latn&quot;,
                &quot;direction&quot;: &quot;ltr&quot;,
                &quot;russian_pluralization&quot;: 0,
                &quot;date_format&quot;: &quot;D MMMM YYYY&quot;,
                &quot;datetime_format&quot;: &quot;D MMMM YYYY HH:mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 0,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 13,
                &quot;rgt&quot;: 14,
                &quot;depth&quot;: 0,
                &quot;created_at&quot;: &quot;2025-09-08 09:28:49&quot;,
                &quot;updated_at&quot;: null,
                &quot;iso_locale&quot;: &quot;it_IT&quot;,
                &quot;tag&quot;: &quot;it&quot;,
                &quot;primary&quot;: &quot;it&quot;
            },
            {
                &quot;code&quot;: &quot;tr&quot;,
                &quot;locale&quot;: &quot;tr_TR.UTF-8&quot;,
                &quot;name&quot;: &quot;Turkish&quot;,
                &quot;native&quot;: &quot;T&uuml;rk&ccedil;e&quot;,
                &quot;flag&quot;: &quot;flag-icon-tr&quot;,
                &quot;script&quot;: &quot;Latn&quot;,
                &quot;direction&quot;: &quot;ltr&quot;,
                &quot;russian_pluralization&quot;: 0,
                &quot;date_format&quot;: &quot;DD MMMM YYYY dddd&quot;,
                &quot;datetime_format&quot;: &quot;DD MMMM YYYY dddd HH:mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 0,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 15,
                &quot;rgt&quot;: 16,
                &quot;depth&quot;: 0,
                &quot;created_at&quot;: &quot;2025-09-08 09:28:49&quot;,
                &quot;updated_at&quot;: null,
                &quot;iso_locale&quot;: &quot;tr_TR&quot;,
                &quot;tag&quot;: &quot;tr&quot;,
                &quot;primary&quot;: &quot;tr&quot;
            },
            {
                &quot;code&quot;: &quot;ru&quot;,
                &quot;locale&quot;: &quot;ru_RU&quot;,
                &quot;name&quot;: &quot;Russian&quot;,
                &quot;native&quot;: &quot;Русский&quot;,
                &quot;flag&quot;: &quot;flag-icon-ru&quot;,
                &quot;script&quot;: &quot;Cyrl&quot;,
                &quot;direction&quot;: &quot;ltr&quot;,
                &quot;russian_pluralization&quot;: 1,
                &quot;date_format&quot;: &quot;D MMMM YYYY&quot;,
                &quot;datetime_format&quot;: &quot;D MMMM YYYY [ г.] H:mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 0,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 17,
                &quot;rgt&quot;: 18,
                &quot;depth&quot;: 0,
                &quot;created_at&quot;: &quot;2025-09-08 09:28:49&quot;,
                &quot;updated_at&quot;: null,
                &quot;iso_locale&quot;: &quot;ru_RU&quot;,
                &quot;tag&quot;: &quot;ru&quot;,
                &quot;primary&quot;: &quot;ru&quot;
            },
            {
                &quot;code&quot;: &quot;hi&quot;,
                &quot;locale&quot;: &quot;hi_IN&quot;,
                &quot;name&quot;: &quot;Hindi&quot;,
                &quot;native&quot;: &quot;हिन्दी&quot;,
                &quot;flag&quot;: &quot;flag-icon-in&quot;,
                &quot;script&quot;: &quot;Deva&quot;,
                &quot;direction&quot;: &quot;ltr&quot;,
                &quot;russian_pluralization&quot;: 0,
                &quot;date_format&quot;: &quot;D MMMM YYYY&quot;,
                &quot;datetime_format&quot;: &quot;D MMMM YYYY H:mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 0,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 19,
                &quot;rgt&quot;: 20,
                &quot;depth&quot;: 0,
                &quot;created_at&quot;: &quot;2025-09-08 09:28:49&quot;,
                &quot;updated_at&quot;: null,
                &quot;iso_locale&quot;: &quot;hi_IN&quot;,
                &quot;tag&quot;: &quot;hi&quot;,
                &quot;primary&quot;: &quot;hi&quot;
            },
            {
                &quot;code&quot;: &quot;bn&quot;,
                &quot;locale&quot;: &quot;bn_BD&quot;,
                &quot;name&quot;: &quot;Bengali&quot;,
                &quot;native&quot;: &quot;বাংলা&quot;,
                &quot;flag&quot;: &quot;flag-icon-bd&quot;,
                &quot;script&quot;: &quot;Beng&quot;,
                &quot;direction&quot;: &quot;ltr&quot;,
                &quot;russian_pluralization&quot;: 0,
                &quot;date_format&quot;: &quot;D MMMM YYYY&quot;,
                &quot;datetime_format&quot;: &quot;D MMMM YYYY H.mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 0,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 21,
                &quot;rgt&quot;: 22,
                &quot;depth&quot;: 0,
                &quot;created_at&quot;: &quot;2025-09-08 09:28:49&quot;,
                &quot;updated_at&quot;: null,
                &quot;iso_locale&quot;: &quot;bn_BD&quot;,
                &quot;tag&quot;: &quot;bn&quot;,
                &quot;primary&quot;: &quot;bn&quot;
            },
            {
                &quot;code&quot;: &quot;zh&quot;,
                &quot;locale&quot;: &quot;zh_CN&quot;,
                &quot;name&quot;: &quot;Simplified Chinese&quot;,
                &quot;native&quot;: &quot;简体中文&quot;,
                &quot;flag&quot;: &quot;flag-icon-cn&quot;,
                &quot;script&quot;: &quot;Hans&quot;,
                &quot;direction&quot;: &quot;ltr&quot;,
                &quot;russian_pluralization&quot;: 0,
                &quot;date_format&quot;: &quot;D MMMM YYYY&quot;,
                &quot;datetime_format&quot;: &quot;D MMMM YYYY H:mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 0,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 23,
                &quot;rgt&quot;: 24,
                &quot;depth&quot;: 0,
                &quot;created_at&quot;: &quot;2025-09-08 09:28:49&quot;,
                &quot;updated_at&quot;: null,
                &quot;iso_locale&quot;: &quot;zh_CN&quot;,
                &quot;tag&quot;: &quot;zh&quot;,
                &quot;primary&quot;: &quot;zh&quot;
            },
            {
                &quot;code&quot;: &quot;ja&quot;,
                &quot;locale&quot;: &quot;ja_JP&quot;,
                &quot;name&quot;: &quot;Japanese&quot;,
                &quot;native&quot;: &quot;日本語&quot;,
                &quot;flag&quot;: &quot;flag-icon-jp&quot;,
                &quot;script&quot;: &quot;Jpan&quot;,
                &quot;direction&quot;: &quot;ltr&quot;,
                &quot;russian_pluralization&quot;: 0,
                &quot;date_format&quot;: &quot;D MMMM YYYY&quot;,
                &quot;datetime_format&quot;: &quot;D MMMM YYYY H:mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 0,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 25,
                &quot;rgt&quot;: 26,
                &quot;depth&quot;: 0,
                &quot;created_at&quot;: &quot;2025-09-08 09:28:49&quot;,
                &quot;updated_at&quot;: null,
                &quot;iso_locale&quot;: &quot;ja_JP&quot;,
                &quot;tag&quot;: &quot;ja&quot;,
                &quot;primary&quot;: &quot;ja&quot;
            },
            {
                &quot;code&quot;: &quot;he&quot;,
                &quot;locale&quot;: &quot;he_IL&quot;,
                &quot;name&quot;: &quot;Hebrew&quot;,
                &quot;native&quot;: &quot;עִברִית&quot;,
                &quot;flag&quot;: &quot;flag-icon-il&quot;,
                &quot;script&quot;: &quot;Hebr&quot;,
                &quot;direction&quot;: &quot;rtl&quot;,
                &quot;russian_pluralization&quot;: 0,
                &quot;date_format&quot;: &quot;D MMMM YYYY&quot;,
                &quot;datetime_format&quot;: &quot;D MMMM YYYY H:mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 0,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 27,
                &quot;rgt&quot;: 28,
                &quot;depth&quot;: 0,
                &quot;created_at&quot;: &quot;2025-09-08 09:28:49&quot;,
                &quot;updated_at&quot;: null,
                &quot;iso_locale&quot;: &quot;he_IL&quot;,
                &quot;tag&quot;: &quot;he&quot;,
                &quot;primary&quot;: &quot;he&quot;
            },
            {
                &quot;code&quot;: &quot;th&quot;,
                &quot;locale&quot;: &quot;th_TH&quot;,
                &quot;name&quot;: &quot;Thai&quot;,
                &quot;native&quot;: &quot;ไทย&quot;,
                &quot;flag&quot;: &quot;flag-icon-th&quot;,
                &quot;script&quot;: &quot;Thai&quot;,
                &quot;direction&quot;: &quot;ltr&quot;,
                &quot;russian_pluralization&quot;: 0,
                &quot;date_format&quot;: &quot;D MMMM YYYY&quot;,
                &quot;datetime_format&quot;: &quot;D MMMM YYYY H:mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 0,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 29,
                &quot;rgt&quot;: 30,
                &quot;depth&quot;: 0,
                &quot;created_at&quot;: &quot;2025-09-08 09:28:49&quot;,
                &quot;updated_at&quot;: null,
                &quot;iso_locale&quot;: &quot;th_TH&quot;,
                &quot;tag&quot;: &quot;th&quot;,
                &quot;primary&quot;: &quot;th&quot;
            },
            {
                &quot;code&quot;: &quot;ro&quot;,
                &quot;locale&quot;: &quot;ro_RO&quot;,
                &quot;name&quot;: &quot;Romanian&quot;,
                &quot;native&quot;: &quot;Rom&acirc;nă&quot;,
                &quot;flag&quot;: &quot;flag-icon-ro&quot;,
                &quot;script&quot;: &quot;Latn&quot;,
                &quot;direction&quot;: &quot;ltr&quot;,
                &quot;russian_pluralization&quot;: 0,
                &quot;date_format&quot;: &quot;D MMMM YYYY&quot;,
                &quot;datetime_format&quot;: &quot;D MMMM YYYY H:mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 0,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 31,
                &quot;rgt&quot;: 32,
                &quot;depth&quot;: 0,
                &quot;created_at&quot;: &quot;2025-09-08 09:28:49&quot;,
                &quot;updated_at&quot;: null,
                &quot;iso_locale&quot;: &quot;ro_RO&quot;,
                &quot;tag&quot;: &quot;ro&quot;,
                &quot;primary&quot;: &quot;ro&quot;
            },
            {
                &quot;code&quot;: &quot;ka&quot;,
                &quot;locale&quot;: &quot;ka_GE&quot;,
                &quot;name&quot;: &quot;Georgian&quot;,
                &quot;native&quot;: &quot;ქართული&quot;,
                &quot;flag&quot;: &quot;flag-icon-ge&quot;,
                &quot;script&quot;: &quot;Geor&quot;,
                &quot;direction&quot;: &quot;ltr&quot;,
                &quot;russian_pluralization&quot;: 0,
                &quot;date_format&quot;: &quot;YYYY [წლის] DD MM&quot;,
                &quot;datetime_format&quot;: &quot;YYYY [წლის] DD MMMM, dddd H:mm&quot;,
                &quot;active&quot;: 1,
                &quot;default&quot;: 0,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 33,
                &quot;rgt&quot;: 34,
                &quot;depth&quot;: 0,
                &quot;created_at&quot;: &quot;2025-09-08 09:28:49&quot;,
                &quot;updated_at&quot;: null,
                &quot;iso_locale&quot;: &quot;ka_GE&quot;,
                &quot;tag&quot;: &quot;ka&quot;,
                &quot;primary&quot;: &quot;ka&quot;
            }
        ]
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-languages" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-languages"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-languages"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-languages" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-languages">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-languages" data-method="GET"
      data-path="api/languages"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-languages', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-languages"
                    onclick="tryItOut('GETapi-languages');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-languages"
                    onclick="cancelTryOut('GETapi-languages');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-languages"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/languages</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-languages"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-languages"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-languages"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-languages"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-languages"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        </form>

                    <h2 id="languages-GETapi-languages--code-">Get language</h2>

<p>
</p>



<span id="example-requests-GETapi-languages--code-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/languages/en" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/languages/en"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/languages/en';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/languages/en'
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-languages--code-">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;code&quot;: &quot;en&quot;,
        &quot;locale&quot;: &quot;en_US&quot;,
        &quot;name&quot;: &quot;English&quot;,
        &quot;native&quot;: &quot;English&quot;,
        &quot;flag&quot;: &quot;flag-icon-gb&quot;,
        &quot;script&quot;: &quot;Latn&quot;,
        &quot;direction&quot;: &quot;ltr&quot;,
        &quot;russian_pluralization&quot;: 0,
        &quot;date_format&quot;: &quot;MMM Do, YYYY&quot;,
        &quot;datetime_format&quot;: &quot;MMM Do, YYYY [at] HH:mm&quot;,
        &quot;active&quot;: 1,
        &quot;default&quot;: 1,
        &quot;parent_id&quot;: null,
        &quot;lft&quot;: 1,
        &quot;rgt&quot;: 2,
        &quot;depth&quot;: 0,
        &quot;created_at&quot;: &quot;2025-09-08 09:28:49&quot;,
        &quot;updated_at&quot;: null,
        &quot;iso_locale&quot;: &quot;en_US&quot;,
        &quot;tag&quot;: &quot;en&quot;,
        &quot;primary&quot;: &quot;en&quot;
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-languages--code-" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-languages--code-"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-languages--code-"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-languages--code-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-languages--code-">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-languages--code-" data-method="GET"
      data-path="api/languages/{code}"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-languages--code-', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-languages--code-"
                    onclick="tryItOut('GETapi-languages--code-');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-languages--code-"
                    onclick="cancelTryOut('GETapi-languages--code-');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-languages--code-"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/languages/{code}</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-languages--code-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-languages--code-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-languages--code-"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-languages--code-"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-languages--code-"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>code</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="code"                data-endpoint="GETapi-languages--code-"
               value="en"
               data-component="url">
    <br>
<p>The language's code. Example: <code>en</code></p>
            </div>
                    </form>

                <h1 id="listings">Listings</h1>

    

                                <h2 id="listings-GETapi-postTypes">List listing types</h2>

<p>
</p>



<span id="example-requests-GETapi-postTypes">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/postTypes" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/postTypes"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/postTypes';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/postTypes'
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-postTypes">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;1&quot;: {
            &quot;id&quot;: 1,
            &quot;name&quot;: &quot;INDIVIDUAL&quot;,
            &quot;label&quot;: &quot;Individual&quot;
        },
        &quot;2&quot;: {
            &quot;id&quot;: 2,
            &quot;name&quot;: &quot;PROFESSIONAL&quot;,
            &quot;label&quot;: &quot;Professional&quot;
        }
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-postTypes" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-postTypes"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-postTypes"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-postTypes" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-postTypes">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-postTypes" data-method="GET"
      data-path="api/postTypes"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-postTypes', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-postTypes"
                    onclick="tryItOut('GETapi-postTypes');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-postTypes"
                    onclick="cancelTryOut('GETapi-postTypes');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-postTypes"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/postTypes</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-postTypes"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-postTypes"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-postTypes"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-postTypes"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-postTypes"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        </form>

                    <h2 id="listings-GETapi-postTypes--id-">Get listing type</h2>

<p>
</p>



<span id="example-requests-GETapi-postTypes--id-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/postTypes/1" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/postTypes/1"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/postTypes/1';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/postTypes/1'
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-postTypes--id-">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;id&quot;: 1,
        &quot;name&quot;: &quot;INDIVIDUAL&quot;,
        &quot;label&quot;: &quot;Individual&quot;
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-postTypes--id-" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-postTypes--id-"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-postTypes--id-"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-postTypes--id-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-postTypes--id-">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-postTypes--id-" data-method="GET"
      data-path="api/postTypes/{id}"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-postTypes--id-', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-postTypes--id-"
                    onclick="tryItOut('GETapi-postTypes--id-');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-postTypes--id-"
                    onclick="cancelTryOut('GETapi-postTypes--id-');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-postTypes--id-"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/postTypes/{id}</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-postTypes--id-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-postTypes--id-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-postTypes--id-"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-postTypes--id-"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-postTypes--id-"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="id"                data-endpoint="GETapi-postTypes--id-"
               value="1"
               data-component="url">
    <br>
<p>The listing type's ID. Example: <code>1</code></p>
            </div>
                    </form>

                    <h2 id="listings-GETapi-reportTypes">List report types</h2>

<p>
</p>



<span id="example-requests-GETapi-reportTypes">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/reportTypes" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/reportTypes"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/reportTypes';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/reportTypes'
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-reportTypes">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;data&quot;: [
            {
                &quot;id&quot;: 5,
                &quot;name&quot;: &quot;Other&quot;
            },
            {
                &quot;id&quot;: 4,
                &quot;name&quot;: &quot;Wrong category&quot;
            },
            {
                &quot;id&quot;: 3,
                &quot;name&quot;: &quot;Spam&quot;
            },
            {
                &quot;id&quot;: 2,
                &quot;name&quot;: &quot;Duplicate&quot;
            },
            {
                &quot;id&quot;: 1,
                &quot;name&quot;: &quot;Fraud&quot;
            }
        ]
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-reportTypes" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-reportTypes"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-reportTypes"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-reportTypes" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-reportTypes">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-reportTypes" data-method="GET"
      data-path="api/reportTypes"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-reportTypes', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-reportTypes"
                    onclick="tryItOut('GETapi-reportTypes');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-reportTypes"
                    onclick="cancelTryOut('GETapi-reportTypes');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-reportTypes"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/reportTypes</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-reportTypes"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-reportTypes"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-reportTypes"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-reportTypes"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-reportTypes"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        </form>

                    <h2 id="listings-GETapi-reportTypes--id-">Get report type</h2>

<p>
</p>



<span id="example-requests-GETapi-reportTypes--id-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/reportTypes/1" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/reportTypes/1"
);

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/reportTypes/1';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/reportTypes/1'
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-reportTypes--id-">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;id&quot;: 1,
        &quot;name&quot;: &quot;Fraud&quot;
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-reportTypes--id-" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-reportTypes--id-"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-reportTypes--id-"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-reportTypes--id-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-reportTypes--id-">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-reportTypes--id-" data-method="GET"
      data-path="api/reportTypes/{id}"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-reportTypes--id-', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-reportTypes--id-"
                    onclick="tryItOut('GETapi-reportTypes--id-');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-reportTypes--id-"
                    onclick="cancelTryOut('GETapi-reportTypes--id-');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-reportTypes--id-"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/reportTypes/{id}</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-reportTypes--id-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-reportTypes--id-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-reportTypes--id-"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-reportTypes--id-"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-reportTypes--id-"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="id"                data-endpoint="GETapi-reportTypes--id-"
               value="1"
               data-component="url">
    <br>
<p>The report type's ID. Example: <code>1</code></p>
            </div>
                    </form>

                    <h2 id="listings-GETapi-posts">List listings</h2>

<p>
</p>

<p>Note: The main picture of the listings is fetched via a 'picture' attribute (added as fake column),
that provide default picture as image placeholder when the listing has no pictures.
In addition, for performance reasons, default picture is also provided when the 'pictures' table is not embed in the endpoint.
So you need to embed the picture table like: /api/posts?embed=pictures to retrieve right main picture data.</p>

<span id="example-requests-GETapi-posts">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/posts?op=&amp;postId=&amp;distance=&amp;belongLoggedUser=1&amp;pendingApproval=1&amp;archived=1&amp;embed=&amp;sort=created_at&amp;perPage=2" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/posts"
);

const params = {
    "op": "",
    "postId": "",
    "distance": "",
    "belongLoggedUser": "1",
    "pendingApproval": "1",
    "archived": "1",
    "embed": "",
    "sort": "created_at",
    "perPage": "2",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/posts';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'op' =&gt; '',
            'postId' =&gt; '',
            'distance' =&gt; '',
            'belongLoggedUser' =&gt; '1',
            'pendingApproval' =&gt; '1',
            'archived' =&gt; '1',
            'embed' =&gt; '',
            'sort' =&gt; 'created_at',
            'perPage' =&gt; '2',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/posts'
params = {
  'op': '',
  'postId': '',
  'distance': '',
  'belongLoggedUser': '1',
  'pendingApproval': '1',
  'archived': '1',
  'embed': '',
  'sort': 'created_at',
  'perPage': '2',
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-posts">
            <blockquote>
            <p>Example response (401):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: false,
    &quot;message&quot;: &quot;Unauthorized&quot;,
    &quot;result&quot;: null
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-posts" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-posts"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-posts"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-posts" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-posts">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-posts" data-method="GET"
      data-path="api/posts"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-posts', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-posts"
                    onclick="tryItOut('GETapi-posts');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-posts"
                    onclick="cancelTryOut('GETapi-posts');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-posts"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/posts</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-posts"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-posts"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-posts"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-posts"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-posts"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                            <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>op</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="op"                data-endpoint="GETapi-posts"
               value=""
               data-component="query">
    <br>
<p>Type of listings list (optional) - Possible value: search,premium,latest,free,premiumFirst,similar.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>postId</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="postId"                data-endpoint="GETapi-posts"
               value=""
               data-component="query">
    <br>
<p>Base Listing's ID to get similar listings (optional) - Mandatory to get similar listings (when op=similar).</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>distance</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="distance"                data-endpoint="GETapi-posts"
               value=""
               data-component="query">
    <br>
<p>Distance to get similar listings (optional) - Also optional when the type of similar listings is based on the current listing's category. Mandatory when the type of similar listings is based on the current listing's location. So, its usage is limited to get similar listings (when op=similar) based on the current listing's location.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>belongLoggedUser</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="GETapi-posts" style="display: none">
            <input type="radio" name="belongLoggedUser"
                   value="1"
                   data-endpoint="GETapi-posts"
                   data-component="query"             >
            <code>true</code>
        </label>
        <label data-endpoint="GETapi-posts" style="display: none">
            <input type="radio" name="belongLoggedUser"
                   value="0"
                   data-endpoint="GETapi-posts"
                   data-component="query"             >
            <code>false</code>
        </label>
    <br>
<p>Force users to be logged to get data that belongs to him. Authentication token needs to be sent in the header, and the &quot;op&quot; parameter needs to be null or unset - Possible value: 0 or 1. Example: <code>true</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>pendingApproval</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="GETapi-posts" style="display: none">
            <input type="radio" name="pendingApproval"
                   value="1"
                   data-endpoint="GETapi-posts"
                   data-component="query"             >
            <code>true</code>
        </label>
        <label data-endpoint="GETapi-posts" style="display: none">
            <input type="radio" name="pendingApproval"
                   value="0"
                   data-endpoint="GETapi-posts"
                   data-component="query"             >
            <code>false</code>
        </label>
    <br>
<p>To list a user's listings in pending approval. Authentication token needs to be sent in the header, and the &quot;op&quot; parameter needs to be null or unset - Possible value: 0 or 1. Example: <code>true</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>archived</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="GETapi-posts" style="display: none">
            <input type="radio" name="archived"
                   value="1"
                   data-endpoint="GETapi-posts"
                   data-component="query"             >
            <code>true</code>
        </label>
        <label data-endpoint="GETapi-posts" style="display: none">
            <input type="radio" name="archived"
                   value="0"
                   data-endpoint="GETapi-posts"
                   data-component="query"             >
            <code>false</code>
        </label>
    <br>
<p>To list a user's archived listings. Authentication token needs to be sent in the header, and the &quot;op&quot; parameter need be null or unset - Possible value: 0 or 1. Example: <code>true</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>embed</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="embed"                data-endpoint="GETapi-posts"
               value=""
               data-component="query">
    <br>
<p>Comma-separated list of the post relationships for Eager Loading - Possible values: user,category,parent,postType,city,currency,savedByLoggedUser,pictures,payment,package.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>sort</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="sort"                data-endpoint="GETapi-posts"
               value="created_at"
               data-component="query">
    <br>
<p>The sorting parameter (Order by DESC with the given column. Use &quot;-&quot; as prefix to order by ASC). Possible values: created_at. Example: <code>created_at</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>perPage</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="perPage"                data-endpoint="GETapi-posts"
               value="2"
               data-component="query">
    <br>
<p>Items per page. Can be defined globally from the admin settings. Cannot be exceeded 100. Example: <code>2</code></p>
            </div>
                </form>

                    <h2 id="listings-GETapi-posts--id-">Get listing</h2>

<p>
</p>

<p>Note: The main picture of the listing is fetched via a 'picture' attribute (added as fake column),
that provide default picture as image placeholder when the listing has no pictures.
In addition, for performance reasons, default picture is also provided when the 'pictures' table is not embed in the endpoint.
So you need to embed the picture table like: /api/posts/1?embed=pictures to retrieve right main picture data.</p>

<span id="example-requests-GETapi-posts--id-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/posts/2?unactivatedIncluded=1&amp;belongLoggedUser=&amp;noCache=&amp;embed=user%2CpostType&amp;detailed=" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/posts/2"
);

const params = {
    "unactivatedIncluded": "1",
    "belongLoggedUser": "0",
    "noCache": "0",
    "embed": "user,postType",
    "detailed": "0",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/posts/2';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'unactivatedIncluded' =&gt; '1',
            'belongLoggedUser' =&gt; '0',
            'noCache' =&gt; '0',
            'embed' =&gt; 'user,postType',
            'detailed' =&gt; '0',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/posts/2'
params = {
  'unactivatedIncluded': '1',
  'belongLoggedUser': '0',
  'noCache': '0',
  'embed': 'user,postType',
  'detailed': '0',
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-posts--id-">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;id&quot;: 2,
        &quot;country_code&quot;: &quot;US&quot;,
        &quot;user_id&quot;: 2,
        &quot;payment_id&quot;: null,
        &quot;category_id&quot;: 22,
        &quot;post_type_id&quot;: 2,
        &quot;title&quot;: &quot;HomePod red&quot;,
        &quot;description&quot;: &quot;Qui ipsum mollitia sit alias aut perspiciatis. Corrupti in rem et est ipsam voluptatem. Et harum dicta saepe animi tenetur. Fugit aut voluptatem nobis possimus ipsum sit eaque.&quot;,
        &quot;tags&quot;: [
            &quot;est&quot;,
            &quot;doloremque&quot;,
            &quot;laudantium&quot;
        ],
        &quot;price&quot;: &quot;57415.00&quot;,
        &quot;currency_code&quot;: null,
        &quot;negotiable&quot;: 0,
        &quot;contact_name&quot;: &quot;Admin Demo&quot;,
        &quot;address&quot;: null,
        &quot;city_id&quot;: 49311,
        &quot;lat&quot;: 36.3,
        &quot;lon&quot;: -119.21,
        &quot;create_from_ip&quot;: &quot;4.9.254.3&quot;,
        &quot;latest_update_ip&quot;: null,
        &quot;visits&quot;: 41,
        &quot;auth_field&quot;: &quot;email&quot;,
        &quot;email&quot;: &quot;admin@domain.tld&quot;,
        &quot;phone&quot;: &quot;+10540102569&quot;,
        &quot;phone_national&quot;: &quot;0540102569&quot;,
        &quot;phone_country&quot;: &quot;US&quot;,
        &quot;email_token&quot;: null,
        &quot;phone_token&quot;: &quot;demoFaker&quot;,
        &quot;email_verified_at&quot;: &quot;2025-06-24T17:38:45.000000Z&quot;,
        &quot;phone_verified_at&quot;: &quot;2025-06-24T17:38:45.000000Z&quot;,
        &quot;otp_expires_at&quot;: null,
        &quot;last_otp_sent_at&quot;: null,
        &quot;otp_resend_attempts&quot;: 0,
        &quot;otp_resend_attempts_expires_at&quot;: null,
        &quot;total_otp_resend_attempts&quot;: 0,
        &quot;locked_at&quot;: null,
        &quot;phone_hidden&quot;: 0,
        &quot;accept_terms&quot;: 1,
        &quot;accept_marketing_offers&quot;: 0,
        &quot;is_permanent&quot;: 0,
        &quot;featured&quot;: 0,
        &quot;tmp_token&quot;: null,
        &quot;reviewed_at&quot;: &quot;2025-06-24T17:38:45.000000Z&quot;,
        &quot;archived_at&quot;: null,
        &quot;archived_manually_at&quot;: null,
        &quot;deletion_mail_sent_at&quot;: null,
        &quot;created_at&quot;: &quot;2025-05-29T23:55:39.000000Z&quot;,
        &quot;updated_at&quot;: &quot;2025-09-08T10:06:26.000000Z&quot;,
        &quot;reference&quot;: &quot;GWpmbk5ezJn&quot;,
        &quot;slug&quot;: &quot;homepod-red&quot;,
        &quot;url&quot;: &quot;https://demo.laraclassifier.local/homepod-red/GWpmbk5ezJn&quot;,
        &quot;excerpt&quot;: &quot;Qui ipsum mollitia sit alias aut perspiciatis. Corrupti in rem et est ipsam voluptatem. Et harum dic...&quot;,
        &quot;phone_intl&quot;: &quot;0540102569&quot;,
        &quot;created_at_formatted&quot;: &quot;3 months ago&quot;,
        &quot;updated_at_formatted&quot;: &quot;Sep 8th, 2025 at 06:06&quot;,
        &quot;archived_at_formatted&quot;: &quot;&quot;,
        &quot;archived_manually_at_formatted&quot;: &quot;&quot;,
        &quot;user_photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/2/thumbnails/800x800-a7591871e7d8d1de0f705c4a915a7edf.jpg&quot;,
        &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;,
        &quot;count_pictures&quot;: 0,
        &quot;price_label&quot;: &quot;Price:&quot;,
        &quot;price_formatted&quot;: &quot;$57,415&quot;,
        &quot;visits_formatted&quot;: &quot;41 views&quot;,
        &quot;distance_info&quot;: null,
        &quot;picture&quot;: {
            &quot;id&quot;: 7,
            &quot;post_id&quot;: 2,
            &quot;file_path&quot;: &quot;files/us/2/bc5d103fa9d2fbd383c0e1fa72905f5e.jpg&quot;,
            &quot;mime_type&quot;: &quot;image/jpeg&quot;,
            &quot;position&quot;: 1,
            &quot;active&quot;: 1,
            &quot;url&quot;: {
                &quot;full&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/2/thumbnails/816x460-bc5d103fa9d2fbd383c0e1fa72905f5e.jpg&quot;,
                &quot;small&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/2/thumbnails/120x90-bc5d103fa9d2fbd383c0e1fa72905f5e.jpg&quot;,
                &quot;medium&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/2/thumbnails/320x240-bc5d103fa9d2fbd383c0e1fa72905f5e.jpg&quot;,
                &quot;large&quot;: &quot;https://demo.laraclassifier.local/storage/files/us/2/thumbnails/816x460-bc5d103fa9d2fbd383c0e1fa72905f5e.jpg&quot;
            }
        },
        &quot;user&quot;: {
            &quot;id&quot;: 2,
            &quot;name&quot;: &quot;Admin Demo&quot;,
            &quot;username&quot;: &quot;admin&quot;,
            &quot;two_factor_enabled&quot;: false,
            &quot;two_factor_method&quot;: &quot;email&quot;,
            &quot;updated_at&quot;: &quot;2025-09-08T09:29:18.000000Z&quot;,
            &quot;original_updated_at&quot;: &quot;2025-09-08 09:29:18&quot;,
            &quot;original_last_activity&quot;: &quot;2025-09-08 08:00:59&quot;,
            &quot;created_at_formatted&quot;: &quot;5 months ago&quot;,
            &quot;photo_url&quot;: &quot;https://demo.laraclassifier.local/storage/avatars/us/2/thumbnails/800x800-a7591871e7d8d1de0f705c4a915a7edf.jpg&quot;,
            &quot;p_is_online&quot;: false,
            &quot;country_flag_url&quot;: &quot;https://demo.laraclassifier.local/images/flags/rectangle/16/us.png&quot;
        },
        &quot;postType&quot;: {
            &quot;id&quot;: 2,
            &quot;name&quot;: &quot;PROFESSIONAL&quot;,
            &quot;label&quot;: &quot;Professional&quot;
        },
        &quot;rating_cache&quot;: 0,
        &quot;rating_count&quot;: 0
    },
    &quot;extra&quot;: {
        &quot;fieldsValues&quot;: []
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-posts--id-" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-posts--id-"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-posts--id-"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-posts--id-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-posts--id-">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-posts--id-" data-method="GET"
      data-path="api/posts/{id}"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-posts--id-', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-posts--id-"
                    onclick="tryItOut('GETapi-posts--id-');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-posts--id-"
                    onclick="cancelTryOut('GETapi-posts--id-');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-posts--id-"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/posts/{id}</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-posts--id-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-posts--id-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-posts--id-"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-posts--id-"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-posts--id-"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="id"                data-endpoint="GETapi-posts--id-"
               value="2"
               data-component="url">
    <br>
<p>The post/listing's ID. Example: <code>2</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>unactivatedIncluded</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="GETapi-posts--id-" style="display: none">
            <input type="radio" name="unactivatedIncluded"
                   value="1"
                   data-endpoint="GETapi-posts--id-"
                   data-component="query"             >
            <code>true</code>
        </label>
        <label data-endpoint="GETapi-posts--id-" style="display: none">
            <input type="radio" name="unactivatedIncluded"
                   value="0"
                   data-endpoint="GETapi-posts--id-"
                   data-component="query"             >
            <code>false</code>
        </label>
    <br>
<p>Include or not unactivated entries - Possible value: 0 or 1. Example: <code>true</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>belongLoggedUser</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="GETapi-posts--id-" style="display: none">
            <input type="radio" name="belongLoggedUser"
                   value="1"
                   data-endpoint="GETapi-posts--id-"
                   data-component="query"             >
            <code>true</code>
        </label>
        <label data-endpoint="GETapi-posts--id-" style="display: none">
            <input type="radio" name="belongLoggedUser"
                   value="0"
                   data-endpoint="GETapi-posts--id-"
                   data-component="query"             >
            <code>false</code>
        </label>
    <br>
<p>Force users to be logged to get data that belongs to him - Possible value: 0 or 1. Example: <code>false</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>noCache</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="GETapi-posts--id-" style="display: none">
            <input type="radio" name="noCache"
                   value="1"
                   data-endpoint="GETapi-posts--id-"
                   data-component="query"             >
            <code>true</code>
        </label>
        <label data-endpoint="GETapi-posts--id-" style="display: none">
            <input type="radio" name="noCache"
                   value="0"
                   data-endpoint="GETapi-posts--id-"
                   data-component="query"             >
            <code>false</code>
        </label>
    <br>
<p>Disable the cache for this request - Possible value: 0 or 1. Example: <code>false</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>embed</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="embed"                data-endpoint="GETapi-posts--id-"
               value="user,postType"
               data-component="query">
    <br>
<p>Comma-separated list of the post relationships for Eager Loading - Possible values: user,category,parent,postType,city,currency,savedByLoggedUser,pictures,payment,package,fieldsValues. Example: <code>user,postType</code></p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>detailed</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="GETapi-posts--id-" style="display: none">
            <input type="radio" name="detailed"
                   value="1"
                   data-endpoint="GETapi-posts--id-"
                   data-component="query"             >
            <code>true</code>
        </label>
        <label data-endpoint="GETapi-posts--id-" style="display: none">
            <input type="radio" name="detailed"
                   value="0"
                   data-endpoint="GETapi-posts--id-"
                   data-component="query"             >
            <code>false</code>
        </label>
    <br>
<p>Allow getting the listing's details with all its relationships (No need to set the 'embed' parameter). Example: <code>false</code></p>
            </div>
                </form>

                    <h2 id="listings-POSTapi-posts">Store listing</h2>

<p>
<small class="badge badge-darkred">requires authentication</small>
</p>

<p>For both types of listing's creation (Single step or Multi steps).
Note: The field 'admin_code' is only available when the listing's country's 'admin_type' column is set to 1 or 2.</p>

<span id="example-requests-POSTapi-posts">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request POST \
    "https://demo.laraclassifier.local/api/posts" \
    --header "Authorization: Bearer {YOUR_AUTH_TOKEN}" \
    --header "Content-Type: multipart/form-data" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs" \
    --form "category_id=1"\
    --form "title=John Doe"\
    --form "description=Beatae placeat atque tempore consequatur animi magni omnis."\
    --form "contact_name=John Doe"\
    --form "auth_field=email"\
    --form "phone=+17656766467"\
    --form "phone_country="\
    --form "city_id=5"\
    --form "accept_terms="\
    --form "email=john.doe@domain.tld"\
    --form "country_code=US"\
    --form "post_type_id=1"\
    --form "admin_code=0"\
    --form "price=5000"\
    --form "negotiable="\
    --form "phone_hidden="\
    --form "create_from_ip=127.0.0.1"\
    --form "accept_marketing_offers="\
    --form "is_permanent="\
    --form "tags=car,automotive,tesla,cyber,truck"\
    --form "package_id=2"\
    --form "payment_method_id=5"\
    --form "captcha_key=consectetur"\
    --form "pictures[]=@/private/var/folders/r0/k0xbnx757k3fnz09_6g9rp6w0000gn/T/php3M4aAw" </code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/posts"
);

const headers = {
    "Authorization": "Bearer {YOUR_AUTH_TOKEN}",
    "Content-Type": "multipart/form-data",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

const body = new FormData();
body.append('category_id', '1');
body.append('title', 'John Doe');
body.append('description', 'Beatae placeat atque tempore consequatur animi magni omnis.');
body.append('contact_name', 'John Doe');
body.append('auth_field', 'email');
body.append('phone', '+17656766467');
body.append('phone_country', '');
body.append('city_id', '5');
body.append('accept_terms', '');
body.append('email', 'john.doe@domain.tld');
body.append('country_code', 'US');
body.append('post_type_id', '1');
body.append('admin_code', '0');
body.append('price', '5000');
body.append('negotiable', '');
body.append('phone_hidden', '');
body.append('create_from_ip', '127.0.0.1');
body.append('accept_marketing_offers', '');
body.append('is_permanent', '');
body.append('tags', 'car,automotive,tesla,cyber,truck');
body.append('package_id', '2');
body.append('payment_method_id', '5');
body.append('captcha_key', 'consectetur');
body.append('pictures[]', document.querySelector('input[name="pictures[]"]').files[0]);

fetch(url, {
    method: "POST",
    headers,
    body,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/posts';
$response = $client-&gt;post(
    $url,
    [
        'headers' =&gt; [
            'Authorization' =&gt; 'Bearer {YOUR_AUTH_TOKEN}',
            'Content-Type' =&gt; 'multipart/form-data',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'multipart' =&gt; [
            [
                'name' =&gt; 'category_id',
                'contents' =&gt; '1'
            ],
            [
                'name' =&gt; 'title',
                'contents' =&gt; 'John Doe'
            ],
            [
                'name' =&gt; 'description',
                'contents' =&gt; 'Beatae placeat atque tempore consequatur animi magni omnis.'
            ],
            [
                'name' =&gt; 'contact_name',
                'contents' =&gt; 'John Doe'
            ],
            [
                'name' =&gt; 'auth_field',
                'contents' =&gt; 'email'
            ],
            [
                'name' =&gt; 'phone',
                'contents' =&gt; '+17656766467'
            ],
            [
                'name' =&gt; 'phone_country',
                'contents' =&gt; ''
            ],
            [
                'name' =&gt; 'city_id',
                'contents' =&gt; '5'
            ],
            [
                'name' =&gt; 'accept_terms',
                'contents' =&gt; ''
            ],
            [
                'name' =&gt; 'email',
                'contents' =&gt; 'john.doe@domain.tld'
            ],
            [
                'name' =&gt; 'country_code',
                'contents' =&gt; 'US'
            ],
            [
                'name' =&gt; 'post_type_id',
                'contents' =&gt; '1'
            ],
            [
                'name' =&gt; 'admin_code',
                'contents' =&gt; '0'
            ],
            [
                'name' =&gt; 'price',
                'contents' =&gt; '5000'
            ],
            [
                'name' =&gt; 'negotiable',
                'contents' =&gt; ''
            ],
            [
                'name' =&gt; 'phone_hidden',
                'contents' =&gt; ''
            ],
            [
                'name' =&gt; 'create_from_ip',
                'contents' =&gt; '127.0.0.1'
            ],
            [
                'name' =&gt; 'accept_marketing_offers',
                'contents' =&gt; ''
            ],
            [
                'name' =&gt; 'is_permanent',
                'contents' =&gt; ''
            ],
            [
                'name' =&gt; 'tags',
                'contents' =&gt; 'car,automotive,tesla,cyber,truck'
            ],
            [
                'name' =&gt; 'package_id',
                'contents' =&gt; '2'
            ],
            [
                'name' =&gt; 'payment_method_id',
                'contents' =&gt; '5'
            ],
            [
                'name' =&gt; 'captcha_key',
                'contents' =&gt; 'consectetur'
            ],
            [
                'name' =&gt; 'pictures[]',
                'contents' =&gt; fopen('/private/var/folders/r0/k0xbnx757k3fnz09_6g9rp6w0000gn/T/php3M4aAw', 'r')
            ],
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/posts'
files = {
  'category_id': (None, '1'),
  'title': (None, 'John Doe'),
  'description': (None, 'Beatae placeat atque tempore consequatur animi magni omnis.'),
  'contact_name': (None, 'John Doe'),
  'auth_field': (None, 'email'),
  'phone': (None, '+17656766467'),
  'phone_country': (None, ''),
  'city_id': (None, '5'),
  'accept_terms': (None, ''),
  'email': (None, 'john.doe@domain.tld'),
  'country_code': (None, 'US'),
  'post_type_id': (None, '1'),
  'admin_code': (None, '0'),
  'price': (None, '5000'),
  'negotiable': (None, ''),
  'phone_hidden': (None, ''),
  'create_from_ip': (None, '127.0.0.1'),
  'accept_marketing_offers': (None, ''),
  'is_permanent': (None, ''),
  'tags': (None, 'car,automotive,tesla,cyber,truck'),
  'package_id': (None, '2'),
  'payment_method_id': (None, '5'),
  'captcha_key': (None, 'consectetur'),
  'pictures[]': open('/private/var/folders/r0/k0xbnx757k3fnz09_6g9rp6w0000gn/T/php3M4aAw', 'rb')}
payload = {
    "category_id": 1,
    "title": "John Doe",
    "description": "Beatae placeat atque tempore consequatur animi magni omnis.",
    "contact_name": "John Doe",
    "auth_field": "email",
    "phone": "+17656766467",
    "phone_country": null,
    "city_id": 5,
    "accept_terms": false,
    "email": "john.doe@domain.tld",
    "country_code": "US",
    "post_type_id": 1,
    "admin_code": "0",
    "price": 5000,
    "negotiable": false,
    "phone_hidden": false,
    "create_from_ip": "127.0.0.1",
    "accept_marketing_offers": false,
    "is_permanent": false,
    "tags": "car,automotive,tesla,cyber,truck",
    "package_id": 2,
    "payment_method_id": 5,
    "captcha_key": "consectetur"
}
headers = {
  'Authorization': 'Bearer {YOUR_AUTH_TOKEN}',
  'Content-Type': 'multipart/form-data',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('POST', url, headers=headers, files=files)
response.json()</code></pre></div>

</span>

<span id="example-responses-POSTapi-posts">
</span>
<span id="execution-results-POSTapi-posts" hidden>
    <blockquote>Received response<span
                id="execution-response-status-POSTapi-posts"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-POSTapi-posts"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-POSTapi-posts" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-POSTapi-posts">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-POSTapi-posts" data-method="POST"
      data-path="api/posts"
      data-authed="1"
      data-hasfiles="1"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('POSTapi-posts', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-POSTapi-posts"
                    onclick="tryItOut('POSTapi-posts');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-POSTapi-posts"
                    onclick="cancelTryOut('POSTapi-posts');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-POSTapi-posts"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-black">POST</small>
            <b><code>api/posts</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Authorization</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Authorization" class="auth-value"               data-endpoint="POSTapi-posts"
               value="Bearer {YOUR_AUTH_TOKEN}"
               data-component="header">
    <br>
<p>Example: <code>Bearer {YOUR_AUTH_TOKEN}</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="POSTapi-posts"
               value="multipart/form-data"
               data-component="header">
    <br>
<p>Example: <code>multipart/form-data</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="POSTapi-posts"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="POSTapi-posts"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="POSTapi-posts"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="POSTapi-posts"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                                <h4 class="fancy-heading-panel"><b>Body Parameters</b></h4>
        <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>category_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="category_id"                data-endpoint="POSTapi-posts"
               value="1"
               data-component="body">
    <br>
<p>The category's ID. Example: <code>1</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>title</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="title"                data-endpoint="POSTapi-posts"
               value="John Doe"
               data-component="body">
    <br>
<p>The listing's title. Example: <code>John Doe</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>description</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="description"                data-endpoint="POSTapi-posts"
               value="Beatae placeat atque tempore consequatur animi magni omnis."
               data-component="body">
    <br>
<p>The listing's description. Example: <code>Beatae placeat atque tempore consequatur animi magni omnis.</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>contact_name</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="contact_name"                data-endpoint="POSTapi-posts"
               value="John Doe"
               data-component="body">
    <br>
<p>The listing's author name. Example: <code>John Doe</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>auth_field</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="auth_field"                data-endpoint="POSTapi-posts"
               value="email"
               data-component="body">
    <br>
<p>The user's auth field ('email' or 'phone'). Example: <code>email</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>phone</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="phone"                data-endpoint="POSTapi-posts"
               value="+17656766467"
               data-component="body">
    <br>
<p>The listing's author mobile number (Required when 'auth_field' value is 'phone'). Example: <code>+17656766467</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>phone_country</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="phone_country"                data-endpoint="POSTapi-posts"
               value=""
               data-component="body">
    <br>
<p>The user's phone number's country code (Required when the 'phone' field is filled).</p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>city_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="city_id"                data-endpoint="POSTapi-posts"
               value="5"
               data-component="body">
    <br>
<p>The city's ID. Example: <code>5</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>accept_terms</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
 &nbsp;
                <label data-endpoint="POSTapi-posts" style="display: none">
            <input type="radio" name="accept_terms"
                   value="true"
                   data-endpoint="POSTapi-posts"
                   data-component="body"             >
            <code>true</code>
        </label>
        <label data-endpoint="POSTapi-posts" style="display: none">
            <input type="radio" name="accept_terms"
                   value="false"
                   data-endpoint="POSTapi-posts"
                   data-component="body"             >
            <code>false</code>
        </label>
    <br>
<p>Accept the website terms and conditions. Example: <code>false</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>pictures</code></b>&nbsp;&nbsp;
<small>file[]</small>&nbsp;
 &nbsp;
                <input type="file" style="display: none"
                              name="pictures[0]"                data-endpoint="POSTapi-posts"
               data-component="body">
        <input type="file" style="display: none"
               name="pictures[1]"                data-endpoint="POSTapi-posts"
               data-component="body">
    <br>
<p>The listing's pictures.</p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>email</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="email"                data-endpoint="POSTapi-posts"
               value="john.doe@domain.tld"
               data-component="body">
    <br>
<p>The listing's author email address (Required when 'auth_field' value is 'email'). Example: <code>john.doe@domain.tld</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>country_code</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="country_code"                data-endpoint="POSTapi-posts"
               value="US"
               data-component="body">
    <br>
<p>The code of the user's country. Example: <code>US</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>post_type_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="post_type_id"                data-endpoint="POSTapi-posts"
               value="1"
               data-component="body">
    <br>
<p>The listing type's ID. Example: <code>1</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>admin_code</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="admin_code"                data-endpoint="POSTapi-posts"
               value="0"
               data-component="body">
    <br>
<p>The administrative division's code. Example: <code>0</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>price</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="price"                data-endpoint="POSTapi-posts"
               value="5000"
               data-component="body">
    <br>
<p>The price. Example: <code>5000</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>negotiable</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="POSTapi-posts" style="display: none">
            <input type="radio" name="negotiable"
                   value="true"
                   data-endpoint="POSTapi-posts"
                   data-component="body"             >
            <code>true</code>
        </label>
        <label data-endpoint="POSTapi-posts" style="display: none">
            <input type="radio" name="negotiable"
                   value="false"
                   data-endpoint="POSTapi-posts"
                   data-component="body"             >
            <code>false</code>
        </label>
    <br>
<p>Negotiable price or no. Example: <code>false</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>phone_hidden</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="POSTapi-posts" style="display: none">
            <input type="radio" name="phone_hidden"
                   value="true"
                   data-endpoint="POSTapi-posts"
                   data-component="body"             >
            <code>true</code>
        </label>
        <label data-endpoint="POSTapi-posts" style="display: none">
            <input type="radio" name="phone_hidden"
                   value="false"
                   data-endpoint="POSTapi-posts"
                   data-component="body"             >
            <code>false</code>
        </label>
    <br>
<p>Mobile phone number will be hidden in public or no. Example: <code>false</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>create_from_ip</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="create_from_ip"                data-endpoint="POSTapi-posts"
               value="127.0.0.1"
               data-component="body">
    <br>
<p>The listing's author IP address. Example: <code>127.0.0.1</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>accept_marketing_offers</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="POSTapi-posts" style="display: none">
            <input type="radio" name="accept_marketing_offers"
                   value="true"
                   data-endpoint="POSTapi-posts"
                   data-component="body"             >
            <code>true</code>
        </label>
        <label data-endpoint="POSTapi-posts" style="display: none">
            <input type="radio" name="accept_marketing_offers"
                   value="false"
                   data-endpoint="POSTapi-posts"
                   data-component="body"             >
            <code>false</code>
        </label>
    <br>
<p>Accept to receive marketing offers or no. Example: <code>false</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>is_permanent</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="POSTapi-posts" style="display: none">
            <input type="radio" name="is_permanent"
                   value="true"
                   data-endpoint="POSTapi-posts"
                   data-component="body"             >
            <code>true</code>
        </label>
        <label data-endpoint="POSTapi-posts" style="display: none">
            <input type="radio" name="is_permanent"
                   value="false"
                   data-endpoint="POSTapi-posts"
                   data-component="body"             >
            <code>false</code>
        </label>
    <br>
<p>Is it permanent post or no. Example: <code>false</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>tags</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="tags"                data-endpoint="POSTapi-posts"
               value="car,automotive,tesla,cyber,truck"
               data-component="body">
    <br>
<p>Comma-separated tags list. Example: <code>car,automotive,tesla,cyber,truck</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>package_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="package_id"                data-endpoint="POSTapi-posts"
               value="2"
               data-component="body">
    <br>
<p>The package's ID. Example: <code>2</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>payment_method_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="payment_method_id"                data-endpoint="POSTapi-posts"
               value="5"
               data-component="body">
    <br>
<p>The payment method's ID (required when the selected package's price is &gt; 0). Example: <code>5</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>captcha_key</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="captcha_key"                data-endpoint="POSTapi-posts"
               value="consectetur"
               data-component="body">
    <br>
<p>Key generated by the CAPTCHA endpoint calling (Required when the CAPTCHA verification is enabled from the Admin panel). Example: <code>consectetur</code></p>
        </div>
        </form>

                    <h2 id="listings-PUTapi-posts--id-">Update listing</h2>

<p>
<small class="badge badge-darkred">requires authentication</small>
</p>

<p>Note: The fields 'pictures', 'package_id' and 'payment_method_id' are only available with the single step listing edition.
The field 'admin_code' is only available when the listing's country's 'admin_type' column is set to 1 or 2.</p>

<span id="example-requests-PUTapi-posts--id-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request PUT \
    "https://demo.laraclassifier.local/api/posts/15" \
    --header "Authorization: Bearer {YOUR_AUTH_TOKEN}" \
    --header "Content-Type: multipart/form-data" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs" \
    --form "category_id=1"\
    --form "title=John Doe"\
    --form "description=Beatae placeat atque tempore consequatur animi magni omnis."\
    --form "contact_name=John Doe"\
    --form "auth_field=email"\
    --form "phone=+17656766467"\
    --form "phone_country="\
    --form "city_id=1"\
    --form "accept_terms="\
    --form "email=john.doe@domain.tld"\
    --form "country_code=US"\
    --form "post_type_id=1"\
    --form "admin_code=0"\
    --form "price=5000"\
    --form "negotiable="\
    --form "phone_hidden="\
    --form "latest_update_ip=127.0.0.1"\
    --form "accept_marketing_offers="\
    --form "is_permanent=1"\
    --form "tags=car,automotive,tesla,cyber,truck"\
    --form "package_id=2"\
    --form "payment_method_id=5"\
    --form "pictures[]=@/private/var/folders/r0/k0xbnx757k3fnz09_6g9rp6w0000gn/T/phpNJbKqD" </code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/posts/15"
);

const headers = {
    "Authorization": "Bearer {YOUR_AUTH_TOKEN}",
    "Content-Type": "multipart/form-data",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

const body = new FormData();
body.append('category_id', '1');
body.append('title', 'John Doe');
body.append('description', 'Beatae placeat atque tempore consequatur animi magni omnis.');
body.append('contact_name', 'John Doe');
body.append('auth_field', 'email');
body.append('phone', '+17656766467');
body.append('phone_country', '');
body.append('city_id', '1');
body.append('accept_terms', '');
body.append('email', 'john.doe@domain.tld');
body.append('country_code', 'US');
body.append('post_type_id', '1');
body.append('admin_code', '0');
body.append('price', '5000');
body.append('negotiable', '');
body.append('phone_hidden', '');
body.append('latest_update_ip', '127.0.0.1');
body.append('accept_marketing_offers', '');
body.append('is_permanent', '1');
body.append('tags', 'car,automotive,tesla,cyber,truck');
body.append('package_id', '2');
body.append('payment_method_id', '5');
body.append('pictures[]', document.querySelector('input[name="pictures[]"]').files[0]);

fetch(url, {
    method: "PUT",
    headers,
    body,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/posts/15';
$response = $client-&gt;put(
    $url,
    [
        'headers' =&gt; [
            'Authorization' =&gt; 'Bearer {YOUR_AUTH_TOKEN}',
            'Content-Type' =&gt; 'multipart/form-data',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'multipart' =&gt; [
            [
                'name' =&gt; 'category_id',
                'contents' =&gt; '1'
            ],
            [
                'name' =&gt; 'title',
                'contents' =&gt; 'John Doe'
            ],
            [
                'name' =&gt; 'description',
                'contents' =&gt; 'Beatae placeat atque tempore consequatur animi magni omnis.'
            ],
            [
                'name' =&gt; 'contact_name',
                'contents' =&gt; 'John Doe'
            ],
            [
                'name' =&gt; 'auth_field',
                'contents' =&gt; 'email'
            ],
            [
                'name' =&gt; 'phone',
                'contents' =&gt; '+17656766467'
            ],
            [
                'name' =&gt; 'phone_country',
                'contents' =&gt; ''
            ],
            [
                'name' =&gt; 'city_id',
                'contents' =&gt; '1'
            ],
            [
                'name' =&gt; 'accept_terms',
                'contents' =&gt; ''
            ],
            [
                'name' =&gt; 'email',
                'contents' =&gt; 'john.doe@domain.tld'
            ],
            [
                'name' =&gt; 'country_code',
                'contents' =&gt; 'US'
            ],
            [
                'name' =&gt; 'post_type_id',
                'contents' =&gt; '1'
            ],
            [
                'name' =&gt; 'admin_code',
                'contents' =&gt; '0'
            ],
            [
                'name' =&gt; 'price',
                'contents' =&gt; '5000'
            ],
            [
                'name' =&gt; 'negotiable',
                'contents' =&gt; ''
            ],
            [
                'name' =&gt; 'phone_hidden',
                'contents' =&gt; ''
            ],
            [
                'name' =&gt; 'latest_update_ip',
                'contents' =&gt; '127.0.0.1'
            ],
            [
                'name' =&gt; 'accept_marketing_offers',
                'contents' =&gt; ''
            ],
            [
                'name' =&gt; 'is_permanent',
                'contents' =&gt; '1'
            ],
            [
                'name' =&gt; 'tags',
                'contents' =&gt; 'car,automotive,tesla,cyber,truck'
            ],
            [
                'name' =&gt; 'package_id',
                'contents' =&gt; '2'
            ],
            [
                'name' =&gt; 'payment_method_id',
                'contents' =&gt; '5'
            ],
            [
                'name' =&gt; 'pictures[]',
                'contents' =&gt; fopen('/private/var/folders/r0/k0xbnx757k3fnz09_6g9rp6w0000gn/T/phpNJbKqD', 'r')
            ],
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/posts/15'
files = {
  'category_id': (None, '1'),
  'title': (None, 'John Doe'),
  'description': (None, 'Beatae placeat atque tempore consequatur animi magni omnis.'),
  'contact_name': (None, 'John Doe'),
  'auth_field': (None, 'email'),
  'phone': (None, '+17656766467'),
  'phone_country': (None, ''),
  'city_id': (None, '1'),
  'accept_terms': (None, ''),
  'email': (None, 'john.doe@domain.tld'),
  'country_code': (None, 'US'),
  'post_type_id': (None, '1'),
  'admin_code': (None, '0'),
  'price': (None, '5000'),
  'negotiable': (None, ''),
  'phone_hidden': (None, ''),
  'latest_update_ip': (None, '127.0.0.1'),
  'accept_marketing_offers': (None, ''),
  'is_permanent': (None, '1'),
  'tags': (None, 'car,automotive,tesla,cyber,truck'),
  'package_id': (None, '2'),
  'payment_method_id': (None, '5'),
  'pictures[]': open('/private/var/folders/r0/k0xbnx757k3fnz09_6g9rp6w0000gn/T/phpNJbKqD', 'rb')}
payload = {
    "category_id": 1,
    "title": "John Doe",
    "description": "Beatae placeat atque tempore consequatur animi magni omnis.",
    "contact_name": "John Doe",
    "auth_field": "email",
    "phone": "+17656766467",
    "phone_country": null,
    "city_id": 1,
    "accept_terms": false,
    "email": "john.doe@domain.tld",
    "country_code": "US",
    "post_type_id": 1,
    "admin_code": "0",
    "price": 5000,
    "negotiable": false,
    "phone_hidden": false,
    "latest_update_ip": "127.0.0.1",
    "accept_marketing_offers": false,
    "is_permanent": true,
    "tags": "car,automotive,tesla,cyber,truck",
    "package_id": 2,
    "payment_method_id": 5
}
headers = {
  'Authorization': 'Bearer {YOUR_AUTH_TOKEN}',
  'Content-Type': 'multipart/form-data',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('PUT', url, headers=headers, files=files)
response.json()</code></pre></div>

</span>

<span id="example-responses-PUTapi-posts--id-">
</span>
<span id="execution-results-PUTapi-posts--id-" hidden>
    <blockquote>Received response<span
                id="execution-response-status-PUTapi-posts--id-"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-PUTapi-posts--id-"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-PUTapi-posts--id-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-PUTapi-posts--id-">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-PUTapi-posts--id-" data-method="PUT"
      data-path="api/posts/{id}"
      data-authed="1"
      data-hasfiles="1"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('PUTapi-posts--id-', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-PUTapi-posts--id-"
                    onclick="tryItOut('PUTapi-posts--id-');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-PUTapi-posts--id-"
                    onclick="cancelTryOut('PUTapi-posts--id-');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-PUTapi-posts--id-"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-darkblue">PUT</small>
            <b><code>api/posts/{id}</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Authorization</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Authorization" class="auth-value"               data-endpoint="PUTapi-posts--id-"
               value="Bearer {YOUR_AUTH_TOKEN}"
               data-component="header">
    <br>
<p>Example: <code>Bearer {YOUR_AUTH_TOKEN}</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="PUTapi-posts--id-"
               value="multipart/form-data"
               data-component="header">
    <br>
<p>Example: <code>multipart/form-data</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="PUTapi-posts--id-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="PUTapi-posts--id-"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="PUTapi-posts--id-"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="PUTapi-posts--id-"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="id"                data-endpoint="PUTapi-posts--id-"
               value="15"
               data-component="url">
    <br>
<p>The post/listing's ID. Example: <code>15</code></p>
            </div>
                            <h4 class="fancy-heading-panel"><b>Body Parameters</b></h4>
        <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>category_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="category_id"                data-endpoint="PUTapi-posts--id-"
               value="1"
               data-component="body">
    <br>
<p>The category's ID. Example: <code>1</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>title</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="title"                data-endpoint="PUTapi-posts--id-"
               value="John Doe"
               data-component="body">
    <br>
<p>The listing's title. Example: <code>John Doe</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>description</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="description"                data-endpoint="PUTapi-posts--id-"
               value="Beatae placeat atque tempore consequatur animi magni omnis."
               data-component="body">
    <br>
<p>The listing's description. Example: <code>Beatae placeat atque tempore consequatur animi magni omnis.</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>contact_name</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="contact_name"                data-endpoint="PUTapi-posts--id-"
               value="John Doe"
               data-component="body">
    <br>
<p>The listing's author name. Example: <code>John Doe</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>auth_field</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="auth_field"                data-endpoint="PUTapi-posts--id-"
               value="email"
               data-component="body">
    <br>
<p>The user's auth field ('email' or 'phone'). Example: <code>email</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>phone</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="phone"                data-endpoint="PUTapi-posts--id-"
               value="+17656766467"
               data-component="body">
    <br>
<p>The listing's author mobile number (Required when 'auth_field' value is 'phone'). Example: <code>+17656766467</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>phone_country</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="phone_country"                data-endpoint="PUTapi-posts--id-"
               value=""
               data-component="body">
    <br>
<p>The user's phone number's country code (Required when the 'phone' field is filled).</p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>city_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="city_id"                data-endpoint="PUTapi-posts--id-"
               value="1"
               data-component="body">
    <br>
<p>The city's ID. Example: <code>1</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>accept_terms</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
 &nbsp;
                <label data-endpoint="PUTapi-posts--id-" style="display: none">
            <input type="radio" name="accept_terms"
                   value="true"
                   data-endpoint="PUTapi-posts--id-"
                   data-component="body"             >
            <code>true</code>
        </label>
        <label data-endpoint="PUTapi-posts--id-" style="display: none">
            <input type="radio" name="accept_terms"
                   value="false"
                   data-endpoint="PUTapi-posts--id-"
                   data-component="body"             >
            <code>false</code>
        </label>
    <br>
<p>Accept the website terms and conditions. Example: <code>false</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>email</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="email"                data-endpoint="PUTapi-posts--id-"
               value="john.doe@domain.tld"
               data-component="body">
    <br>
<p>The listing's author email address (Required when 'auth_field' value is 'email'). Example: <code>john.doe@domain.tld</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>country_code</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="country_code"                data-endpoint="PUTapi-posts--id-"
               value="US"
               data-component="body">
    <br>
<p>The code of the user's country. Example: <code>US</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>post_type_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="post_type_id"                data-endpoint="PUTapi-posts--id-"
               value="1"
               data-component="body">
    <br>
<p>The listing type's ID. Example: <code>1</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>admin_code</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="admin_code"                data-endpoint="PUTapi-posts--id-"
               value="0"
               data-component="body">
    <br>
<p>The administrative division's code. Example: <code>0</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>price</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="price"                data-endpoint="PUTapi-posts--id-"
               value="5000"
               data-component="body">
    <br>
<p>The price. Example: <code>5000</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>negotiable</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="PUTapi-posts--id-" style="display: none">
            <input type="radio" name="negotiable"
                   value="true"
                   data-endpoint="PUTapi-posts--id-"
                   data-component="body"             >
            <code>true</code>
        </label>
        <label data-endpoint="PUTapi-posts--id-" style="display: none">
            <input type="radio" name="negotiable"
                   value="false"
                   data-endpoint="PUTapi-posts--id-"
                   data-component="body"             >
            <code>false</code>
        </label>
    <br>
<p>Negotiable price or no. Example: <code>false</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>phone_hidden</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="PUTapi-posts--id-" style="display: none">
            <input type="radio" name="phone_hidden"
                   value="true"
                   data-endpoint="PUTapi-posts--id-"
                   data-component="body"             >
            <code>true</code>
        </label>
        <label data-endpoint="PUTapi-posts--id-" style="display: none">
            <input type="radio" name="phone_hidden"
                   value="false"
                   data-endpoint="PUTapi-posts--id-"
                   data-component="body"             >
            <code>false</code>
        </label>
    <br>
<p>Mobile phone number will be hidden in public or no. Example: <code>false</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>latest_update_ip</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="latest_update_ip"                data-endpoint="PUTapi-posts--id-"
               value="127.0.0.1"
               data-component="body">
    <br>
<p>The listing's author IP address. Example: <code>127.0.0.1</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>accept_marketing_offers</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="PUTapi-posts--id-" style="display: none">
            <input type="radio" name="accept_marketing_offers"
                   value="true"
                   data-endpoint="PUTapi-posts--id-"
                   data-component="body"             >
            <code>true</code>
        </label>
        <label data-endpoint="PUTapi-posts--id-" style="display: none">
            <input type="radio" name="accept_marketing_offers"
                   value="false"
                   data-endpoint="PUTapi-posts--id-"
                   data-component="body"             >
            <code>false</code>
        </label>
    <br>
<p>Accept to receive marketing offers or no. Example: <code>false</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>is_permanent</code></b>&nbsp;&nbsp;
<small>boolean</small>&nbsp;
<i>optional</i> &nbsp;
                <label data-endpoint="PUTapi-posts--id-" style="display: none">
            <input type="radio" name="is_permanent"
                   value="true"
                   data-endpoint="PUTapi-posts--id-"
                   data-component="body"             >
            <code>true</code>
        </label>
        <label data-endpoint="PUTapi-posts--id-" style="display: none">
            <input type="radio" name="is_permanent"
                   value="false"
                   data-endpoint="PUTapi-posts--id-"
                   data-component="body"             >
            <code>false</code>
        </label>
    <br>
<p>Is it permanent post or no. Example: <code>true</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>tags</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="tags"                data-endpoint="PUTapi-posts--id-"
               value="car,automotive,tesla,cyber,truck"
               data-component="body">
    <br>
<p>Comma-separated tags list. Example: <code>car,automotive,tesla,cyber,truck</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>pictures</code></b>&nbsp;&nbsp;
<small>file[]</small>&nbsp;
 &nbsp;
                <input type="file" style="display: none"
                              name="pictures[0]"                data-endpoint="PUTapi-posts--id-"
               data-component="body">
        <input type="file" style="display: none"
               name="pictures[1]"                data-endpoint="PUTapi-posts--id-"
               data-component="body">
    <br>
<p>The listing's pictures.</p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>package_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
 &nbsp;
                <input type="number" style="display: none"
               step="any"               name="package_id"                data-endpoint="PUTapi-posts--id-"
               value="2"
               data-component="body">
    <br>
<p>The package's ID. Example: <code>2</code></p>
        </div>
                <div style=" padding-left: 28px;  clear: unset;">
            <b style="line-height: 2;"><code>payment_method_id</code></b>&nbsp;&nbsp;
<small>integer</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="number" style="display: none"
               step="any"               name="payment_method_id"                data-endpoint="PUTapi-posts--id-"
               value="5"
               data-component="body">
    <br>
<p>The payment method's ID (Required when the selected package's price is &gt; 0). Example: <code>5</code></p>
        </div>
        </form>

                    <h2 id="listings-DELETEapi-posts--ids-">Delete listing(s)</h2>

<p>
<small class="badge badge-darkred">requires authentication</small>
</p>



<span id="example-requests-DELETEapi-posts--ids-">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request DELETE \
    "https://demo.laraclassifier.local/api/posts/111111,222222,333333" \
    --header "Authorization: Bearer {YOUR_AUTH_TOKEN}" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/posts/111111,222222,333333"
);

const headers = {
    "Authorization": "Bearer {YOUR_AUTH_TOKEN}",
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "DELETE",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/posts/111111,222222,333333';
$response = $client-&gt;delete(
    $url,
    [
        'headers' =&gt; [
            'Authorization' =&gt; 'Bearer {YOUR_AUTH_TOKEN}',
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/posts/111111,222222,333333'
headers = {
  'Authorization': 'Bearer {YOUR_AUTH_TOKEN}',
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('DELETE', url, headers=headers)
response.json()</code></pre></div>

</span>

<span id="example-responses-DELETEapi-posts--ids-">
</span>
<span id="execution-results-DELETEapi-posts--ids-" hidden>
    <blockquote>Received response<span
                id="execution-response-status-DELETEapi-posts--ids-"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-DELETEapi-posts--ids-"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-DELETEapi-posts--ids-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-DELETEapi-posts--ids-">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-DELETEapi-posts--ids-" data-method="DELETE"
      data-path="api/posts/{ids}"
      data-authed="1"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('DELETEapi-posts--ids-', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-DELETEapi-posts--ids-"
                    onclick="tryItOut('DELETEapi-posts--ids-');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-DELETEapi-posts--ids-"
                    onclick="cancelTryOut('DELETEapi-posts--ids-');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-DELETEapi-posts--ids-"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-red">DELETE</small>
            <b><code>api/posts/{ids}</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Authorization</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Authorization" class="auth-value"               data-endpoint="DELETEapi-posts--ids-"
               value="Bearer {YOUR_AUTH_TOKEN}"
               data-component="header">
    <br>
<p>Example: <code>Bearer {YOUR_AUTH_TOKEN}</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="DELETEapi-posts--ids-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="DELETEapi-posts--ids-"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="DELETEapi-posts--ids-"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="DELETEapi-posts--ids-"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="DELETEapi-posts--ids-"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                        <h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>ids</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="ids"                data-endpoint="DELETEapi-posts--ids-"
               value="111111,222222,333333"
               data-component="url">
    <br>
<p>The ID or comma-separated IDs list of listing(s). Example: <code>111111,222222,333333</code></p>
            </div>
                    </form>

                <h1 id="packages">Packages</h1>

    

                                <h2 id="packages-GETapi-packages-promotion">List packages</h2>

<p>
</p>



<span id="example-requests-GETapi-packages-promotion">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/packages/promotion?embed=&amp;sort=-lft" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/packages/promotion"
);

const params = {
    "embed": "",
    "sort": "-lft",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/packages/promotion';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'embed' =&gt; '',
            'sort' =&gt; '-lft',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/packages/promotion'
params = {
  'embed': '',
  'sort': '-lft',
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-packages-promotion">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;data&quot;: [
            {
                &quot;id&quot;: 3,
                &quot;type&quot;: &quot;promotion&quot;,
                &quot;name&quot;: &quot;Premium Listing (+)&quot;,
                &quot;short_name&quot;: &quot;Premium+&quot;,
                &quot;ribbon&quot;: &quot;success&quot;,
                &quot;has_badge&quot;: 1,
                &quot;price&quot;: &quot;9.00&quot;,
                &quot;currency_code&quot;: &quot;USD&quot;,
                &quot;promotion_time&quot;: 30,
                &quot;interval&quot;: null,
                &quot;listings_limit&quot;: null,
                &quot;pictures_limit&quot;: 15,
                &quot;expiration_time&quot;: 120,
                &quot;description&quot;: &quot;Featured on the homepage\nFeatured in the category&quot;,
                &quot;facebook_ads_duration&quot;: 0,
                &quot;google_ads_duration&quot;: 0,
                &quot;twitter_ads_duration&quot;: 0,
                &quot;linkedin_ads_duration&quot;: 0,
                &quot;recommended&quot;: 0,
                &quot;active&quot;: 1,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 5,
                &quot;rgt&quot;: 6,
                &quot;depth&quot;: 0,
                &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                &quot;period_end&quot;: &quot;2025-10-08T23:59:59.999999Z&quot;,
                &quot;description_array&quot;: [
                    &quot;30 days of promotion&quot;,
                    &quot;Up to 15 images allowed&quot;,
                    &quot;Featured on the homepage&quot;,
                    &quot;Featured in the category&quot;,
                    &quot;Keep online for 120 days&quot;
                ],
                &quot;description_string&quot;: &quot;30 days of promotion. \nUp to 15 images allowed. \nFeatured on the homepage. \nFeatured in the category. \nKeep online for 120 days&quot;,
                &quot;price_formatted&quot;: &quot;$9&quot;
            },
            {
                &quot;id&quot;: 2,
                &quot;type&quot;: &quot;promotion&quot;,
                &quot;name&quot;: &quot;Premium Listing&quot;,
                &quot;short_name&quot;: &quot;Premium&quot;,
                &quot;ribbon&quot;: &quot;warning&quot;,
                &quot;has_badge&quot;: 1,
                &quot;price&quot;: &quot;7.50&quot;,
                &quot;currency_code&quot;: &quot;USD&quot;,
                &quot;promotion_time&quot;: 7,
                &quot;interval&quot;: null,
                &quot;listings_limit&quot;: null,
                &quot;pictures_limit&quot;: 10,
                &quot;expiration_time&quot;: 60,
                &quot;description&quot;: &quot;Featured on the homepage\nFeatured in the category&quot;,
                &quot;facebook_ads_duration&quot;: 0,
                &quot;google_ads_duration&quot;: 0,
                &quot;twitter_ads_duration&quot;: 0,
                &quot;linkedin_ads_duration&quot;: 0,
                &quot;recommended&quot;: 1,
                &quot;active&quot;: 1,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 3,
                &quot;rgt&quot;: 4,
                &quot;depth&quot;: 0,
                &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                &quot;period_end&quot;: &quot;2025-09-15T23:59:59.999999Z&quot;,
                &quot;description_array&quot;: [
                    &quot;7 days of promotion&quot;,
                    &quot;Up to 10 images allowed&quot;,
                    &quot;Featured on the homepage&quot;,
                    &quot;Featured in the category&quot;,
                    &quot;Keep online for 60 days&quot;
                ],
                &quot;description_string&quot;: &quot;7 days of promotion. \nUp to 10 images allowed. \nFeatured on the homepage. \nFeatured in the category. \nKeep online for 60 days&quot;,
                &quot;price_formatted&quot;: &quot;$7.50&quot;
            },
            {
                &quot;id&quot;: 1,
                &quot;type&quot;: &quot;promotion&quot;,
                &quot;name&quot;: &quot;Free&quot;,
                &quot;short_name&quot;: &quot;Free&quot;,
                &quot;ribbon&quot;: &quot;danger&quot;,
                &quot;has_badge&quot;: 1,
                &quot;price&quot;: &quot;0.00&quot;,
                &quot;currency_code&quot;: &quot;USD&quot;,
                &quot;promotion_time&quot;: null,
                &quot;interval&quot;: null,
                &quot;listings_limit&quot;: null,
                &quot;pictures_limit&quot;: null,
                &quot;expiration_time&quot;: null,
                &quot;description&quot;: &quot;&quot;,
                &quot;facebook_ads_duration&quot;: 0,
                &quot;google_ads_duration&quot;: 0,
                &quot;twitter_ads_duration&quot;: 0,
                &quot;linkedin_ads_duration&quot;: 0,
                &quot;recommended&quot;: 0,
                &quot;active&quot;: 1,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 1,
                &quot;rgt&quot;: 2,
                &quot;depth&quot;: 0,
                &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                &quot;period_end&quot;: &quot;2025-10-08T23:59:59.999999Z&quot;,
                &quot;description_array&quot;: [
                    &quot;Up to 6 images allowed&quot;,
                    &quot;Keep online for 30 days&quot;
                ],
                &quot;description_string&quot;: &quot;Up to 6 images allowed. \nKeep online for 30 days&quot;,
                &quot;price_formatted&quot;: &quot;$0&quot;
            }
        ]
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-packages-promotion" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-packages-promotion"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-packages-promotion"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-packages-promotion" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-packages-promotion">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-packages-promotion" data-method="GET"
      data-path="api/packages/promotion"
      data-authed="0"
      data-hasfiles="0"
      data-isarraybody="0"
      autocomplete="off"
      onsubmit="event.preventDefault(); executeTryOut('GETapi-packages-promotion', this);">
    <h3>
        Request&nbsp;&nbsp;&nbsp;
                    <button type="button"
                    style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-tryout-GETapi-packages-promotion"
                    onclick="tryItOut('GETapi-packages-promotion');">Try it out ⚡
            </button>
            <button type="button"
                    style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-canceltryout-GETapi-packages-promotion"
                    onclick="cancelTryOut('GETapi-packages-promotion');" hidden>Cancel 🛑
            </button>&nbsp;&nbsp;
            <button type="submit"
                    style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;"
                    id="btn-executetryout-GETapi-packages-promotion"
                    data-initial-text="Send Request 💥"
                    data-loading-text="⏱ Sending..."
                    hidden>Send Request 💥
            </button>
            </h3>
            <p>
            <small class="badge badge-green">GET</small>
            <b><code>api/packages/promotion</code></b>
        </p>
                <h4 class="fancy-heading-panel"><b>Headers</b></h4>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Type</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Type"                data-endpoint="GETapi-packages-promotion"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Accept</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Accept"                data-endpoint="GETapi-packages-promotion"
               value="application/json"
               data-component="header">
    <br>
<p>Example: <code>application/json</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>Content-Language</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="Content-Language"                data-endpoint="GETapi-packages-promotion"
               value="en"
               data-component="header">
    <br>
<p>Example: <code>en</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppApiToken</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppApiToken"                data-endpoint="GETapi-packages-promotion"
               value="Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs="
               data-component="header">
    <br>
<p>Example: <code>Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=</code></p>
            </div>
                                <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>X-AppType</code></b>&nbsp;&nbsp;
&nbsp;
 &nbsp;
                <input type="text" style="display: none"
                              name="X-AppType"                data-endpoint="GETapi-packages-promotion"
               value="docs"
               data-component="header">
    <br>
<p>Example: <code>docs</code></p>
            </div>
                            <h4 class="fancy-heading-panel"><b>Query Parameters</b></h4>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>embed</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="embed"                data-endpoint="GETapi-packages-promotion"
               value=""
               data-component="query">
    <br>
<p>Comma-separated list of the package relationships for Eager Loading - Possible values: currency.</p>
            </div>
                                    <div style="padding-left: 28px; clear: unset;">
                <b style="line-height: 2;"><code>sort</code></b>&nbsp;&nbsp;
<small>string</small>&nbsp;
<i>optional</i> &nbsp;
                <input type="text" style="display: none"
                              name="sort"                data-endpoint="GETapi-packages-promotion"
               value="-lft"
               data-component="query">
    <br>
<p>The sorting parameter (Order by DESC with the given column. Use &quot;-&quot; as prefix to order by ASC). Possible values: lft. Example: <code>-lft</code></p>
            </div>
                </form>

                    <h2 id="packages-GETapi-packages-subscription">List packages</h2>

<p>
</p>



<span id="example-requests-GETapi-packages-subscription">
<blockquote>Example request:</blockquote>


<div class="bash-example">
    <pre><code class="language-bash">curl --request GET \
    --get "https://demo.laraclassifier.local/api/packages/subscription?embed=&amp;sort=-lft" \
    --header "Content-Type: application/json" \
    --header "Accept: application/json" \
    --header "Content-Language: en" \
    --header "X-AppApiToken: Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=" \
    --header "X-AppType: docs"</code></pre></div>


<div class="javascript-example">
    <pre><code class="language-javascript">const url = new URL(
    "https://demo.laraclassifier.local/api/packages/subscription"
);

const params = {
    "embed": "",
    "sort": "-lft",
};
Object.keys(params)
    .forEach(key =&gt; url.searchParams.append(key, params[key]));

const headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=",
    "X-AppType": "docs",
};

fetch(url, {
    method: "GET",
    headers,
}).then(response =&gt; response.json());</code></pre></div>


<div class="php-example">
    <pre><code class="language-php">$client = new \GuzzleHttp\Client();
$url = 'https://demo.laraclassifier.local/api/packages/subscription';
$response = $client-&gt;get(
    $url,
    [
        'headers' =&gt; [
            'Content-Type' =&gt; 'application/json',
            'Accept' =&gt; 'application/json',
            'Content-Language' =&gt; 'en',
            'X-AppApiToken' =&gt; 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
            'X-AppType' =&gt; 'docs',
        ],
        'query' =&gt; [
            'embed' =&gt; '',
            'sort' =&gt; '-lft',
        ],
    ]
);
$body = $response-&gt;getBody();
print_r(json_decode((string) $body));</code></pre></div>


<div class="python-example">
    <pre><code class="language-python">import requests
import json

url = 'https://demo.laraclassifier.local/api/packages/subscription'
params = {
  'embed': '',
  'sort': '-lft',
}
headers = {
  'Content-Type': 'application/json',
  'Accept': 'application/json',
  'Content-Language': 'en',
  'X-AppApiToken': 'Uk1DSFlVUVhIRXpHbWt6d2pIZjlPTG15akRPN2tJTUs=',
  'X-AppType': 'docs'
}

response = requests.request('GET', url, headers=headers, params=params)
response.json()</code></pre></div>

</span>

<span id="example-responses-GETapi-packages-subscription">
            <blockquote>
            <p>Example response (200):</p>
        </blockquote>
                <details class="annotation">
            <summary style="cursor: pointer;">
                <small onclick="textContent = parentElement.parentElement.open ? 'Show headers' : 'Hide headers'">Show headers</small>
            </summary>
            <pre><code class="language-http">content-type: application/json; charset=UTF-8
cache-control: no-cache, private
vary: Origin
 </code></pre></details>         <pre>

<code class="language-json" style="max-height: 300px;">{
    &quot;success&quot;: true,
    &quot;message&quot;: null,
    &quot;result&quot;: {
        &quot;data&quot;: [
            {
                &quot;id&quot;: 5,
                &quot;type&quot;: &quot;subscription&quot;,
                &quot;name&quot;: &quot;Premium&quot;,
                &quot;short_name&quot;: &quot;Premium&quot;,
                &quot;ribbon&quot;: null,
                &quot;has_badge&quot;: 0,
                &quot;price&quot;: &quot;9.00&quot;,
                &quot;currency_code&quot;: &quot;USD&quot;,
                &quot;promotion_time&quot;: null,
                &quot;interval&quot;: &quot;month&quot;,
                &quot;listings_limit&quot;: 100,
                &quot;pictures_limit&quot;: 10,
                &quot;expiration_time&quot;: 90,
                &quot;description&quot;: &quot;&quot;,
                &quot;facebook_ads_duration&quot;: 0,
                &quot;google_ads_duration&quot;: 0,
                &quot;twitter_ads_duration&quot;: 0,
                &quot;linkedin_ads_duration&quot;: 0,
                &quot;recommended&quot;: 1,
                &quot;active&quot;: 1,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 9,
                &quot;rgt&quot;: 10,
                &quot;depth&quot;: 0,
                &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                &quot;period_end&quot;: &quot;2025-10-08T23:59:59.999999Z&quot;,
                &quot;description_array&quot;: [
                    &quot;Publish up to 100 listings per month&quot;,
                    &quot;Add 10 pictures per listing&quot;,
                    &quot;Keep listings online for 90 days&quot;
                ],
                &quot;description_string&quot;: &quot;Publish up to 100 listings per month. \nAdd 10 pictures per listing. \nKeep listings online for 90 days&quot;,
                &quot;price_formatted&quot;: &quot;$9&quot;
            },
            {
                &quot;id&quot;: 4,
                &quot;type&quot;: &quot;subscription&quot;,
                &quot;name&quot;: &quot;Basic&quot;,
                &quot;short_name&quot;: &quot;Basic&quot;,
                &quot;ribbon&quot;: null,
                &quot;has_badge&quot;: 0,
                &quot;price&quot;: &quot;0.00&quot;,
                &quot;currency_code&quot;: &quot;USD&quot;,
                &quot;promotion_time&quot;: null,
                &quot;interval&quot;: &quot;month&quot;,
                &quot;listings_limit&quot;: null,
                &quot;pictures_limit&quot;: null,
                &quot;expiration_time&quot;: null,
                &quot;description&quot;: &quot;&quot;,
                &quot;facebook_ads_duration&quot;: 0,
                &quot;google_ads_duration&quot;: 0,
                &quot;twitter_ads_duration&quot;: 0,
                &quot;linkedin_ads_duration&quot;: 0,
                &quot;recommended&quot;: 0,
                &quot;active&quot;: 1,
                &quot;parent_id&quot;: null,
                &quot;lft&quot;: 7,
                &quot;rgt&quot;: 8,
                &quot;depth&quot;: 0,
                &quot;period_start&quot;: &quot;2025-09-08T00:00:00.000000Z&quot;,
                &quot;period_end&quot;: &quot;2025-10-08T23:59:59.999999Z&quot;,
                &quot;description_array&quot;: [
                    &quot;Up to 50 listings allowed&quot;,
                    &quot;Add 6 pictures per listing&quot;,
                    &quot;Keep listings online for 30 days&quot;
                ],
                &quot;description_string&quot;: &quot;Up to 50 listings allowed. \nAdd 6 pictures per listing. \nKeep listings online for 30 days&quot;,
                &quot;price_formatted&quot;: &quot;$0&quot;
            }
        ]
    }
}</code>
 </pre>
    </span>
<span id="execution-results-GETapi-packages-subscription" hidden>
    <blockquote>Received response<span
                id="execution-response-status-GETapi-packages-subscription"></span>:
    </blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-packages-subscription"
      data-empty-response-text="<Empty response>" style="max-height: 400px;"></code></pre>
</span>
<span id="execution-error-GETapi-packages-subscription" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-packages-subscription">

Tip: Check that you&#039;re properly connected to the network.
If you&#039;re a maintainer of ths API, verify that your API is running and you&#039;ve enabled CORS.
You can check the Dev Tools console for debugging information.</code></pre>
</span>
<form id="form-GETapi-packages-subscription" da