<?php

namespace Database\Seeders;

use App\Helpers\Common\NestedSetSeeder;
use App\Models\Package;
use Illuminate\Database\Seeder;

class PackageSeeder extends Seeder
{
	/**
	 * Run the database seeds.
	 *
	 * @return void
	 */
	public function run()
	{
		$entries = [
			// promotion
			[
				'type'                  => 'promotion',
				'name'                  => [
					'en' => 'Free',
					'fr' => 'Standard',
					'es' => 'Estándar',
					'ar' => 'اساسي',
					'pt' => 'Padrão',
					'ru' => 'Стандарт',
					'tr' => 'Standart',
					'th' => 'มาตรฐาน',
					'ka' => 'სტანდარტული',
					'zh' => '标准',
					'ja' => '標準',
					'it' => 'Standard',
					'ro' => 'Standard',
					'de' => 'Standard',
					'hi' => 'नि: शुल्क',
					'bn' => 'মুক্ত',
					'he' => 'חינם',
				],
				'short_name'            => [
					'en' => 'Free',
					'fr' => 'Standard',
					'es' => 'Estándar',
					'ar' => 'اساسي',
					'pt' => 'Padrão',
					'ru' => 'Стандарт',
					'tr' => 'Standart',
					'th' => 'มาตรฐาน',
					'ka' => 'სტანდარტული',
					'zh' => '标准',
					'ja' => '標準',
					'it' => 'Standard',
					'ro' => 'Standard',
					'de' => 'Standard',
					'hi' => 'नि: शुल्क',
					'bn' => 'মুক্ত',
					'he' => 'חינם',
				],
				'ribbon'                => 'danger',
				'has_badge'             => '1',
				'price'                 => '0.00',
				'currency_code'         => 'USD',
				'promotion_time'        => null,
				'expiration_time'       => null,
				'pictures_limit'        => null,
				'description'           => null,
				'facebook_ads_duration' => '0',
				'google_ads_duration'   => '0',
				'twitter_ads_duration'  => '0',
				'linkedin_ads_duration' => '0',
				'recommended'           => '0',
			],
			[
				'type'                  => 'promotion',
				'name'                  => [
					'en' => 'Premium Listing',
					'fr' => 'Annonce Premium',
					'es' => 'Anuncio premium',
					'ar' => 'إعلان مميز',
					'pt' => 'Anúncio Premium',
					'ru' => 'Премиум-объявление',
					'tr' => 'Premium Reklam',
					'th' => 'โฆษณาพรีเมียม',
					'ka' => 'პრემიუმ რეკლამა',
					'zh' => '优质广告',
					'ja' => 'プレミアム広告',
					'it' => 'Annuncio premium',
					'ro' => 'Anunț premium',
					'de' => 'Premium-Anzeige',
					'hi' => 'प्रीमियम विज्ञापन',
					'bn' => 'প্রিমিয়াম বিজ্ঞাপন',
					'he' => 'מודעת פרימיום',
				],
				'short_name'            => [
					'en' => 'Premium',
					'fr' => 'Premium',
					'es' => 'Prima',
					'ar' => 'الممتازة',
					'pt' => 'Prêmio',
					'ru' => 'Премиум',
					'tr' => 'Ödül',
					'th' => 'พรีเมียม',
					'ka' => 'პრემია',
					'zh' => '保费',
					'ja' => 'プレミアム',
					'it' => 'Premium',
					'ro' => 'Premium',
					'de' => 'Prämie',
					'hi' => 'अधिमूल्य',
					'bn' => 'প্রিমিয়াম',
					'he' => 'פּרֶמיָה',
				],
				'ribbon'                => 'warning',
				'has_badge'             => '1',
				'price'                 => '7.50',
				'currency_code'         => 'USD',
				'promotion_time'        => '7',
				'expiration_time'       => '60',
				'pictures_limit'        => '10',
				'description'           => [
					'en' => "Featured on the homepage\nFeatured in the category",
					'fr' => "En vedette à l'accueil\nEn vedette dans la catégorie",
					'es' => "Destacado en la página de inicio\nDestacado en la categoría",
					'ar' => "ظهرت على الصفحة الرئيسية\nظهرت في الفئة",
					'pt' => "Apresentado na página inicial\nApresentado na categoria",
					'ru' => "Показано на главной странице\nВ категории",
					'tr' => "Ana Sayfada Öne Çıkanlar\nKategoride Öne Çıkanlar",
					'th' => "นำเสนอในหน้าแรก\nนำเสนอในหมวดหมู่",
					'ka' => "მთავარ გვერდზე\nმთავარი კატეგორიაში",
					'zh' => "精选在首页上\n列入类别",
					'ja' => "ホームページに掲載\nカテゴリーで紹介",
					'it' => "In primo piano sulla home page\nIn primo piano nella categoria",
					'ro' => "Prezentat pe pagina de pornire\nPrezentat în categorie",
					'de' => "Auf der Homepage vorgestellt\nGekennzeichnet in der Kategorie",
					'hi' => "मुखपृष्ठ पर विशेष रुप से प्रदर्शित\nश्रेणी में विशेष रुप से प्रदर्शित",
					'bn' => "হোমপেজে বৈশিষ্ট্যযুক্ত\nবিষয়শ্রেণীতে বৈশিষ্ট্যযুক্ত",
					'he' => "מוצג בדף הבית\nמוצג בקטגוריה",
				],
				'facebook_ads_duration' => '0',
				'google_ads_duration'   => '0',
				'twitter_ads_duration'  => '0',
				'linkedin_ads_duration' => '0',
				'recommended'           => '1',
			],
			[
				'type'                  => 'promotion',
				'name'                  => [
					'en' => 'Premium Listing (+)',
					'fr' => 'Annonce Premium (+)',
					'es' => 'Anuncio premium (+)',
					'ar' => 'إعلان مميز (+)',
					'pt' => 'Anúncio Premium (+)',
					'ru' => 'Премиум-объявление (+)',
					'tr' => 'Premium Reklam (+)',
					'th' => 'โฆษณาพรีเมียม (+)',
					'ka' => 'პრემიუმ რეკლამა (+)',
					'zh' => '优质广告 (+)',
					'ja' => 'プレミアム広告 (+)',
					'it' => 'Annuncio premium (+)',
					'ro' => 'Anunț premium (+)',
					'de' => 'Premium-Anzeige (+)',
					'hi' => 'प्रीमियम विज्ञापन (+)',
					'bn' => 'প্রিমিয়াম বিজ্ঞাপন (+)',
					'he' => 'מודעת פרימיום (+)',
				],
				'short_name'            => [
					'en' => 'Premium+',
					'fr' => 'Premium+',
					'es' => 'Prima+',
					'ar' => 'الممتازة+',
					'pt' => 'Prêmio+',
					'ru' => 'Премиум+',
					'tr' => 'Ödül+',
					'th' => 'พรีเมียม+',
					'ka' => 'პრემია+',
					'zh' => '保费+',
					'ja' => 'プレミアム+',
					'it' => 'Premium+',
					'ro' => 'Premium+',
					'de' => 'Prämie+',
					'hi' => 'प्रीमियम+',
					'bn' => 'প্রিমিয়াম+',
					'he' => 'פרימיום+',
				],
				'ribbon'                => 'success',
				'has_badge'             => '1',
				'price'                 => '9.00',
				'currency_code'         => 'USD',
				'promotion_time'        => '30',
				'expiration_time'       => '120',
				'pictures_limit'        => '15',
				'description'           => [
					'en' => "Featured on the homepage\nFeatured in the category",
					'fr' => "En vedette à l\'accueil\nEn vedette dans la catégorie",
					'es' => "Destacado en la página de inicio\nDestacado en la categoría",
					'ar' => "ظهرت على الصفحة الرئيسية\nظهرت في الفئة",
					'pt' => "Apresentado na página inicial\nApresentado na categoria",
					'ru' => "Показано на главной странице\nВ категории",
					'tr' => "Ana Sayfada Öne Çıkanlar\nKategoride Öne Çıkanlar",
					'th' => "นำเสนอในหน้าแรก\nนำเสนอในหมวดหมู่",
					'ka' => "მთავარ გვერდზე\nმთავარი კატეგორიაში",
					'zh' => "精选在首页上\n列入类别",
					'ja' => "ホームページに掲載\nカテゴリーで紹介",
					'it' => "In primo piano sulla home page\nIn primo piano nella categoria",
					'ro' => "Prezentat pe pagina de pornire\nPrezentat în categorie",
					'de' => "Auf der Homepage vorgestellt\nGekennzeichnet in der Kategorie",
					'hi' => "मुखपृष्ठ पर विशेष रुप से प्रदर्शित\nश्रेणी में विशेष रुप से प्रदर्शित",
					'bn' => "হোমপেজে বৈশিষ্ট্যযুক্ত\nবিষয়শ্রেণীতে বৈশিষ্ট্যযুক্ত",
					'he' => "מוצג בדף הבית\nמוצג בקטגוריה",
				],
				'facebook_ads_duration' => '0',
				'google_ads_duration'   => '0',
				'twitter_ads_duration'  => '0',
				'linkedin_ads_duration' => '0',
				'recommended'           => '0',
			],
			
			// subscription
			[
				'type'            => 'subscription',
				'name'            => [
					'en' => 'Basic',
					'fr' => 'Basique',
					'es' => 'Básico',
					'ar' => 'أساسي',
					'pt' => 'Básico',
					'ru' => 'Базовый',
					'tr' => 'Temel',
					'th' => 'ขั้นพื้นฐาน',
					'ka' => 'ძირითადი',
					'zh' => '基本的',
					'ja' => '基本',
					'it' => 'Di base',
					'ro' => 'De bază',
					'de' => 'Basic',
					'hi' => 'बुनियादी',
					'bn' => 'মৌলিক',
					'he' => 'בסיסי',
				],
				'short_name'      => [
					'en' => 'Basic',
					'fr' => 'Basique',
					'es' => 'Básico',
					'ar' => 'أساسي',
					'pt' => 'Básico',
					'ru' => 'Базовый',
					'tr' => 'Temel',
					'th' => 'ขั้นพื้นฐาน',
					'ka' => 'ძირითადი',
					'zh' => '基本的',
					'ja' => '基本',
					'it' => 'Di base',
					'ro' => 'De bază',
					'de' => 'Basic',
					'hi' => 'बुनियादी',
					'bn' => 'মৌলিক',
					'he' => 'בסיסי',
				],
				'price'           => '0.00',
				'currency_code'   => 'USD',
				'interval'        => 'month', // week, month, year or null
				'listings_limit'  => null,
				'expiration_time' => null,
				'pictures_limit'  => null,
				'description'     => null,
				'recommended'     => '0',
			],
			[
				'type'            => 'subscription',
				'name'            => [
					'en' => 'Premium',
					'fr' => 'Premium',
					'es' => 'Prima',
					'ar' => 'الممتازة',
					'pt' => 'Prêmio',
					'ru' => 'Премиум',
					'tr' => 'Ödül',
					'th' => 'พรีเมียม',
					'ka' => 'პრემია',
					'zh' => '保费',
					'ja' => 'プレミアム',
					'it' => 'Premium',
					'ro' => 'Premium',
					'de' => 'Prämie',
					'hi' => 'अधिमूल्य',
					'bn' => 'প্রিমিয়াম',
					'he' => 'פּרֶמיָה',
				],
				'short_name'      => [
					'en' => 'Premium',
					'fr' => 'Premium',
					'es' => 'Prima',
					'ar' => 'الممتازة',
					'pt' => 'Prêmio',
					'ru' => 'Премиум',
					'tr' => 'Ödül',
					'th' => 'พรีเมียม',
					'ka' => 'პრემია',
					'zh' => '保费',
					'ja' => 'プレミアム',
					'it' => 'Premium',
					'ro' => 'Premium',
					'de' => 'Prämie',
					'hi' => 'अधिमूल्य',
					'bn' => 'প্রিমিয়াম',
					'he' => 'פּרֶמיָה',
				],
				'price'           => '9.00',
				'currency_code'   => 'USD',
				'interval'        => 'month', // week, month, year or null
				'listings_limit'  => '100',
				'expiration_time' => '90',
				'pictures_limit'  => '10',
				'description'     => null,
				'recommended'     => '1',
			],
		];
		
		// Packages' "active" column value
		// $appUrl = env('APP_URL');
		$appUrl = config('app.url');
		$isDemoDomain = (isDemoDomain($appUrl) || isDevEnv($appUrl));
		$activeValue = $isDemoDomain ? 1 : 0;
		
		// Add or update columns
		$entries = collect($entries)
			->map(function ($item) use ($activeValue) {
				$item['parent_id'] = null;
				$item['lft'] = 0;
				$item['rgt'] = 0;
				$item['depth'] = 0;
				
				$item['active'] = $activeValue;
				
				return $item;
			})->toArray();
		
		$tableName = (new Package())->getTable();
		
		$startPosition = NestedSetSeeder::getNextRgtValue($tableName);
		NestedSetSeeder::insertEntries($tableName, $entries, $startPosition);
	}
}
