<?php

namespace Database\Seeders;

use App\Models\Currency;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CurrencySeeder extends Seeder
{
	/**
	 * Run the database seeds.
	 *
	 * @return void
	 */
	public function run()
	{
		$entries = [
			[
				'code'               => 'AED',
				'name'               => 'United Arab Emirates Dirham',
				'symbol'             => 'د.إ',
				'html_entities'      => '&#1583;.&#1573;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'AFN',
				'name'               => 'Afghanistan Afghani',
				'symbol'             => '؋',
				'html_entities'      => '&#65;&#102;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'ALL',
				'name'               => 'Albania Lek',
				'symbol'             => 'Lek',
				'html_entities'      => '&#76;&#101;&#107;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'AMD',
				'name'               => 'Armenia Dram',
				'symbol'             => null,
				'html_entities'      => '',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'ANG',
				'name'               => 'Netherlands Antilles Guilder',
				'symbol'             => 'ƒ',
				'html_entities'      => '&#402;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'AOA',
				'name'               => 'Angola Kwanza',
				'symbol'             => 'Kz',
				'html_entities'      => '&#75;&#122;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'ARS',
				'name'               => 'Argentina Peso',
				'symbol'             => '$',
				'html_entities'      => '&#36;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'AUD',
				'name'               => 'Australia Dollar',
				'symbol'             => '$',
				'html_entities'      => '&#36;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'AWG',
				'name'               => 'Aruba Guilder',
				'symbol'             => 'ƒ',
				'html_entities'      => '&#402;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'AZN',
				'name'               => 'Azerbaijan New Manat',
				'symbol'             => 'ман',
				'html_entities'      => '&#1084;&#1072;&#1085;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'BAM',
				'name'               => 'Bosnia and Herzegovina Convertible Marka',
				'symbol'             => 'KM',
				'html_entities'      => '&#75;&#77;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'BBD',
				'name'               => 'Barbados Dollar',
				'symbol'             => '$',
				'html_entities'      => '&#36;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'BDT',
				'name'               => 'Bangladesh Taka',
				'symbol'             => '৳',
				'html_entities'      => '&#2547;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'BGN',
				'name'               => 'Bulgaria Lev',
				'symbol'             => 'лв',
				'html_entities'      => '&#1083;&#1074;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'BHD',
				'name'               => 'Bahrain Dinar',
				'symbol'             => null,
				'html_entities'      => '.&#1583;.&#1576;',
				'in_left'            => '0',
				'decimal_places'     => '3',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'BIF',
				'name'               => 'Burundi Franc',
				'symbol'             => 'FBu',
				'html_entities'      => '&#70;&#66;&#117;',
				'in_left'            => '0',
				'decimal_places'     => '0',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'BMD',
				'name'               => 'Bermuda Dollar',
				'symbol'             => '$',
				'html_entities'      => '&#36;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'BND',
				'name'               => 'Brunei Darussalam Dollar',
				'symbol'             => '$',
				'html_entities'      => '&#36;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'BOB',
				'name'               => 'Bolivia Boliviano',
				'symbol'             => '$b',
				'html_entities'      => '&#36;&#98;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'BRL',
				'name'               => 'Brazil Real',
				'symbol'             => 'R$',
				'html_entities'      => '&#82;&#36;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'BSD',
				'name'               => 'Bahamas Dollar',
				'symbol'             => '$',
				'html_entities'      => '&#36;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'BTN',
				'name'               => 'Bhutan Ngultrum',
				'symbol'             => null,
				'html_entities'      => '&#78;&#117;&#46;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'BWP',
				'name'               => 'Botswana Pula',
				'symbol'             => 'P',
				'html_entities'      => '&#80;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'BYR',
				'name'               => 'Belarus Ruble',
				'symbol'             => 'p.',
				'html_entities'      => '&#112;&#46;',
				'in_left'            => '0',
				'decimal_places'     => '0',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'BZD',
				'name'               => 'Belize Dollar',
				'symbol'             => 'BZ$',
				'html_entities'      => '&#66;&#90;&#36;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'CAD',
				'name'               => 'Canada Dollar',
				'symbol'             => '$',
				'html_entities'      => '&#36;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'CDF',
				'name'               => 'Congo/Kinshasa Franc',
				'symbol'             => 'Fr',
				'html_entities'      => '&#70;&#67;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'CHF',
				'name'               => 'Switzerland Franc',
				'symbol'             => 'Fr',
				'html_entities'      => '&#67;&#72;&#70;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'CLP',
				'name'               => 'Chile Peso',
				'symbol'             => '$',
				'html_entities'      => '&#36;',
				'in_left'            => '0',
				'decimal_places'     => '0',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'CNY',
				'name'               => 'China Yuan Renminbi',
				'symbol'             => '¥',
				'html_entities'      => '&#165;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'COP',
				'name'               => 'Colombia Peso',
				'symbol'             => '$',
				'html_entities'      => '&#36;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'CRC',
				'name'               => 'Costa Rica Colon',
				'symbol'             => '₡',
				'html_entities'      => '&#8353;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'CUC',
				'name'               => 'Cuba Convertible Peso',
				'symbol'             => null,
				'html_entities'      => null,
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'CUP',
				'name'               => 'Cuba Peso',
				'symbol'             => '₱',
				'html_entities'      => '&#8396;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'CVE',
				'name'               => 'Cape Verde Escudo',
				'symbol'             => '$',
				'html_entities'      => '&#x24;',
				'in_left'            => '1',
				'decimal_places'     => '0',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'CZK',
				'name'               => 'Czech Republic Koruna',
				'symbol'             => 'Kč',
				'html_entities'      => '&#75;&#269;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'DJF',
				'name'               => 'Djibouti Franc',
				'symbol'             => 'Fr',
				'html_entities'      => '&#70;&#100;&#106;',
				'in_left'            => '0',
				'decimal_places'     => '0',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'DKK',
				'name'               => 'Denmark Krone',
				'symbol'             => 'kr',
				'html_entities'      => '&#107;&#114;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'DOP',
				'name'               => 'Dominican Republic Peso',
				'symbol'             => 'RD$',
				'html_entities'      => '&#82;&#68;&#36;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'DZD',
				'name'               => 'Algeria Dinar',
				'symbol'             => 'DA',
				'html_entities'      => '&#1583;&#1580;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'EEK',
				'name'               => 'Estonia Kroon',
				'symbol'             => 'kr',
				'html_entities'      => null,
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'EGP',
				'name'               => 'Egypt Pound',
				'symbol'             => '£',
				'html_entities'      => '&#163;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'ERN',
				'name'               => 'Eritrea Nakfa',
				'symbol'             => 'Nfk',
				'html_entities'      => '&#x4E;&#x66;&#x6B;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'ETB',
				'name'               => 'Ethiopia Birr',
				'symbol'             => 'Br',
				'html_entities'      => '&#66;&#114;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'EUR',
				'name'               => 'Euro Member Countries',
				'symbol'             => '€',
				'html_entities'      => '€',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => ',',
				'thousand_separator' => ' ',
			],
			[
				'code'               => 'FJD',
				'name'               => 'Fiji Dollar',
				'symbol'             => '$',
				'html_entities'      => '&#36;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'FKP',
				'name'               => 'Falkland Islands (Malvinas) Pound',
				'symbol'             => '£',
				'html_entities'      => '&#163;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'GBP',
				'name'               => 'United Kingdom Pound',
				'symbol'             => '£',
				'html_entities'      => '&#163;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'GEL',
				'name'               => 'Georgia Lari',
				'symbol'             => null,
				'html_entities'      => '&#4314;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'GGP',
				'name'               => 'Guernsey Pound',
				'symbol'             => '£',
				'html_entities'      => null,
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'GHC',
				'name'               => 'Ghana Cedi',
				'symbol'             => 'GH¢',
				'html_entities'      => '&#x47;&#x48;&#xA2;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'GHS',
				'name'               => 'Ghana Cedi',
				'symbol'             => 'GH¢',
				'html_entities'      => '&#x47;&#x48;&#xA2;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'GIP',
				'name'               => 'Gibraltar Pound',
				'symbol'             => '£',
				'html_entities'      => '&#163;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'GMD',
				'name'               => 'Gambia Dalasi',
				'symbol'             => 'D',
				'html_entities'      => '&#68;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'GNF',
				'name'               => 'Guinea Franc',
				'symbol'             => 'Fr',
				'html_entities'      => '&#70;&#71;',
				'in_left'            => '0',
				'decimal_places'     => '0',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'GTQ',
				'name'               => 'Guatemala Quetzal',
				'symbol'             => 'Q',
				'html_entities'      => '&#81;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'GYD',
				'name'               => 'Guyana Dollar',
				'symbol'             => '$',
				'html_entities'      => '&#36;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'HKD',
				'name'               => 'Hong Kong Dollar',
				'symbol'             => '$',
				'html_entities'      => '&#36;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'HNL',
				'name'               => 'Honduras Lempira',
				'symbol'             => 'L',
				'html_entities'      => '&#76;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'HRK',
				'name'               => 'Croatia Kuna',
				'symbol'             => 'kn',
				'html_entities'      => '&#107;&#110;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'HTG',
				'name'               => 'Haiti Gourde',
				'symbol'             => null,
				'html_entities'      => '&#71;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'HUF',
				'name'               => 'Hungary Forint',
				'symbol'             => 'Ft',
				'html_entities'      => '&#70;&#116;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'IDR',
				'name'               => 'Indonesia Rupiah',
				'symbol'             => 'Rp',
				'html_entities'      => '&#82;&#112;',
				'in_left'            => '0',
				'decimal_places'     => '0',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'ILS',
				'name'               => 'Israel Shekel',
				'symbol'             => '₪',
				'html_entities'      => '&#8362;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'IMP',
				'name'               => 'Isle of Man Pound',
				'symbol'             => '£',
				'html_entities'      => null,
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'INR',
				'name'               => 'India Rupee',
				'symbol'             => '₹',
				'html_entities'      => '&#8377;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'IQD',
				'name'               => 'Iraq Dinar',
				'symbol'             => 'د.ع;',
				'html_entities'      => '&#1593;.&#1583;',
				'in_left'            => '0',
				'decimal_places'     => '0',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'IRR',
				'name'               => 'Iran Rial',
				'symbol'             => '﷼',
				'html_entities'      => '&#65020;',
				'in_left'            => '0',
				'decimal_places'     => '0',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'ISK',
				'name'               => 'Iceland Krona',
				'symbol'             => 'kr',
				'html_entities'      => '&#107;&#114;',
				'in_left'            => '0',
				'decimal_places'     => '0',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'JEP',
				'name'               => 'Jersey Pound',
				'symbol'             => '£',
				'html_entities'      => '&#163;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'JMD',
				'name'               => 'Jamaica Dollar',
				'symbol'             => 'J$',
				'html_entities'      => '&#74;&#36;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'JOD',
				'name'               => 'Jordan Dinar',
				'symbol'             => null,
				'html_entities'      => '&#74;&#68;',
				'in_left'            => '0',
				'decimal_places'     => '3',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'JPY',
				'name'               => 'Japan Yen',
				'symbol'             => '¥',
				'html_entities'      => '&#165;',
				'in_left'            => '0',
				'decimal_places'     => '0',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'KES',
				'name'               => 'Kenya Shilling',
				'symbol'             => 'KSh',
				'html_entities'      => '&#x4B;&#x53;&#x68;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'KGS',
				'name'               => 'Kyrgyzstan Som',
				'symbol'             => 'лв',
				'html_entities'      => '&#1083;&#1074;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'KHR',
				'name'               => 'Cambodia Riel',
				'symbol'             => '៛',
				'html_entities'      => '&#6107;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'KMF',
				'name'               => 'Comoros Franc',
				'symbol'             => 'Fr',
				'html_entities'      => '&#67;&#70;',
				'in_left'            => '0',
				'decimal_places'     => '0',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'KPW',
				'name'               => 'Korea (North) Won',
				'symbol'             => '₩',
				'html_entities'      => '&#8361;',
				'in_left'            => '0',
				'decimal_places'     => '0',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'KRW',
				'name'               => 'Korea (South) Won',
				'symbol'             => '₩',
				'html_entities'      => '&#8361;',
				'in_left'            => '0',
				'decimal_places'     => '0',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'KWD',
				'name'               => 'Kuwait Dinar',
				'symbol'             => 'د.ك',
				'html_entities'      => '&#1583;.&#1603;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'KYD',
				'name'               => 'Cayman Islands Dollar',
				'symbol'             => '$',
				'html_entities'      => '&#36;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'KZT',
				'name'               => 'Kazakhstan Tenge',
				'symbol'             => 'лв',
				'html_entities'      => '&#1083;&#1074;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'LAK',
				'name'               => 'Laos Kip',
				'symbol'             => '₭',
				'html_entities'      => '&#8365;',
				'in_left'            => '0',
				'decimal_places'     => '0',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'LBP',
				'name'               => 'Lebanon Pound',
				'symbol'             => '£',
				'html_entities'      => '&#163;',
				'in_left'            => '0',
				'decimal_places'     => '0',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'LKR',
				'name'               => 'Sri Lanka Rupee',
				'symbol'             => '₨',
				'html_entities'      => '&#8360;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'LRD',
				'name'               => 'Liberia Dollar',
				'symbol'             => '$',
				'html_entities'      => '&#36;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'LSL',
				'name'               => 'Lesotho Loti',
				'symbol'             => 'M',
				'html_entities'      => '&#76;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'LTL',
				'name'               => 'Lithuania Litas',
				'symbol'             => 'Lt',
				'html_entities'      => '&#76;&#116;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'LVL',
				'name'               => 'Latvia Lat',
				'symbol'             => 'Ls',
				'html_entities'      => '&#76;&#115;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'LYD',
				'name'               => 'Libya Dinar',
				'symbol'             => 'DL',
				'html_entities'      => '&#1604;.&#1583;',
				'in_left'            => '0',
				'decimal_places'     => '3',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'MAD',
				'name'               => 'Morocco Dirham',
				'symbol'             => 'Dhs',
				'html_entities'      => '&#1583;.&#1605;.',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'MDL',
				'name'               => 'Moldova Leu',
				'symbol'             => null,
				'html_entities'      => '&#76;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'MGA',
				'name'               => 'Madagascar Ariary',
				'symbol'             => 'Ar',
				'html_entities'      => '&#65;&#114;',
				'in_left'            => '0',
				'decimal_places'     => '5',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'MKD',
				'name'               => 'Macedonia Denar',
				'symbol'             => 'ден',
				'html_entities'      => '&#1076;&#1077;&#1085;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'MMK',
				'name'               => 'Myanmar (Burma) Kyat',
				'symbol'             => null,
				'html_entities'      => '&#75;',
				'in_left'            => '0',
				'decimal_places'     => '0',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'MNT',
				'name'               => 'Mongolia Tughrik',
				'symbol'             => '₮',
				'html_entities'      => '&#8366;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'MOP',
				'name'               => 'Macau Pataca',
				'symbol'             => null,
				'html_entities'      => '&#77;&#79;&#80;&#36;',
				'in_left'            => '0',
				'decimal_places'     => '1',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'MRO',
				'name'               => 'Mauritania Ouguiya',
				'symbol'             => 'UM',
				'html_entities'      => '&#85;&#77;',
				'in_left'            => '0',
				'decimal_places'     => '5',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'MUR',
				'name'               => 'Mauritius Rupee',
				'symbol'             => '₨',
				'html_entities'      => '&#8360;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'MVR',
				'name'               => 'Maldives (Maldive Islands) Rufiyaa',
				'symbol'             => null,
				'html_entities'      => '.&#1923;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'MWK',
				'name'               => 'Malawi Kwacha',
				'symbol'             => 'MK',
				'html_entities'      => '&#77;&#75;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'MXN',
				'name'               => 'Mexico Peso',
				'symbol'             => '$',
				'html_entities'      => '&#36;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'MYR',
				'name'               => 'Malaysia Ringgit',
				'symbol'             => 'RM',
				'html_entities'      => '&#82;&#77;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'MZN',
				'name'               => 'Mozambique Metical',
				'symbol'             => 'MT',
				'html_entities'      => '&#77;&#84;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'NAD',
				'name'               => 'Namibia Dollar',
				'symbol'             => '$',
				'html_entities'      => '&#36;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'NGN',
				'name'               => 'Nigeria Naira',
				'symbol'             => '₦',
				'html_entities'      => '&#8358;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'NIO',
				'name'               => 'Nicaragua Cordoba',
				'symbol'             => 'C$',
				'html_entities'      => '&#67;&#36;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'NOK',
				'name'               => 'Norway Krone',
				'symbol'             => 'kr',
				'html_entities'      => '&#107;&#114;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'NPR',
				'name'               => 'Nepal Rupee',
				'symbol'             => '₨',
				'html_entities'      => '&#8360;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'NZD',
				'name'               => 'New Zealand Dollar',
				'symbol'             => '$',
				'html_entities'      => '&#36;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'OMR',
				'name'               => 'Omani Rial',
				'symbol'             => 'ر.ع.',
				'html_entities'      => '',
				'in_left'            => '0',
				'decimal_places'     => '3',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'PAB',
				'name'               => 'Panama Balboa',
				'symbol'             => 'B/.',
				'html_entities'      => '&#66;&#47;&#46;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'PEN',
				'name'               => 'Peru Nuevo Sol',
				'symbol'             => 'S/.',
				'html_entities'      => '&#83;&#47;&#46;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'PGK',
				'name'               => 'Papua New Guinea Kina',
				'symbol'             => null,
				'html_entities'      => '&#75;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'PHP',
				'name'               => 'Philippines Peso',
				'symbol'             => '₱',
				'html_entities'      => '&#8369;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'PKR',
				'name'               => 'Pakistan Rupee',
				'symbol'             => '₨',
				'html_entities'      => '&#8360;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'PLN',
				'name'               => 'Poland Zloty',
				'symbol'             => 'zł',
				'html_entities'      => '&#122;&#322;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'PYG',
				'name'               => 'Paraguay Guarani',
				'symbol'             => 'Gs',
				'html_entities'      => '&#71;&#115;',
				'in_left'            => '0',
				'decimal_places'     => '0',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'QAR',
				'name'               => 'Qatar Riyal',
				'symbol'             => '﷼',
				'html_entities'      => '&#65020;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'RON',
				'name'               => 'Romania New Leu',
				'symbol'             => 'lei',
				'html_entities'      => '&#108;&#101;&#105;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'RSD',
				'name'               => 'Serbia Dinar',
				'symbol'             => 'Дин.',
				'html_entities'      => '&#1044;&#1080;&#1085;&#46;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'RUB',
				'name'               => 'Russia Ruble',
				'symbol'             => '₽',
				'html_entities'      => '&#8381;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'RWF',
				'name'               => 'Rwanda Franc',
				'symbol'             => 'FRw',
				'html_entities'      => '&#1585;.&#1587;',
				'in_left'            => '0',
				'decimal_places'     => '0',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'SAR',
				'name'               => 'Saudi Arabia Riyal',
				'symbol'             => '﷼',
				'html_entities'      => '&#65020;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'SBD',
				'name'               => 'Solomon Islands Dollar',
				'symbol'             => '$',
				'html_entities'      => '&#36;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'SCR',
				'name'               => 'Seychelles Rupee',
				'symbol'             => '₨',
				'html_entities'      => '&#8360;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'SDG',
				'name'               => 'Sudan Pound',
				'symbol'             => 'DS',
				'html_entities'      => '&#163;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'SEK',
				'name'               => 'Sweden Krona',
				'symbol'             => 'kr',
				'html_entities'      => '&#107;&#114;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'SGD',
				'name'               => 'Singapore Dollar',
				'symbol'             => '$',
				'html_entities'      => '&#36;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'SHP',
				'name'               => 'Saint Helena Pound',
				'symbol'             => '£',
				'html_entities'      => '&#163;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'SLL',
				'name'               => 'Sierra Leone Leone',
				'symbol'             => 'Le',
				'html_entities'      => '&#76;&#101;',
				'in_left'            => '1',
				'decimal_places'     => '0',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'SOS',
				'name'               => 'Somalia Shilling',
				'symbol'             => 'S',
				'html_entities'      => '&#83;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'SPL',
				'name'               => 'Seborga Luigino',
				'symbol'             => null,
				'html_entities'      => null,
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'SRD',
				'name'               => 'Suriname Dollar',
				'symbol'             => '$',
				'html_entities'      => '&#36;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'SSP',
				'name'               => 'South Sudanese Pound',
				'symbol'             => '£',
				'html_entities'      => '&#xA3;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'STD',
				'name'               => 'São Tomé and Príncipe Dobra',
				'symbol'             => 'Db',
				'html_entities'      => '&#68;&#98;',
				'in_left'            => '0',
				'decimal_places'     => '0',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'SVC',
				'name'               => 'El Salvador Colon',
				'symbol'             => '$',
				'html_entities'      => '&#36;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'SYP',
				'name'               => 'Syria Pound',
				'symbol'             => '£',
				'html_entities'      => '&#163;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'SZL',
				'name'               => 'Swaziland Lilangeni',
				'symbol'             => 'E',
				'html_entities'      => '&#76;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'THB',
				'name'               => 'Thailand Baht',
				'symbol'             => '฿',
				'html_entities'      => '&#3647;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'TJS',
				'name'               => 'Tajikistan Somoni',
				'symbol'             => null,
				'html_entities'      => '&#84;&#74;&#83;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'TMT',
				'name'               => 'Turkmenistan Manat',
				'symbol'             => null,
				'html_entities'      => '&#109;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'TND',
				'name'               => 'Tunisia Dinar',
				'symbol'             => 'DT',
				'html_entities'      => '&#1583;.&#1578;',
				'in_left'            => '1',
				'decimal_places'     => '3',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'TOP',
				'name'               => 'Tonga Pa\'anga',
				'symbol'             => null,
				'html_entities'      => '&#84;&#36;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'TRL',
				'name'               => 'Turkey Lira',
				'symbol'             => '₤',
				'html_entities'      => null,
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'TRY',
				'name'               => 'Turkey Lira',
				'symbol'             => '₺',
				'html_entities'      => '&#x20BA;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'TTD',
				'name'               => 'Trinidad and Tobago Dollar',
				'symbol'             => 'TT$',
				'html_entities'      => '&#36;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'TVD',
				'name'               => 'Tuvalu Dollar',
				'symbol'             => '$',
				'html_entities'      => null,
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'TWD',
				'name'               => 'Taiwan New Dollar',
				'symbol'             => 'NT$',
				'html_entities'      => '&#78;&#84;&#36;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'TZS',
				'name'               => 'Tanzania Shilling',
				'symbol'             => 'TSh',
				'html_entities'      => '&#x54;&#x53;&#x68;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'UAH',
				'name'               => 'Ukraine Hryvnia',
				'symbol'             => '₴',
				'html_entities'      => '&#8372;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'UGX',
				'name'               => 'Uganda Shilling',
				'symbol'             => 'USh',
				'html_entities'      => '&#85;&#83;&#104;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'USD',
				'name'               => 'United States Dollar',
				'symbol'             => '$',
				'html_entities'      => '&#36;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'UYU',
				'name'               => 'Uruguay Peso',
				'symbol'             => '$U',
				'html_entities'      => '&#36;&#85;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'UZS',
				'name'               => 'Uzbekistan Som',
				'symbol'             => 'лв',
				'html_entities'      => '&#1083;&#1074;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'VEF',
				'name'               => 'Venezuela Bolivar',
				'symbol'             => 'Bs',
				'html_entities'      => '&#66;&#115;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'VND',
				'name'               => 'Viet Nam Dong',
				'symbol'             => '₫',
				'html_entities'      => '&#8363;',
				'in_left'            => '1',
				'decimal_places'     => '0',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'VUV',
				'name'               => 'Vanuatu Vatu',
				'symbol'             => null,
				'html_entities'      => '&#86;&#84;',
				'in_left'            => '0',
				'decimal_places'     => '0',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'WST',
				'name'               => 'Samoa Tala',
				'symbol'             => null,
				'html_entities'      => '&#87;&#83;&#36;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'XAF',
				'name'               => 'Communauté Financière Africaine (CFA) Franc B (BEAC)',
				'symbol'             => 'F',
				'html_entities'      => '&#70;&#67;&#70;&#65;',
				'in_left'            => '0',
				'decimal_places'     => '0',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'XCD',
				'name'               => 'East Caribbean Dollar',
				'symbol'             => '$',
				'html_entities'      => '&#36;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'XDR',
				'name'               => 'International Monetary Fund (IMF) Special Drawing ',
				'symbol'             => null,
				'html_entities'      => '',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'XOF',
				'name'               => 'Communauté Financière Africaine (CFA) Franc (BCEAO)',
				'symbol'             => 'FCFA',
				'html_entities'      => '&#70;&#67;&#70;&#65;',
				'in_left'            => '0',
				'decimal_places'     => '0',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'XPF',
				'name'               => 'Comptoirs Français du Pacifique (CFP) Franc',
				'symbol'             => 'F',
				'html_entities'      => '&#70;',
				'in_left'            => '0',
				'decimal_places'     => '0',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'YER',
				'name'               => 'Yemen Rial',
				'symbol'             => '﷼',
				'html_entities'      => '&#65020;',
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'ZAR',
				'name'               => 'South Africa Rand',
				'symbol'             => 'R',
				'html_entities'      => '&#82;',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'ZMW',
				'name'               => 'Zambia Kwacha',
				'symbol'             => 'ZK',
				'html_entities'      => null,
				'in_left'            => '0',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'ZWD',
				'name'               => 'Zimbabwe Dollar',
				'symbol'             => 'Z$',
				'html_entities'      => null,
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'ZWL',
				'name'               => 'Zimbabwe Dollar',
				'symbol'             => 'Z$',
				'html_entities'      => null,
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
			[
				'code'               => 'XBT',
				'name'               => 'Bitcoin',
				'symbol'             => '฿',
				'html_entities'      => '฿',
				'in_left'            => '1',
				'decimal_places'     => '2',
				'decimal_separator'  => '.',
				'thousand_separator' => ',',
			],
		];
		
		// Add or update columns
		$timezone = config('app.timezone', 'UTC');
		$entries = collect($entries)
			->map(function ($item) use ($timezone) {
				$item['created_at'] = now($timezone)->format('Y-m-d H:i:s');
				$item['updated_at'] = null;
				
				return $item;
			})->toArray();
		
		$tableName = (new Currency())->getTable();
		foreach ($entries as $entry) {
			DB::table($tableName)->insert($entry);
		}
	}
}
