<?php
/*
 * LaraClassifier - Classified Ads Web Application
 * Copyright (c) BeDigit. All Rights Reserved
 *
 * Website: https://laraclassifier.com
 * Author: Mayeul Akpovi (BeDigit - https://bedigit.com)
 *
 * LICENSE
 * -------
 * This software is provided under a license agreement and may only be used or copied
 * in accordance with its terms, including the inclusion of the above copyright notice.
 * As this software is sold exclusively on CodeCanyon,
 * please review the full license details here: https://codecanyon.net/licenses/standard
 */

namespace App\Observers;

use App\Models\City;
use App\Models\SubAdmin1;
use App\Models\SubAdmin2;

class SubAdmin1Observer extends BaseObserver
{
	/**
	 * Listen to the Entry deleting event.
	 *
	 * @param SubAdmin1 $admin
	 * @return void
	 */
	public function deleting(SubAdmin1 $admin)
	{
		// Delete all the sub-admins 2 of the admin. division
		$admin2s = SubAdmin2::inCountry($admin->country_code)->where('subadmin1_code', $admin->code);
		if ($admin2s->count() > 0) {
			foreach ($admin2s->cursor() as $admin2) {
				$admin2->delete();
			}
		}
		
		// Delete all the cities of the admin. division
		$cities = City::inCountry($admin->country_code)->where('subadmin1_code', $admin->code);
		if ($cities->count() > 0) {
			foreach ($cities->cursor() as $city) {
				$city->delete();
			}
		}
	}
	
	/**
	 * Listen to the Entry saved event.
	 *
	 * @param SubAdmin1 $admin
	 * @return void
	 */
	public function saved(SubAdmin1 $admin)
	{
		// ...
	}
	
	/**
	 * Listen to the Entry deleted event.
	 *
	 * @param SubAdmin1 $admin
	 * @return void
	 */
	public function deleted(SubAdmin1 $admin)
	{
		// ...
	}
}
