<?php
/*
 * LaraClassifier - Classified Ads Web Application
 * Copyright (c) BeDigit. All Rights Reserved
 *
 * Website: https://laraclassifier.com
 * Author: Mayeul Akpovi (BeDigit - https://bedigit.com)
 *
 * LICENSE
 * -------
 * This software is provided under a license agreement and may only be used or copied
 * in accordance with its terms, including the inclusion of the above copyright notice.
 * As this software is sold exclusively on CodeCanyon,
 * please review the full license details here: https://codecanyon.net/licenses/standard
 */

namespace App\Models\Scopes;

use App\Http\Controllers\Web\Admin\InlineRequestController;
use App\Http\Controllers\Web\Admin\PaymentController;
use Illuminate\Database\Eloquent\Scope;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;

class StrictActiveScope implements Scope
{
	/**
	 * Apply the scope to a given Eloquent query builder.
	 *
	 * @param \Illuminate\Database\Eloquent\Builder $builder
	 * @param \Illuminate\Database\Eloquent\Model $model
	 * @return void
	 */
	public function apply(Builder $builder, Model $model): void
	{
		/*
		 * This scope is considered as strict except this condition,
		 * where we need to load all entries from some Admin panel Controllers:
		 */
		$areActiveOrNonActiveEntriesRequired = (
			routeActionHas(PaymentController::class)
			|| routeActionHas(InlineRequestController::class)
		);
		if ($areActiveOrNonActiveEntriesRequired) {
			return;
		}
		
		// Load only activated entries for the rest of the website (Admin panel & Front)
		$builder->where('active', 1);
	}
}
