<?php

/*
 * Languages by their main country
 * List of ISO 639-1 language codes along with the ISO 3166 country codes of their main countries
 *
 * Chat GPT
 *
 * ---
 * ISO 639-1 Code => [Name, Country ISO 3166 Code]
 */
return [
	'aa' => [
		'name'    => 'Afar',
		'country' => 'DJ', // Djibouti
	],
	'ab' => [
		'name'    => 'Abkhaz',
		'country' => 'GE', // Georgia
	],
	'af' => [
		'name'    => 'Afrikaans',
		'country' => 'ZA', // South Africa
	],
	'ak' => [
		'name'    => 'Akan',
		'country' => 'GH', // Ghana
	],
	'am' => [
		'name'    => 'Amharic',
		'country' => 'ET', // Ethiopia
	],
	'an' => [
		'name'    => 'Aragonese',
		'country' => 'ES', // Spain
	],
	'ar' => [
		'name'    => 'Arabic',
		'country' => 'SA', // Saudi Arabia
	],
	'as' => [
		'name'    => 'Assamese',
		'country' => 'IN', // India
	],
	'av' => [
		'name'    => 'Avaric',
		'country' => 'RU', // Russia
	],
	'ae' => [
		'name'    => 'Avestan',
		'country' => '', // Avestan is not associated with a specific country
	],
	'ay' => [
		'name'    => 'Aymara',
		'country' => 'BO', // Bolivia
	],
	'az' => [
		'name'    => 'Azerbaijani',
		'country' => 'AZ', // Azerbaijan
	],
	'ba' => [
		'name'    => 'Bashkir',
		'country' => 'RU', // Russia
	],
	'be' => [
		'name'    => 'Belarusian',
		'country' => 'BY', // Belarus
	],
	'bn' => [
		'name'    => 'Bengali',
		'country' => 'BD', // Bangladesh
	],
	'bh' => [
		'name'    => 'Bihari',
		'country' => 'IN', // India
	],
	'bi' => [
		'name'    => 'Bislama',
		'country' => 'VU', // Vanuatu
	],
	'bs' => [
		'name'    => 'Bosnian',
		'country' => 'BA', // Bosnia and Herzegovina
	],
	'br' => [
		'name'    => 'Breton',
		'country' => 'FR', // France
	],
	'bg' => [
		'name'    => 'Bulgarian',
		'country' => 'BG', // Bulgaria
	],
	'my' => [
		'name'    => 'Burmese',
		'country' => 'MM', // Myanmar
	],
	'ca' => [
		'name'    => 'Catalan',
		'country' => 'AD', // Andorra
	],
	'ch' => [
		'name'    => 'Chamorro',
		'country' => 'GU', // Guam
	],
	'ce' => [
		'name'    => 'Chechen',
		'country' => 'RU', // Russia
	],
	'ny' => [
		'name'    => 'Chichewa',
		'country' => 'MW', // Malawi
	],
	'zh' => [
		'name'    => 'Chinese',
		'country' => 'CN', // China
	],
	'cv' => [
		'name'    => 'Chuvash',
		'country' => 'RU', // Russia
	],
	'kw' => [
		'name'    => 'Cornish',
		'country' => 'GB', // United Kingdom
	],
	'co' => [
		'name'    => 'Corsican',
		'country' => 'FR', // France
	],
	'cr' => [
		'name'    => 'Cree',
		'country' => 'CA', // Canada
	],
	'hr' => [
		'name'    => 'Croatian',
		'country' => 'HR', // Croatia
	],
	'cs' => [
		'name'    => 'Czech',
		'country' => 'CZ', // Czech Republic
	],
	'da' => [
		'name'    => 'Danish',
		'country' => 'DK', // Denmark
	],
	'dv' => [
		'name'    => 'Divehi',
		'country' => 'MV', // Maldives
	],
	'nl' => [
		'name'    => 'Dutch',
		'country' => 'NL', // Netherlands
	],
	'dz' => [
		'name'    => 'Dzongkha',
		'country' => 'BT', // Bhutan
	],
	'en' => [
		'name'    => 'English',
		'country' => 'GB', // United Kingdom
	],
	'eo' => [
		'name'    => 'Esperanto',
		'country' => '', // Esperanto is not associated with a specific country
	],
	'et' => [
		'name'    => 'Estonian',
		'country' => 'EE', // Estonia
	],
	'ee' => [
		'name'    => 'Ewe',
		'country' => 'GH', // Ghana
	],
	'fo' => [
		'name'    => 'Faroese',
		'country' => 'FO', // Faroe Islands
	],
	'fj' => [
		'name'    => 'Fijian',
		'country' => 'FJ', // Fiji
	],
	'fi' => [
		'name'    => 'Finnish',
		'country' => 'FI', // Finland
	],
	'fr' => [
		'name'    => 'French',
		'country' => 'FR', // France
	],
	'ff' => [
		'name'    => 'Fulah',
		'country' => 'SN', // Senegal
	],
	'gl' => [
		'name'    => 'Galician',
		'country' => 'ES', // Spain
	],
	'ka' => [
		'name'    => 'Georgian',
		'country' => 'GE', // Georgia
	],
	'de' => [
		'name'    => 'German',
		'country' => 'DE', // Germany
	],
	'el' => [
		'name'    => 'Greek',
		'country' => 'GR', // Greece
	],
	'gn' => [
		'name'    => 'Guarani',
		'country' => 'PY', // Paraguay
	],
	'gu' => [
		'name'    => 'Gujarati',
		'country' => 'IN', // India
	],
	'ht' => [
		'name'    => 'Haitian Creole',
		'country' => 'HT', // Haiti
	],
	'ha' => [
		'name'    => 'Hausa',
		'country' => 'NG', // Nigeria
	],
	'he' => [
		'name'    => 'Hebrew',
		'country' => 'IL', // Israel
	],
	'hi' => [
		'name'    => 'Hindi',
		'country' => 'IN', // India
	],
	'ho' => [
		'name'    => 'Hiri Motu',
		'country' => 'PG', // Papua New Guinea
	],
	'hu' => [
		'name'    => 'Hungarian',
		'country' => 'HU', // Hungary
	],
	'is' => [
		'name'    => 'Icelandic',
		'country' => 'IS', // Iceland
	],
	'ig' => [
		'name'    => 'Igbo',
		'country' => 'NG', // Nigeria
	],
	'id' => [
		'name'    => 'Indonesian',
		'country' => 'ID', // Indonesia
	],
	'ga' => [
		'name'    => 'Irish',
		'country' => 'IE', // Ireland
	],
	'it' => [
		'name'    => 'Italian',
		'country' => 'IT', // Italy
	],
	'ja' => [
		'name'    => 'Japanese',
		'country' => 'JP', // Japan
	],
	'jv' => [
		'name'    => 'Javanese',
		'country' => 'ID', // Indonesia
	],
	'kn' => [
		'name'    => 'Kannada',
		'country' => 'IN', // India
	],
	'kr' => [
		'name'    => 'Kanuri',
		'country' => 'NE', // Niger
	],
	'kk' => [
		'name'    => 'Kazakh',
		'country' => 'KZ', // Kazakhstan
	],
	'km' => [
		'name'    => 'Khmer',
		'country' => 'KH', // Cambodia
	],
	'ki' => [
		'name'    => 'Kikuyu',
		'country' => 'KE', // Kenya
	],
	'rw' => [
		'name'    => 'Kinyarwanda',
		'country' => 'RW', // Rwanda
	],
	'ky' => [
		'name'    => 'Kyrgyz',
		'country' => 'KG', // Kyrgyzstan
	],
	'ko' => [
		'name'    => 'Korean',
		'country' => 'KR', // South Korea
	],
	'ku' => [
		'name'    => 'Kurdish',
		'country' => 'IQ', // Iraq
	],
	'lo' => [
		'name'    => 'Lao',
		'country' => 'LA', // Laos
	],
	'la' => [
		'name'    => 'Latin',
		'country' => '', // Latin is not associated with a specific country
	],
	'lv' => [
		'name'    => 'Latvian',
		'country' => 'LV', // Latvia
	],
	'lt' => [
		'name'    => 'Lithuanian',
		'country' => 'LT', // Lithuania
	],
	'lb' => [
		'name'    => 'Luxembourgish',
		'country' => 'LU', // Luxembourg
	],
	'mk' => [
		'name'    => 'Macedonian',
		'country' => 'MK', // North Macedonia
	],
	'mg' => [
		'name'    => 'Malagasy',
		'country' => 'MG', // Madagascar
	],
	'ms' => [
		'name'    => 'Malay',
		'country' => 'MY', // Malaysia
	],
	'ml' => [
		'name'    => 'Malayalam',
		'country' => 'IN', // India
	],
	'mt' => [
		'name'    => 'Maltese',
		'country' => 'MT', // Malta
	],
	'mi' => [
		'name'    => 'Maori',
		'country' => 'NZ', // New Zealand
	],
	'mr' => [
		'name'    => 'Marathi',
		'country' => 'IN', // India
	],
	'mh' => [
		'name'    => 'Marshallese',
		'country' => 'MH', // Marshall Islands
	],
	'mn' => [
		'name'    => 'Mongolian',
		'country' => 'MN', // Mongolia
	],
	'na' => [
		'name'    => 'Nauruan',
		'country' => 'NR', // Nauru
	],
	'nv' => [
		'name'    => 'Navajo',
		'country' => 'US', // United States
	],
	'nd' => [
		'name'    => 'Ndebele',
		'country' => 'ZW', // Zimbabwe
	],
	'ne' => [
		'name'    => 'Nepali',
		'country' => 'NP', // Nepal
	],
	'ng' => [
		'name'    => 'Ndonga',
		'country' => 'NA', // Namibia
	],
	'nb' => [
		'name'    => 'Norwegian Bokmål',
		'country' => 'NO', // Norway
	],
	'nn' => [
		'name'    => 'Norwegian Nynorsk',
		'country' => 'NO', // Norway
	],
	'no' => [
		'name'    => 'Norwegian',
		'country' => 'NO', // Norway
	],
	'ii' => [
		'name'    => 'Nuosu',
		'country' => 'CN', // China
	],
	'nr' => [
		'name'    => 'Ndebele',
		'country' => 'ZA', // South Africa
	],
	'oc' => [
		'name'    => 'Occitan',
		'country' => 'FR', // France
	],
	'oj' => [
		'name'    => 'Ojibwa',
		'country' => 'CA', // Canada
	],
	'cu' => [
		'name'    => 'Old Church Slavonic',
		'country' => '', // Old Church Slavonic is not associated with a specific country
	],
	'or' => [
		'name'    => 'Oriya',
		'country' => 'IN', // India
	],
	'om' => [
		'name'    => 'Oromo',
		'country' => 'ET', // Ethiopia
	],
	'os' => [
		'name'    => 'Ossetian',
		'country' => 'RU', // Russia
	],
	'pa' => [
		'name'    => 'Punjabi',
		'country' => 'IN', // India
	],
	'pi' => [
		'name'    => 'Pali',
		'country' => '', // Pali is not associated with a specific country
	],
	'pl' => [
		'name'    => 'Polish',
		'country' => 'PL', // Poland
	],
	'ps' => [
		'name'    => 'Pashto',
		'country' => 'AF', // Afghanistan
	],
	'pt' => [
		'name'    => 'Portuguese',
		'country' => 'PT', // Portugal
	],
	'qu' => [
		'name'    => 'Quechua',
		'country' => 'PE', // Peru
	],
	'rm' => [
		'name'    => 'Romansh',
		'country' => 'CH', // Switzerland
	],
	'rn' => [
		'name'    => 'Kirundi',
		'country' => 'BI', // Burundi
	],
	'ro' => [
		'name'    => 'Romanian',
		'country' => 'RO', // Romania
	],
	'ru' => [
		'name'    => 'Russian',
		'country' => 'RU', // Russia
	],
	'sa' => [
		'name'    => 'Sanskrit',
		'country' => '', // Sanskrit is not associated with a specific country
	],
	'sc' => [
		'name'    => 'Sardinian',
		'country' => 'IT', // Italy
	],
	'sd' => [
		'name'    => 'Sindhi',
		'country' => 'PK', // Pakistan
	],
	'se' => [
		'name'    => 'Sami',
		'country' => 'NO', // Norway
	],
	'sm' => [
		'name'    => 'Samoan',
		'country' => 'WS', // Samoa
	],
	'sg' => [
		'name'    => 'Sango',
		'country' => 'CF', // Central African Republic
	],
	'sr' => [
		'name'    => 'Serbian',
		'country' => 'RS', // Serbia
	],
	'gd' => [
		'name'    => 'Gaelic',
		'country' => 'GB', // United Kingdom
	],
	'sn' => [
		'name'    => 'Shona',
		'country' => 'ZW', // Zimbabwe
	],
	'si' => [
		'name'    => 'Sinhalese',
		'country' => 'LK', // Sri Lanka
	],
	'sk' => [
		'name'    => 'Slovak',
		'country' => 'SK', // Slovakia
	],
	'sl' => [
		'name'    => 'Slovenian',
		'country' => 'SI', // Slovenia
	],
	'so' => [
		'name'    => 'Somali',
		'country' => 'SO', // Somalia
	],
	'st' => [
		'name'    => 'Sotho',
		'country' => 'LS', // Lesotho
	],
	'es' => [
		'name'    => 'Spanish',
		'country' => 'ES', // Spain
	],
	'su' => [
		'name'    => 'Sundanese',
		'country' => 'ID', // Indonesia
	],
	'sw' => [
		'name'    => 'Swahili',
		'country' => 'KE', // Kenya
	],
	'ss' => [
		'name'    => 'Swati',
		'country' => 'SZ', // Eswatini
	],
	'sv' => [
		'name'    => 'Swedish',
		'country' => 'SE', // Sweden
	],
	'ta' => [
		'name'    => 'Tamil',
		'country' => 'IN', // India
	],
	'te' => [
		'name'    => 'Telugu',
		'country' => 'IN', // India
	],
	'tg' => [
		'name'    => 'Tajik',
		'country' => 'TJ', // Tajikistan
	],
	'th' => [
		'name'    => 'Thai',
		'country' => 'TH', // Thailand
	],
	'ti' => [
		'name'    => 'Tigrinya',
		'country' => 'ER', // Eritrea
	],
	'bo' => [
		'name'    => 'Tibetan',
		'country' => 'CN', // China
	],
	'tk' => [
		'name'    => 'Turkmen',
		'country' => 'TM', // Turkmenistan
	],
	'tl' => [
		'name'    => 'Tagalog',
		'country' => 'PH', // Philippines
	],
	'tn' => [
		'name'    => 'Tswana',
		'country' => 'BW', // Botswana
	],
	'to' => [
		'name'    => 'Tonga',
		'country' => 'TO', // Tonga
	],
	'tr' => [
		'name'    => 'Turkish',
		'country' => 'TR', // Turkey
	],
	'ts' => [
		'name'    => 'Tsonga',
		'country' => 'ZA', // South Africa
	],
	'tt' => [
		'name'    => 'Tatar',
		'country' => 'RU', // Russia
	],
	'ug' => [
		'name'    => 'Uighur',
		'country' => 'CN', // China
	],
	'uk' => [
		'name'    => 'Ukrainian',
		'country' => 'UA', // Ukraine
	],
	'ur' => [
		'name'    => 'Urdu',
		'country' => 'PK', // Pakistan
	],
	'uz' => [
		'name'    => 'Uzbek',
		'country' => 'UZ', // Uzbekistan
	],
	've' => [
		'name'    => 'Venda',
		'country' => 'ZA', // South Africa
	],
	'vi' => [
		'name'    => 'Vietnamese',
		'country' => 'VN', // Vietnam
	],
	'vo' => [
		'name'    => 'Volapük',
		'country' => '', // Volapük is not associated with a specific country
	],
	'wa' => [
		'name'    => 'Walloon',
		'country' => 'BE', // Belgium
	],
	'cy' => [
		'name'    => 'Welsh',
		'country' => 'GB', // United Kingdom
	],
	'wo' => [
		'name'    => 'Wolof',
		'country' => 'SN', // Senegal
	],
	'fy' => [
		'name'    => 'Western Frisian',
		'country' => 'NL', // Netherlands
	],
	'xh' => [
		'name'    => 'Xhosa',
		'country' => 'ZA', // South Africa
	],
	'yi' => [
		'name'    => 'Yiddish',
		'country' => '', // Yiddish is not associated with a specific country
	],
	'yo' => [
		'name'    => 'Yoruba',
		'country' => 'NG', // Nigeria
	],
	'za' => [
		'name'    => 'Zhuang',
		'country' => 'CN', // China
	],
	'zu' => [
		'name'    => 'Zulu',
		'country' => 'ZA', // South Africa
	],
];
